/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.GenericFileSystem;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.CommonTableContainerView;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.common.CCPagelet;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCHiddenField;
import java.io.IOException;
import javax.servlet.ServletException;

public class FSDClusterView
extends CommonTableContainerView
implements CCPagelet {
    public static final String PAGE_NAME = "FSDClusterView";
    public static final String NODE_NAMES = "nodeNames";
    public static final String NODE_TO_REMOVE = "nodeToRemove";
    public static final String MOUNTED = "mountedNodes";
    public static final String REMOVE_CONFIRM = "removeConfirmation";
    private CCActionTableModel tableModel = null;
    private int sunPlexManagerState = -1;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean;

    public FSDClusterView(View parent, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.CHILD_ACTION_TABLE = "FSDClusterTable";
        this.tableModel = this.getTableModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(NODE_NAMES, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSDClusterView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(NODE_TO_REMOVE, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSDClusterView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(MOUNTED, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSDClusterView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(REMOVE_CONFIRM, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSDClusterView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        super.registerChildren(this.tableModel);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        if (name.equals(NODE_NAMES) || name.equals(NODE_TO_REMOVE) || name.equals(MOUNTED) || name.equals(REMOVE_CONFIRM)) {
            return new CCHiddenField((ContainerView)this, name, null);
        }
        return super.createChild(this.tableModel, name);
    }

    private CCActionTableModel getTableModel() {
        return new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/jsp/fs/FSDClusterTable.xml");
    }

    private void populateTableModel() {
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        String serverName = parent.getServerName();
        try {
            String fsName = (String)parent.getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            this.sunPlexManagerState = sysModel.getPlexMgrState();
            GenericFileSystem filesystem = sysModel.getSamQFSSystemFSManager().getGenericFileSystem(fsName);
            GenericFileSystem[] instance = filesystem.getHAFSInstances();
            NonSyncStringBuffer buffer = new NonSyncStringBuffer();
            NonSyncStringBuffer mounted = new NonSyncStringBuffer();
            for (int i = 0; i < instance.length; ++i) {
                String hostName = instance[i].getHostName();
                if (i > 0) {
                    this.tableModel.appendRow();
                }
                buffer.append(hostName).append(";");
                this.tableModel.setValue("HostNameText", (Object)hostName);
                switch (instance[i].getState()) {
                    case 0: {
                        this.tableModel.setValue("StateText", (Object)SamUtil.getResourceString("FSSummary.mount"));
                        mounted.append(hostName).append(";");
                        this.tableModel.setSelectionVisible(i, false);
                        break;
                    }
                    case 1: {
                        this.tableModel.setValue("StateText", (Object)SamUtil.getResourceString("FSSummary.unmount"));
                        break;
                    }
                }
                this.tableModel.setRowSelected(false);
            }
            ((CCHiddenField)this.getChild(NODE_NAMES)).setValue((Object)buffer.toString());
            ((CCHiddenField)this.getChild(MOUNTED)).setValue((Object)mounted.toString());
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "populateTableModel", "unable to retrieve cluster instances", serverName);
            SamUtil.setErrorAlert((ContainerView)parent, "Alert", "fs.cluster.loadinfo.error", sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
    }

    public void beginDisplay(DisplayEvent evt) throws ModelControlException {
        this.tableModel.setActionValue("Add", (Object)"common.button.add");
        this.tableModel.setActionValue("Remove", (Object)"common.button.remove");
        this.tableModel.setActionValue("HostName", (Object)"common.columnheader.hostname");
        this.tableModel.setActionValue("State", (Object)"common.columnheader.state");
        ((CCHiddenField)this.getChild(REMOVE_CONFIRM)).setValue((Object)SamUtil.getResourceString("fs.cluster.removenode.confirmation"));
        this.populateTableModel();
        if (!SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.FILESYSTEM_OPERATOR)) {
            ((CCButton)this.getChild("Add")).setDisabled(true);
            this.tableModel.setSelectionType("multiple");
        } else {
            ((CCButton)this.getChild("Add")).setDisabled(false);
        }
        ((CCButton)this.getChild("Remove")).setDisabled(true);
    }

    public void handleAddRequest(RequestInvocationEvent evt) throws ServletException, IOException {
        this.getParentViewBean().forwardTo(this.getRequestContext());
    }

    public void handleRemoveRequest(RequestInvocationEvent evt) throws ServletException, IOException {
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        String serverName = parent.getServerName();
        String nodeToRemove = this.getDisplayFieldStringValue(NODE_TO_REMOVE);
        String fsName = (String)parent.getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
        boolean backToSummaryPage = false;
        try {
            SamQFSSystemFSManager fsManager = SamUtil.getModel(serverName).getSamQFSSystemFSManager();
            FileSystem fs2 = fsManager.getFileSystem(fsName);
            fsManager.removeHostFromHAFS(fs2, nodeToRemove);
            if (serverName.trim().equals(nodeToRemove.trim())) {
                backToSummaryPage = true;
            } else {
                SamUtil.setInfoAlert((ContainerView)parent, "Alert", "success.summary", SamUtil.getResourceString("fs.details.removenode.success", new String[]{nodeToRemove, fsName}), serverName);
            }
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "handleRemoveRequest", "unable to remove cluster node from hafs", serverName);
            SamUtil.setErrorAlert((ContainerView)parent, "Alert", SamUtil.getResourceString("fs.details.removenode.error", new String[]{nodeToRemove, fsName}), sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
        if (backToSummaryPage) {
            CommonViewBeanBase target = (CommonViewBeanBase)this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean = FSDClusterView.class$("com.sun.netstorage.samqfs.web.fs.FSSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean);
            SamUtil.setInfoAlert((ContainerView)target, "Alert", "success.summary", SamUtil.getResourceString("fs.details.removenode.success", new String[]{nodeToRemove, fsName}), serverName);
            parent.forwardTo((ViewBean)target);
        } else {
            parent.forwardTo(this.getRequestContext());
        }
    }

    public String getPageletUrl() {
        boolean hafs = false;
        boolean samqfs = false;
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        String serverName = parent.getServerName();
        String fsName = (String)parent.getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
        GenericFileSystem gfs = null;
        try {
            gfs = SamUtil.getModel(serverName).getSamQFSSystemFSManager().getGenericFileSystem(fsName);
            hafs = gfs.isHA();
            samqfs = gfs.getFSTypeByProduct() != 13;
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "getPageletUrl", "unable to determine if cluster node", serverName);
            SamUtil.setErrorAlert((ContainerView)parent, "Alert", "fs.details.iscluster.error", sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
        if (samqfs && hafs && ((FileSystem)gfs).getShareStatus() != 3) {
            return "/jsp/fs/FSDClusterPagelet.jsp";
        }
        return "/jsp/archive/BlankPagelet.jsp";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

