/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiMsgException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.archive.VSNPoolSummaryTiledView;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.VSNPool;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.CommonTableContainerView;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCHref;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.servlet.ServletException;

public class VSNPoolSummaryView
extends CommonTableContainerView {
    public static final String CHILD_NE_HIDDEN_FIELD1 = "NEHiddenField1";
    public static final String CHILD_NE_HIDDEN_FIELD2 = "NEHiddenField2";
    public static final String CHILD_NE_HIDDEN_FIELD3 = "NEHiddenField3";
    public static final String CHILD_NE_HIDDEN_FIELD4 = "NEHiddenField4";
    public static final String CHILD_NE_HIDDEN_FIELD5 = "NEHiddenField5";
    public static final String CHILD_NEW_VSNPOOL_HREF = "NewVSNPoolHref";
    public static final String CHILD_EDIT_VSNPOOL_HREF = "EditVSNPoolHref";
    public static final String SELECTED_POOL = "selectedPool";
    public static final String CHILD_TILED_VIEW = "VSNPoolSummaryTiledView";
    private VSNPool existedPool;
    private CCActionTableModel model = null;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHref;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryTiledView;

    public VSNPoolSummaryView(View parent, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.CHILD_ACTION_TABLE = "VSNPoolSummaryTable";
        this.createTableModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren(this.model);
        this.registerChild(CHILD_NE_HIDDEN_FIELD1, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = VSNPoolSummaryView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_NE_HIDDEN_FIELD2, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = VSNPoolSummaryView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_NE_HIDDEN_FIELD3, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = VSNPoolSummaryView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_NE_HIDDEN_FIELD4, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = VSNPoolSummaryView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_NE_HIDDEN_FIELD5, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = VSNPoolSummaryView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(SELECTED_POOL, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = VSNPoolSummaryView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_NEW_VSNPOOL_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = VSNPoolSummaryView.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_EDIT_VSNPOOL_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = VSNPoolSummaryView.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_TILED_VIEW, class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryTiledView == null ? (class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryTiledView = VSNPoolSummaryView.class$("com.sun.netstorage.samqfs.web.archive.VSNPoolSummaryTiledView")) : class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryTiledView);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        if (name.equals(CHILD_NE_HIDDEN_FIELD1) || name.equals(CHILD_NE_HIDDEN_FIELD2) || name.equals(CHILD_NE_HIDDEN_FIELD3) || name.equals(CHILD_NE_HIDDEN_FIELD4) || name.equals(CHILD_NE_HIDDEN_FIELD5) || name.equals(SELECTED_POOL)) {
            return new CCHiddenField((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_NEW_VSNPOOL_HREF)) {
            return new CCHref((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_EDIT_VSNPOOL_HREF)) {
            return new CCHref((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_TILED_VIEW)) {
            return new VSNPoolSummaryTiledView((View)this, this.model, name);
        }
        return super.createChild(this.model, name, CHILD_TILED_VIEW);
    }

    private void createTableModel() {
        this.model = new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/jsp/archive/VSNPoolSummaryTable.xml");
    }

    private void checkRolePrivilege() throws ModelControlException {
        TraceUtil.trace3("Entering");
        if (!SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.MEDIA_OPERATOR)) {
            this.model.setSelectionType("none");
        } else {
            ((CCButton)this.getChild("New")).setDisabled(false);
            ((CCButton)this.getChild("Edit")).setDisabled(true);
            ((CCButton)this.getChild("Delete")).setDisabled(true);
        }
        TraceUtil.trace3("Exiting");
    }

    public void handleNewRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleEditRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleDeleteRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        String poolName = this.getDisplayFieldStringValue(SELECTED_POOL);
        System.out.println("Delete VSN Pool ... name = " + poolName);
        String serverName = parent.getServerName();
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            sysModel.getSamQFSSystemArchiveManager43().deleteVSNPool(poolName);
            this.showAlert("VSNPoolSummary.delete.alert", poolName);
        }
        catch (SamFSException smfex) {
            String processMsg = null;
            String errMsg = null;
            String errCause = null;
            boolean warning = false;
            if (smfex instanceof SamFSMultiMsgException) {
                processMsg = "Error in archiver configuration";
                errMsg = "ArchiveConfig.error";
                errCause = "ArchiveConfig.error.detail";
            } else if (smfex instanceof SamFSWarnings) {
                warning = true;
                processMsg = "Warning in archiver configuration";
                errMsg = "ArchiveConfig.warning.summary";
                errCause = "ArchiveConfig.warning.detail";
            } else {
                processMsg = "Failed to delete vsn pool";
                errMsg = "VSNPoolSummary.error.failedDelete";
                errCause = smfex.getMessage();
            }
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "handleDeleteRequest", processMsg, serverName);
            if (!warning) {
                SamUtil.setErrorAlert((ContainerView)parent, "Alert", errMsg, smfex.getSAMerrno(), errCause, serverName);
            }
            SamUtil.setWarningAlert((ContainerView)parent, "Alert", errMsg, errCause);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException iex) {
            TraceUtil.trace3("InterruptedException Caught: Reason: " + iex.getMessage());
        }
        parent.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    private void initTableHeaders() {
        this.model.setActionValue("New", (Object)"archiving.new");
        this.model.setActionValue("Edit", (Object)"archiving.edit");
        this.model.setActionValue("Delete", (Object)"archiving.delete");
        this.model.setActionValue("VSNPoolName", (Object)"VSNPoolSummary.heading1");
        this.model.setActionValue("MediaType", (Object)"VSNPoolSummary.heading2");
        this.model.setActionValue("Members", (Object)"VSNPoolSummary.heading3");
        this.model.setActionValue("FreeSpace", (Object)"VSNPoolSummary.heading4");
    }

    public void populateTableModel() {
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        String serverName = parent.getServerName();
        NonSyncStringBuffer inUse = new NonSyncStringBuffer();
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            VSNPool[] pool = sysModel.getSamQFSSystemArchiveManager43().getAllVSNPools();
            if (pool == null) {
                pool = new VSNPool[]{};
            }
            NonSyncStringBuffer buffer = new NonSyncStringBuffer();
            this.model.clear();
            for (int i = 0; i < pool.length; ++i) {
                if (i > 0) {
                    this.model.appendRow();
                    buffer.append(";").append(pool[i].getPoolName());
                } else {
                    buffer.append(pool[i].getPoolName());
                }
                String poolName = pool[i].getPoolName();
                int mediaType = pool[i].getMediaType();
                Capacity freeSpace = new Capacity(pool[i].getSpaceAvailable(), 2);
                String status = sysModel.getSamQFSSystemArchiveManager43().isPoolInUse(poolName) ? "true" : "false";
                this.model.setValue("VSNPoolNameText", (Object)poolName);
                this.model.setValue("MediaTypeText", (Object)SamUtil.getMediaTypeString(mediaType));
                this.model.setValue("MembersText", (Object)new Integer(pool[i].getNoOfVSNsInPool()));
                this.model.setValue("FreeSpaceText", (Object)freeSpace);
                this.model.setValue("VSNPoolHref", (Object)poolName);
                this.model.setValue("VSNPoolHiddenField", (Object)poolName);
                this.model.setValue("HiddenStatus", (Object)status);
                this.model.setValue("MediaTypeHidden", (Object)new Integer(mediaType));
                this.model.setRowSelected(false);
                if (!sysModel.getSamQFSSystemArchiveManager43().isPoolInUse(pool[i].getPoolName())) continue;
                inUse.append(i).append(";");
            }
            ((CCHiddenField)parent.getChild("poolNames")).setValue((Object)buffer.toString());
            ((CCHiddenField)parent.getChild("poolsInUse")).setValue((Object)inUse.toString());
        }
        catch (SamFSWarnings sfw) {
            SamUtil.processException((Exception)((Object)sfw), ((Object)((Object)this)).getClass(), "populateTableModel", "Unable to retrieve VSN pools", serverName);
            SamUtil.setWarningAlert((ContainerView)parent, "Alert", "ArchiveConfig.error.summary", "ArchiveConfig.warning.detail");
        }
        catch (SamFSMultiMsgException smme) {
            SamUtil.processException((Exception)((Object)smme), ((Object)((Object)this)).getClass(), "populate Table Model", "Unable to retrieve VSN Pools", serverName);
            SamUtil.setErrorAlert((ContainerView)parent, "Alert", "ArchiveConfig.error.summary", smme.getSAMerrno(), "ArchiveConfig.error.detail", serverName);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "populateTableModel", "Unable to retrieve VSN Pools", serverName);
            SamUtil.setErrorAlert((ContainerView)parent, "Alert", "ArchiveConfig.error.summary", sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        this.initTableHeaders();
        this.checkRolePrivilege();
    }

    public void handleNewVSNPoolHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        TraceUtil.trace3("In NEW HREF method");
        this.processNewEditVSN(true);
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    private void processNewEditVSN(boolean newOrEdit) {
        String specifyVSN;
        String vsnRange;
        String mediaType;
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        String serverName = parent.getServerName();
        String start = null;
        String end = null;
        String vsnName = (String)this.getDisplayFieldValue(CHILD_NE_HIDDEN_FIELD1);
        if (vsnName != null) {
            vsnName = vsnName.trim();
        }
        if ((mediaType = (String)this.getDisplayFieldValue(CHILD_NE_HIDDEN_FIELD2)) != null) {
            mediaType = mediaType.trim();
        }
        int media = Integer.parseInt(mediaType);
        String startend = (String)this.getDisplayFieldValue(CHILD_NE_HIDDEN_FIELD3);
        if (startend != null) {
            startend = startend.trim();
        }
        if ((vsnRange = (String)this.getDisplayFieldValue(CHILD_NE_HIDDEN_FIELD4)) != null) {
            vsnRange = vsnRange.trim();
        }
        if ((specifyVSN = (String)this.getDisplayFieldValue(CHILD_NE_HIDDEN_FIELD5)) != null) {
            specifyVSN = specifyVSN.trim();
        }
        if (specifyVSN != null && specifyVSN.equals("startend")) {
            StringTokenizer tokens = new StringTokenizer(startend, ",");
            start = tokens.nextToken();
            end = tokens.nextToken();
        }
        String express = new String();
        if (specifyVSN != null && specifyVSN.equals("range")) {
            express = new String(vsnRange);
        } else if (specifyVSN != null && specifyVSN.equals("startend") && (express = SamQFSUtil.createExpression(start, end)) == null && media == 133) {
            express = start + "," + end;
        }
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            if (newOrEdit) {
                if (this.existingPool(vsnName)) {
                    throw new SamFSException(null, -2018);
                }
                LogUtil.info(((Object)((Object)this)).getClass(), "processNewEditVSN", "Start creating VSN pool " + vsnName);
                sysModel.getSamQFSSystemArchiveManager43().createVSNPool(vsnName, media, express);
                LogUtil.info(((Object)((Object)this)).getClass(), "processNewEditVSN", "Done creating VSN pool " + vsnName);
                this.showAlert("VSNPoolSummary.new.alert", vsnName);
            } else {
                VSNPool vsnPool = this.getExistingVSNPool(vsnName);
                if (vsnPool == null) {
                    throw new SamFSException(null, -2010);
                }
                LogUtil.info(((Object)((Object)this)).getClass(), "processNewEditVSN", "Start editing VSN pool " + vsnName);
                vsnPool.setMemberVSNs(media, express);
                LogUtil.info(((Object)((Object)this)).getClass(), "processNewEditVSN", "Done editing VSN pool " + vsnName);
                this.showAlert("VSNPoolSummary.edit.alert", vsnName);
            }
        }
        catch (SamFSException smfex) {
            String processMsg = null;
            String errMsg = null;
            String errCause = null;
            boolean warning = false;
            if (smfex instanceof SamFSMultiMsgException) {
                processMsg = "Error in archiver configuration";
                errMsg = "ArchiveConfig.error";
                errCause = "ArchiveConfig.error.detail";
            } else if (smfex instanceof SamFSWarnings) {
                warning = true;
                processMsg = "Error in archiver configuration";
                errMsg = "ArchiveConfig.error";
                errCause = "ArchiveConfig.warning.detail";
            } else {
                processMsg = "Failed to save vsn pool";
                errMsg = newOrEdit ? "VSNPoolSummary.error.failedCreateVSN" : "VSNPoolSummary.error.failedEditVSN";
                errCause = smfex.getMessage();
            }
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "processNewEditVSN", processMsg, serverName);
            if (!warning) {
                SamUtil.setErrorAlert((ContainerView)parent, "Alert", errMsg, smfex.getSAMerrno(), errCause, serverName);
            }
            SamUtil.setWarningAlert((ContainerView)parent, "Alert", errMsg, errCause);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException iex) {
            TraceUtil.trace3("InterruptedException Caught: Reason: " + iex.getMessage());
        }
        TraceUtil.trace3("Exiting");
    }

    public void handleEditVSNPoolHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        this.processNewEditVSN(false);
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    private boolean existingPool(String vsnName) throws SamFSException {
        TraceUtil.trace3("Entering");
        String serverName = ((CommonViewBeanBase)this.getParentViewBean()).getServerName();
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        VSNPool[] pools = sysModel.getSamQFSSystemArchiveManager43().getAllVSNPools();
        for (int i = 0; i < pools.length; ++i) {
            if (!pools[i].getPoolName().equals(vsnName)) continue;
            return true;
        }
        TraceUtil.trace3("Exiting");
        return false;
    }

    private VSNPool getExistingVSNPool(String vsnPoolName) throws SamFSException {
        TraceUtil.trace3("Entering");
        String serverName = ((CommonViewBeanBase)this.getParentViewBean()).getServerName();
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        VSNPool retPool = null;
        VSNPool[] pools = sysModel.getSamQFSSystemArchiveManager43().getAllVSNPools();
        if (pools == null) {
            return null;
        }
        for (int i = 0; i < pools.length; ++i) {
            if (!pools[i].getPoolName().equals(vsnPoolName)) continue;
            retPool = pools[i];
            TraceUtil.trace3("Exiting");
            return retPool;
        }
        TraceUtil.trace3("Exiting");
        return null;
    }

    private void showAlert(String operation, String key) {
        TraceUtil.trace3("Entering");
        SamUtil.setInfoAlert((ContainerView)this.getParentViewBean(), "Alert", "success.summary", SamUtil.getResourceString(operation, key));
        TraceUtil.trace3("Exiting");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

