/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.BasicCommandField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiMsgException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.archive.FileMatchCriteriaTiledView;
import com.sun.netstorage.samqfs.web.archive.PolicyDetailsViewBean;
import com.sun.netstorage.samqfs.web.archive.PolicyUtil;
import com.sun.netstorage.samqfs.web.archive.wizards.NewCriteriaWizardImpl;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaProp;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.BreadCrumbUtil;
import com.sun.netstorage.samqfs.web.util.CommonTableContainerView;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.PageInfo;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.common.CCPagelet;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCHiddenField;
import java.io.IOException;
import javax.servlet.ServletException;

public class FileMatchCriteriaView
extends CommonTableContainerView
implements CCPagelet {
    public static final String ADD_CRITERIA_WIZARD_FORWARDTO = "AddCriteriaForwardToVB";
    public static final String ADD_CRITERIA = "SamQFSWizardAddCriteria";
    public static final String REMOVE_CRITERIA = "RemoveCriteria";
    public static final String TILED_VIEW = "FileMatchCriteriaTiledView";
    public static final String TEST = "test";
    private CCActionTableModel tableModel = null;
    private CCWizardWindowModel addCriteriaWWModel = null;
    private boolean addCriteriaWizardRunning = false;
    static /* synthetic */ Class class$com$iplanet$jato$view$BasicCommandField;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$FileMatchCriteriaTiledView;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$CriteriaDetailsViewBean;

    FileMatchCriteriaView(View parent, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.CHILD_ACTION_TABLE = "FileMatchCriteriaTable";
        this.createTableModel();
        this.initializeCriteriaWizardButton();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(ADD_CRITERIA_WIZARD_FORWARDTO, class$com$iplanet$jato$view$BasicCommandField == null ? (class$com$iplanet$jato$view$BasicCommandField = FileMatchCriteriaView.class$("com.iplanet.jato.view.BasicCommandField")) : class$com$iplanet$jato$view$BasicCommandField);
        this.registerChild(TILED_VIEW, class$com$sun$netstorage$samqfs$web$archive$FileMatchCriteriaTiledView == null ? (class$com$sun$netstorage$samqfs$web$archive$FileMatchCriteriaTiledView = FileMatchCriteriaView.class$("com.sun.netstorage.samqfs.web.archive.FileMatchCriteriaTiledView")) : class$com$sun$netstorage$samqfs$web$archive$FileMatchCriteriaTiledView);
        super.registerChildren(this.tableModel);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        if (name.equals(ADD_CRITERIA_WIZARD_FORWARDTO)) {
            return new BasicCommandField((View)this, name);
        }
        if (name.equals(TILED_VIEW)) {
            return new FileMatchCriteriaTiledView((View)this, this.tableModel, name);
        }
        return super.createChild(this.tableModel, name, TILED_VIEW);
    }

    private void createTableModel() {
        this.tableModel = new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), "/jsp/archive/FileMatchCriteriaTable.xml");
    }

    public void initializeCriteriaWizardButton() {
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        String serverName = parent.getServerName();
        String policyName = (String)parent.getPageSessionAttribute("SAMQFS_POLICY_NAME");
        NonSyncStringBuffer buf = new NonSyncStringBuffer();
        buf.append(parent.getQualifiedName()).append(".").append(this.getName()).append(".").append(ADD_CRITERIA_WIZARD_FORWARDTO);
        this.addCriteriaWWModel = NewCriteriaWizardImpl.createModel(buf.toString());
        this.addCriteriaWWModel.setValue("clientsideParameterJSFunction", (Object)"getAddPolicyCriteriaWizardParams");
        this.tableModel.setModel(ADD_CRITERIA, (Object)this.addCriteriaWWModel);
        this.addCriteriaWWModel.setValue(ADD_CRITERIA, (Object)"archiving.add");
        this.addCriteriaWWModel.setValue("SAMQFS_POLICY_NAME", (Object)policyName);
        this.addCriteriaWWModel.setValue("SERVER_NAME", (Object)serverName);
    }

    public void handleSamQFSWizardAddCriteriaRequest(RequestInvocationEvent rie) throws ServletException, IOException {
        this.addCriteriaWizardRunning = true;
        this.getParentViewBean().forwardTo(this.getRequestContext());
    }

    public void handleAddCriteriaForwardToVBRequest(RequestInvocationEvent rie) throws ServletException, IOException {
        this.addCriteriaWizardRunning = false;
        this.getParentViewBean().forwardTo(this.getRequestContext());
    }

    public void handleEditCriteriaRequest(RequestInvocationEvent rie) throws ServletException, IOException {
        CommonViewBeanBase source = (CommonViewBeanBase)this.getParentViewBean();
        String cns = source.getDisplayFieldStringValue("selectedCriteriaNumber");
        Integer criteriaNumber = new Integer(cns);
        source.setPageSessionAttribute("SAMQFS_criteria_number", criteriaNumber);
        ViewBean target = this.getViewBean(class$com$sun$netstorage$samqfs$web$archive$CriteriaDetailsViewBean == null ? (class$com$sun$netstorage$samqfs$web$archive$CriteriaDetailsViewBean = FileMatchCriteriaView.class$("com.sun.netstorage.samqfs.web.archive.CriteriaDetailsViewBean")) : class$com$sun$netstorage$samqfs$web$archive$CriteriaDetailsViewBean);
        BreadCrumbUtil.breadCrumbPathForward((ViewBean)source, PageInfo.getPageInfo().getPageNumber(source.getName()));
        source.forwardTo(target);
    }

    public void handleRemoveCriteriaRequest(RequestInvocationEvent rie) throws ServletException, IOException {
        PolicyDetailsViewBean parent = (PolicyDetailsViewBean)this.getParentViewBean();
        String cnString = parent.getDisplayFieldStringValue("selectedCriteriaNumber");
        String serverName = parent.getServerName();
        try {
            int criteriaNumber = Integer.parseInt(cnString);
            String policyName = (String)parent.getPageSessionAttribute("SAMQFS_POLICY_NAME");
            ArchivePolicy thePolicy = SamUtil.getModel(serverName).getSamQFSSystemArchiveManager43().getArchivePolicy(policyName);
            thePolicy.deleteArchivePolCriteria(criteriaNumber);
            SamUtil.getModel(serverName).getSamQFSSystemArchiveManager43().getAllArchivePolicies();
            String temp = SamUtil.getResourceString("archiving.criterianumber", cnString);
            SamUtil.setInfoAlert((ContainerView)parent, "Alert", "success.summary", SamUtil.getResourceString("archiving.criteria.delete.success", temp));
        }
        catch (SamFSWarnings sfw) {
            SamUtil.processException((Exception)((Object)sfw), ((Object)((Object)this)).getClass(), "handleRemoveCriteriaRequest", "Unable to remove policy criteria", serverName);
            SamUtil.setWarningAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveConfig.error", "ArchiveConfig.warning.detail");
        }
        catch (SamFSMultiMsgException sme) {
            SamUtil.processException((Exception)((Object)sme), ((Object)((Object)this)).getClass(), "handleRemoveCriteriaRequest", "Unable to remove policy criteria", serverName);
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveConfig.error.detail", sme.getSAMerrno(), sme.getMessage(), serverName);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "handleRemoveCriteriaRequest", "Unable to remove policy criteria", serverName);
            String temp = SamUtil.getResourceString("archiving.criterianumber", cnString);
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", SamUtil.getResourceString("archiving.criteria.delete.failure", temp), sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
        parent.forwardTo(this.getRequestContext());
    }

    protected void initializeTableHeaders() {
        this.tableModel.setActionValue("StartingDirectory", (Object)"archiving.startingdirectory");
        this.tableModel.setActionValue("NamePattern", (Object)"archiving.namepattern");
        this.tableModel.setActionValue("Owner", (Object)"archiving.owner");
        this.tableModel.setActionValue("Group", (Object)"archiving.group");
        this.tableModel.setActionValue("MinimumSize", (Object)"archiving.minimumsize");
        this.tableModel.setActionValue("MaximumSize", (Object)"archiving.maximumsize");
        this.tableModel.setActionValue("AccessAge", (Object)"archiving.accessage");
        this.tableModel.setActionValue("ArchiveAge", (Object)"archiving.archiveage");
        this.tableModel.setActionValue("MediaTypeColumn", (Object)"archiving.media.type");
        this.tableModel.setActionValue("DeleteCriteria", (Object)"archiving.delete");
        this.tableModel.setActionValue(REMOVE_CRITERIA, (Object)"archiving.remove");
        this.tableModel.setActionValue("EditCriteria", (Object)"archiving.edit");
    }

    public void populateTableModel() {
        CommonViewBeanBase parent = (CommonViewBeanBase)this.getParentViewBean();
        String policyName = (String)parent.getPageSessionAttribute("SAMQFS_POLICY_NAME");
        String serverName = parent.getServerName();
        NonSyncStringBuffer criteriaNumbers = new NonSyncStringBuffer();
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            ArchivePolicy thePolicy = sysModel.getSamQFSSystemArchiveManager43().getArchivePolicy(policyName);
            ArchivePolCriteria[] criteria = thePolicy.getArchivePolCriteria();
            this.tableModel.clear();
            for (int i = 0; i < criteria.length; ++i) {
                if (i > 0) {
                    this.tableModel.appendRow();
                    criteriaNumbers.append(",");
                }
                ArchivePolCriteriaProp prop = criteria[i].getArchivePolCriteriaProperties();
                Integer criteriaNumber = new Integer(criteria[i].getIndex());
                this.tableModel.setValue("CriteriaNumber", (Object)criteriaNumber);
                this.tableModel.setValue("StartingDirectoryText", (Object)prop.getStartingDir());
                this.tableModel.setValue("NamePatternText", (Object)prop.getNamePattern());
                this.tableModel.setValue("OwnerText", (Object)prop.getOwner());
                this.tableModel.setValue("GroupText", (Object)prop.getGroup());
                String minSize = PolicyUtil.getSizeString(prop.getMinSize(), prop.getMinSizeUnit());
                this.tableModel.setValue("MinimumSizeText", (Object)minSize);
                String maxSize = PolicyUtil.getSizeString(prop.getMaxSize(), prop.getMaxSizeUnit());
                this.tableModel.setValue("MaximumSizeText", (Object)maxSize);
                String accessAge = "";
                if (prop.getAccessAge() > 0L) {
                    accessAge = Long.toString(prop.getAccessAge()).concat(" ").concat(SamUtil.getTimeUnitL10NString(prop.getAccessAgeUnit()));
                }
                this.tableModel.setValue("AccessAgeText", (Object)accessAge);
                this.tableModel.setValue("ArchiveAgeText", (Object)PolicyUtil.getArchiveAgeString(criteria[i]));
                criteriaNumbers.append((Object)criteriaNumber);
                this.tableModel.setRowSelected(false);
                this.tableModel.setValue("MediaType", (Object)PolicyUtil.getMediaTypeString(criteria[i]));
            }
        }
        catch (SamFSWarnings sfw) {
            SamUtil.processException((Exception)((Object)sfw), ((Object)((Object)this)).getClass(), "populateTableModel", "unable to populate table model", serverName);
            SamUtil.setWarningAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveConfig.error", "ArchiveConfig.warning.detail");
        }
        catch (SamFSMultiMsgException smme) {
            SamUtil.processException((Exception)((Object)smme), ((Object)((Object)this)).getClass(), "populateTableModel", "unable to populate table model", serverName);
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveConfig.error.detail", smme.getSAMerrno(), smme.getMessage(), serverName);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "populateTableModel", "unable to populate table model", serverName);
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveConfig.error.summary", sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
        CCHiddenField field = (CCHiddenField)parent.getChild("criteriaNumbers");
        field.setValue((Object)criteriaNumbers.toString());
    }

    public void beginDisplay(DisplayEvent evt) throws ModelControlException {
        this.initializeTableHeaders();
        ((CCButton)this.getChild(REMOVE_CRITERIA)).setDisabled(true);
        ((CCButton)this.getChild("EditCriteria")).setDisabled(true);
        if (!SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.CONFIG)) {
            this.tableModel.setSelectionType("none");
            ((CCButton)this.getChild(ADD_CRITERIA)).setDisabled(true);
        }
    }

    public String getPageletUrl() {
        Integer policyType = (Integer)this.getParentViewBean().getPageSessionAttribute("SAMQFS_policy_type");
        if (policyType == 1002 || policyType == 1003) {
            return "/jsp/archive/FileMatchCriteriaPagelet.jsp";
        }
        return "/jsp/archive/BlankPagelet.jsp";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

