/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.archive.ArchiveSetUpViewBean;
import com.sun.netstorage.samqfs.web.model.archive43.DriveDirective;
import com.sun.netstorage.samqfs.web.model.archive43.GlobalArchiveDirective;
import com.sun.netstorage.samqfs.web.util.CommonTiledViewBase;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.html.CCTextField;

public class DriveLimitsTiledView
extends CommonTiledViewBase {
    public DriveLimitsTiledView(View parent, CCActionTableModel model, String name) {
        super(parent, model, name);
    }

    public boolean beginMaxDrivesForStageDisplay(ChildDisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = this.model.getRowIndex();
        try {
            String maxDrives = this.getMaxDrivesEditableValue("stage", index);
            if (!maxDrives.equals("-1")) {
                ((CCTextField)this.getChild("MaxDrivesForStage", index)).setValue((Object)maxDrives);
            }
        }
        catch (SamFSException smfex) {
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "beginMaxDrivesForStageDisplay", "Failed to retrieve maximum drives for stage", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", smfex.getSAMerrno(), smfex.getMessage(), this.getServerName());
        }
        catch (Exception ex) {
            SamUtil.processException(ex, ((Object)((Object)this)).getClass(), "beginMaxDrivesForStageDisplay", "Failed to retrieve maximum drives for stage", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", -2017, ex.getMessage(), this.getServerName());
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    public boolean beginMaxDrivesForArchiveDisplay(ChildDisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = this.model.getRowIndex();
        CCTextField driver = (CCTextField)this.getChild("MaxDrivesForArchive", index);
        try {
            String maxDrives = this.getMaxDrivesEditableValue("archive", index);
            if (!maxDrives.equals("-1")) {
                driver.setValue((Object)maxDrives);
            }
        }
        catch (SamFSException smfex) {
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "beginMaxDrivesForStageDisplay", "Failed to retrieve maximum drives for stage", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", smfex.getSAMerrno(), smfex.getMessage(), this.getServerName());
        }
        catch (Exception ex) {
            SamUtil.processException(ex, ((Object)((Object)this)).getClass(), "beginDriverCountDisplay", "Failed to set the driver count", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ArchiveSetupViewBean.error.failedPopulate", -2017, ex.getMessage(), this.getServerName());
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private String getMaxDrivesEditableValue(String type, int index) throws SamFSException {
        TraceUtil.trace3("Entering");
        DriveDirective[] drives = null;
        if (type.equals("archive")) {
            GlobalArchiveDirective globalDir = ((ArchiveSetUpViewBean)this.getParentViewBean()).getGlobalDirective();
            if (globalDir == null) {
                throw new SamFSException(null, -2015);
            }
            drives = globalDir.getDriveDirectives();
        } else if (type.equals("stage")) {
            drives = ((ArchiveSetUpViewBean)this.getParentViewBean()).getStageDriveDirectives();
        }
        if (drives == null) {
            throw new SamFSException(null, -2015);
        }
        if (drives.length == 0) {
            return "";
        }
        DriveDirective drive = drives[index];
        String value = Integer.toString(drive.getCount());
        value = value != null ? value.trim() : "";
        TraceUtil.trace3("Exiting");
        return value;
    }

    private String getServerName() {
        return ((CommonViewBeanBase)this.getParentViewBean()).getServerName();
    }
}

