/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.archive.SelectableGroupHelper;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.ServerInfo;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCRadioButton;
import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

public class ArchiveActivityViewBean
extends CommonViewBeanBase {
    private static final String PAGE_NAME = "ArchiveActivity";
    private static final String DEFAULT_DISPLAY_URL = "/jsp/archive/ArchiveActivity.jsp";
    private static final int TAB_NAME = 20;
    public static final String CHILD_ALERT = "Alert";
    public static final String CHILD_ARCHIVE_ACTIONS = "archiveValue";
    public static final String CHILD_STAGE_ACTIONS = "stageValue";
    private static CCPageTitleModel pageTitleModel = null;
    private static CCPropertySheetModel propertySheetModel = null;
    private NonSyncStringBuffer msgsBuf = new NonSyncStringBuffer();
    static /* synthetic */ Class class$com$sun$web$ui$view$alert$CCAlertInline;

    public ArchiveActivityViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL, 20);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.createPageTitleModel();
        this.createPropertySheetModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        PageTitleUtil.registerChildren((ContainerViewBase)this, pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, propertySheetModel);
        this.registerChild(CHILD_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = ArchiveActivityViewBean.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3("Entering");
        View child = null;
        if (super.isChildSupported(name)) {
            child = super.createChild(name);
        } else if (name.equals(CHILD_ALERT)) {
            CCAlertInline myChild = new CCAlertInline((ContainerView)this, name, null);
            myChild.setValue((Object)"info");
            child = myChild;
        } else if (PageTitleUtil.isChildSupported(pageTitleModel, name)) {
            child = PageTitleUtil.createChild((ContainerView)this, pageTitleModel, name);
        } else if (PropertySheetUtil.isChildSupported(propertySheetModel, name)) {
            child = PropertySheetUtil.createChild((ContainerView)this, propertySheetModel, name);
        } else {
            throw new IllegalArgumentException("Invalid child name [" + name + "]");
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        ServerInfo serverInfo;
        TraceUtil.trace3("Entering");
        String serverAPIVersion = "1.3.2";
        HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
        Hashtable serverTable = (Hashtable)session.getAttribute("SAMFS_SERVER_INFO");
        String hostName = this.getServerName();
        if (serverTable != null && hostName != null && (serverInfo = (ServerInfo)serverTable.get(hostName)) != null) {
            serverAPIVersion = serverInfo.getSamfsServerAPIVersion();
        }
        TraceUtil.trace2("serverAPIVersion = " + serverAPIVersion);
        CCRadioButton archiveActions2 = (CCRadioButton)this.getChild(CHILD_ARCHIVE_ACTIONS);
        CCRadioButton stageActions2 = (CCRadioButton)this.getChild(CHILD_STAGE_ACTIONS);
        if (serverAPIVersion.compareTo("1.3.2") < 0) {
            archiveActions2.setOptions(new OptionList(SelectableGroupHelper.archiveActions43.labels, SelectableGroupHelper.archiveActions43.values));
        } else {
            archiveActions2.setOptions(new OptionList(SelectableGroupHelper.archiveActions.labels, SelectableGroupHelper.archiveActions.values));
        }
        stageActions2.setOptions(new OptionList(SelectableGroupHelper.stageActions.labels, SelectableGroupHelper.stageActions.values));
        this.loadPropertySheetModel();
        if (!SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.SAM_CONTROL)) {
            ((CCButton)this.getChild("SubmitJobPageButton")).setDisabled(true);
            ((CCButton)this.getChild("CancelPageButton")).setDisabled(true);
        }
        archiveActions2.setValue((Object)String.valueOf(25));
        stageActions2.setValue((Object)String.valueOf(32));
        TraceUtil.trace3("Exiting");
    }

    private void createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (pageTitleModel == null) {
            pageTitleModel = PageTitleUtil.createModel("/jsp/archive/ArchiveActivityPageTitle.xml");
        }
        TraceUtil.trace3("Exiting");
    }

    private void createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        if (propertySheetModel == null) {
            propertySheetModel = PropertySheetUtil.createModel("/jsp/archive/ArchiveActivityPropertySheet.xml");
        }
        TraceUtil.trace3("Exiting");
    }

    private void loadPropertySheetModel() {
        TraceUtil.trace3("Entering");
        propertySheetModel.clear();
        TraceUtil.trace3("Exiting");
    }

    private void showAlert(String name) {
        TraceUtil.trace3("Entering");
        SamUtil.setInfoAlert((ContainerView)this, CHILD_ALERT, "success.summary", SamUtil.getResourceString("success.details", name), this.getServerName());
        TraceUtil.trace3("Exiting");
    }

    public void handleSubmitJobPageButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        boolean archive = false;
        boolean stage = false;
        String archiveOperation = (String)propertySheetModel.getValue(CHILD_ARCHIVE_ACTIONS);
        String stageOperation = (String)propertySheetModel.getValue(CHILD_STAGE_ACTIONS);
        TraceUtil.trace3("archiveOperation " + archiveOperation);
        TraceUtil.trace3("stageOperation " + stageOperation);
        if (!archiveOperation.equals(String.valueOf(25))) {
            archive = true;
        }
        if (!stageOperation.equals(String.valueOf(32))) {
            stage = true;
        }
        try {
            if (archive) {
                this.executeArchive(archiveOperation);
            }
            if (stage) {
                this.executeStage(stageOperation);
            }
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleSubmitJobPageButtonRequest", "Failed to execute the requested operation", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "ArchiveActivity.error", ex.getSAMerrno(), ex.getMessage(), this.getServerName());
        }
        if (archive || stage) {
            this.showAlert(this.msgsBuf.toString());
        }
        TraceUtil.trace3("Exiting");
        this.forwardTo(this.getRequestContext());
    }

    private void executeArchive(String archiveOperation) throws SamFSException {
        TraceUtil.trace3("Entering");
        int intOperation = Integer.parseInt(archiveOperation);
        SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        switch (intOperation) {
            case 20: {
                this.msgsBuf.append(SamUtil.getResourceString("ArchiveActivity.arrestart"));
                LogUtil.info(((Object)((Object)this)).getClass(), "handlePageActionButton1Request", "Start restart archive all");
                sysModel.getSamQFSSystemArchiveManager43().restartArchivingAll();
                LogUtil.info(((Object)((Object)this)).getClass(), "handlePageActionButton1Request", "Done restart archive all");
                break;
            }
            case 21: {
                this.msgsBuf.append(SamUtil.getResourceString("ArchiveActivity.aridle"));
                LogUtil.info(((Object)((Object)this)).getClass(), "handlePageActionButton1Request", "Start idle archive all");
                sysModel.getSamQFSSystemArchiveManager43().idleArchivingAll();
                LogUtil.info(((Object)((Object)this)).getClass(), "handlePageActionButton1Request", "Done idle archive all");
                break;
            }
            case 22: {
                this.msgsBuf.append(SamUtil.getResourceString("ArchiveActivity.arrun"));
                LogUtil.info(((Object)((Object)this)).getClass(), "handlePageActionButton1Request", "Start run archive all");
                sysModel.getSamQFSSystemArchiveManager43().runNowArchivingAll();
                LogUtil.info(((Object)((Object)this)).getClass(), "handlePageActionButton1Request", "Done run archive all");
                break;
            }
            case 23: {
                this.msgsBuf.append(SamUtil.getResourceString("ArchiveActivity.arrerun"));
                LogUtil.info(((Object)((Object)this)).getClass(), "handlePageActionButton1Request", "Start rerun archive all");
                sysModel.getSamQFSSystemArchiveManager43().rerunArchivingAll();
                LogUtil.info(((Object)((Object)this)).getClass(), "handlePageActionButton1Request", "Done rerun archive all");
                break;
            }
            case 24: {
                this.msgsBuf.append(SamUtil.getResourceString("ArchiveActivity.arstop"));
                LogUtil.info(((Object)((Object)this)).getClass(), "handlePageActionButton1Request", "Start stopping archive all");
                sysModel.getSamQFSSystemArchiveManager43().stopArchivingAll();
                LogUtil.info(((Object)((Object)this)).getClass(), "handlePageActionButton1Request", "Done stopping archive all");
                break;
            }
        }
        TraceUtil.trace3("Exiting");
    }

    private void executeStage(String stageOperation) throws SamFSException {
        TraceUtil.trace3("Entering");
        int intOperation = Integer.parseInt(stageOperation);
        SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        if (this.msgsBuf.length() != 0) {
            this.msgsBuf.append(", ");
        }
        switch (intOperation) {
            case 30: {
                this.msgsBuf.append(SamUtil.getResourceString("ArchiveActivity.stidle"));
                LogUtil.info(((Object)((Object)this)).getClass(), "issueStaging", "Start idle staging all");
                sysModel.getSamQFSSystemArchiveManager43().idleStagingAll();
                LogUtil.info(((Object)((Object)this)).getClass(), "issueStaging", "Done idle staging all");
                break;
            }
            case 31: {
                this.msgsBuf.append(SamUtil.getResourceString("ArchiveActivity.strun"));
                LogUtil.info(((Object)((Object)this)).getClass(), "issueStaging", "Start run staging all");
                sysModel.getSamQFSSystemArchiveManager43().runStagingAll();
                LogUtil.info(((Object)((Object)this)).getClass(), "issueStaging", "Done run staging all");
                break;
            }
        }
        TraceUtil.trace3("Exiting");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

