/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.mgmt.fs;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.fs.DiskDev;
import com.sun.netstorage.samqfs.mgmt.fs.FS;
import com.sun.netstorage.samqfs.mgmt.fs.Host;
import com.sun.netstorage.samqfs.mgmt.fs.MountOptions;
import com.sun.netstorage.samqfs.mgmt.fs.StripedGrp;

public class FSInfo {
    public static final String SEPARATE_METADATA = "ma";
    public static final String COMBINED_METADATA = "ms";
    public static final String UFS_DATA = "ufs";
    public static final int EQU_AUTO = 0;
    private String name;
    private int equ;
    private int dau;
    private String eqType;
    private DiskDev[] metadataDevs;
    private DiskDev[] dataDevs;
    private StripedGrp[] stripedGrps;
    private MountOptions opts;
    private String mntPoint;
    private String sharedFsServerName;
    private Host[] hosts;
    private long time;
    private int smallDau;
    private boolean archiving;
    private boolean shared;
    private long kbytesTotal;
    private long kbytesAvail;
    private int statusFlags;
    private String nfsShareState;
    public static final int FS_MOUNTED = 1;
    public static final int FS_MOUNTING = 2;
    public static final int FS_UMOUNT_IN_PROGRESS = 4;
    public static final int FS_SERVER = 16;
    public static final int FS_CLIENT = 32;
    public static final int FS_NODEVS = 64;
    public static final int FS_SAM = 128;
    public static final int FS_LOCK_WRITE = 256;
    public static final int FS_LOCK_NAME = 512;
    public static final int FS_LOCK_RM_NAME = 1024;
    public static final int FS_LOCK_HARD = 2048;
    public static final int FS_FREEZING = 0x1000000;
    public static final int FS_FROZEN = 0x2000000;
    public static final int FS_THAWING = 0x4000000;
    public static final int FS_RESYNCING = 0x8000000;
    public static final int FS_RELEASING = 0x20000000;
    public static final int FS_STAGING = 0x40000000;
    public static final int FS_ARCHIVING = Integer.MIN_VALUE;
    public static final String NFS_SHARED = "yes";
    public static final String NFS_NOTSHARED = "no";
    public static final String NFS_CONFIGURED = "config";

    private FSInfo(String string, int n, int n2, int n3, String string2, long l, boolean bl, boolean bl2, DiskDev[] diskDevArray, DiskDev[] diskDevArray2, StripedGrp[] stripedGrpArray, MountOptions mountOptions, String string3, long l2, long l3, String string4, Host[] hostArray, int n4, String string5) {
        this(string, n, n3, string2, diskDevArray, diskDevArray2, stripedGrpArray, mountOptions, string3);
        this.time = l;
        this.smallDau = n2;
        this.archiving = bl;
        this.shared = bl2;
        this.kbytesAvail = l3;
        this.kbytesTotal = l2;
        this.sharedFsServerName = string4;
        this.hosts = hostArray;
        this.statusFlags = n4;
        this.nfsShareState = string5;
    }

    public FSInfo(String string, int n, int n2, String string2, DiskDev[] diskDevArray, DiskDev[] diskDevArray2, StripedGrp[] stripedGrpArray, MountOptions mountOptions, String string3) {
        this.name = string;
        this.equ = n;
        this.dau = n2;
        this.eqType = string2;
        this.metadataDevs = diskDevArray;
        this.dataDevs = diskDevArray2;
        this.stripedGrps = stripedGrpArray;
        this.opts = mountOptions;
        this.mntPoint = string3;
        this.shared = false;
        this.sharedFsServerName = null;
        this.hosts = null;
        this.time = 0L;
    }

    public FSInfo(String string, int n, int n2, String string2, DiskDev[] diskDevArray, DiskDev[] diskDevArray2, StripedGrp[] stripedGrpArray, MountOptions mountOptions, String string3, String string4, boolean bl, boolean bl2, Host[] hostArray) {
        this(string, n, n2, string2, diskDevArray, diskDevArray2, stripedGrpArray, mountOptions, string3);
        this.shared = true;
        this.sharedFsServerName = string4;
        if (!bl) {
            this.statusFlags = 96;
        } else if (bl2) {
            this.statusFlags = 32;
        } else {
            this.statusFlags = 16;
            this.time = 0L;
        }
        this.hosts = hostArray;
    }

    public String getName() {
        return this.name;
    }

    public int getEqu() {
        return this.equ;
    }

    public int getDAUSize() {
        return this.dau;
    }

    public long getCreationTime() {
        return this.time;
    }

    public boolean isArchiving() {
        return this.archiving;
    }

    public boolean isShared() {
        return this.shared;
    }

    public MountOptions getMountOptions() {
        return this.opts;
    }

    public String getMountPoint() {
        return this.mntPoint;
    }

    public DiskDev[] getMetadataDevices() {
        return this.metadataDevs;
    }

    public DiskDev[] getDataDevices() {
        return this.dataDevs;
    }

    public StripedGrp[] getStripedGroups() {
        return this.stripedGrps;
    }

    public long getCapacity() {
        return this.kbytesTotal;
    }

    public long getAvailableSpace() {
        return this.kbytesAvail;
    }

    public String getServerName() {
        return this.sharedFsServerName;
    }

    public Host[] getHosts() {
        return this.hosts;
    }

    public String getNFSShareState() {
        return this.nfsShareState;
    }

    public void doNotMkfs() {
        this.time = 1L;
    }

    public boolean isMounted() {
        return (this.statusFlags & 1) == 1;
    }

    public boolean isMdServer() {
        return (this.statusFlags & 0x10) == 16;
    }

    public boolean isPotentialMdServer() {
        return (this.statusFlags & 0x20) == 32 && (this.statusFlags & 0x40) == 0;
    }

    public boolean isClient() {
        return (this.statusFlags & 0x60) == 96;
    }

    public int failoverStatus() {
        return this.statusFlags & 0xF000000;
    }

    public String toString() {
        int n;
        String string = "name=" + this.name + ",dau=" + this.dau + ",equ=" + this.equ + ",isArc=" + (this.archiving ? "T" : "F") + ",shared=" + (this.shared ? "T" : "F") + ",time=" + this.time + ",cap=" + this.kbytesTotal + ",space=" + this.kbytesAvail + Integer.toHexString(this.statusFlags) + "\n";
        string = string + "metadata devices:\n";
        if (this.metadataDevs != null) {
            for (n = 0; n < this.metadataDevs.length; ++n) {
                string = string + "   " + this.metadataDevs[n] + "\n";
            }
        } else {
            string = string + "  none\n";
        }
        string = string + "data devices:\n";
        if (this.dataDevs != null) {
            for (n = 0; n < this.dataDevs.length; ++n) {
                string = string + "   " + this.dataDevs[n] + "\n";
            }
        } else {
            string = string + "  none\n";
        }
        string = string + "striped groups devices:\n";
        if (this.stripedGrps != null) {
            for (n = 0; n < this.stripedGrps.length; ++n) {
                string = string + this.stripedGrps[n] + "\n";
            }
        }
        if (this.shared) {
            string = string + "MDS server:" + this.sharedFsServerName + "\n";
        }
        if (null != this.hosts) {
            string = string + "hosts config:\n";
            for (n = 0; n < this.hosts.length; ++n) {
                string = string + this.hosts[n] + "\n";
            }
        }
        return string;
    }

    public void create(Ctx ctx, boolean bl) throws SamFSException {
        FS.create(ctx, this, bl);
    }

    public void remove(Ctx ctx) throws SamFSException {
        FS.remove(ctx, this.name);
    }

    public void mount(Ctx ctx) throws SamFSException {
        FS.mount(ctx, this.name);
    }

    public void umount(Ctx ctx) throws SamFSException {
        FS.umount(ctx, this.name);
    }

    public void grow(Ctx ctx, DiskDev[] diskDevArray, DiskDev[] diskDevArray2, StripedGrp[] stripedGrpArray) throws SamFSException {
        FS.grow(ctx, this, diskDevArray, diskDevArray2, stripedGrpArray);
    }

    public void fsck(Ctx ctx, String string, boolean bl) throws SamFSException {
        FS.fsck(ctx, this.name, string, bl);
    }
}

