<%--
/*
 *    SAM-QFS_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *      Copyright (c) 2006 Sun Microsystems, Inc.
 *      All Rights Reserved.
 *
 *      Government Rights Notice
 *      Use, duplication, or disclosure by the U.S. Government is
 *      subject to restrictions set forth in the Sun Microsystems,
 *      Inc. license agreements and as provided in DFARS 227.7202-1(a)
 *      and 227.7202-3(a) (1995), DRAS 252.227-7013(c)(ii) (OCT 1988),
 *      FAR 12.212(a)(1995), FAR 52.227-19, or FAR 52.227-14 (ALT III),
 *      as applicable.  Sun Microsystems, Inc.
 *
 *    SAM-QFS_notice_end
 */

// ident	$Id: FSDetails.jsp,v 1.20.2.2 2006/03/22 20:24:15 kilemba Exp $
--%>
<%@ page info="Index" language="java" %> 
<%@taglib uri="/WEB-INF/tld/com_iplanet_jato/jato.tld" prefix="jato"%>
<%@taglib uri="/WEB-INF/tld/com_sun_web_ui/cc.tld" prefix="cc"%>
<%@taglib uri="/WEB-INF/tld/com_sun_netstorage_samqfs_web_ui/scope.tld" prefix="samqfs"%>

<jato:useViewBean className="com.sun.netstorage.samqfs.web.fs.FSDetailsViewBean">

<cc:header
    pageTitle="FSDetails.pageTitle" 
    copyrightYear="2006"
    baseName="com.sun.netstorage.samqfs.web.resources.Resources" 
    onLoad="enableComponents()"
    bundleID="testBundle">

<script language="javascript">

    function getDropDownSelectedItem() {
        var index = -1;
        var myForm = document.FSDetailsForm;
        var dropDownMenu =
            myForm.elements["FSDetails.FSDetailsView.PageActionsMenu"];

        if (dropDownMenu != null) {
            index = dropDownMenu.value;
        }

        return index;
    }

    function resetDropDownMenu() {

        var myForm = document.FSDetailsForm;
        var dropDownMenu =
            myForm.elements["FSDetails.FSDetailsView.PageActionsMenu"];

        // reset to Operation
        dropDownMenu.options[0].selected = true;
    }

    function getClientParams() {
        var myForm = document.FSDetailsForm;
        var fsName = myForm.elements["FSDetails.FSDetailsView.fsName"].value;
        var serverName = myForm.elements["FSDetails.ServerName"].value;
        var clientParams =
            "fsNameParam=" + fsName + "&" + "serverNameParam=" + serverName;
        return clientParams;
    }

    function enableComponents() {
        var myForm = document.FSDetailsForm;
        var enabledMenuOptions =
            myForm.elements[
                "FSDetails.FSDetailsView.HiddenDynamicMenuOptions"].value;

        var actionMenu = "FSDetails.FSDetailsView.PageActionsMenu";
        var formName      = "FSDetailsForm";

        var menuOptionStates = new Array();
        menuOptionStates[0] = true; // not used
        menuOptionStates[1] = true; // fsck
        menuOptionStates[2] = true; // mount
        menuOptionStates[3] = true; // umount
        menuOptionStates[4] = true; // delete
        menuOptionStates[5] = true; // edit NFS properties
        menuOptionStates[6] = true; // stop archiving
        menuOptionStates[7] = true; // idle archiving
        menuOptionStates[8] = true; // run archiving
        menuOptionStates[9] = true; // schedule snapshot
        menuOptionStates[10] = true; // take snapshot
        menuOptionStates[11] = true; // remove schedule
        menuOptionStates[12] = true; // restore
        
        var options =
            myForm.elements[
                "FSDetails.FSDetailsView.HiddenDynamicMenuOptions"].value;
        var optionsArray = options.split(",");
        var optionsSize = optionsArray.length;

        for (i = 0; i < optionsSize; i++) {
            var index = parseInt(optionsArray[i]);
            if (index > 0 && index < menuOptionStates.length) {
                menuOptionStates[index] = false;
            }
        }

        for (i = 1; i < menuOptionStates.length; i++) {
            ccSetDropDownMenuOptionDisabled(
                actionMenu,
                formName,
                menuOptionStates[i],
                i);
        }
    }

    function showConfirmMsg(key) {

        var str1 = "<cc:text name='StaticText' bundleID='testBundle' 
            defaultValue='FSDetails.confirmDeleteMsg'/>";
        var str2 = "<cc:text name='StaticText' bundleID='testBundle' 
            defaultValue='FSDetails.confirmUnmountAndUnshareMsg'/>";
        var str3 = "<cc:text name='StaticText' bundleID='testBundle' 
            defaultValue='FSDetails.confirmRemoveScheduleMsg'/>";
        var fsName =
            document.FSDetailsForm.elements[
                "FSDetails.FSDetailsView.fsName"].value;

        if (key == 1) {
            if (!confirm(str1)) {
                return false;
            } else {
                return true;
            }
        } else if (key == 2) {
            if (!confirm(str2)) {
                return false;
            } else {
                 return true;
            }
        } else if (key == 3) {
            if (!confirm(str3 + " " + fsName + "?")) {
                return false;
            } else {
                return true;
            }
        } else {
            return false; // this case should never be used
        }
    }

</script>

<script language="javascript" src="/samqfsui/js/popuphelper.js"></script>
<script language="javascript" src="/samqfsui/js/fs/popups.js"></script>
<script language="javascript" src="/samqfsui/js/fs/cluster.js"></script>
<script language="javascript" src="/samqfsui/js/popuphelper.js"></script>


<!-- Form -->
<jato:form name="FSDetailsForm" method="post">

<!-- Masthead -->
<cc:primarymasthead name="Masthead" bundleID="testBundle" />

<samqfs:scope />
  
<!-- Navigation Tabs --> 
<jato:content name="LocalTabs">
<cc:tabs name="Tabs" bundleID="testBundle" />

</jato:content>

<!-- Bread Crumb componente-->
<cc:breadcrumbs name="BreadCrumb" bundleID="testBundle" />

<br>
<!-- inline alart -->
<cc:alertinline name="Alert" bundleID="testBundle" />
<br>

<jato:containerView name="FSDetailsView">

<!-- Page title -->
<cc:pagetitle name="PageTitle" 
              bundleID="testBundle"
              pageTitleText="FSDetails.pageTitle"
              showPageTitleSeparator="true"
              showPageButtonsTop="false"
              showPageButtonsBottom="false">


<!-- PropertySheet -->
<cc:propertysheet name="PropertySheet" 
              bundleID="testBundle" 
              showJumpLinks="false"/>

<cc:hidden name="SamfsckHiddenAction" />
<cc:hidden name="SamfsckHiddenLog" />
<cc:hidden name="DumpNowHiddenPath" />

<cc:hidden name="fsName" />
<cc:hidden name="HiddenDynamicMenuOptions" />

</cc:pagetitle>

</jato:containerView>

<!-- sunplex manager link -->
<cc:includepagelet name="SunPlexManagerView"/>

<!-- cluster node list table -->
<cc:includepagelet name="FSDClusterView"/>

<br>
<cc:hidden name="PreferencesHiddenField1" />
<cc:hidden name="ServerName" />

</jato:form>
</cc:header>
</jato:useViewBean> 

