/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.util;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.Util;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;

public final class TraceUtil {
    private static final boolean ON = true;
    private static final String TRACE_STDOUT_NAME = "stdout";
    private static final String TRACE_STDERR_NAME = "stderr";
    private static final String TRACE_FILE_NAME = "file";
    private static final int TRACE_OFF = 0;
    private static final int TRACE_STDOUT = 1;
    private static final int TRACE_STDERR = 2;
    private static final int TRACE_FILE = 3;
    private static final int TRACE_RETRY = 5;
    private static final int TRACE_STACKSIZE = 5;
    private static boolean trace_init = false;
    private static int trace_level = 0;
    private static int trace_stacksize = 5;
    private static int trace_out = 2;
    private static FileWriter trace_fw = null;
    private static BufferedWriter trace_bw = null;
    private static PrintWriter trace_pw = null;
    private static final String SUNOS_FILE_CONFIG_PATH = "/etc/opt/webconsole/webconsole";
    private static final String TRACE_PROP_DEVICE = "com.sun.netstorage.samqfs.web.tracedevice";
    private static final String TRACE_PROP_LEVEL = "com.sun.netstorage.samqfs.web.tracelevel";

    public static final synchronized void initTrace() {
        String level = TraceUtil.getProperty(TRACE_PROP_LEVEL);
        String device = TraceUtil.getProperty(TRACE_PROP_DEVICE);
        if (level == null || device == null) {
            trace_level = 0;
            trace_init = false;
            return;
        }
        if (device != null && device.equalsIgnoreCase(TRACE_FILE_NAME)) {
            device = "component";
        }
        trace_stacksize = 5;
        TraceUtil.traceOpen(level, device);
        Util.setNativeTraceLevel((int)trace_level);
        TraceUtil.trace1(new NonSyncStringBuffer("Starting component debug tracing. L").append(trace_level).toString());
    }

    private static final void traceOpen(String level, String filename) {
        TraceUtil.openTrace(level, filename);
    }

    public static final boolean isOn() {
        return trace_level > 0;
    }

    public static final boolean isOnLevel2() {
        return trace_level > 1;
    }

    public static final boolean isOnLevel3() {
        return trace_level > 2;
    }

    public static final void trace1(String message) {
        if (trace_level > 0) {
            TraceUtil.writeTraceToSyslog(message);
        }
    }

    public static final void trace1(String message, Throwable ex) {
        if (trace_level > 0) {
            TraceUtil.writeTraceToSyslog(message);
            if (ex != null) {
                TraceUtil.writeStackTraceToSyslog(ex);
            }
        }
    }

    public static final void trace2(String message) {
        if (trace_level > 1) {
            TraceUtil.writeTraceToSyslog(message);
        }
    }

    public static final void trace2(String message, Throwable ex) {
        if (trace_level > 1) {
            TraceUtil.writeTraceToSyslog(message);
            if (ex != null) {
                TraceUtil.writeStackTraceToSyslog(ex);
            }
        }
    }

    public static final void trace3(String message) {
        if (trace_level > 2) {
            TraceUtil.writeTraceToSyslog(message);
        }
    }

    public static final void trace3(String message, Throwable ex) {
        if (trace_level > 2) {
            TraceUtil.writeTraceToSyslog(message);
            if (ex != null) {
                TraceUtil.writeStackTraceToSyslog(ex);
            }
        }
    }

    public static void writeTraceToSyslog(String msg) {
        NonSyncStringBuffer full_msg = new NonSyncStringBuffer().append("ui:");
        full_msg.append(Thread.currentThread().getName()).append(">").append(TraceUtil.getClassMethod()).append(':').append(msg);
        Util.writeToSyslog((String)full_msg.toString());
    }

    public static void writeStackTraceToSyslog(Throwable ex) {
        if (null != ex) {
            StackTraceElement[] elems = ex.getStackTrace();
            int j = elems.length;
            if (j > trace_stacksize) {
                j = trace_stacksize;
            }
            for (int i = 0; i < j; ++i) {
                Util.writeToSyslog((String)("    " + elems[i].toString()));
            }
        }
    }

    private static void openTrace(String level, String filename) {
        String trace_file = null;
        Object trace_sufx = null;
        if (trace_init && level != null && Integer.parseInt(level) != trace_level) {
            trace_level = Integer.parseInt(level);
            return;
        }
        trace_level = 0;
        if (level != null) {
            Integer ix;
            try {
                ix = new Integer(level.substring(0, 1));
            }
            catch (Exception ex) {
                ix = new Integer(0);
            }
            trace_level = ix;
        }
        Util.setNativeTraceLevel((int)trace_level);
        if (trace_level == 0) {
            return;
        }
        if (filename != null && filename.trim().length() != 0) {
            if (filename.equals(TRACE_STDOUT_NAME)) {
                trace_out = 1;
            } else if (filename.equals(TRACE_STDERR_NAME)) {
                trace_out = 2;
            } else {
                trace_out = 3;
                trace_file = filename.trim();
            }
        } else {
            trace_level = 2;
        }
        trace_init = true;
    }

    private static void writeStackTrace(Throwable ex) {
        StackTraceElement[] elems = ex.getStackTrace();
        int j = elems.length;
        if (j > trace_stacksize) {
            j = trace_stacksize;
        }
        for (int i = 0; i < j; ++i) {
            String line = new NonSyncStringBuffer("    ").append(elems[i].toString()).toString();
            try {
                if (trace_out == 3) {
                    trace_pw.println(line);
                    continue;
                }
                if (trace_out == 1) {
                    System.out.println(line);
                    continue;
                }
                if (trace_out != 2) continue;
                System.err.println(line);
                continue;
            }
            catch (Exception x) {
                // empty catch block
            }
        }
    }

    private static String getClassMethod() {
        String cn;
        String clmd = null;
        int depth = 3;
        StackTraceElement[] elems = new Exception().getStackTrace();
        if (elems.length > 3 && (cn = elems[3].getClassName()) != null) {
            int i = cn.lastIndexOf(46);
            clmd = i > 0 ? cn.substring(i + 1) : cn;
            String mn = elems[3].getMethodName();
            if (mn != null) {
                clmd = clmd + ":" + mn;
            }
        }
        return clmd;
    }

    private static synchronized String getProperty(String name) {
        if (name == null) {
            return null;
        }
        Properties tprops = TraceUtil.loadFileProperties(SUNOS_FILE_CONFIG_PATH);
        if (tprops != null) {
            Enumeration<?> en = tprops.propertyNames();
            while (en.hasMoreElements()) {
                String pname = (String)en.nextElement();
                if (!pname.equals(name)) continue;
                String pval = (String)tprops.get(pname);
                return pval;
            }
        }
        return null;
    }

    private static synchronized Properties loadFileProperties(String fileName) {
        FileInputStream fin = null;
        BufferedInputStream bin = null;
        boolean fileFound = true;
        try {
            fin = new FileInputStream(fileName);
            bin = new BufferedInputStream(fin);
        }
        catch (FileNotFoundException fex) {
            fileFound = false;
        }
        if (fileFound) {
            try {
                Properties props = new Properties();
                props.load(bin);
                fin.close();
                bin.close();
                return props;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return null;
    }
}

