/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.util;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.ViewBeanBase;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.ServerInfo;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCTabsModel;
import java.io.Serializable;
import java.util.Hashtable;

public class TabsUtil {
    public static final int FS_TAB = 0;
    public static final int ARCHIVE_TAB = 1;
    public static final int MEDIA_TAB = 2;
    public static final int JOBS_TAB = 3;
    public static final int ALARMS_TAB = 4;
    public static final int ADMIN_TAB = 5;
    public static final int ARCHIVEPOL_TAB = 7;
    public static final int ARCHIVEVSN_TAB = 8;
    public static final int ARCHIVESETUP_TAB = 9;
    public static final int MEDIALIB_TAB = 10;
    public static final int MEDIASTANDALONE_TAB = 11;
    public static final int JOBSCURRENT_TAB = 12;
    public static final int JOBSPENDING_TAB = 13;
    public static final int JOBSALL_TAB = 14;
    public static final int JOBSHIS_TAB = 15;
    public static final int RECYCLER_TAB = 18;
    public static final int ADMINNOTIFICATION_TAB = 19;
    public static final int ARCHIVEACTIVITY_TAB = 20;
    public static final int SERVER_CONFIGURATION_TAB = 21;
    public static final int ARCHIVEDISKVSN_TAB = 22;
    private static CCNavNode fsTab = new CCNavNode(0, "fstab", "fstabtooltip", "fstabstatus");
    private static CCNavNode archiveTab = new CCNavNode(1, "archivetab", "archivetabtooltip", "archivetabstatus");
    private static CCNavNode mediaTab = new CCNavNode(2, "mediatab", "mediatabtooltip", "mediatabstatus");
    private static CCNavNode jobsTab = new CCNavNode(3, "jobstab", "jobstabtooltip", "jobstabstatus");
    private static CCNavNode alarmsTab = new CCNavNode(4, "alarmstab", "alarmstabtooltip", "alarmstabstatus");
    private static CCNavNode adminTab = new CCNavNode(5, "admintab", "admintabtooltip", "admintabstatus");
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$PolicySummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$jobs$CurrentJobsViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$alarms$CurrentAlarmSummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$admin$ServerConfigurationViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$DiskVSNSummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$ArchiveSetUpViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$RecyclerViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$ArchiveActivityViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$media$StandAloneSummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$jobs$PendingJobsViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$jobs$AllJobsViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$admin$AdminNotificationViewBean;

    public static CCTabsModel createTabsModel(int selectedTab, String hostName) {
        CCTabsModel tabsModel = null;
        ServerInfo serverInfo = null;
        try {
            serverInfo = SamUtil.getServerInfo(hostName);
        }
        catch (SamFSException samEx) {
            TraceUtil.trace1(new NonSyncStringBuffer("Exception caught while retreiving server info. Reason: ").append(samEx.getMessage()).toString());
            return TabsUtil.populateTabsModel(selectedTab, hostName, true);
        }
        tabsModel = serverInfo.getTabsModel();
        if (tabsModel == null) {
            return TabsUtil.populateTabsModel(selectedTab, hostName, false);
        }
        tabsModel.setSelectedNode(selectedTab);
        return tabsModel;
    }

    private static void initTabNodes(String hostName) {
        ServerInfo serverInfo = null;
        boolean isQFSStandAlone = SamUtil.getSystemType(hostName) == 1;
        try {
            serverInfo = SamUtil.getServerInfo(hostName);
        }
        catch (SamFSException samEx) {
            TraceUtil.trace1(new NonSyncStringBuffer("Exception caught while retreiving server info. Reason: ").append(samEx.getMessage()).toString());
            serverInfo = new ServerInfo(hostName);
        }
        CCNavNode parent1 = archiveTab;
        CCNavNode archivePoliciesTab = new CCNavNode(7, (CCNavNodeInterface)parent1, "archivepolicestab", "archivepolicestabtooltip", "archivepolicestabstatus");
        CCNavNode archiveVSNTab = new CCNavNode(8, (CCNavNodeInterface)parent1, "archivevsntab", "archivevsntabtooltip", "archivevsntabstatus");
        CCNavNode archiveDiskVSNTab = new CCNavNode(22, (CCNavNodeInterface)parent1, "archivediskvsntab", "archivediskvsntabtooltip", "archivediskvsntabstatus");
        CCNavNode archiveSetupTab = new CCNavNode(9, (CCNavNodeInterface)parent1, "archivesetuptab", "archivesetuptabtooltip", "archivesetuptabstatus");
        CCNavNode adminGeneralSettingsTab = new CCNavNode(18, (CCNavNodeInterface)parent1, "recyclertab", "recyclertabtooltip", "recyclertabstatus");
        CCNavNode adminActivityTab = new CCNavNode(20, (CCNavNodeInterface)parent1, "archiveactivitytab", "archiveactivitytabtooltip", "archiveactivitytabstatus");
        CCNavNode parent2 = mediaTab;
        CCNavNode mediaLibTab = new CCNavNode(10, (CCNavNodeInterface)parent2, "medialibtab", "medialibtabtooltip", "medialibtabstatus");
        CCNavNode mediaStandAloneTab = new CCNavNode(11, (CCNavNodeInterface)parent2, "mediastandalonetab", "mediastandalonetabtooltip", "mediastandalonetabstatus");
        CCNavNode parent4 = jobsTab;
        CCNavNode jobsCurrentTab = new CCNavNode(12, (CCNavNodeInterface)parent4, "jobscurrenttab", "jobscurrenttabtooltip", "jobscurrenttabstatus");
        CCNavNode jobsPendingTab = new CCNavNode(13, (CCNavNodeInterface)parent4, "jobspendingtab", "jobspendingtabtooltip", "jobspendingtabstatus");
        CCNavNode jobsAllTab = new CCNavNode(14, (CCNavNodeInterface)parent4, "jobsalltab", "jobsalltabtooltip", "jobsalltabstatus");
        CCNavNode parent5 = adminTab;
        CCNavNode hostConfigurationTab = new CCNavNode(21, (CCNavNodeInterface)parent5, "serverconfigtab", "serverconfigtooltip", "serverconfigtabstatus");
        CCNavNode adminNotificationTab = new CCNavNode(19, (CCNavNodeInterface)parent5, "adminnottab", "adminnottabtooltip", "adminnottabstatus");
    }

    private static CCTabsModel populateTabsModel(int selectedTab, String hostName, boolean forDownServers) {
        ServerInfo serverInfo = null;
        CCTabsModel tabsModel = new CCTabsModel();
        mediaTab.removeAllChildren();
        adminTab.removeAllChildren();
        archiveTab.removeAllChildren();
        jobsTab.removeAllChildren();
        TabsUtil.initTabNodes(hostName);
        boolean isQFSStandAlone = false;
        if (!forDownServers) {
            isQFSStandAlone = SamUtil.getSystemType(hostName) == 1;
            try {
                serverInfo = SamUtil.getServerInfo(hostName);
            }
            catch (SamFSException samEx) {
                TraceUtil.trace1(new NonSyncStringBuffer("Exception caught while retreiving server info. Reason: ").append(samEx.getMessage()).toString());
                serverInfo = new ServerInfo(hostName);
            }
        } else {
            TraceUtil.trace2("Generating tabsModel for down servers");
        }
        tabsModel.addNode((CCNavNodeInterface)fsTab);
        if (isQFSStandAlone) {
            tabsModel.addNode((CCNavNodeInterface)jobsTab);
            tabsModel.addNode((CCNavNodeInterface)alarmsTab);
            tabsModel.addNode((CCNavNodeInterface)adminTab);
        } else {
            tabsModel.addNode((CCNavNodeInterface)archiveTab);
            tabsModel.addNode((CCNavNodeInterface)mediaTab);
            tabsModel.addNode((CCNavNodeInterface)jobsTab);
            tabsModel.addNode((CCNavNodeInterface)alarmsTab);
            tabsModel.addNode((CCNavNodeInterface)adminTab);
        }
        tabsModel.setSelectedNode(selectedTab);
        if (!forDownServers) {
            serverInfo.setTabsModel(tabsModel);
            Hashtable serverTable = SamUtil.getServerTable();
            serverTable.put(hostName, serverInfo);
            RequestManager.getRequestContext().getRequest().getSession().setAttribute("SAMFS_SERVER_INFO", (Object)serverTable);
        }
        return tabsModel;
    }

    public static boolean handleTabClickRequest(ViewBeanBase viewBean, RequestInvocationEvent event, int id, String hostName) {
        return TabsUtil.forwardToTab(viewBean, id, hostName);
    }

    public static boolean forwardToTab(ViewBeanBase viewBean, int id, String hostName) {
        ViewBean targetView = null;
        boolean handled = false;
        switch (id) {
            case 0: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.fs.FSSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean);
                handled = true;
                break;
            }
            case 1: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$archive$PolicySummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$archive$PolicySummaryViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.archive.PolicySummaryViewBean")) : class$com$sun$netstorage$samqfs$web$archive$PolicySummaryViewBean);
                handled = true;
                break;
            }
            case 2: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.media.LibrarySummaryViewBean")) : class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean);
                handled = true;
                break;
            }
            case 3: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$jobs$CurrentJobsViewBean == null ? (class$com$sun$netstorage$samqfs$web$jobs$CurrentJobsViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.jobs.CurrentJobsViewBean")) : class$com$sun$netstorage$samqfs$web$jobs$CurrentJobsViewBean);
                handled = true;
                break;
            }
            case 4: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$alarms$CurrentAlarmSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$alarms$CurrentAlarmSummaryViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.alarms.CurrentAlarmSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$alarms$CurrentAlarmSummaryViewBean);
                handled = true;
                break;
            }
            case 5: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$admin$ServerConfigurationViewBean == null ? (class$com$sun$netstorage$samqfs$web$admin$ServerConfigurationViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.admin.ServerConfigurationViewBean")) : class$com$sun$netstorage$samqfs$web$admin$ServerConfigurationViewBean);
                handled = true;
                break;
            }
            case 7: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$archive$PolicySummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$archive$PolicySummaryViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.archive.PolicySummaryViewBean")) : class$com$sun$netstorage$samqfs$web$archive$PolicySummaryViewBean);
                handled = true;
                break;
            }
            case 8: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.archive.VSNPoolSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$archive$VSNPoolSummaryViewBean);
                handled = true;
                break;
            }
            case 22: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$archive$DiskVSNSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$archive$DiskVSNSummaryViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.archive.DiskVSNSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$archive$DiskVSNSummaryViewBean);
                handled = true;
                break;
            }
            case 9: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$archive$ArchiveSetUpViewBean == null ? (class$com$sun$netstorage$samqfs$web$archive$ArchiveSetUpViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.archive.ArchiveSetUpViewBean")) : class$com$sun$netstorage$samqfs$web$archive$ArchiveSetUpViewBean);
                handled = true;
                break;
            }
            case 18: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$archive$RecyclerViewBean == null ? (class$com$sun$netstorage$samqfs$web$archive$RecyclerViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.archive.RecyclerViewBean")) : class$com$sun$netstorage$samqfs$web$archive$RecyclerViewBean);
                handled = true;
                break;
            }
            case 20: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$archive$ArchiveActivityViewBean == null ? (class$com$sun$netstorage$samqfs$web$archive$ArchiveActivityViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.archive.ArchiveActivityViewBean")) : class$com$sun$netstorage$samqfs$web$archive$ArchiveActivityViewBean);
                handled = true;
                break;
            }
            case 10: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.media.LibrarySummaryViewBean")) : class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean);
                handled = true;
                break;
            }
            case 11: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$media$StandAloneSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$media$StandAloneSummaryViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.media.StandAloneSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$media$StandAloneSummaryViewBean);
                handled = true;
                break;
            }
            case 12: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$jobs$CurrentJobsViewBean == null ? (class$com$sun$netstorage$samqfs$web$jobs$CurrentJobsViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.jobs.CurrentJobsViewBean")) : class$com$sun$netstorage$samqfs$web$jobs$CurrentJobsViewBean);
                handled = true;
                break;
            }
            case 13: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$jobs$PendingJobsViewBean == null ? (class$com$sun$netstorage$samqfs$web$jobs$PendingJobsViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.jobs.PendingJobsViewBean")) : class$com$sun$netstorage$samqfs$web$jobs$PendingJobsViewBean);
                handled = true;
                break;
            }
            case 14: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$jobs$AllJobsViewBean == null ? (class$com$sun$netstorage$samqfs$web$jobs$AllJobsViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.jobs.AllJobsViewBean")) : class$com$sun$netstorage$samqfs$web$jobs$AllJobsViewBean);
                handled = true;
                break;
            }
            case 21: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$admin$ServerConfigurationViewBean == null ? (class$com$sun$netstorage$samqfs$web$admin$ServerConfigurationViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.admin.ServerConfigurationViewBean")) : class$com$sun$netstorage$samqfs$web$admin$ServerConfigurationViewBean);
                handled = true;
                break;
            }
            case 19: {
                targetView = viewBean.getViewBean(class$com$sun$netstorage$samqfs$web$admin$AdminNotificationViewBean == null ? (class$com$sun$netstorage$samqfs$web$admin$AdminNotificationViewBean = TabsUtil.class$("com.sun.netstorage.samqfs.web.admin.AdminNotificationViewBean")) : class$com$sun$netstorage$samqfs$web$admin$AdminNotificationViewBean);
                handled = true;
                break;
            }
        }
        if (handled) {
            targetView.setPageSessionAttribute("SERVER_NAME", (Serializable)((Object)hostName));
            targetView.forwardTo(viewBean.getRequestContext());
        }
        return handled;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

