/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.util;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.sun.netstorage.samqfs.mgmt.SamFSAccessDeniedException;
import com.sun.netstorage.samqfs.mgmt.SamFSCommException;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiHostException;
import com.sun.netstorage.samqfs.mgmt.SamFSNotInitException;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.alarm.Alarm;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.SecurityUtil;
import com.sun.netstorage.samqfs.web.util.ServerInfo;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.view.alert.CCAlertInline;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SamUtil {
    public static SamQFSSystemModel getModel() throws SamFSException {
        HttpSession session;
        String hostName;
        SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
        if (appModel.getSamQFSSystemModel(hostName = (String)(session = RequestManager.getRequestContext().getRequest().getSession()).getAttribute("SERVER_NAME")).isDown()) {
            throw new SamFSException(null, -2800);
        }
        return appModel.getSamQFSSystemModel(hostName);
    }

    public static boolean isClusterNode(String serverName) throws SamFSException {
        return SamUtil.getModel(serverName).isClusterNode();
    }

    public static SamQFSSystemModel getModel(String serverName) throws SamFSException {
        SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
        SamQFSSystemModel model = appModel.getSamQFSSystemModel(serverName);
        if (model.isDown()) {
            if (model.isAccessDenied()) {
                throw new SamFSException(null, -2803);
            }
            throw new SamFSException(null, -2800);
        }
        return model;
    }

    public static String getAPIVersion() throws SamFSException {
        HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
        String serverName = (String)session.getAttribute("SERVER_NAME");
        String key = "api_version_prefix." + serverName;
        String version = (String)session.getAttribute(key);
        if (version == null) {
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            SamQFSSystemModel model = appModel.getSamQFSSystemModel(serverName);
            if (model.isDown()) {
                throw new SamFSException(null, -2800);
            }
            version = model.getServerAPIVersion();
            session.setAttribute(key, (Object)version);
        }
        return version;
    }

    public static String getAPIVersion(String serverName) throws SamFSException {
        String key = new NonSyncStringBuffer().append("api_version_prefix").append(".").append(serverName).toString();
        HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
        SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
        SamQFSSystemModel model = appModel.getSamQFSSystemModel(serverName);
        if (model.isDown()) {
            throw new SamFSException(null, -2800);
        }
        String version = model.getServerAPIVersion();
        session.setAttribute(key, (Object)version);
        return version;
    }

    public static String getAPIVersionFromUIVersion(String uiVersion) {
        if (uiVersion.equals("4.1")) {
            return "1.0";
        }
        if (uiVersion.equals("4.2")) {
            return "1.1";
        }
        if (uiVersion.equals("4.3")) {
            return "1.2";
        }
        if (uiVersion.equals("4.4")) {
            return "1.3";
        }
        if (uiVersion.equals("4.5")) {
            return "1.4";
        }
        return "";
    }

    public static boolean isVersionCurrentOrLaterThan(String version, String referenceVersion) {
        return version.compareTo(referenceVersion) >= 0;
    }

    public static int getNetworkAttachedLibraryNumber(String selection) {
        if (selection.equals("AddLibrary.manage1")) {
            return 117;
        }
        if (selection.equals("AddLibrary.manage2")) {
            return 118;
        }
        if (selection.equals("AddLibrary.manage3")) {
            return 119;
        }
        if (selection.equals("AddLibrary.manage4")) {
            return 120;
        }
        if (selection.equals("AddLibrary.manage5")) {
            return 121;
        }
        return -1;
    }

    public static String getLibraryDriverString(int dValue) {
        String libraryDriverString = null;
        switch (dValue) {
            case 1001: {
                libraryDriverString = SamUtil.getResourceString("library.driver.samst");
                break;
            }
            case 1002: {
                libraryDriverString = SamUtil.getResourceString("library.driver.acsls");
                break;
            }
            case 1003: {
                libraryDriverString = SamUtil.getResourceString("library.driver.adic");
                break;
            }
            case 1004: {
                libraryDriverString = SamUtil.getResourceString("library.driver.fuji");
                break;
            }
            case 1005: {
                libraryDriverString = SamUtil.getResourceString("library.driver.ibm");
                break;
            }
            case 1006: {
                libraryDriverString = SamUtil.getResourceString("library.driver.sony");
                break;
            }
            default: {
                libraryDriverString = SamUtil.getResourceString("library.driver.other");
            }
        }
        return libraryDriverString;
    }

    public static String getStateString(int sValue) {
        String libraryStateString = null;
        switch (sValue) {
            case 0: {
                libraryStateString = SamUtil.getResourceString("LibrarySummary.status1");
                break;
            }
            case 1: {
                libraryStateString = SamUtil.getResourceString("LibrarySummary.status2");
                break;
            }
            case 3: {
                libraryStateString = SamUtil.getResourceString("LibrarySummary.status4");
                break;
            }
            default: {
                libraryStateString = SamUtil.getResourceString("LibrarySummary.status5");
            }
        }
        return libraryStateString;
    }

    public static String getRobotTypeString(int rValue) {
        String robotTypeString = null;
        switch (rValue) {
            case 6347: {
                robotTypeString = SamUtil.getResourceString("robot.type.acl2640");
                break;
            }
            case 6346: {
                robotTypeString = SamUtil.getResourceString("robot.type.acl452");
                break;
            }
            case 6360: {
                robotTypeString = SamUtil.getResourceString("robot.type.atlp3000");
                break;
            }
            case 6367: {
                robotTypeString = SamUtil.getResourceString("robot.type.adic100");
                break;
            }
            case 6363: {
                robotTypeString = SamUtil.getResourceString("robot.type.adic1000");
                break;
            }
            case 6351: {
                robotTypeString = SamUtil.getResourceString("robot.type.adic448");
                break;
            }
            case 6371: {
                robotTypeString = SamUtil.getResourceString("robot.type.atl1500");
                break;
            }
            case 6274: {
                robotTypeString = SamUtil.getResourceString("robot.type.cyg1803");
                break;
            }
            case 6341: {
                robotTypeString = SamUtil.getResourceString("robot.type.dlt2700");
                break;
            }
            case 6275: {
                robotTypeString = SamUtil.getResourceString("robot.type.docstor");
                break;
            }
            case 6349: {
                robotTypeString = SamUtil.getResourceString("robot.type.exb210");
                break;
            }
            case 6364: {
                robotTypeString = SamUtil.getResourceString("robot.type.exbx80");
                break;
            }
            case 6231: {
                robotTypeString = SamUtil.getResourceString("robot.type.fujitsuLt300");
                break;
            }
            case 6220: {
                robotTypeString = SamUtil.getResourceString("robot.type.grauaci");
                break;
            }
            case 6369: {
                robotTypeString = SamUtil.getResourceString("robot.type.hpc7200");
                break;
            }
            case 6276: {
                robotTypeString = SamUtil.getResourceString("robot.type.hpoplib");
                break;
            }
            case 6356: {
                robotTypeString = SamUtil.getResourceString("robot.type.ibm3570c");
                break;
            }
            case 6366: {
                robotTypeString = SamUtil.getResourceString("robot.type.ibm3584");
                break;
            }
            case 6225: {
                robotTypeString = SamUtil.getResourceString("robot.type.ibmatl");
                break;
            }
            case 1281: {
                robotTypeString = SamUtil.getResourceString("robot.type.lms4500");
                break;
            }
            case 6344: {
                robotTypeString = SamUtil.getResourceString("robot.type.metd360");
                break;
            }
            case 6343: {
                robotTypeString = SamUtil.getResourceString("robot.type.metd28");
                break;
            }
            case 6372: {
                robotTypeString = SamUtil.getResourceString("robot.type.odineo");
                break;
            }
            case 6297: {
                robotTypeString = SamUtil.getResourceString("robot.type.plasmond");
                break;
            }
            case 6370: {
                robotTypeString = SamUtil.getResourceString("robot.type.qual82xx");
                break;
            }
            case 6145: {
                robotTypeString = SamUtil.getResourceString("robot.type.rap4500");
                break;
            }
            case 6357: {
                robotTypeString = SamUtil.getResourceString("robot.type.sanydms");
                break;
            }
            case 6234: {
                robotTypeString = SamUtil.getResourceString("robot.type.sonypsc");
                break;
            }
            case 6352: {
                robotTypeString = SamUtil.getResourceString("robot.type.speclog");
                break;
            }
            case 6222: {
                robotTypeString = SamUtil.getResourceString("robot.type.stkapi");
                break;
            }
            case 6354: {
                robotTypeString = SamUtil.getResourceString("robot.type.stk97xx");
                break;
            }
            case 6365: {
                robotTypeString = SamUtil.getResourceString("robot.type.stklxx");
                break;
            }
            default: {
                robotTypeString = SamUtil.getResourceString("robot.type.unknown");
            }
        }
        return robotTypeString;
    }

    public static String getMediaTypeString(int mValue) {
        String mediaTypeString = null;
        switch (mValue) {
            case 101: {
                mediaTypeString = SamUtil.getResourceString("media.type.sony");
                break;
            }
            case 102: {
                mediaTypeString = SamUtil.getResourceString("media.type.ampex");
                break;
            }
            case 103: {
                mediaTypeString = SamUtil.getResourceString("media.type.stk");
                break;
            }
            case 104: {
                mediaTypeString = SamUtil.getResourceString("media.type.dat");
                break;
            }
            case 105: {
                mediaTypeString = SamUtil.getResourceString("media.type.fuji");
                break;
            }
            case 106: {
                mediaTypeString = SamUtil.getResourceString("media.type.ibm3570");
                break;
            }
            case 107: {
                mediaTypeString = SamUtil.getResourceString("media.type.ibm3580");
                break;
            }
            case 108: {
                mediaTypeString = SamUtil.getResourceString("media.type.dlt");
                break;
            }
            case 109: {
                mediaTypeString = SamUtil.getResourceString("media.type.stk9490");
                break;
            }
            case 110: {
                mediaTypeString = SamUtil.getResourceString("media.type.stk9840");
                break;
            }
            case 111: {
                mediaTypeString = SamUtil.getResourceString("media.type.sonydtf");
                break;
            }
            case 112: {
                mediaTypeString = SamUtil.getResourceString("media.type.metrum");
                break;
            }
            case 113: {
                mediaTypeString = SamUtil.getResourceString("media.type.exabytem");
                break;
            }
            case 114: {
                mediaTypeString = SamUtil.getResourceString("media.type.eod");
                break;
            }
            case 115: {
                mediaTypeString = SamUtil.getResourceString("media.type.wod");
                break;
            }
            case 116: {
                mediaTypeString = SamUtil.getResourceString("media.type.historian");
                break;
            }
            case 122: {
                mediaTypeString = SamUtil.getResourceString("media.type.ibm3590");
                break;
            }
            case 123: {
                mediaTypeString = SamUtil.getResourceString("media.type.stk9940");
                break;
            }
            case 124: {
                mediaTypeString = SamUtil.getResourceString("media.type.stk3480");
                break;
            }
            case 125: {
                mediaTypeString = SamUtil.getResourceString("media.type.exabyte8");
                break;
            }
            case 126: {
                mediaTypeString = SamUtil.getResourceString("media.type.12wod");
                break;
            }
            case 127: {
                mediaTypeString = SamUtil.getResourceString("media.type.optical");
                break;
            }
            case 128: {
                mediaTypeString = SamUtil.getResourceString("media.type.tape");
                break;
            }
            case 129: {
                mediaTypeString = SamUtil.getResourceString("media.type.robot");
                break;
            }
            case 130: {
                mediaTypeString = SamUtil.getResourceString("media.type.hp");
                break;
            }
            case 117: {
                mediaTypeString = SamUtil.getResourceString("media.type.stkacsls");
                break;
            }
            case 118: {
                mediaTypeString = SamUtil.getResourceString("media.type.adicdas");
                break;
            }
            case 120: {
                mediaTypeString = SamUtil.getResourceString("media.type.fujilmf");
                break;
            }
            case 121: {
                mediaTypeString = SamUtil.getResourceString("media.type.ibm3494");
                break;
            }
            case 119: {
                mediaTypeString = SamUtil.getResourceString("media.type.sonypetasite");
                break;
            }
            case 132: {
                mediaTypeString = SamUtil.getResourceString("media.type.stk97");
                break;
            }
            case 133: {
                mediaTypeString = SamUtil.getResourceString("media.type.disk");
                break;
            }
            case 134: {
                mediaTypeString = SamUtil.getResourceString("media.type.sstorage_l_series");
                break;
            }
            case 135: {
                mediaTypeString = SamUtil.getResourceString("media.type.quantumc4");
                break;
            }
            case 136: {
                mediaTypeString = SamUtil.getResourceString("media.type.titanium");
                break;
            }
            default: {
                mediaTypeString = SamUtil.getResourceString("media.type.unknown");
            }
        }
        return mediaTypeString;
    }

    public static int getMediaType(String mValue) {
        int mediaType = -1;
        if (mValue.equals(SamUtil.getResourceString("media.type.sony"))) {
            mediaType = 101;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.ampex"))) {
            mediaType = 102;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.stk"))) {
            mediaType = 103;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.dat"))) {
            mediaType = 104;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.fuji"))) {
            mediaType = 105;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.ibm3570"))) {
            mediaType = 106;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.ibm3580"))) {
            mediaType = 107;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.dlt"))) {
            mediaType = 108;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.stk9490"))) {
            mediaType = 109;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.stk9840"))) {
            mediaType = 110;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.sonydtf"))) {
            mediaType = 111;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.metrum"))) {
            mediaType = 112;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.exabytem"))) {
            mediaType = 113;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.eod"))) {
            mediaType = 114;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.wod"))) {
            mediaType = 115;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.historian"))) {
            mediaType = 116;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.ibm3590"))) {
            mediaType = 122;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.stk9940"))) {
            mediaType = 123;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.stk3480"))) {
            mediaType = 124;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.exabyte8"))) {
            mediaType = 125;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.12wod"))) {
            mediaType = 126;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.optical"))) {
            mediaType = 127;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.tape"))) {
            mediaType = 128;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.robot"))) {
            mediaType = 129;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.hp"))) {
            mediaType = 130;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.stkacsls"))) {
            mediaType = 117;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.adicdas"))) {
            mediaType = 118;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.fujilmf"))) {
            mediaType = 120;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.ibm3494"))) {
            mediaType = 121;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.sonypetasite"))) {
            mediaType = 119;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.stk97"))) {
            mediaType = 132;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.disk"))) {
            mediaType = 133;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.sstorage_l_series"))) {
            mediaType = 134;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.quantumc4"))) {
            mediaType = 135;
        } else if (mValue.equals(SamUtil.getResourceString("media.type.titanium"))) {
            mediaType = 136;
        }
        return mediaType;
    }

    public static String getTimeUnitL10NString(int unit) {
        switch (unit) {
            case 9: {
                return SamUtil.getResourceString("ArchiveSetup.weeks");
            }
            case 8: {
                return SamUtil.getResourceString("ArchiveSetup.days");
            }
            case 7: {
                return SamUtil.getResourceString("ArchiveSetup.hours");
            }
            case 6: {
                return SamUtil.getResourceString("ArchiveSetup.minutes");
            }
            case 5: {
                return SamUtil.getResourceString("ArchiveSetup.seconds");
            }
        }
        return "";
    }

    public static String getSizeUnitL10NString(int unit) {
        switch (unit) {
            case 0: {
                return SamUtil.getResourceString("AdminSetup.qutity1");
            }
            case 1: {
                return SamUtil.getResourceString("AdminSetup.qutity2");
            }
            case 2: {
                return SamUtil.getResourceString("AdminSetup.qutity3");
            }
            case 3: {
                return SamUtil.getResourceString("AdminSetup.qutity4");
            }
            case 4: {
                return SamUtil.getResourceString("AdminSetup.qutity5");
            }
            case 41: {
                return SamUtil.getResourceString("AdminSetup.qutity6");
            }
        }
        return "";
    }

    public static String getSizeUnitString(int unit) {
        switch (unit) {
            case 0: {
                return "b";
            }
            case 1: {
                return "kb";
            }
            case 2: {
                return "mb";
            }
            case 3: {
                return "gb";
            }
            case 4: {
                return "tb";
            }
            case 41: {
                return "pb";
            }
        }
        return "";
    }

    public static int getSizeUnit(String unitString) {
        int unit = -1;
        if (unitString.equals("b")) {
            unit = 0;
        } else if (unitString.equals("kb")) {
            unit = 1;
        } else if (unitString.equals("mb")) {
            unit = 2;
        } else if (unitString.equals("gb")) {
            unit = 3;
        } else if (unitString.equals("tb")) {
            unit = 4;
        } else if (unitString.equals("pb")) {
            unit = 41;
        }
        return unit;
    }

    public static String getTimeString(Calendar calendar) {
        DateFormat formatter = SamUtil.getTimeFormat();
        String localedString = "";
        if (calendar != null) {
            localedString = formatter.format(calendar.getTime());
        }
        return localedString;
    }

    public static DateFormat getTimeFormat() {
        CCI18N i18n = SamUtil.getCCI18NObj();
        DateFormat formatter = null;
        formatter = i18n != null ? DateFormat.getDateTimeInstance(1, 1, i18n.getResourceBundle().getLocale()) : DateFormat.getDateTimeInstance(1, 1);
        return formatter;
    }

    public static int[] getAlarmInfo(Alarm[] alarms) throws SamFSException {
        int criticalCount = 0;
        int majorCount = 0;
        int minorCount = 0;
        int[] result = new int[2];
        if (alarms != null) {
            block5: for (int j = 0; j < alarms.length; ++j) {
                int severity = alarms[j].getSeverity();
                switch (severity) {
                    case 0: {
                        ++criticalCount;
                        continue block5;
                    }
                    case 1: {
                        ++majorCount;
                        continue block5;
                    }
                    case 2: {
                        ++minorCount;
                    }
                }
            }
            if (criticalCount != 0) {
                result[0] = 1;
                result[1] = criticalCount;
            } else if (majorCount != 0) {
                result[0] = 2;
                result[1] = majorCount;
            } else if (minorCount != 0) {
                result[0] = 3;
                result[1] = minorCount;
            }
        }
        return result;
    }

    public static void setErrorAlert(ContainerView view, String varName, String errMsg, int origErrorCode, String origErrorMsg) {
        CCAlertInline alert = (CCAlertInline)view.getChild(varName);
        boolean alertInfoPresent = false;
        boolean alertErrorPresent = false;
        String detailMsg = "";
        String downMessage = SamUtil.getServerDownMessage();
        String alertValue = (String)alert.getValue();
        detailMsg = alert.getDetail();
        if (alertValue != null) {
            if ((alertValue.equals("info") || alertValue.equals("warning")) && detailMsg != null) {
                TraceUtil.trace3("VALUE IS CCAlertInline.TYPE_INFO");
                alertInfoPresent = true;
                alert.setSummary("success.summary");
            }
            if (alertValue.equals("error") && detailMsg != null) {
                alertErrorPresent = true;
            }
        }
        alert.setValue((Object)"error");
        if (!alertInfoPresent) {
            alert.setSummary(errMsg);
        }
        String displayErrMsg = "";
        displayErrMsg = origErrorMsg == null ? (origErrorCode <= -1000 && origErrorCode >= -3000 ? (origErrorCode == -2800 ? downMessage : SamUtil.getResourceStringError(Integer.toString(origErrorCode)).toString()) : "") : origErrorMsg;
        if (origErrorCode == 30806) {
            SamUtil.doPrint("Error code in setErrorAlert is 30806");
            displayErrMsg = SamUtil.getResourceStringError("-2801");
        } else if (origErrorCode == 30807) {
            SamUtil.doPrint("Error code in setErrorAlert is 30807");
            displayErrMsg = SamUtil.getResourceStringError("-2802");
        }
        SamUtil.doPrint(new NonSyncStringBuffer().append("displayErrMsg is ").append(displayErrMsg).toString());
        SamUtil.doPrint(new NonSyncStringBuffer().append("detailMsg is ").append(detailMsg).toString());
        if (alertInfoPresent) {
            alert.setValue((Object)"warning");
            if (detailMsg.indexOf(displayErrMsg) != -1) {
                TraceUtil.trace2("Not concatenating infoPresent in setErrorAlert");
                alert.setDetail(detailMsg);
            } else {
                TraceUtil.trace2("Concatenating infoPresent in setErrorAlert");
                alert.setDetail(detailMsg.concat("<br>").concat(displayErrMsg));
            }
        } else if (alertErrorPresent && origErrorCode != -2800 && origErrorCode != -2400) {
            if (detailMsg.indexOf(displayErrMsg) != -1) {
                SamUtil.doPrint("Not concatenating errorPresent in setErrorAlert");
                alert.setDetail(detailMsg);
            } else {
                TraceUtil.trace2("Concatenating errorPresent in setErrorAlert");
                alert.setDetail(displayErrMsg.concat("<br>").concat(detailMsg));
            }
        } else if (origErrorCode == -2800) {
            alert.setDetail("<br>" + displayErrMsg);
        } else if (origErrorCode == -2400) {
            alert.setDetail(displayErrMsg, (Object[])new String[]{"File System Manager"});
        } else {
            alert.setDetail(displayErrMsg);
        }
        String detailStr = alert.getDetail();
        if (detailStr.indexOf(downMessage) != -1) {
            HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
            String serverName = (String)session.getAttribute("SERVER_NAME");
            alert.setDetail(detailStr, (Object[])new String[]{serverName});
        }
    }

    public static void setErrorAlert(ContainerView view, String varName, String errMsg, int origErrorCode, String origErrorMsg, String serverName) {
        CCAlertInline alert = (CCAlertInline)view.getChild(varName);
        boolean alertInfoPresent = false;
        boolean alertErrorPresent = false;
        String detailMsg = "";
        String alertValue = (String)alert.getValue();
        detailMsg = alert.getDetail();
        if (alertValue != null) {
            if ((alertValue.equals("info") || alertValue.equals("warning")) && detailMsg != null) {
                TraceUtil.trace3("VALUE IS CCAlertInline.TYPE_INFO");
                alertInfoPresent = true;
                alert.setSummary("success.summary");
            }
            if (alertValue.equals("error") && detailMsg != null) {
                alertErrorPresent = true;
            }
        }
        alert.setValue((Object)"error");
        if (!alertInfoPresent) {
            alert.setSummary(errMsg);
        }
        String displayErrMsg = "";
        displayErrMsg = origErrorMsg == null ? (origErrorCode <= -1000 && origErrorCode >= -3000 ? (origErrorCode == -2800 ? SamUtil.getServerDownMessage() : (origErrorCode == -2803 ? SamUtil.getAccessDeniedMessage() : SamUtil.getResourceStringError(Integer.toString(origErrorCode)).toString())) : "") : origErrorMsg;
        if (origErrorCode == 30806) {
            SamUtil.doPrint("Error code in setErrorAlert is 30806");
            displayErrMsg = SamUtil.getResourceStringError("-2801");
        } else if (origErrorCode == 30807) {
            SamUtil.doPrint("Error code in setErrorAlert is 30807");
            displayErrMsg = SamUtil.getResourceStringError("-2802");
        }
        SamUtil.doPrint(new NonSyncStringBuffer().append("displayErrMsg is ").append(displayErrMsg).toString());
        SamUtil.doPrint(new NonSyncStringBuffer().append("detailMsg is ").append(detailMsg).toString());
        if (alertInfoPresent) {
            alert.setValue((Object)"warning");
            if (detailMsg.indexOf(displayErrMsg) != -1) {
                TraceUtil.trace2("Not concatenating infoPresent in setErrorAlert");
                alert.setDetail(detailMsg);
            } else {
                TraceUtil.trace2("Concatenating infoPresent in setErrorAlert");
                alert.setDetail(detailMsg.concat("<br>").concat(displayErrMsg));
            }
        } else if (alertErrorPresent && origErrorCode != -2800 && origErrorCode != -2400) {
            if (detailMsg.indexOf(displayErrMsg) != -1) {
                SamUtil.doPrint("Not concatenating errorPresent in setErrorAlert");
                alert.setDetail(detailMsg);
            } else {
                TraceUtil.trace2("Concatenating errorPresent in setErrorAlert");
                alert.setDetail(displayErrMsg.concat("<br>").concat(detailMsg));
            }
        } else if (origErrorCode == -2800) {
            alert.setDetail("<br>" + displayErrMsg);
        } else if (origErrorCode == -2400) {
            alert.setDetail(displayErrMsg, (Object[])new String[]{"File System Manager"});
        } else {
            alert.setDetail(displayErrMsg);
        }
        String detailStr = alert.getDetail();
        if (detailStr.indexOf(SamUtil.getServerDownMessage()) != -1 || detailStr.indexOf(SamUtil.getAccessDeniedMessage()) != -1) {
            alert.setDetail(detailStr, (Object[])new String[]{serverName});
        }
    }

    public static void setInfoAlert(ContainerView view, String alertChildName, String infoSummary, String infoDetail) {
        TraceUtil.trace3("Entering setInfoAlert");
        CCAlertInline alert = (CCAlertInline)view.getChild(alertChildName);
        boolean errorAlertPresent = false;
        String detailMsg = "";
        String downMessage = SamUtil.getServerDownMessage();
        String alertValue = (String)alert.getValue();
        detailMsg = alert.getDetail();
        SamUtil.doPrint(new NonSyncStringBuffer().append("infoDetail is ").append(infoDetail).toString());
        SamUtil.doPrint(new NonSyncStringBuffer().append("detailMsg is ").append(detailMsg).toString());
        if (alertValue != null && alertValue.equals("error") && detailMsg != null) {
            TraceUtil.trace3("FOUND AN ERROR ALERT");
            errorAlertPresent = true;
            alert.setValue((Object)"warning");
            alert.setSummary("success.summary");
        }
        if (!errorAlertPresent) {
            SamUtil.doPrint("setInfoAlert: no error is present");
            alert.setValue((Object)"info");
            alert.setSummary(infoSummary);
            alert.setDetail(infoDetail);
        } else {
            SamUtil.doPrint("setInfoAlert: error is present");
            if (detailMsg.indexOf(infoDetail) != -1) {
                SamUtil.doPrint("Not concatenating in setInfoAlert");
                alert.setDetail(detailMsg);
            } else {
                SamUtil.doPrint("Concatenating in setInfoAlert");
                alert.setDetail(infoDetail.concat("<br>").concat(detailMsg));
            }
        }
        String detailStr = alert.getDetail();
        if (detailStr != null && detailStr.indexOf(downMessage) != -1) {
            HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
            String serverName = (String)session.getAttribute("SERVER_NAME");
            alert.setDetail(detailStr, (Object[])new String[]{serverName});
        }
    }

    public static void setInfoAlert(ContainerView view, String alertChildName, String summaryMsg, String detailMsg, String serverName) {
        TraceUtil.trace3("Entering setInfoAlert");
        CCAlertInline alert = (CCAlertInline)view.getChild(alertChildName);
        boolean errorAlertPresent = false;
        String prevDetailMsg = "";
        String downMessage = SamUtil.getServerDownMessage();
        String alertValue = (String)alert.getValue();
        prevDetailMsg = alert.getDetail();
        SamUtil.doPrint(new NonSyncStringBuffer().append("detailMsg is ").append(detailMsg).toString());
        SamUtil.doPrint(new NonSyncStringBuffer().append("prevDetailMsg is ").append(prevDetailMsg).toString());
        if (alertValue != null && alertValue.equals("error") && prevDetailMsg != null) {
            TraceUtil.trace3("FOUND AN ERROR ALERT");
            errorAlertPresent = true;
            alert.setValue((Object)"warning");
            alert.setSummary("success.summary");
        }
        if (!errorAlertPresent) {
            SamUtil.doPrint("setInfoAlert: no error is present");
            alert.setValue((Object)"info");
            alert.setSummary(summaryMsg);
            alert.setDetail(detailMsg);
        } else {
            SamUtil.doPrint("setInfoAlert: error is present");
            if (prevDetailMsg.indexOf(detailMsg) != -1) {
                SamUtil.doPrint("Not concatenating in setInfoAlert");
                alert.setDetail(prevDetailMsg);
            } else {
                SamUtil.doPrint("Concatenating in setInfoAlert");
                alert.setDetail(detailMsg.concat("<br>").concat(prevDetailMsg));
            }
        }
        String detailStr = alert.getDetail();
        if (detailStr.indexOf(downMessage) != -1) {
            alert.setDetail(detailStr, (Object[])new String[]{serverName});
        }
    }

    public static void setWarningAlert(ContainerView view, String varName, String summaryMsg, String detailMsg) {
        TraceUtil.trace3("Entering setWarningAlert");
        CCAlertInline alert = (CCAlertInline)view.getChild(varName);
        boolean errorAlertPresent = false;
        String detailErrMsg = "";
        String alertValue = (String)alert.getValue();
        detailErrMsg = alert.getDetail();
        if (alertValue != null && alertValue.equals("error") && detailErrMsg != null) {
            TraceUtil.trace3("FOUND AN ERROR ALERT");
            errorAlertPresent = true;
        }
        alert.setValue((Object)"warning");
        alert.setSummary(summaryMsg);
        String warningValue = SamUtil.getResourceString(detailMsg);
        String displayMsg = "";
        displayMsg = warningValue != null && !warningValue.equals("") ? warningValue : detailMsg;
        if (!errorAlertPresent) {
            alert.setDetail(displayMsg);
        } else if (detailErrMsg.indexOf(displayMsg) != -1) {
            alert.setDetail(detailErrMsg);
        } else {
            alert.setDetail(displayMsg.concat("<br>").concat(detailErrMsg));
        }
    }

    public static CCI18N getCCI18NObj() {
        HttpServletRequest httprq = RequestManager.getRequest();
        CCI18N i18n = (CCI18N)httprq.getAttribute("i18nObj");
        if (i18n == null) {
            i18n = new CCI18N((ServletRequest)RequestManager.getRequest(), (ServletResponse)RequestManager.getResponse(), "com.sun.netstorage.samqfs.web.resources.Resources", null, null);
            httprq.setAttribute("i18nObj", (Object)i18n);
        }
        return i18n;
    }

    public static CCI18N getCCI18NObj(String BaseName, String bundleId) {
        HttpServletRequest httprq = RequestManager.getRequest();
        CCI18N i18n = (CCI18N)httprq.getAttribute("i18nObj" + bundleId);
        if (i18n == null) {
            i18n = new CCI18N((ServletRequest)httprq, (ServletResponse)RequestManager.getResponse(), BaseName, bundleId, null);
            httprq.setAttribute("i18nObj" + bundleId, (Object)i18n);
        }
        return i18n;
    }

    public static String getLockhartTagString(String key) {
        CCI18N i18n = SamUtil.getCCI18NObj("com.sun.web.ui.resources.Resources", "com.sun.web.ui");
        return i18n.getMessage(key);
    }

    public static String getResourceStringError(String errorCode) {
        return SamUtil.getResourceString(errorCode);
    }

    public static String getResourceString(String aString) {
        CCI18N i18n = SamUtil.getCCI18NObj();
        String localedString = "";
        if (i18n != null) {
            localedString = i18n.getMessage(aString);
        }
        return localedString;
    }

    public static String getResourceString(String key, String[] detailInfo) {
        CCI18N i18n = SamUtil.getCCI18NObj();
        String localedString = "";
        if (i18n != null) {
            localedString = i18n.getMessage(key, (Object[])detailInfo);
        }
        return localedString;
    }

    public static String getResourceString(String key, String value) {
        String[] params = null;
        if (value != null && value.length() > 0) {
            params = new String[]{value};
        }
        return SamUtil.getResourceString(key, params);
    }

    public static String getResourceStringWithoutL10NArgs(String key, String[] arguments) {
        CCI18N i18n = SamUtil.getCCI18NObj();
        String localedString = "";
        if (i18n != null) {
            String pattern = i18n.getMessage(key);
            localedString = MessageFormat.format(pattern, arguments);
        }
        return localedString;
    }

    public static void doPrint(String printString) {
        TraceUtil.trace2(printString);
    }

    public static boolean isValidString(String testString) {
        return testString.indexOf(" ") == -1;
    }

    public static boolean isValidVSNString(String vsnString) {
        if (vsnString == null) {
            return false;
        }
        vsnString = vsnString.trim();
        if (!SamUtil.isValidString(vsnString)) {
            return false;
        }
        if (vsnString.length() > 6) {
            return false;
        }
        for (int i = 0; i < vsnString.length(); ++i) {
            if (SamUtil.isVSNDigit(vsnString.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void processException(Exception ex, Class clazz, String methodName, String message) {
        if (ex instanceof SamFSException) {
            SamUtil.handleSamFSException((SamFSException)((Object)ex));
        }
        if (ex.getMessage() != null) {
            TraceUtil.trace1(new NonSyncStringBuffer().append("Exception occurred: ").append(ex.getMessage()).toString());
            LogUtil.error(clazz, methodName, ex.getMessage());
        } else {
            TraceUtil.trace1(new NonSyncStringBuffer().append("Exception occurred: ").append(message).toString());
            LogUtil.error(clazz, methodName, message);
        }
    }

    public static void processException(Exception ex, Class clazz, String methodName, String message, String serverName) {
        if (ex instanceof SamFSException) {
            SamUtil.handleSamFSException((SamFSException)((Object)ex), serverName);
        }
        if (ex.getMessage() != null) {
            TraceUtil.trace1(new NonSyncStringBuffer().append("Exception occurred: ").append(ex.getMessage()).toString());
            LogUtil.error(clazz, methodName, ex.getMessage());
        } else {
            TraceUtil.trace1(new NonSyncStringBuffer().append("Exception occurred: ").append(message).toString());
            LogUtil.error(clazz, methodName, message);
        }
    }

    private static boolean isVSNDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '!' || c == '\"' || c == '%' || c == '&' || c == '\'' || c == '(' || c == ')' || c == '*' || c == '+' || c == ',' || c == '-' || c == '.' || c == '/' || c == ':' || c == ';' || c == '<' || c == '=' || c == '>' || c == '?' || c == '_';
    }

    public static boolean isValidNonSpecialCharString(String inputString) {
        if (!SamUtil.isValidString(inputString)) {
            return false;
        }
        for (int i = 0; i < inputString.length(); ++i) {
            if (!SamUtil.isSpecialDigit(inputString.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSpecialDigit(char c) {
        return c == '#' || c == '$' || c == '!' || c == '\\' || c == '@' || c == '\"' || c == '%' || c == '&' || c == '\'' || c == '(' || c == ')' || c == '*' || c == '+' || c == ',' || c == ':' || c == ';' || c == '<' || c == '=' || c == '>' || c == '?';
    }

    public static void handleSamFSException(SamFSException samEx) {
        SamUtil.doPrint(new NonSyncStringBuffer().append("Entering: handleSamFSException(): errCode is: ").append(samEx.getSAMerrno()).toString());
        try {
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
            String hostName = (String)session.getAttribute("SERVER_NAME");
            SamUtil.doPrint(new NonSyncStringBuffer().append("hostName is ").append(hostName).toString());
            SamQFSSystemModel model = appModel.getSamQFSSystemModel(hostName);
            if (model != null) {
                model.clearContext();
            }
            if (samEx instanceof SamFSCommException || samEx instanceof SamFSNotInitException || samEx.getSAMerrno() == -2800 || samEx.getSAMerrno() == 30104) {
                SamUtil.doPrint("Exception is a type of SamFSComm/SamFSNotInit, ");
                SamUtil.doPrint("or simply marked as DOWN");
                if (model != null) {
                    if (samEx instanceof SamFSNotInitException || samEx.getSAMerrno() == 30804 || samEx.getSAMerrno() == 30104) {
                        SamUtil.doPrint("Attempt to reinitialize ...");
                        model.reinitialize();
                    } else if ((samEx instanceof SamFSCommException || samEx.getSAMerrno() == -2800) && !(samEx instanceof SamFSAccessDeniedException)) {
                        SamUtil.doPrint("Attempt to reconnect ...");
                        model.reconnect();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void handleSamFSException(SamFSException samEx, String serverName) {
        SamUtil.doPrint(new NonSyncStringBuffer().append("Entering: handleSamFSException(): errCode is: ").append(samEx.getSAMerrno()).toString());
        try {
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            SamUtil.doPrint(new NonSyncStringBuffer().append("serverName is ").append(serverName).toString());
            SamQFSSystemModel model = appModel.getSamQFSSystemModel(serverName);
            if (model != null) {
                model.clearContext();
            }
            if (samEx instanceof SamFSCommException || samEx instanceof SamFSNotInitException || samEx.getSAMerrno() == -2800 || samEx.getSAMerrno() == 30104) {
                SamUtil.doPrint("Exception is a type of SamFSComm/SamFSNotInit, ");
                SamUtil.doPrint("or simply marked as DOWN");
                if (model != null) {
                    if (samEx instanceof SamFSNotInitException || samEx.getSAMerrno() == 30804 || samEx.getSAMerrno() == 30104) {
                        SamUtil.doPrint("Attempt to reinitialize ...");
                        model.reinitialize();
                    } else if ((samEx instanceof SamFSCommException || samEx.getSAMerrno() == -2800) && !(samEx instanceof SamFSAccessDeniedException)) {
                        SamUtil.doPrint("Attempt to reconnect ...");
                        model.reconnect();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isValidLetterOrDigitString(String s) {
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (Character.isLetterOrDigit(c[i]) || c[i] == '_') continue;
            return false;
        }
        return true;
    }

    public static String concatErrMsg(String[] messages) {
        String retMessage = "";
        if (messages == null) {
            return "";
        }
        for (int i = 0; i < messages.length; ++i) {
            retMessage = retMessage.concat(messages[i]).concat("<br>");
        }
        return retMessage;
    }

    public static String getMultiMsgInfoError() {
        return new NonSyncStringBuffer().append(SamUtil.getResourceString("ArchiveConfig.info.save")).append("\n").append(SamUtil.getResourceString("ArchiveConfig.error")).toString();
    }

    public static String replaceSpaceWithUnderscore(String myString) {
        myString = myString.trim();
        myString = myString.replace(' ', '_');
        return myString;
    }

    public static String processJobDescription(String[] s) {
        boolean flag = false;
        String result = "";
        String comma = ",";
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == null || s[i].equals("")) continue;
            if (i == 0) {
                flag = true;
                result = s[i];
                continue;
            }
            result = flag ? result + comma + s[i] : result + s[i];
            flag = true;
        }
        return result;
    }

    public static String createBlankPageTitleXML() {
        return new NonSyncStringBuffer().append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<!DOCTYPE pagetitle SYSTEM \"tags/dtd/pagetitle.dtd\">\n\n").append("<pagetitle>\n").append("</pagetitle>\n").toString();
    }

    public static String handleMultiHostException(SamFSMultiHostException multiEx) {
        String err_msg = "";
        SamUtil.doPrint(new NonSyncStringBuffer().append("Entering: handleMultiHostException(): errCode is: ").append(multiEx.getSAMerrno()).toString());
        err_msg = err_msg + SamUtil.getResourceString(multiEx.getMessage());
        SamFSException[] exceptions = multiEx.getExceptions();
        if (exceptions == null || exceptions.length == 0) {
            return err_msg;
        }
        err_msg = err_msg + "\n<br>\n<br>";
        String[] hosts = multiEx.getHostNames();
        for (int i = 0; i < exceptions.length; ++i) {
            err_msg = err_msg + hosts[i] + ": " + SamUtil.getResourceString(exceptions[i].getMessage()) + "\n<br>";
            SamUtil.doPrint(new NonSyncStringBuffer().append("exception hostName is ").append(hosts[i]).toString());
            SamUtil.doPrint(new NonSyncStringBuffer().append("exception info is ").append((Object)exceptions[i]).toString());
            if (multiEx instanceof SamFSException) {
                SamUtil.handleSamFSException((SamFSException)multiEx, hosts[i]);
            }
            try {
                SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
                SamQFSSystemModel model = appModel.getSamQFSSystemModel(hosts[i]);
                if (model != null) {
                    model.clearContext();
                }
                if (!(exceptions[i] instanceof SamFSCommException) && !(exceptions[i] instanceof SamFSNotInitException) && exceptions[i].getSAMerrno() != -2800) continue;
                SamUtil.doPrint("Exception is a type of SamFSComm/SamFSNotInit, ");
                SamUtil.doPrint("or simply marked as DOWN");
                if (model == null) continue;
                if (exceptions[i] instanceof SamFSNotInitException || exceptions[i].getSAMerrno() == 30804) {
                    SamUtil.doPrint("Attempt to reinitialize ...");
                    model.reinitialize();
                    continue;
                }
                if (!(exceptions[i] instanceof SamFSCommException) && exceptions[i].getSAMerrno() != -2800) continue;
                SamUtil.doPrint("Attempt to reconnect ...");
                model.reconnect();
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return err_msg;
    }

    public static boolean isValidFSNameString(String inputString) {
        if (!SamUtil.isValidString(inputString)) {
            return false;
        }
        char[] c = inputString.toCharArray();
        if (Character.isDigit(c[0])) {
            return false;
        }
        for (int i = 0; i < c.length; ++i) {
            if (Character.isLetterOrDigit(c[i]) || c[i] == '_' || c[i] == '.' || c[i] == '-') continue;
            return false;
        }
        return true;
    }

    public static boolean isWellFormedPath(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        path = path.trim();
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String subdir = st.nextToken();
            if (SamUtil.isValidFSNameString(subdir)) continue;
            return false;
        }
        return true;
    }

    public static void buildPath(NonSyncStringBuffer addToPath, NonSyncStringBuffer fileOrDir) {
        if (addToPath == null || fileOrDir == null) {
            return;
        }
        if (addToPath.charAt(addToPath.length() - 1) != '/') {
            addToPath.append("/");
        }
        addToPath.append((Object)fileOrDir);
    }

    public static String buildPath(String addToPath, String fileOrDir) {
        if (addToPath == null || fileOrDir == null) {
            return null;
        }
        String retPath = addToPath;
        if (addToPath.charAt(addToPath.length() - 1) != '/') {
            retPath = retPath + "/";
        }
        retPath = retPath + fileOrDir;
        return retPath;
    }

    public static short getSystemType(String hostName) {
        short license = 3;
        try {
            ServerInfo serverInfo = SamUtil.getServerInfo(hostName);
            if (serverInfo != null) {
                license = serverInfo.getServerLicenseType();
            }
        }
        catch (SamFSException samEx) {
            TraceUtil.trace1(new NonSyncStringBuffer("Exception caught while retreiving system type. Reason: ").append(samEx.getMessage()).toString());
        }
        return license;
    }

    public static String swapArchString(String archString) {
        if (archString.equals("i386")) {
            return SamUtil.getResourceString("samqfsui.x86");
        }
        return archString;
    }

    public static String getServerDownMessage() {
        return SamUtil.getResourceStringError("ErrorHandle.alertElementFailedDetail2");
    }

    public static String getAccessDeniedMessage() {
        return SamUtil.getResourceStringError("ErrorHandle.accessDeniedDetail");
    }

    public static ServerInfo getServerInfo(String serverName) throws SamFSException {
        HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
        Hashtable serverTable = SamUtil.getServerTable();
        ServerInfo serverInfo = (ServerInfo)serverTable.get(serverName);
        if (serverInfo == null) {
            serverInfo = SamUtil.createServerInfoObject(serverName);
            serverTable.put(serverName, serverInfo);
            session.setAttribute("SAMFS_SERVER_INFO", (Object)serverTable);
        }
        return serverInfo;
    }

    public static Hashtable getServerTable() {
        HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
        Hashtable serverTable = (Hashtable)session.getAttribute("SAMFS_SERVER_INFO");
        if (serverTable == null) {
            serverTable = new Hashtable();
            session.setAttribute("SAMFS_SERVER_INFO", serverTable);
            SamUtil.setPermission();
        }
        return serverTable;
    }

    private static ServerInfo createServerInfoObject(String serverName) throws SamFSException {
        ServerInfo serverInfo = new ServerInfo(serverName);
        SamQFSSystemModel model = SamUtil.getModel(serverName);
        serverInfo.setSamfsServerAPIVersion(model.getServerAPIVersion());
        serverInfo.setServerLicenseType(model.getLicenseType());
        return serverInfo;
    }

    public static void setPermission() {
        HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
        try {
            if (!SecurityUtil.checkPermission(RequestManager.getRequestContext(), "com.sun.netstorage.samqfs.web.write")) {
                session.setAttribute("PERMISSION", (Object)"READ");
            } else {
                session.setAttribute("PERMISSION", (Object)"WRITE");
            }
        }
        catch (SamFSException samEx) {
            TraceUtil.trace1(new NonSyncStringBuffer("Exception caught while setting permission. Reason: ").append(samEx.getMessage()).toString());
        }
    }

    public static TreeSet delimitedStringToTreeSet(String theString, String delimiter) {
        if (theString == null || theString == "") {
            return new TreeSet();
        }
        if (delimiter == null) {
            delimiter = "";
        }
        String[] strArray = theString.split(delimiter);
        return new TreeSet<String>(Arrays.asList(strArray));
    }

    public static String treeSetToDelimitedString(TreeSet set, String delimiter) {
        if (set == null) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        NonSyncStringBuffer buf = new NonSyncStringBuffer();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            buf.appendDelimited(delimiter, iter.next());
        }
        return buf.toString();
    }
}

