/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.util;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.alarm.AlarmSummary;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.web.ui.model.CCMastheadModel;

public class MastheadUtil {
    private static CCMastheadModel mastheadModel = null;

    public static CCMastheadModel createMastHeadModel(String fileName, String serverName) throws SamFSException {
        if (mastheadModel != null) {
            mastheadModel.clear();
        }
        mastheadModel = new CCMastheadModel();
        mastheadModel.setSrc("masthead.logo");
        mastheadModel.setAlt("masthead.altText");
        mastheadModel.setShowUserRole(true);
        mastheadModel.setShowServer(true);
        mastheadModel.setShowDate(true);
        mastheadModel.setCurrentAlarmsLabel("masthead.currentfaults");
        SamUtil.doPrint(new NonSyncStringBuffer("HELP LINK: path is ").append(" fileName: ").append(fileName).toString());
        mastheadModel.setHelpFileName(MastheadUtil.setFileName(fileName));
        if (mastheadModel.getNumLinks() < 1) {
            mastheadModel.addLink("RefreshHref", "Masthead.refreshLinkName", "Masthead.refreshLinkTooltip", "Masthead.refreshLinkStatus");
        }
        if (SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.CONFIG) && mastheadModel.getNumLinks() < 2) {
            mastheadModel.addLink("PreferenceHref", "Preferences.linkName", "Preferences.linkTooltip", "Preferences.linkStatus");
        }
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        AlarmSummary myAlarmSummary = sysModel.getSamQFSSystemAlarmManager().getAlarmSummary();
        mastheadModel.setCriticalAlarms(myAlarmSummary.getCriticalTotal());
        mastheadModel.setMajorAlarms(myAlarmSummary.getMajorTotal());
        mastheadModel.setMinorAlarms(myAlarmSummary.getMinorTotal());
        return mastheadModel;
    }

    public static String setFileName(String fileName) {
        if (fileName.equals("FSSummary")) {
            return "samqfs-filesystemssummary.html";
        }
        if (fileName.equals("FSDetails") || fileName.equals("SharedFSDetails")) {
            return "samqfs-filesystemdetails.html";
        }
        if (fileName.equals("FSArchivePolicies")) {
            return "samqfs-filesystemarchivepolicies.html";
        }
        if (fileName.equals("FSDevices")) {
            return "samqfs-filesystemdevices.html";
        }
        if (fileName.equals("FSMount")) {
            return "samqfs-filesystemeditmountoptions.html";
        }
        if (fileName.equals("FSFaultsSummary")) {
            return "samqfs-filesystemfaultsummary.html";
        }
        if (fileName.equals("FSScheduleDump")) {
            return "samqfs-schedulemetadatasnapshots.html";
        }
        if (fileName.equals("FSRestore")) {
            return "samqfs-restorefilesystem.html";
        }
        if (fileName.equals("NFSDetails")) {
            return "samqfs-filesystemeditnfsproperties.html";
        }
        if (fileName.equals("AdvancedNetworkConfig")) {
            return "samqfs-advancednetworkconfig.html";
        }
        if (fileName.equals("Stage")) {
            return "samqfs-staging.html";
        }
        if (fileName.equals("PolicySummary")) {
            return "samqfs-archivepoliciessummary.html";
        }
        if (fileName.equals("PolicyDetails")) {
            return "samqfs-policydetails.html";
        }
        if (fileName.equals("TapeArchivePolCopy")) {
            return "samqfs-policycopytapeoptions.html";
        }
        if (fileName.equals("DiskArchivePolCopy")) {
            return "samqfs-policycopydiskoptions.html";
        }
        if (fileName.equals("VSNPoolSummary")) {
            return "samqfs-vsnpoolsummary.html";
        }
        if (fileName.equals("PolFileSystem")) {
            return "samqfs-policyfilesystems.html";
        }
        if (fileName.equals("VSNPoolDetails")) {
            return "samqfs-vsnpooldetails.html";
        }
        if (fileName.equals("ArchiveSetUp")) {
            return "samqfs-generalarchivingsetup.html";
        }
        if (fileName.equals("GeneralArchivingSetup")) {
            return "samqfs-generalarchivingsetupfilesystems.html";
        }
        if (fileName.equals("CriteriaDetails")) {
            return "samqfs-policycriteriadetails.html";
        }
        if (fileName.equals("DiskVSNSummary")) {
            return "samqfs-diskvsns.html";
        }
        if (fileName.equals("CopyVSNs")) {
            return "samqfs-policycopyvsns.html";
        }
        if (fileName.equals("Recycler")) {
            return "samqfs-recycler.html";
        }
        if (fileName.equals("ArchiveActivity")) {
            return "samqfs-activitymanagement.html";
        }
        if (fileName.equals("LibrarySummary")) {
            return "samqfs-librarysummary.html";
        }
        if (fileName.equals("LibraryDetails")) {
            return "samqfs-librarydetails.html";
        }
        if (fileName.equals("LibraryFaultsSummary")) {
            return "samqfs-devicefaultsummary.html";
        }
        if (fileName.equals("LibraryDriveSummary")) {
            return "samqfs-drivessummaryofalibrary.html";
        }
        if (fileName.equals("DriveDetails")) {
            return "samqfs-drivedetails.html";
        }
        if (fileName.equals("VSNSummary")) {
            return "samqfs-libraryvsnsummary.html";
        }
        if (fileName.equals("VSNSearch")) {
            return "samqfs-vsnsearch.html";
        }
        if (fileName.equals("VSNSearchResult")) {
            return "samqfs-searchresults.html";
        }
        if (fileName.equals("StandAloneSummary")) {
            return "samqfs-standalonetapedrivessummary.html";
        }
        if (fileName.equals("VSNDetails")) {
            return "samqfs-vsndetails.html";
        }
        if (fileName.equals("Historian")) {
            return "samqfs-historian.html";
        }
        if (fileName.equals("ImportVSN")) {
            return "samqfs-importvsn.html";
        }
        if (fileName.equals("CurrentJobs")) {
            return "samqfs-currentjobssummary.html";
        }
        if (fileName.equals("JobsDetails") || fileName.equals("StageJobs")) {
            return "samqfs-jobdetails.html";
        }
        if (fileName.equals("PendingJobs")) {
            return "samqfs-pendingjobs.html";
        }
        if (fileName.equals("AllJobs")) {
            return "samqfs-alljobssummary.html";
        }
        if (fileName.equals("CurrentAlarmSummary")) {
            return "samqfs-faultsummary.html";
        }
        if (fileName.equals("AdminNotification")) {
            return "samqfs-notificationsummary.html";
        }
        if (fileName.equals("ServerConfiguration")) {
            return "samqfs-serverconfiguration.html";
        }
        return "";
    }
}

