/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.util;

import com.sun.management.services.common.ConsoleConfiguration;
import com.sun.management.services.logging.ConsoleLogService;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LogUtil {
    private static FileHandler fileHandler = null;
    private static final String LOG_FILE = "com.sun.netstorage.samqfs.web.logfile";
    private static Logger logger = null;

    private static final Logger getLogger() {
        try {
            if (fileHandler == null) {
                TraceUtil.trace1("UI Logging: FILE HANDLER IS NULL");
                fileHandler = new FileHandler(ConsoleConfiguration.getProperty((String)LOG_FILE));
                fileHandler.setFormatter(new SimpleFormatter());
            }
        }
        catch (IOException ioex) {
            TraceUtil.trace1("UI Logging: IOEXCEPTION CAUGHT IN LOGGER");
            return null;
        }
        if (logger != null) {
            return logger;
        }
        logger = ConsoleLogService.getConsoleLogger();
        logger.addHandler(fileHandler);
        return logger;
    }

    public static void info(Class clazz, String methodName, String message) {
        Logger logger = LogUtil.getLogger();
        if (logger == null) {
            return;
        }
        logger.logp(Level.INFO, clazz.getName(), methodName, message);
    }

    public static void info(Object objectClass, String methodName, String message) {
        LogUtil.info(objectClass.getClass(), methodName, message);
    }

    public static void info(String message) {
        Logger logger = LogUtil.getLogger();
        if (logger == null) {
            return;
        }
        logger.log(Level.INFO, message);
    }

    public static void warn(Class clazz, String method, String message, Throwable throwable) {
        Logger logger = LogUtil.getLogger();
        if (logger == null) {
            return;
        }
        logger.logp(Level.WARNING, clazz.getName(), method, message, throwable);
    }

    public static void warn(Object objectClass, String method, String message, Throwable throwable) {
        LogUtil.warn(objectClass.getClass(), method, message, throwable);
    }

    public static void warn(String message) {
        Logger logger = LogUtil.getLogger();
        if (logger == null) {
            return;
        }
        logger.log(Level.WARNING, message);
    }

    public static void error(Object objectClass, String method, String message) {
        LogUtil.error(objectClass.getClass(), method, message);
    }

    public static void error(Class clazz, String method, String message) {
        Logger logger = LogUtil.getLogger();
        message = message == null ? "<empty message>" : message;
        String string = method = method == null ? "<unknown method>" : method;
        if (logger == null) {
            return;
        }
        logger.logp(Level.SEVERE, clazz == null ? "<unknown class>" : clazz.getName(), method, message);
    }

    public static void error(Class clazz, Exception cme) {
        LogUtil.error(clazz, "", cme.toString());
    }

    public static void error(Object objectClazz, Exception cme) {
        LogUtil.error(objectClazz.getClass(), cme);
    }

    public static void error(String message) {
        Logger logger = LogUtil.getLogger();
        if (logger == null) {
            return;
        }
        logger.log(Level.SEVERE, message);
    }
}

