/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.util;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.util.LargeDataSet;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class LDSTableModel
extends CCActionTableModel {
    protected LargeDataSet dataSet = null;
    protected Object[] currentDataSet = null;
    protected boolean initModelRows = true;
    protected int totalRecords = -1;
    protected String sortName = null;
    protected String sortOrder = null;

    public LDSTableModel(ServletContext cntx, String file) {
        super(cntx, file);
        TraceUtil.initTrace();
    }

    public int getAvailableRows() {
        if (this.totalRecords == -1) {
            return 0;
        }
        return this.totalRecords;
    }

    public int getFirstRow() {
        Boolean isPaginated = this.getShowPaginationControls();
        if (isPaginated == null || isPaginated.booleanValue()) {
            int page = super.getPage() > 0 ? super.getPage() : 1;
            return (page - 1) * this.getMaxRows() + 1;
        }
        return 1;
    }

    public int getLastRow() {
        Boolean isPaginated = this.getShowPaginationControls();
        if (isPaginated == null || isPaginated.booleanValue()) {
            int page = super.getPage() > 0 ? super.getPage() : 1;
            return page * this.getMaxRows();
        }
        if (this.currentDataSet == null) {
            return 0;
        }
        return this.currentDataSet.length;
    }

    public int getFirstRowIndex() {
        return 0;
    }

    public int getLastRowIndex() {
        return this.getNumRows();
    }

    public int getMaxRows() {
        return 25;
    }

    public int[] getSortIndex() {
        int[] sortIndex = new int[this.getNumRows()];
        for (int i = 0; i < this.getNumRows(); ++i) {
            sortIndex[i] = i;
        }
        return sortIndex;
    }

    protected void getModelRows() throws SamFSException {
        this.clear();
        int firstRow = this.getFirstRow() - 1;
        Boolean isPaginated = this.getShowPaginationControls();
        int num = isPaginated == null || isPaginated != false ? this.getMaxRows() : this.getAvailableRows();
        this.sortName = this.getPrimarySortName();
        if (this.sortName != null) {
            this.sortOrder = this.getPrimarySortOrder();
        }
        TraceUtil.trace3(new NonSyncStringBuffer().append("firstRow = ").append(firstRow).append(", num = ").append(num).toString());
        TraceUtil.trace3(new NonSyncStringBuffer().append("sortName = ").append(this.sortName).append(",sortOrder = ").append(this.sortOrder).toString());
        HttpServletRequest request = RequestManager.getRequestContext().getRequest();
        String queryString = request.getQueryString();
        TraceUtil.trace3(new NonSyncStringBuffer().append("QueryString = ").append(queryString).toString());
        String tmpStr = request.getParameter("sortName");
        if (tmpStr != null) {
            this.sortName = tmpStr;
        }
        if ((tmpStr = request.getParameter("sortOrder")) != null) {
            this.sortOrder = tmpStr;
        }
        TraceUtil.trace3(new NonSyncStringBuffer().append("sortName = ").append(this.sortName).append(",sortOrder = ").append(this.sortOrder).toString());
        this.currentDataSet = this.dataSet.getData(firstRow, num, this.sortName, this.sortOrder);
        if (this.currentDataSet != null && this.currentDataSet.length < num) {
            int page = super.getPage() > 0 ? super.getPage() : 1;
            this.totalRecords = (page - 1) * this.getMaxRows() + this.currentDataSet.length;
        }
        if (this.totalRecords == -1) {
            this.totalRecords = this.dataSet.getTotalRecords();
        }
    }

    public Object getCurrentData(int index) {
        if (index < 0 || index > this.currentDataSet.length) {
            return null;
        }
        return this.currentDataSet[index];
    }

    public Object[] getCurrentData() {
        return this.currentDataSet;
    }
}

