/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.util;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.CommonPopupBase;
import com.sun.netstorage.samqfs.web.util.Filter;
import com.sun.netstorage.samqfs.web.util.FsmVersion;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.taglib.header.CCHtmlHeaderTag;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class FilterSettingsViewBean
extends CommonPopupBase {
    private static final String PAGE_NAME = "FilterSettings";
    private static final String DEFAULT_DISPLAY_URL_ROOT = "/jsp/util/FilterSettings.jsp";
    public static final String CHILD_HEADER = "pageHeader";
    public static final String CHILD_FILE_NAME_PATTERN = "fileNamePatternValue";
    public static final String CHILD_FILE_SIZE_GREATER_VALUE = "fileSizeGreaterValue";
    public static final String CHILD_FILE_SIZE_LESS_VALUE = "fileSizeLessValue";
    public static final String CHILD_FILE_SIZE_GREATER_UNIT = "fileSizeGreaterUnit";
    public static final String CHILD_FILE_SIZE_LESS_UNIT = "fileSizeLessUnit";
    public static final String CHILD_FILE_DATE_TYPE = "fileDateType";
    public static final String CHILD_FILE_DATE_RANGE = "fileDateRange";
    public static final String CHILD_FILE_DATE_NUM = "fileDateNum";
    public static final String CHILD_FILE_DATE_UNIT = "fileDateUnit";
    public static final String CHILD_FILE_DATE_START = "fileDateStart";
    public static final String CHILD_FILE_DATE_END = "fileDateEnd";
    public static final String CHILD_OWNER = "ownerValue";
    public static final String CHILD_GROUP = "groupValue";
    public static final String CHILD_ISDAMAGED = "isDamagedValue";
    public static final String CHILD_ISDAMAGED_PROP = "isDamaged";
    public static final String CHILD_ISONLINE = "isOnlineValue";
    public static final String CHILD_ISONLINE_PROP = "isOnline";
    public static final String CHILD_RETURN_VALUE = "returnValue";
    public static final String CHILD_SUBMIT_NOW = "submitNow";
    public static final String FILE_SIZE_UNIT_KB = "kb";
    public static final String FILE_SIZE_UNIT_MB = "mb";
    public static final String FILE_SIZE_UNIT_GB = "gb";
    public static final String FILE_DATE_TYPE_BLANK = "blank";
    public static final String FILE_DATE_TYPE_CREATED = "created";
    public static final String FILE_DATE_TYPE_MODIFIED = "modified";
    public static final String FILE_DATE_TYPE_ACCESSED = "lastAccessed";
    public static final String FILE_DATE_RANGE_INTHELAST = "inTheLast";
    public static final String FILE_DATE_RANGE_BETWEEN = "between";
    public static final String FILE_DATE_UNIT_DAYS = "days";
    public static final String FILE_DATE_UNIT_MONTHS = "months";
    public static final String BOOLEAN_YES = "yes";
    public static final String BOOLEAN_NO = "no";
    public static final String FILTER_OBJECT = "filterObject";
    private Filter filter;
    private FsmVersion version45;

    public FilterSettingsViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL_ROOT);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        TraceUtil.trace3("Exiting");
    }

    public String getPageTitleXmlFile() {
        return "/jsp/util/FilterSettingsPageTitle.xml";
    }

    public String getPropSheetXmlFile() {
        return "/jsp/util/FilterSettingsPropSheet.xml";
    }

    protected View createChild(String name) {
        TraceUtil.trace3("Entering");
        Object child = null;
        child = name.equals(CHILD_HEADER) ? new ViewBase() : super.createChild(name);
        return child;
    }

    public void beginDisplay(DisplayEvent event) {
        TraceUtil.trace3("Entering");
        super.beginDisplay(event);
        this.loadFilterSettings();
        TraceUtil.trace3("Exiting");
    }

    public boolean beginChildDisplay(ChildDisplayEvent event) {
        super.endDisplay((DisplayEvent)event);
        if (event.getChildName().equals(CHILD_HEADER)) {
            CCHtmlHeaderTag tag = (CCHtmlHeaderTag)event.getSource();
            tag.setPageTitle((String)this.getPageSessionAttribute("pageTitleText"));
        }
        return true;
    }

    public void loadFilterSettings() {
        Filter.DateCriteria date;
        String filterStr;
        this.filter = (Filter)this.getPageSessionAttribute(FILTER_OBJECT);
        if (this.filter == null && (filterStr = this.getLoadValue()) != null && filterStr.length() > 0) {
            try {
                this.filter = Filter.getFilterFromEncodedString(filterStr);
                this.setPageSessionAttribute(FILTER_OBJECT, this.filter);
            }
            catch (UnsupportedEncodingException e) {
                TraceUtil.trace1("Unable to build filter object from string.", e);
            }
        }
        if (this.filter == null) {
            this.filter = new Filter(2);
            this.setPageSessionAttribute(FILTER_OBJECT, this.filter);
        }
        this.setDisplayFieldValue(CHILD_FILE_NAME_PATTERN, this.filter.getNamePattern());
        Filter.SizeCriteria size = this.filter.getSizeGreater();
        if (size != null) {
            this.setDisplayFieldValue(CHILD_FILE_SIZE_GREATER_VALUE, String.valueOf(size.getSize()));
            if (size.getSizeUnit() == 2) {
                this.setDisplayFieldValue(CHILD_FILE_SIZE_GREATER_UNIT, FILE_SIZE_UNIT_MB);
            } else if (size.getSizeUnit() == 3) {
                this.setDisplayFieldValue(CHILD_FILE_SIZE_GREATER_UNIT, FILE_SIZE_UNIT_GB);
            } else {
                this.setDisplayFieldValue(CHILD_FILE_SIZE_GREATER_UNIT, FILE_SIZE_UNIT_KB);
            }
        }
        if ((size = this.filter.getSizeLess()) != null) {
            this.setDisplayFieldValue(CHILD_FILE_SIZE_LESS_VALUE, String.valueOf(size.getSize()));
            if (size.getSizeUnit() == 2) {
                this.setDisplayFieldValue(CHILD_FILE_SIZE_LESS_UNIT, FILE_SIZE_UNIT_MB);
            } else if (size.getSizeUnit() == 3) {
                this.setDisplayFieldValue(CHILD_FILE_SIZE_LESS_UNIT, FILE_SIZE_UNIT_GB);
            } else {
                this.setDisplayFieldValue(CHILD_FILE_SIZE_LESS_UNIT, FILE_SIZE_UNIT_KB);
            }
        }
        if ((date = this.filter.getDateCreated()) != null) {
            this.setDisplayFieldValue(CHILD_FILE_DATE_TYPE, FILE_DATE_TYPE_CREATED);
        } else {
            date = this.filter.getDateModified();
            if (date != null) {
                this.setDisplayFieldValue(CHILD_FILE_DATE_TYPE, FILE_DATE_TYPE_MODIFIED);
            } else {
                date = this.filter.getDateAccessed();
                if (date != null) {
                    this.setDisplayFieldValue(CHILD_FILE_DATE_TYPE, FILE_DATE_TYPE_ACCESSED);
                }
            }
        }
        if (date != null) {
            if (date.getDateRangeType() == 9) {
                this.setDisplayFieldValue(CHILD_FILE_DATE_RANGE, FILE_DATE_RANGE_INTHELAST);
                this.setDisplayFieldValue(CHILD_FILE_DATE_NUM, String.valueOf(date.getDateValue()));
                if (date.getDateUnit() == 11) {
                    this.setDisplayFieldValue(CHILD_FILE_DATE_UNIT, FILE_DATE_UNIT_DAYS);
                } else {
                    this.setDisplayFieldValue(CHILD_FILE_DATE_UNIT, FILE_DATE_UNIT_MONTHS);
                }
            } else {
                this.setDisplayFieldValue(CHILD_FILE_DATE_RANGE, FILE_DATE_RANGE_BETWEEN);
                String datePattern = SamUtil.getResourceString("FilterSettings.fileDatePattern");
                SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
                String startDate = "";
                if (date.getAfterDate() != null) {
                    startDate = sdf.format(date.getAfterDate().getTime());
                }
                String endDate = "";
                if (date.getBeforeDate() != null) {
                    endDate = sdf.format(date.getBeforeDate().getTime());
                }
                this.setDisplayFieldValue(CHILD_FILE_DATE_START, startDate);
                this.setDisplayFieldValue(CHILD_FILE_DATE_END, endDate);
            }
        }
        if (this.filter.getOwner() != null) {
            this.setDisplayFieldValue(CHILD_OWNER, this.filter.getOwner());
        }
        if (this.filter.getGroup() != null) {
            this.setDisplayFieldValue(CHILD_GROUP, this.filter.getGroup());
        }
        if (this.filter.getVersion() >= 2) {
            if (this.filter.getIsDamaged() != null) {
                this.setDisplayFieldValue(CHILD_ISDAMAGED, this.filter.getIsDamaged() != false ? BOOLEAN_YES : BOOLEAN_NO);
            }
            if (this.filter.getIsOnline() != null) {
                this.setDisplayFieldValue(CHILD_ISONLINE, this.filter.getIsOnline() != false ? BOOLEAN_YES : BOOLEAN_NO);
            }
        } else {
            this.propertySheetModel.setVisible(CHILD_ISDAMAGED_PROP, false);
            this.propertySheetModel.setVisible(CHILD_ISONLINE_PROP, false);
        }
    }

    public void handleOKButtonRequest(RequestInvocationEvent event) {
        TraceUtil.trace3("Entering");
        try {
            this.storeFilterSettings();
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleOKButtonRequest()", "Failed to save the filter settings.Most likely a user error.", "");
            SamUtil.setErrorAlert((ContainerView)this, "Alert", "FilterSettings.error.cantSave", ex.getSAMerrno(), ex.getMessage(), "");
        }
        this.forwardTo();
        TraceUtil.trace3("Exiting");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean storeFilterSettings() throws SamFSException {
        String owner;
        Capacity capLess;
        Capacity capGreater;
        Filter filter = (Filter)this.getPageSessionAttribute(FILTER_OBJECT);
        int version = 2;
        if (filter != null) {
            version = filter.getVersion();
        }
        filter = new Filter(version);
        NonSyncStringBuffer errors = new NonSyncStringBuffer();
        String namePattern = this.getDisplayFieldStringValue(CHILD_FILE_NAME_PATTERN);
        if (namePattern == null || namePattern.length() == 0) {
            filter.filterOnNamePattern(false, null);
        } else {
            filter.filterOnNamePattern(true, namePattern);
        }
        block12: for (int i = 0; i < 2; ++i) {
            String value = "";
            String unitFieldName = "";
            Filter.SizeCriteria size = null;
            switch (i) {
                case 0: {
                    value = this.getDisplayFieldStringValue(CHILD_FILE_SIZE_GREATER_VALUE);
                    if (value == null || value.length() == 0) {
                        filter.filterOnSizeGreater(false);
                        continue block12;
                    }
                    filter.filterOnSizeGreater(true);
                    size = filter.getSizeGreater();
                    unitFieldName = CHILD_FILE_SIZE_GREATER_UNIT;
                    break;
                }
                case 1: {
                    value = this.getDisplayFieldStringValue(CHILD_FILE_SIZE_LESS_VALUE);
                    if (value == null || value.length() == 0) {
                        filter.filterOnSizeLess(false);
                        continue block12;
                    }
                    filter.filterOnSizeLess(true);
                    size = filter.getSizeLess();
                    unitFieldName = CHILD_FILE_SIZE_LESS_UNIT;
                }
            }
            long sizeLong = 0L;
            try {
                sizeLong = Long.parseLong(value);
                if (sizeLong < 0L) {
                    this.addError("FilterSettings.error.badSize", errors);
                }
            }
            catch (NumberFormatException e) {
                this.addError("FilterSettings.error.badSize", errors);
            }
            size.setSize(sizeLong);
            value = this.getDisplayFieldStringValue(unitFieldName);
            if (value.equals(FILE_SIZE_UNIT_MB)) {
                size.setSizeUnit(2);
                continue;
            }
            if (value.equals(FILE_SIZE_UNIT_GB)) {
                size.setSizeUnit(3);
                continue;
            }
            size.setSizeUnit(1);
        }
        if (filter.getSizeGreater() != null && filter.getSizeLess() != null && (capGreater = new Capacity(filter.getSizeGreater().getSize(), filter.getSizeGreater().getSizeUnit())).compareTo(capLess = new Capacity(filter.getSizeLess().getSize(), filter.getSizeLess().getSizeUnit())) > 0) {
            this.addError("FilterSettings.error.badSizeCombo", errors);
        }
        String temp = this.getDisplayFieldStringValue(CHILD_FILE_DATE_TYPE);
        Filter.DateCriteria date = null;
        if (temp.equals(FILE_DATE_TYPE_CREATED)) {
            filter.filterOnDateCreated(true);
            date = filter.getDateCreated();
        } else if (temp.equals(FILE_DATE_TYPE_MODIFIED)) {
            filter.filterOnDateModified(true);
            date = filter.getDateModified();
        } else if (temp.equals(FILE_DATE_TYPE_ACCESSED)) {
            filter.filterOnDateAccessed(true);
            date = filter.getDateAccessed();
        }
        if (date != null) {
            temp = this.getDisplayFieldStringValue(CHILD_FILE_DATE_RANGE);
            if (temp.equals(FILE_DATE_RANGE_INTHELAST)) {
                int fileDateNum;
                try {
                    fileDateNum = Integer.parseInt(this.getDisplayFieldStringValue(CHILD_FILE_DATE_NUM));
                    if (fileDateNum < 0) {
                        this.addError("FilterSettings.error.badDateNum", errors);
                    }
                }
                catch (NumberFormatException e) {
                    this.addError("FilterSettings.error.badDateNum", errors);
                    fileDateNum = 0;
                }
                temp = this.getDisplayFieldStringValue(CHILD_FILE_DATE_UNIT);
                if (temp.equals(FILE_DATE_UNIT_DAYS)) {
                    date.setDatesPrior(fileDateNum, 11);
                } else {
                    date.setDatesPrior(fileDateNum, 12);
                }
            } else {
                String datePattern = SamUtil.getResourceString("FilterSettings.fileDatePattern");
                SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
                String startDateStr = this.getDisplayFieldStringValue(CHILD_FILE_DATE_START);
                String endDateStr = this.getDisplayFieldStringValue(CHILD_FILE_DATE_END);
                try {
                    Date startDate = sdf.parse(startDateStr);
                    Date endDate = sdf.parse(endDateStr);
                    GregorianCalendar startGregDate = new GregorianCalendar();
                    GregorianCalendar endGregDate = new GregorianCalendar();
                    startGregDate.setTime(startDate);
                    endGregDate.setTime(endDate);
                    startGregDate.set(11, 0);
                    startGregDate.set(12, 0);
                    startGregDate.set(13, 0);
                    startGregDate.set(14, 0);
                    endGregDate.set(11, 23);
                    endGregDate.set(12, 59);
                    endGregDate.set(13, 59);
                    endGregDate.set(14, 999);
                    if (startGregDate.getTimeInMillis() > endGregDate.getTimeInMillis()) {
                        this.addError("FilterSettings.error.badDateOrder", errors);
                        date.setDateRangeType(10);
                    } else {
                        date.setDatesBetween(startGregDate, endGregDate);
                    }
                }
                catch (ParseException e) {
                    String dateFormatHelp = SamUtil.getResourceString("FilterSettings.fileDateHelp");
                    String alertStr = SamUtil.getResourceString("FilterSettings.error.badDate", dateFormatHelp);
                    this.addError(alertStr, errors);
                    date.setDateRangeType(10);
                }
            }
        }
        if ((owner = this.getDisplayFieldStringValue(CHILD_OWNER)) == null || owner.length() == 0) {
            filter.filterOnOwner(false, null);
        } else {
            filter.filterOnOwner(true, owner);
        }
        String group = this.getDisplayFieldStringValue(CHILD_GROUP);
        if (group == null || group.length() == 0) {
            filter.filterOnGroup(false, null);
        } else {
            filter.filterOnGroup(true, group);
        }
        if (version >= 2) {
            String isDamaged = this.getDisplayFieldStringValue(CHILD_ISDAMAGED);
            if (isDamaged.equals(BOOLEAN_YES)) {
                filter.filterOnIsDamaged(true, true);
            } else if (isDamaged.equals(BOOLEAN_NO)) {
                filter.filterOnIsDamaged(true, false);
            } else {
                filter.filterOnIsDamaged(false, false);
            }
            String isOnline = this.getDisplayFieldStringValue(CHILD_ISONLINE);
            if (isOnline.equals(BOOLEAN_YES)) {
                filter.filterOnIsOnline(true, true);
            } else if (isOnline.equals(BOOLEAN_NO)) {
                filter.filterOnIsOnline(true, false);
            } else {
                filter.filterOnIsOnline(false, false);
            }
        }
        if (errors.length() > 0) {
            SamFSException e = new SamFSException(errors.toString());
            SamUtil.setErrorAlert((ContainerView)this, "Alert", "FilterSettings.error.cantSave", e.getSAMerrno(), e.getMessage(), "");
            this.setPageSessionAttribute(FILTER_OBJECT, filter);
            return false;
        }
        try {
            this.setDisplayFieldValue(CHILD_RETURN_VALUE, filter.writeEncodedString());
            this.setDisplayFieldValue(CHILD_SUBMIT_NOW, "true");
            return true;
        }
        catch (UnsupportedEncodingException e) {
            SamFSException same = new SamFSException(e.getMessage());
            SamUtil.setErrorAlert((ContainerView)this, "Alert", "FilterSettings.error.cantSave", same.getSAMerrno(), same.getMessage(), "");
        }
        return true;
    }

    private void addError(String newError, NonSyncStringBuffer errorBuf) {
        if (errorBuf.length() > 0) {
            errorBuf.append(SamUtil.getResourceString("FilterSettings.error.sentenceTerminator"));
        }
        errorBuf.append(SamUtil.getResourceString(newError));
    }
}

