/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.server;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSAccessDeniedException;
import com.sun.netstorage.samqfs.mgmt.SamFSCommException;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.archive.MultiTableViewBase;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.SystemCapacity;
import com.sun.netstorage.samqfs.web.model.alarm.AlarmSummary;
import com.sun.netstorage.samqfs.web.server.ServerSelectionTiledView;
import com.sun.netstorage.samqfs.web.server.ServerUtil;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.ServerInfo;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.alarm.CCAlarmObject;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

public class ServerSelectionView
extends MultiTableViewBase {
    public static final String CHILD_TILED_VIEW = "ServerSelectionTiledView";
    public static final String SERVER_TABLE = "ServerSelectionTable";
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$server$ServerSelectionTiledView;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$admin$ServerConfigurationViewBean;

    public ServerSelectionView(View parent, Map models, String name) {
        super(parent, models, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        this.registerChild(CHILD_TILED_VIEW, class$com$sun$netstorage$samqfs$web$server$ServerSelectionTiledView == null ? (class$com$sun$netstorage$samqfs$web$server$ServerSelectionTiledView = ServerSelectionView.class$("com.sun.netstorage.samqfs.web.server.ServerSelectionTiledView")) : class$com$sun$netstorage$samqfs$web$server$ServerSelectionTiledView);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        TraceUtil.trace3(new NonSyncStringBuffer().append("Entering: name is ").append(name).toString());
        ServerSelectionTiledView child = null;
        if (name.equals(CHILD_TILED_VIEW)) {
            child = new ServerSelectionTiledView((View)this, this.getTableModel(SERVER_TABLE), name);
        } else if (name.equals(SERVER_TABLE)) {
            child = this.createTable(name, CHILD_TILED_VIEW);
        } else {
            CCActionTableModel model = super.isChildSupported(name);
            if (model != null) {
                child = super.isChildSupported(name).createChild((View)this, name);
            }
        }
        if (child == null) {
            throw new IllegalArgumentException("Invalid Child '" + name + "'");
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    public void handleAddButtonRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleRemoveButtonRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        String rowKey = this.getSelectedRowKey();
        try {
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            if (appModel == null) {
                throw new SamFSException(null, -2501);
            }
            LogUtil.info(((Object)((Object)this)).getClass(), "handleRemoveButtonRequest", new NonSyncStringBuffer().append("Start removing server ").append(rowKey).toString());
            appModel.removeHost(rowKey);
            LogUtil.info(((Object)((Object)this)).getClass(), "handleRemoveButtonRequest", new NonSyncStringBuffer().append("Done removing server ").append(rowKey).toString());
            this.setSuccessAlert("ServerSelection.action.delete", rowKey);
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleRemoveButtonRequest", "Failed to remove server", rowKey);
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ServerSelection.error.delete", ex.getSAMerrno(), ex.getMessage(), rowKey);
        }
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Existing");
    }

    public void handleViewConfigButtonRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        String samfsServerAPIVersion;
        short licenseType;
        TraceUtil.trace3("Entering");
        ViewBean targetViewBean = null;
        String rowKey = this.getSelectedRowKey();
        HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
        Hashtable<String, ServerInfo> serverTable = (Hashtable<String, ServerInfo>)session.getAttribute("SAMFS_SERVER_INFO");
        if (serverTable == null) {
            serverTable = new Hashtable<String, ServerInfo>();
        }
        try {
            licenseType = SamUtil.getSystemType(rowKey);
            samfsServerAPIVersion = SamUtil.getModel(rowKey).getServerAPIVersion();
            samfsServerAPIVersion = samfsServerAPIVersion == null ? "1.3" : samfsServerAPIVersion;
            TraceUtil.trace2(new NonSyncStringBuffer().append("Got samfs license type: ").append((int)licenseType).toString());
            TraceUtil.trace2(new NonSyncStringBuffer().append("Got samfs server api version: ").append(samfsServerAPIVersion).toString());
        }
        catch (SamFSException samEx) {
            TraceUtil.trace1(new NonSyncStringBuffer().append("Exception while trying to get license type").append(samEx.getMessage() != null ? samEx.getMessage() : "null").toString());
            SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "handleViewConfigRequest()", "Failed to retreive license from server", rowKey);
            targetViewBean = this.getViewBean(class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean == null ? (class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean = ServerSelectionView.class$("com.sun.netstorage.samqfs.web.util.ErrorHandleViewBean")) : class$com$sun$netstorage$samqfs$web$util$ErrorHandleViewBean);
            CCAlertInline alert = (CCAlertInline)targetViewBean.getChild("Alert");
            alert.setType("error");
            alert.setSummary(SamUtil.getResourceString("license.error", new String[]{rowKey}));
            if (samEx.getMessage() != null) {
                alert.setDetail(samEx.getMessage());
            }
            targetViewBean.forwardTo(this.getRequestContext());
            TraceUtil.trace3("Exiting");
            return;
        }
        serverTable.put(rowKey, new ServerInfo(rowKey, samfsServerAPIVersion, licenseType));
        session.setAttribute("SAMFS_SERVER_INFO", serverTable);
        targetViewBean = this.getViewBean(class$com$sun$netstorage$samqfs$web$admin$ServerConfigurationViewBean == null ? (class$com$sun$netstorage$samqfs$web$admin$ServerConfigurationViewBean = ServerSelectionView.class$("com.sun.netstorage.samqfs.web.admin.ServerConfigurationViewBean")) : class$com$sun$netstorage$samqfs$web$admin$ServerConfigurationViewBean);
        targetViewBean.setPageSessionAttribute("SERVER_NAME", (Serializable)((Object)this.getSelectedRowKey()));
        targetViewBean.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Existing");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.initializeTableHeaders();
        if (SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.CONFIG)) {
            ((CCButton)this.getChild("AddButton")).setDisabled(false);
        } else {
            CCActionTableModel model = this.getTableModel(SERVER_TABLE);
            model.setSelectionType("none");
        }
        CCActionTable myTable = (CCActionTable)this.getChild(SERVER_TABLE);
        CCRadioButton myRadio = (CCRadioButton)myTable.getChild("SelectionRadiobutton");
        myRadio.setTitle("");
        myRadio.setTitleDisabled("");
        TraceUtil.trace3("Exiting");
    }

    private String getSelectedRowKey() throws ModelControlException {
        TraceUtil.trace3("Entering");
        Object returnValue = null;
        CCActionTable actionTable = (CCActionTable)this.getChild(SERVER_TABLE);
        try {
            actionTable.restoreStateData();
        }
        catch (ModelControlException mcex) {
            SamUtil.processException((Exception)((Object)mcex), ((Object)((Object)this)).getClass(), "getSelectedRowKey", "Failed to retrieve selected row key", "Unknown");
            throw mcex;
        }
        CCActionTableModel serverModel = this.getTableModel(SERVER_TABLE);
        Integer[] selectedRows = serverModel.getSelectedRows();
        int row = selectedRows[0];
        serverModel.setRowIndex(row);
        String[] returnArray = ((String)serverModel.getValue("HiddenInfo")).split("###");
        TraceUtil.trace3(new NonSyncStringBuffer().append("Selected server name is ").append(returnArray[0]).toString());
        TraceUtil.trace3("Exiting");
        return returnArray[0];
    }

    private void setSuccessAlert(String msg, String item) {
        TraceUtil.trace3("Entering");
        SamUtil.setInfoAlert((ContainerView)this.getParentViewBean(), "Alert", "success.summary", SamUtil.getResourceString(msg, item), "");
        TraceUtil.trace3("Exiting");
    }

    private void initializeTableHeaders() {
        CCActionTableModel model = this.getTableModel(SERVER_TABLE);
        model.setRowSelected(false);
        model.setActionValue("NameColumn", (Object)"ServerSelection.heading.name");
        model.setActionValue("FaultsColumn", (Object)"ServerSelection.heading.faults");
        model.setActionValue("VersionColumn", (Object)"ServerSelection.heading.version");
        model.setActionValue("ArchColumn", (Object)"ServerSelection.heading.architecture");
        model.setActionValue("DiskCacheColumn", (Object)"ServerSelection.heading.diskcache");
        model.setActionValue("MediaCapacityColumn", (Object)"ServerSelection.heading.mediacapacity");
    }

    public void populateTableModels() throws SamFSException {
        this.populateServerTable();
    }

    private void populateServerTable() throws SamFSException {
        long totalAvailableServers = 0L;
        long totalMountedFS = 0L;
        long totalDiskCache = 0L;
        long totalAvailableDiskCache = 0L;
        long serverDiskCache = 0L;
        long serverAvailableDiskCache = 0L;
        long serverMediaCapacity = 0L;
        long serverAvailableMediaCapacity = 0L;
        long serverMountedFS = 0L;
        long serverLibraryCount = 0L;
        long serverMediaSlot = 0L;
        int alarmType = -1;
        String hostName = "";
        String versionNumber = "";
        String architecture = "";
        String diskCacheString = "";
        String mediaCapacityString = "";
        CCActionTableModel model = this.getTableModel(SERVER_TABLE);
        model.clear();
        SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
        if (appModel == null) {
            throw new SamFSException(null, -2501);
        }
        appModel.updateDownServers();
        SamQFSSystemModel[] allSystemModel = appModel.getAllSamQFSSystemModels();
        if (allSystemModel == null) {
            return;
        }
        for (int i = 0; i < allSystemModel.length; ++i) {
            if (i > 0) {
                model.appendRow();
            }
            try {
                hostName = allSystemModel[i].getHostname();
                model.setValue("NameText", (Object)hostName);
                String samfsServerAPIVersion = allSystemModel[i].getServerAPIVersion();
                String string = samfsServerAPIVersion = samfsServerAPIVersion == null ? "1.3" : samfsServerAPIVersion;
                if (SamUtil.isVersionCurrentOrLaterThan(samfsServerAPIVersion, "1.4") && allSystemModel[i].isClusterNode()) {
                    model.setValue("NameText", (Object)SamUtil.getResourceString("ServerSelection.host.clusterword", new String[]{hostName, allSystemModel[i].getClusterName()}));
                }
                TraceUtil.trace2(new NonSyncStringBuffer("hostName: ").append(hostName).toString());
                if (allSystemModel[i].isDown()) {
                    TraceUtil.trace2("System is DOWN");
                    if (allSystemModel[i].isAccessDenied()) {
                        TraceUtil.trace1(new NonSyncStringBuffer("Access Denied to server ").append(hostName).toString());
                        alarmType = 5;
                    } else {
                        TraceUtil.trace2("Down: some other problem");
                        alarmType = 4;
                    }
                } else if (!allSystemModel[i].isServerSupported()) {
                    TraceUtil.trace1(new NonSyncStringBuffer("Server ").append(hostName).append(" is not supported.  Out of rev.").toString());
                    alarmType = 6;
                } else {
                    TraceUtil.trace2("Server is supported!");
                    if (hostName != null) {
                        versionNumber = ServerUtil.getVersionString(SamUtil.getModel(hostName).getServerProductVersion());
                        architecture = SamUtil.swapArchString(allSystemModel[i].getArchitecture());
                    }
                    AlarmSummary myAlarmSummary = allSystemModel[i].getSamQFSSystemAlarmManager().getAlarmSummary();
                    int critical = myAlarmSummary.getCriticalTotal();
                    int major = myAlarmSummary.getMajorTotal();
                    int minor = myAlarmSummary.getMinorTotal();
                    if (myAlarmSummary == null) {
                        alarmType = 0;
                    } else {
                        alarmType = this.getMostSevereAlarm(critical, major, minor);
                        TraceUtil.trace2(new NonSyncStringBuffer("AlarmType is ").append(alarmType).toString());
                    }
                    SystemCapacity mySystemCapacity = allSystemModel[i].getCapacity();
                    serverDiskCache = mySystemCapacity.getDiskCacheKB() == -1L ? 0L : mySystemCapacity.getDiskCacheKB();
                    serverAvailableDiskCache = mySystemCapacity.getAvailDiskCacheKB() == -1L ? 0L : mySystemCapacity.getAvailDiskCacheKB();
                    diskCacheString = ServerUtil.createStringWithPercentage(serverDiskCache, serverAvailableDiskCache);
                    serverMediaCapacity = mySystemCapacity.getMediaKB() == -1L ? 0L : mySystemCapacity.getMediaKB();
                    serverAvailableMediaCapacity = mySystemCapacity.getAvailMediaKB() == -1L ? 0L : mySystemCapacity.getAvailMediaKB();
                    mediaCapacityString = ServerUtil.createStringWithPercentage(serverMediaCapacity, serverAvailableMediaCapacity);
                    serverMountedFS = mySystemCapacity.getNumOfMountedFS() == -1 ? 0L : (long)mySystemCapacity.getNumOfMountedFS();
                    serverLibraryCount = mySystemCapacity.getNumOfLibs() == -1 ? 0L : (long)mySystemCapacity.getNumOfLibs();
                    serverMediaSlot = mySystemCapacity.getNumOfSlots() == -1 ? 0L : (long)mySystemCapacity.getNumOfSlots();
                    totalDiskCache += serverDiskCache;
                    totalAvailableDiskCache += serverAvailableDiskCache;
                    totalMountedFS += serverMountedFS;
                }
            }
            catch (SamFSAccessDeniedException denyEx) {
                TraceUtil.trace1(new NonSyncStringBuffer("Access Denied to server ").append(hostName).toString());
                alarmType = 5;
            }
            catch (SamFSCommException comEx) {
                TraceUtil.trace1(new NonSyncStringBuffer("Communication exception while connecting to server ").append(hostName).toString());
                SamUtil.processException((Exception)((Object)comEx), ((Object)((Object)this)).getClass(), "initModelRows()", "Communication exception occur while connecting to server", hostName);
                alarmType = 4;
            }
            catch (SamFSException samEx) {
                TraceUtil.trace1(new NonSyncStringBuffer("General SAM FS exception while connecting to server ").append(hostName).toString());
                TraceUtil.trace1("Reason: " + samEx.getMessage());
                SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "initModelRows()", "General SAM FS exception occur while connecting to server", hostName);
                alarmType = 4;
            }
            catch (Exception genEx) {
                TraceUtil.trace1(new NonSyncStringBuffer("Unknown Exception while connecting to server ").append(hostName).toString());
                SamUtil.processException(genEx, ((Object)((Object)this)).getClass(), "initModelRows()", "Unknown exception occur while connecting to server", hostName);
                alarmType = 4;
            }
            switch (alarmType) {
                case 4: 
                case 5: 
                case 6: {
                    versionNumber = "";
                    architecture = "";
                    diskCacheString = "";
                    mediaCapacityString = "";
                    break;
                }
                default: {
                    ++totalAvailableServers;
                }
            }
            model.setValue("VersionText", (Object)versionNumber);
            model.setValue("ArchText", (Object)architecture);
            model.setValue("DiskCacheText", (Object)diskCacheString);
            model.setValue("MediaCapacityText", (Object)mediaCapacityString);
            model.setValue("AccessDeniedText", (Object)"");
            model.setValue("HiddenInfo", (Object)new NonSyncStringBuffer(hostName).append("###").append(alarmType).toString());
            model.setValue("AlarmHref", (Object)hostName);
            model.setValue("ServerHref", (Object)hostName);
            model.setValue("VersionHref", (Object)hostName);
            model.setValue("DiskCacheHref", (Object)hostName);
            model.setValue("MediaCapacityHref", (Object)hostName);
            SamUtil.doPrint(new NonSyncStringBuffer("Host: ").append(hostName).append(" Alarm: ").append(alarmType).toString());
            this.setAlarmInModel(alarmType);
        }
        this.getParentViewBean().setPageSessionAttribute("CapacitySummary", (Serializable)((Object)new NonSyncStringBuffer().append(totalAvailableServers).append("###").append(totalDiskCache).append("###").append(totalAvailableDiskCache).append("###").append(totalMountedFS).append("###").toString()));
        TraceUtil.trace3("Exiting");
    }

    private int getMostSevereAlarm(int critical, int major, int minor) {
        if (critical != 0) {
            return 1;
        }
        if (major != 0) {
            return 2;
        }
        if (minor != 0) {
            return 3;
        }
        return 0;
    }

    private void setAlarmInModel(int alarmType) {
        CCActionTableModel model = this.getTableModel(SERVER_TABLE);
        switch (alarmType) {
            case 4: {
                model.setValue("Alarm", (Object)new CCAlarmObject(1));
                break;
            }
            case 1: {
                model.setValue("Alarm", (Object)new CCAlarmObject(2));
                break;
            }
            case 2: {
                model.setValue("Alarm", (Object)new CCAlarmObject(3));
                break;
            }
            case 3: {
                model.setValue("Alarm", (Object)new CCAlarmObject(4));
                break;
            }
            case 5: {
                model.setValue("Alarm", (Object)new CCAlarmObject(5));
                model.setValue("AccessDeniedText", (Object)SamUtil.getResourceString("access.denied"));
                break;
            }
            case 6: {
                model.setValue("Alarm", (Object)new CCAlarmObject(5));
                model.setValue("AccessDeniedText", (Object)SamUtil.getResourceString("server.notsupported"));
                break;
            }
            default: {
                model.setValue("Alarm", (Object)new CCAlarmObject(5));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

