/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.server;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.server.HighlightInfo;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXHandler
extends DefaultHandler {
    private int key = 0;
    private static HashMap myHashMap;
    private String featureType;
    private String featureName;
    private String serverVersion;
    private String versionNumber;
    private String versionStatus;
    private NonSyncStringBuffer versionInfo;
    private HighlightInfo highlightInfo;
    private int nowServing = -1;

    public static void parseIt() throws SamFSException {
        SAXHandler handler = new SAXHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new InputSource("samqfsui/jsp/server/VersionHighlightContent.xml"), (DefaultHandler)handler);
        }
        catch (Throwable t) {
            TraceUtil.trace1("Error occurred while parsing version highlight version file. Reason: " + t.getMessage());
            throw new SamFSException(null, -2550);
        }
    }

    public void startDocument() throws SAXException {
        TraceUtil.trace2("Start parsing version highlight XML file ...");
        if (myHashMap == null) {
            myHashMap = new HashMap();
        } else {
            myHashMap.clear();
        }
    }

    public void endDocument() throws SAXException {
        TraceUtil.trace2("Done parsing version highlight XML file.");
    }

    public void startElement(String namespaceURI, String simpleName, String qualifiedName, Attributes attrs) throws SAXException {
        this.print(new NonSyncStringBuffer("StartElement: qualifiedName is ").append(qualifiedName).toString());
        if (qualifiedName.equals("feature")) {
            this.featureType = attrs != null && attrs.getValue(0) != null ? attrs.getValue(0) : "";
            this.featureName = "";
            this.versionNumber = "";
            this.versionStatus = "";
            this.serverVersion = "";
            this.versionInfo = new NonSyncStringBuffer();
            this.highlightInfo = null;
            this.nowServing = -1;
        } else if (qualifiedName.equals("feature-name")) {
            this.nowServing = 0;
        } else if (qualifiedName.equals("version-number")) {
            this.nowServing = 1;
        } else if (qualifiedName.equals("version-status")) {
            this.nowServing = 2;
        } else if (qualifiedName.equals("server-version")) {
            this.nowServing = 3;
        }
    }

    public void endElement(String namespaceURI, String simpleName, String qualifiedName) throws SAXException {
        this.print("endElement is called!");
        this.nowServing = -1;
        if (qualifiedName.equals("feature")) {
            this.featureType = this.featureType == null ? "" : this.featureType.trim();
            this.featureName = this.featureName == null ? "" : this.featureName.trim();
            this.serverVersion = this.serverVersion == null ? "" : this.serverVersion.trim();
            this.highlightInfo = new HighlightInfo(this.featureType, this.featureName, this.serverVersion, this.versionInfo.toString());
            myHashMap.put(new Integer(this.key++), this.highlightInfo);
        } else if (qualifiedName.equals("version")) {
            if (this.versionInfo.length() != 0) {
                this.versionInfo.append("###");
            }
            this.versionInfo.append(this.versionNumber).append(",").append(this.versionStatus);
        }
    }

    public void characters(char[] buf, int offset, int length) throws SAXException {
        String content = new String(buf, offset, length).trim();
        this.print(new NonSyncStringBuffer("Characters: nowServing is ").append(this.nowServing).toString());
        this.print(new NonSyncStringBuffer("Characters: content is ").append(content).toString());
        switch (this.nowServing) {
            case 0: {
                this.featureName = content;
                break;
            }
            case 1: {
                this.versionNumber = content;
                break;
            }
            case 2: {
                this.versionStatus = content;
                break;
            }
            case 3: {
                this.serverVersion = content;
                break;
            }
        }
    }

    private void print(String printMessage) {
        TraceUtil.trace3(printMessage);
    }

    public static HashMap getHashMap() {
        return myHashMap;
    }
}

