/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.remotefilechooser;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.fs.RemoteFile;
import com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserModel;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.model.CCFileChooserModelInterface;
import com.sun.web.ui.view.filechooser.CCFileChooser;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCImageField;
import com.sun.web.ui.view.html.CCSelectableList;
import com.sun.web.ui.view.html.CCTextField;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.servlet.ServletException;

public class RemoteFileChooser
extends CCFileChooser {
    public static final String CHILD_PAGINATION_HREF = "PaginationHref";
    public static final String CHILD_PAGINATION_IMAGE = "PaginationImage";
    public static final String CHILD_PAGINATION_FIRST_HREF = "PaginationFirstHref";
    public static final String CHILD_PAGINATION_FIRST_IMAGE = "PaginationFirstImage";
    public static final String CHILD_PAGINATION_LAST_HREF = "PaginationLastHref";
    public static final String CHILD_PAGINATION_LAST_IMAGE = "PaginationLastImage";
    public static final String CHILD_PAGINATION_NEXT_HREF = "PaginationNextHref";
    public static final String CHILD_PAGINATION_NEXT_IMAGE = "PaginationNextImage";
    public static final String CHILD_PAGINATION_PREV_HREF = "PaginationPrevHref";
    public static final String CHILD_PAGINATION_PREV_IMAGE = "PaginationPrevImage";
    public static final String CHILD_PAGINATION_PAGE_TEXTFIELD = "PaginationPageTextField";
    public static final String CHILD_PAGINATION_GO_BUTTON = "PaginationGoButton";
    public static final String CHILD_CREATE_FOLDER = "createFolderButton";
    public static final String CLEAR_CACHE = "clearCache";
    public static final int TYPE_FILE = 0;
    public static final int TYPE_FOLDER = 1;
    public static final int TYPE_FILE_AND_FOLDER = 2;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHref;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCImageField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCTextField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCButton;

    public RemoteFileChooser(ContainerView parent, RemoteFileChooserModel model, String name) {
        super(parent, (CCFileChooserModelInterface)model, name);
        TraceUtil.trace3("name = " + name);
        ViewBean pvb = this.getParentViewBean();
        String clearCache = (String)pvb.getPageSessionAttribute(CLEAR_CACHE);
        if (clearCache == null || clearCache.equals("true")) {
            model.clearCachedDir();
        }
        pvb.setPageSessionAttribute(CLEAR_CACHE, (Serializable)((Object)"false"));
        TraceUtil.initTrace();
        TraceUtil.trace3("Ctor being called");
    }

    protected void registerChildren() {
        TraceUtil.trace3("I'm here");
        super.registerChildren();
        this.registerChild(CHILD_PAGINATION_FIRST_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = RemoteFileChooser.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_PAGINATION_FIRST_IMAGE, class$com$sun$web$ui$view$html$CCImageField == null ? (class$com$sun$web$ui$view$html$CCImageField = RemoteFileChooser.class$("com.sun.web.ui.view.html.CCImageField")) : class$com$sun$web$ui$view$html$CCImageField);
        this.registerChild(CHILD_PAGINATION_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = RemoteFileChooser.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_PAGINATION_IMAGE, class$com$sun$web$ui$view$html$CCImageField == null ? (class$com$sun$web$ui$view$html$CCImageField = RemoteFileChooser.class$("com.sun.web.ui.view.html.CCImageField")) : class$com$sun$web$ui$view$html$CCImageField);
        this.registerChild(CHILD_PAGINATION_LAST_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = RemoteFileChooser.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_PAGINATION_LAST_IMAGE, class$com$sun$web$ui$view$html$CCImageField == null ? (class$com$sun$web$ui$view$html$CCImageField = RemoteFileChooser.class$("com.sun.web.ui.view.html.CCImageField")) : class$com$sun$web$ui$view$html$CCImageField);
        this.registerChild(CHILD_PAGINATION_NEXT_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = RemoteFileChooser.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_PAGINATION_NEXT_IMAGE, class$com$sun$web$ui$view$html$CCImageField == null ? (class$com$sun$web$ui$view$html$CCImageField = RemoteFileChooser.class$("com.sun.web.ui.view.html.CCImageField")) : class$com$sun$web$ui$view$html$CCImageField);
        this.registerChild(CHILD_PAGINATION_PREV_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = RemoteFileChooser.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_PAGINATION_PREV_IMAGE, class$com$sun$web$ui$view$html$CCImageField == null ? (class$com$sun$web$ui$view$html$CCImageField = RemoteFileChooser.class$("com.sun.web.ui.view.html.CCImageField")) : class$com$sun$web$ui$view$html$CCImageField);
        this.registerChild(CHILD_PAGINATION_PAGE_TEXTFIELD, class$com$sun$web$ui$view$html$CCTextField == null ? (class$com$sun$web$ui$view$html$CCTextField = RemoteFileChooser.class$("com.sun.web.ui.view.html.CCTextField")) : class$com$sun$web$ui$view$html$CCTextField);
        this.registerChild(CHILD_PAGINATION_GO_BUTTON, class$com$sun$web$ui$view$html$CCButton == null ? (class$com$sun$web$ui$view$html$CCButton = RemoteFileChooser.class$("com.sun.web.ui.view.html.CCButton")) : class$com$sun$web$ui$view$html$CCButton);
        this.registerChild(CHILD_CREATE_FOLDER, class$com$sun$web$ui$view$html$CCButton == null ? (class$com$sun$web$ui$view$html$CCButton = RemoteFileChooser.class$("com.sun.web.ui.view.html.CCButton")) : class$com$sun$web$ui$view$html$CCButton);
    }

    protected View createChild(String name) {
        if (name.equals(CHILD_PAGINATION_HREF)) {
            CCHref child = new CCHref((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_PAGINATION_IMAGE)) {
            CCImageField child = new CCImageField((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_PAGINATION_FIRST_HREF)) {
            CCHref child = new CCHref((ContainerView)this, name, null);
            child.setTitle("table.paginationGoToFirst");
            return child;
        }
        if (name.equals(CHILD_PAGINATION_FIRST_IMAGE)) {
            CCImageField child = new CCImageField((ContainerView)this, name, null);
            child.setAlt("table.paginationGoToFirst");
            return child;
        }
        if (name.equals(CHILD_PAGINATION_PREV_HREF)) {
            CCHref child = new CCHref((ContainerView)this, name, null);
            child.setTitle("table.paginationGoToPrevious");
            return child;
        }
        if (name.equals(CHILD_PAGINATION_PREV_IMAGE)) {
            CCImageField child = new CCImageField((ContainerView)this, name, null);
            child.setAlt("table.paginationGoToPrevious");
            return child;
        }
        if (name.equals(CHILD_PAGINATION_NEXT_HREF)) {
            CCHref child = new CCHref((ContainerView)this, name, null);
            child.setTitle("table.paginationGoToNext");
            return child;
        }
        if (name.equals(CHILD_PAGINATION_NEXT_IMAGE)) {
            CCImageField child = new CCImageField((ContainerView)this, name, null);
            child.setAlt("table.paginationGoToNext");
            return child;
        }
        if (name.equals(CHILD_PAGINATION_LAST_HREF)) {
            CCHref child = new CCHref((ContainerView)this, name, null);
            child.setTitle("table.paginationGoToLast");
            return child;
        }
        if (name.equals(CHILD_PAGINATION_LAST_IMAGE)) {
            CCImageField child = new CCImageField((ContainerView)this, name, null);
            child.setAlt("table.paginationGoToLast");
            return child;
        }
        if (name.equals(CHILD_PAGINATION_PAGE_TEXTFIELD)) {
            CCTextField child = new CCTextField((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_PAGINATION_GO_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, (Object)"table.paginationGo");
            child.setTitle("table.paginationGoToPage");
            child.setAlt("table.paginationGoToPage");
            return child;
        }
        if (name.equals(CHILD_CREATE_FOLDER)) {
            CCButton child = new CCButton((ContainerView)this, name, (Object)SamUtil.getResourceString("browser.createFolder"));
            child.setTitle(SamUtil.getResourceString("browser.createFolderAlt"));
            child.setAlt(SamUtil.getResourceString("browser.createFolderAlt"));
            child.setType("secondary");
            return child;
        }
        return super.createChild(name);
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("I'm here");
        super.beginDisplay(event);
    }

    public void initPaginationControls() {
        if (this.model == null) {
            return;
        }
        TraceUtil.trace3("I'm here");
        RemoteFileChooserModel rmodel = (RemoteFileChooserModel)this.model;
        this.setDisplayFieldValue(CHILD_PAGINATION_PAGE_TEXTFIELD, Integer.toString(rmodel.getCurrentPage() + 1));
        CCHref href = (CCHref)this.getChild(CHILD_PAGINATION_HREF);
        CCImageField image = (CCImageField)this.getChild(CHILD_PAGINATION_IMAGE);
        if (rmodel.getTotalPages() > 1) {
            image.setValue((Object)CCImage.TABLE_SCROLL_PAGE);
            image.setHeight(Integer.parseInt("20"));
            image.setWidth(Integer.parseInt("36"));
        } else {
            image.setValue((Object)CCImage.TABLE_SCROLL_PAGE_DISABLED);
            image.setHeight(Integer.parseInt("20"));
            image.setWidth(Integer.parseInt("36"));
        }
        image = (CCImageField)this.getChild(CHILD_PAGINATION_FIRST_IMAGE);
        if (rmodel.getCurrentPage() > 0) {
            image.setValue((Object)CCImage.TABLE_PAGINATION_FIRST);
            image.setHeight(Integer.parseInt("20"));
            image.setWidth(Integer.parseInt("23"));
        } else {
            image.setValue((Object)CCImage.TABLE_PAGINATION_FIRST_DISABLED);
            image.setHeight(Integer.parseInt("20"));
            image.setWidth(Integer.parseInt("23"));
        }
        image = (CCImageField)this.getChild(CHILD_PAGINATION_PREV_IMAGE);
        if (rmodel.getCurrentPage() > 0) {
            image.setValue((Object)CCImage.TABLE_PAGINATION_PREV);
            image.setHeight(Integer.parseInt("20"));
            image.setWidth(Integer.parseInt("23"));
        } else {
            image.setValue((Object)CCImage.TABLE_PAGINATION_PREV_DISABLED);
            image.setHeight(Integer.parseInt("20"));
            image.setWidth(Integer.parseInt("23"));
        }
        image = (CCImageField)this.getChild(CHILD_PAGINATION_NEXT_IMAGE);
        if (rmodel.getCurrentPage() < rmodel.getTotalPages() - 1) {
            image.setValue((Object)CCImage.TABLE_PAGINATION_NEXT);
            image.setHeight(Integer.parseInt("20"));
            image.setWidth(Integer.parseInt("23"));
        } else {
            image.setValue((Object)CCImage.TABLE_PAGINATION_NEXT_DISABLED);
            image.setHeight(Integer.parseInt("20"));
            image.setWidth(Integer.parseInt("23"));
        }
        image = (CCImageField)this.getChild(CHILD_PAGINATION_LAST_IMAGE);
        if (rmodel.getCurrentPage() < rmodel.getTotalPages() - 1) {
            image.setValue((Object)CCImage.TABLE_PAGINATION_LAST);
            image.setHeight(Integer.parseInt("20"));
            image.setWidth(Integer.parseInt("23"));
        } else {
            image.setValue((Object)CCImage.TABLE_PAGINATION_LAST_DISABLED);
            image.setHeight(Integer.parseInt("20"));
            image.setWidth(Integer.parseInt("23"));
        }
        if (rmodel.getTotalPages() <= 1) {
            CCButton button = (CCButton)this.getChild(CHILD_PAGINATION_GO_BUTTON);
            CCTextField textField = (CCTextField)this.getChild(CHILD_PAGINATION_PAGE_TEXTFIELD);
            button.setDisabled(true);
            textField.setDisabled(true);
        }
    }

    public void handlePaginationFirstHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("I'm here");
        RemoteFileChooserModel rmodel = (RemoteFileChooserModel)this.model;
        rmodel.setCurrentPage(0);
        this.getParentViewBean().forwardTo(this.getRequestContext());
    }

    public void handlePaginationLastHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("I'm here");
        RemoteFileChooserModel rmodel = (RemoteFileChooserModel)this.model;
        rmodel.setCurrentPage(rmodel.getTotalPages() - 1);
        this.getParentViewBean().forwardTo(this.getRequestContext());
    }

    public void handlePaginationNextHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("I'm here");
        RemoteFileChooserModel rmodel = (RemoteFileChooserModel)this.model;
        rmodel.setCurrentPage(rmodel.getCurrentPage() + 1);
        this.getParentViewBean().forwardTo(this.getRequestContext());
    }

    public void handlePaginationPrevHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("I'm here");
        RemoteFileChooserModel rmodel = (RemoteFileChooserModel)this.model;
        rmodel.setCurrentPage(rmodel.getCurrentPage() - 1);
        this.getParentViewBean().forwardTo(this.getRequestContext());
    }

    public void handlePaginationGoButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("I'm here");
        String page = (String)this.getDisplayFieldValue(CHILD_PAGINATION_PAGE_TEXTFIELD);
        RemoteFileChooserModel rmodel = (RemoteFileChooserModel)this.model;
        try {
            rmodel.setCurrentPage(Integer.parseInt(page) - 1);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.getParentViewBean().forwardTo(this.getRequestContext());
    }

    public void handleCreateFolderButtonRequest(RequestInvocationEvent event) {
        String folderName = this.getDisplayFieldStringValue("fileName");
        try {
            if (folderName == null || folderName.length() == 0) {
                throw new SamFSException(SamUtil.getResourceString("browser.create.error.noFolderSpecified"));
            }
            File file = new File(folderName);
            if (file.getParent() != null) {
                throw new SamFSException(SamUtil.getResourceString("browser.create.error.noPathsAllowed"));
            }
            if (!SamUtil.isValidNonSpecialCharString(folderName = folderName.trim())) {
                throw new SamFSException(SamUtil.getResourceString("browser.create.error.invalidChars"));
            }
            RemoteFileChooserModel model = (RemoteFileChooserModel)this.getModel();
            SamQFSSystemFSManager fsMgr = SamUtil.getModel(model.getServerName()).getSamQFSSystemFSManager();
            String path = model.getCurrentDirectory();
            RemoteFile[] remoteFiles = model.getDirEntries(model.getMaxEntries(), path, null);
            if (remoteFiles != null) {
                for (int i = 0; i < remoteFiles.length; ++i) {
                    if (!remoteFiles[i].getName().equals(folderName)) continue;
                    throw new SamFSException(SamUtil.getResourceString("browser.create.error.folderExists"));
                }
            }
            NonSyncStringBuffer fullPath = new NonSyncStringBuffer().append(path);
            if (!path.endsWith("/")) {
                fullPath.append("/");
            }
            fullPath.append(folderName);
            fsMgr.createDirectory(fullPath.toString());
            model.clearCachedDir();
        }
        catch (SamFSException e) {
            SamUtil.processException((Exception)((Object)e), ((Object)((Object)this)).getClass(), "handleCreateFolderButtonRequest", "Unable to create new folder in folder chooser.", this.getModel().getServerName());
            if (folderName == null) {
                folderName = "";
            }
            this.displayAlert(SamUtil.getResourceString("browser.create.error", new String[]{folderName}), e.getMessage(), null, null);
        }
        this.getParentViewBean().forwardTo(this.getRequestContext());
    }

    public void handleMoveUpRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("I'm here");
        String flag = (String)this.getDisplayFieldValue("enterFlag");
        if (flag.equals("enterPressed")) {
            this.handleLookInEnteredRequest(event);
        } else {
            String dir;
            this.setSortField();
            RemoteFileChooserModel model = (RemoteFileChooserModel)this.getModel();
            String newDir = dir = (String)this.getDisplayFieldValue("lookIn");
            int firstIndex = dir.indexOf(File.separator);
            int lastIndex = dir.lastIndexOf(File.separator);
            if (firstIndex == lastIndex) {
                if (dir.length() > firstIndex + 1) {
                    newDir = dir.substring(0, firstIndex + 1);
                } else {
                    this.displayAlert("filechooser.errMoveUpErrSum", "filechooser.errMoveUpErrDet", null, null);
                }
            } else {
                if (dir.endsWith(File.separator)) {
                    newDir = dir.substring(0, lastIndex);
                }
                newDir = (lastIndex = newDir.lastIndexOf(File.separator)) == 0 ? File.separator : newDir.substring(0, lastIndex);
            }
            String rootDir = model.getHomeDirectory();
            if (!newDir.startsWith(rootDir)) {
                this.displayAlert(SamUtil.getResourceString("filechooser.error.permission.summary"), SamUtil.getResourceString("filechooser.error.permission.detail", new String[]{newDir}), null, null);
                newDir = dir;
            }
            this.setDisplayFieldValue("lookIn", newDir);
            this.setDisplayFieldValue("fileName", null);
            model.setCurrentDirectory(newDir);
            ((CCSelectableList)this.getChild("files")).setValue(null);
            ViewBean targetView = this.getParentViewBean();
            targetView.forwardTo(this.getRequestContext());
        }
    }

    public void handleLookInEnteredRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("I'm here");
        this.setSortField();
        String currentDirectory = null;
        String lookInDir = ((String)this.getDisplayFieldValue("lookIn")).trim();
        if (lookInDir == null || lookInDir.length() == 0) {
            currentDirectory = this.model.getHomeDirectory();
        } else {
            currentDirectory = this.stripExtraSeparators(lookInDir);
            String rootDir = this.model.getHomeDirectory();
            try {
                boolean flag = true;
                if (!currentDirectory.startsWith(rootDir)) {
                    this.displayAlert(SamUtil.getResourceString("filechooser.error.lookin.summary"), SamUtil.getResourceString("filechooser.error.lookin.detail", new String[]{currentDirectory}), null, null);
                    currentDirectory = this.model.getCurrentDirectory();
                } else if (!this.model.canRead(currentDirectory)) {
                    this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannot_read", null, null);
                    currentDirectory = this.model.getCurrentDirectory();
                } else {
                    File[] list = this.model.getFiles(currentDirectory);
                    if (list == null) {
                        this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.nameNotFolderErrDet", null, new String[]{lookInDir});
                        currentDirectory = this.model.getCurrentDirectory();
                    }
                }
            }
            catch (Exception e) {
                this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.nameNotFolderErrDet", null, new String[]{lookInDir});
                currentDirectory = this.model.getCurrentDirectory();
            }
        }
        this.model.setCurrentDirectory(currentDirectory);
        this.setDisplayFieldValue("lookIn", currentDirectory);
        this.setDisplayFieldValue("enterFlag", null);
        ViewBean targetView = this.getParentViewBean();
        targetView.forwardTo(this.getRequestContext());
    }

    protected String stripExtraSeparators(String inStr) {
        if (inStr == null) {
            return null;
        }
        NonSyncStringBuffer outStr = new NonSyncStringBuffer();
        boolean repeat = false;
        int nChars = inStr.length();
        for (int i = 0; i < nChars; ++i) {
            if (inStr.charAt(i) == File.separatorChar) {
                if (repeat) continue;
                outStr.append(inStr.charAt(i));
                repeat = true;
                continue;
            }
            repeat = false;
            outStr.append(inStr.charAt(i));
        }
        return outStr.toString();
    }

    public String[] getSelectedResources() {
        RemoteFileChooserModel model = (RemoteFileChooserModel)this.getModel();
        String selectedResource = ((String)this.getDisplayFieldValue("fileName")).trim();
        String currentDirectory = ((String)this.getDisplayFieldValue("lookIn")).trim();
        if (currentDirectory == null || currentDirectory.length() == 0) {
            currentDirectory = model.getCurrentDirectory();
        }
        if (selectedResource != null && selectedResource.length() > 0) {
            currentDirectory = this.checkSelectedResource(selectedResource, currentDirectory, model);
            return model.getSelectedFiles();
        }
        CCSelectableList fileList = (CCSelectableList)this.getChild("files");
        Object[] selectedValue = fileList.getValues();
        model.clearFiles();
        if (selectedValue == null || selectedValue.length == 0) {
            return null;
        }
        File[] files = null;
        try {
            files = model.getFiles(currentDirectory);
        }
        catch (Exception e) {
            return null;
        }
        if (model.getType().equals(RemoteFileChooserModel.FILE_AND_FOLDER_CHOOSER)) {
            for (int i = 0; i < selectedValue.length; ++i) {
                String strIndex = (String)selectedValue[i];
                int index = new Integer(strIndex);
                this.addSelectedFile(currentDirectory, (CCFileChooserModelInterface)model, files[index]);
            }
        } else if (model.getType().equals("file")) {
            try {
                for (int i = 0; i < selectedValue.length; ++i) {
                    String strIndex = (String)selectedValue[i];
                    int index = new Integer(strIndex);
                    if (model.isDirectory(files[index].getAbsolutePath())) {
                        this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannotSelectFolder", null, null);
                        model.clearFiles();
                    }
                    this.addSelectedFile(currentDirectory, (CCFileChooserModelInterface)model, files[index]);
                }
            }
            catch (SamFSException e) {
                TraceUtil.trace1("Failed in checking if path is a directory", e);
            }
        } else {
            try {
                for (int i = 0; i < selectedValue.length; ++i) {
                    String strIndex = (String)selectedValue[i];
                    int index = new Integer(strIndex);
                    if (model.isFile(files[index].getAbsolutePath())) {
                        this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannotSelectFile", null, null);
                        model.clearFiles();
                    }
                    this.addSelectedFile(currentDirectory, (CCFileChooserModelInterface)model, files[index]);
                }
            }
            catch (SamFSException e) {
                TraceUtil.trace1("Failed in checking if path is a file", e);
            }
        }
        return model.getSelectedFiles();
    }

    protected String checkSelectedResource(String selectedResource, String currentDirectory, RemoteFileChooserModel model) {
        int chooserType = model.getType().equals("file") ? 0 : (model.getType().equals("folder") ? 1 : 2);
        model.clearFiles();
        ArrayList<String> tokens = new ArrayList<String>();
        int entryStartIdx = 0;
        int startIdx = 0;
        int foundIdx = 0;
        for (int i = 0; i < selectedResource.length(); ++i) {
            foundIdx = selectedResource.indexOf(58, startIdx);
            if (foundIdx == -1) {
                tokens.add(selectedResource.substring(entryStartIdx));
                break;
            }
            if (foundIdx > 0 && selectedResource.charAt(foundIdx - 1) == '\\') {
                startIdx = foundIdx + 1;
                continue;
            }
            tokens.add(selectedResource.substring(entryStartIdx, foundIdx));
            entryStartIdx = startIdx = foundIdx + 1;
        }
        String absolutePath = null;
        try {
            for (int i = 0; i < tokens.size(); ++i) {
                String token = (String)tokens.get(i);
                absolutePath = this.getAbsolutePath((token = token.replaceAll("\\\\:", ":")).trim(), currentDirectory);
                if (!model.canRead(absolutePath)) {
                    this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannot_read", null, null);
                    currentDirectory = model.getCurrentDirectory();
                    model.clearFiles();
                } else if (chooserType == 0) {
                    if (model.isFile(absolutePath)) {
                        model.addSelectedFile(absolutePath);
                        continue;
                    }
                    if (model.isDirectory(absolutePath)) {
                        this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannotSelectFolder", null, null);
                        model.clearFiles();
                    } else {
                        this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.fileSelectError", null, null);
                        model.clearFiles();
                    }
                } else if (chooserType == 1) {
                    if (model.isDirectory(absolutePath)) {
                        model.addSelectedFile(absolutePath);
                        continue;
                    }
                    if (model.isFile(absolutePath)) {
                        this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannotSelectFile", null, null);
                        model.clearFiles();
                    } else {
                        this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.folderSelectError", null, null);
                        model.clearFiles();
                    }
                } else {
                    if (chooserType != 2) continue;
                    if (model.isFile(absolutePath)) {
                        model.addSelectedFile(absolutePath);
                        continue;
                    }
                    if (model.isDirectory(absolutePath)) {
                        model.addSelectedFile(absolutePath);
                        continue;
                    }
                    this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.fileSelectError", null, null);
                    model.clearFiles();
                }
                break;
            }
        }
        catch (Exception e) {
            String key = null;
            key = chooserType == 0 ? "filechooser.fileSelectError" : "filechooser.folderSelectError";
            model.clearFiles();
            this.displayAlert("filechooser.cannotCompleteErrSum", key, null, null);
            currentDirectory = model.getCurrentDirectory();
        }
        return currentDirectory;
    }

    protected String getAbsolutePath(String name, String currentDirectory) {
        boolean absolute = false;
        if (this.getOSName().startsWith("window")) {
            if (name.startsWith("\\\\") || name.indexOf(":\\") != -1) {
                absolute = true;
            }
        } else if (name.startsWith(File.separator)) {
            absolute = true;
        }
        if (absolute) {
            return name;
        }
        return currentDirectory.concat(File.separator).concat(name);
    }

    protected String getOSName() {
        return System.getProperty("os.name").toUpperCase();
    }

    protected void addSelectedFile(String currentDirectory, CCFileChooserModelInterface model, File file) {
        NonSyncStringBuffer fileName = new NonSyncStringBuffer();
        fileName.append(currentDirectory);
        if (!currentDirectory.endsWith(File.separator)) {
            fileName.append(File.separator);
        }
        fileName.append(file.getName());
        model.addSelectedFile(fileName.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

