/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.test.fs;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.test.BaseTest;

public class DeleteFSTest {
    public static FileSystem getFileSystem(SamQFSSystemModel model, String fsName) throws SamFSException {
        return model.getSamQFSSystemFSManager().getFileSystem(fsName);
    }

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.out.println("please specify fs name");
                System.exit(-1);
            }
            SamQFSSystemModel[] models = BaseTest.getAllSamQFSSystemModels();
            String fsName = args[0];
            if (models != null && models.length > 0) {
                for (int i = 0; i < models.length; ++i) {
                    System.out.println("Getting info about filesystem " + fsName + " from host " + models[i].getHostname());
                    FileSystem fs2 = DeleteFSTest.getFileSystem(models[i], fsName);
                    if (fs2 == null) continue;
                    System.out.println("Deleting file system...");
                    models[i].getSamQFSSystemFSManager().deleteFileSystem(fs2);
                    System.out.println("Done...");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

