/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.test.archive43;

import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopyGUIWrapper;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveVSNMap;
import com.sun.netstorage.samqfs.web.model.impl.test.BaseTest;

public class PolCopyTest {
    public static void main(String[] args) {
        try {
            SamQFSSystemModel[] models = BaseTest.getAllSamQFSSystemModels();
            if (models != null && models.length > 0) {
                for (int i = 0; i < models.length; ++i) {
                    ArchivePolicy[] pols = models[i].getSamQFSSystemArchiveManager43().getAllArchivePolicies();
                    if (pols == null || pols.length <= 0) continue;
                    ArchivePolicy pol = pols[0];
                    String policyName = pol.getPolicyName();
                    System.out.println("Policy before adding a copy.");
                    System.out.println(pol);
                    System.out.println("--------\n");
                    ArchiveCopyGUIWrapper wrapper = models[i].getSamQFSSystemArchiveManager43().getArchiveCopyGUIWrapper();
                    ArchiveCopy copy = wrapper.getArchiveCopy();
                    copy.setFillVSNs(true);
                    ArchivePolCriteriaCopy critCp = wrapper.getArchivePolCriteriaCopy();
                    critCp.setArchiveAge(10L);
                    critCp.setArchiveAgeUnit(7);
                    ArchiveVSNMap map = copy.getArchiveVSNMap();
                    map.setArchiveMediaType(108);
                    map.setPoolExpression("pool1");
                    System.out.println("PolCriteriaCopy to be added");
                    System.out.println(critCp);
                    System.out.println("ArchiveCopy to be added");
                    System.out.println(copy);
                    System.out.println("--------\n");
                    pol.addArchiveCopy(wrapper);
                    System.out.println("Done adding copy.");
                    System.out.println("Check archiver.cmd.");
                    System.out.println("Then hit Enter.");
                    System.in.read();
                    System.out.println("Policy after adding a copy.");
                    System.out.println(pol);
                    System.out.println("--------\n");
                    pols = models[i].getSamQFSSystemArchiveManager43().getAllArchivePolicies();
                    pol = models[i].getSamQFSSystemArchiveManager43().getArchivePolicy(policyName);
                    System.out.println("Policy after re-reading.");
                    System.out.println(pol);
                    System.out.println("--------\n");
                    copy = pol.getArchiveCopy(2);
                    System.out.println("Copy to be deleted.");
                    System.out.println(copy);
                    System.out.println("--------\n");
                    pol.deleteArchiveCopy(2);
                    System.out.println("Done deleting copy.");
                    System.out.println("Check archiver.cmd.");
                    System.out.println("Then hit Enter.");
                    System.in.read();
                    System.out.println("Policy after deleting copy.");
                    System.out.println(pol);
                    System.out.println("--------\n");
                    pols = models[i].getSamQFSSystemArchiveManager43().getAllArchivePolicies();
                    pol = models[i].getSamQFSSystemArchiveManager43().getArchivePolicy(policyName);
                    System.out.println("Policy after re-reading.");
                    System.out.println(pol);
                    System.out.println("--------\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

