/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.test.archive;

import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveFileParams;
import com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveVSNMap;
import com.sun.netstorage.samqfs.web.model.archive.VSNPool;
import com.sun.netstorage.samqfs.web.model.impl.test.BaseTest;

public class GetPolTest {
    public static void main(String[] args) {
        try {
            SamQFSSystemModel[] models = BaseTest.getAllSamQFSSystemModels();
            if (models != null && models.length > 0) {
                for (int i = 0; i < models.length; ++i) {
                    ArchivePolicy[] pols = models[i].getSamQFSSystemArchiveManager().getAllArchivePolicies();
                    for (int j = 0; j < pols.length; ++j) {
                        System.out.println(pols[j]);
                        System.out.println("==============================");
                    }
                    ArchivePolicy pol = models[i].getSamQFSSystemArchiveManager().getArchivePolicy("policy1");
                    System.out.println("Getting policy by name:");
                    System.out.println(pol);
                    System.out.println("--------");
                    ArchiveFileParams p = pol.getFileCharacteristics();
                    p.setMinSize(0x100000L);
                    p.setMinSizeUnit(0);
                    p.setMaxSize(0x700000L);
                    p.setMaxSizeUnit(0);
                    ArchiveCopy copy = pol.getArchiveCopy(1);
                    copy.setRecycleDataSize(0xB00000L);
                    copy.setRecycleDataSizeUnit(0);
                    copy.setRecycleHWM(77);
                    copy.setIgnoreRecycle(true);
                    copy.setNotificationAddress("root");
                    copy.setMinGain(33);
                    copy.setMaxVSNCount(1);
                    copy.setArchiveAge(11L);
                    copy.setArchiveAgeUnit(6);
                    copy.setUnarchiveAge(300L);
                    copy.setUnarchiveAgeUnit(6);
                    copy.setStartAge(301L);
                    copy.setStartAgeUnit(6);
                    copy.setBufferSize(12);
                    copy.setOverflowMinSize(1024L);
                    copy.setOverflowMinSizeUnit(0);
                    copy.setJoinMethod(2);
                    copy.setMinDrives(1000L);
                    copy.setMinDrivesUnit(1);
                    copy.setMaxDrives(100L);
                    copy.setMaxDrivesUnit(2);
                    copy.setArchiveMaxSize(0x6400000L);
                    copy.setArchiveMaxSizeUnit(0);
                    copy.setStartSize(0x700000L);
                    copy.setStartSizeUnit(0);
                    ArchiveVSNMap map = copy.getArchiveVSNMap();
                    map.setMapExpression("BL7947");
                    VSNPool[] pools = models[i].getSamQFSSystemArchiveManager().getAllVSNPools();
                    VSNPool[] tmpPool = new VSNPool[]{pools[0]};
                    map.setVSNPools(tmpPool);
                    pol.changeArchiveCopies();
                    System.out.println("Press Enter after checking cmd.");
                    System.in.read();
                    models[i].getSamQFSSystemArchiveManager().getAllArchivePolicies();
                    System.out.println(models[i].getSamQFSSystemArchiveManager().getArchivePolicy("policy1"));
                    System.out.println("--------");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

