/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.media;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemJobManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.BaseJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.LabelJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.LibraryImpl;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import java.util.GregorianCalendar;

public class VSNImpl
implements VSN {
    private Library library = null;
    private Drive drive = null;
    private String vsn = null;
    private int slotNo = -1;
    private String barcode = null;
    private long capacity = -1L;
    private long availableSpace = -1L;
    private long blockSize = -1L;
    private long accessCount = -1L;
    private GregorianCalendar labelTime = null;
    private GregorianCalendar mountTime = null;
    private GregorianCalendar modificationTime = null;
    private boolean reserved = false;
    private GregorianCalendar reservationTime = null;
    private String reservedBy = null;
    private String reservationPolicy = new String();
    private String reservationFS = new String();
    private int reservationType = -1;
    private String reservationNameForType = new String();
    private boolean mediaDamaged = false;
    private boolean duplicateVSN = false;
    private boolean readOnly = false;
    private boolean writeProtected = false;
    private boolean foreignMedia = false;
    private boolean recycled = false;
    private boolean volumeFull = false;
    private boolean unavailable = false;
    private boolean needAudit = false;
    private static int immediateIndicator = 0;

    public VSNImpl() {
    }

    public VSNImpl(Library library, Drive drive, String vsn, int slotNo, String barcode, long capacity, long availableSpace, long blockSize, long accessCount) {
        this.library = library;
        this.drive = drive;
        this.vsn = vsn;
        this.slotNo = slotNo;
        this.barcode = barcode;
        this.capacity = capacity;
        this.availableSpace = availableSpace;
        this.blockSize = blockSize;
        this.accessCount = accessCount;
    }

    public VSNImpl(Library library, Drive drive, String vsn, int slotNo, String barcode, long capacity, long availableSpace, int blockSize, int accessCount, GregorianCalendar labelTime, GregorianCalendar mountTime, GregorianCalendar modificationTime, boolean reserved, GregorianCalendar reservationTime, String reservedBy, boolean mediaDamaged, boolean duplicateVSN, boolean readOnly, boolean writeProtected, boolean foreignMedia, boolean recycled, boolean volumeFull, boolean unavailable, boolean needAudit) {
        this.library = library;
        this.drive = drive;
        this.vsn = vsn;
        this.slotNo = slotNo;
        this.barcode = barcode;
        this.capacity = capacity;
        this.availableSpace = availableSpace;
        this.blockSize = blockSize;
        this.accessCount = accessCount;
        this.labelTime = labelTime;
        this.mountTime = mountTime;
        this.modificationTime = modificationTime;
        this.reserved = reserved;
        this.reservationTime = reservationTime;
        if (reservedBy != null && !reservedBy.equals(new String())) {
            this.reservationType = 2;
            this.reservationNameForType = reservedBy;
        }
        this.mediaDamaged = mediaDamaged;
        this.duplicateVSN = duplicateVSN;
        this.readOnly = readOnly;
        this.writeProtected = writeProtected;
        this.foreignMedia = foreignMedia;
        this.recycled = recycled;
        this.volumeFull = volumeFull;
        this.unavailable = unavailable;
        this.needAudit = needAudit;
    }

    public Library getLibrary() throws SamFSException {
        return this.library;
    }

    public void setLibrary(Library library) throws SamFSException {
        this.library = library;
    }

    public Drive getDrive() throws SamFSException {
        return this.drive;
    }

    public void setDrive(Drive drive) throws SamFSException {
        this.drive = drive;
    }

    public String getVSN() throws SamFSException {
        return this.vsn;
    }

    public int getSlotNumber() throws SamFSException {
        return this.slotNo;
    }

    public void setSlotNumber(int slotNo) throws SamFSException {
        this.slotNo = slotNo;
    }

    public String getBarcode() throws SamFSException {
        return this.barcode;
    }

    public long getCapacity() throws SamFSException {
        return this.capacity;
    }

    public long getAvailableSpace() throws SamFSException {
        return this.availableSpace;
    }

    public void setAvailableSpace(long availableSpace) throws SamFSException {
        availableSpace = this.availableSpace;
    }

    public long getBlockSize() throws SamFSException {
        return this.blockSize;
    }

    public long getAccessCount() throws SamFSException {
        return this.accessCount;
    }

    public void setAccessCount(long accessCount) throws SamFSException {
        this.accessCount = accessCount;
    }

    public GregorianCalendar getLabelTime() throws SamFSException {
        return this.labelTime;
    }

    public void setLabelTime(GregorianCalendar labelTime) throws SamFSException {
        this.labelTime = labelTime;
    }

    public GregorianCalendar getMountTime() throws SamFSException {
        return this.mountTime;
    }

    public void setMountTime(GregorianCalendar MountTime) throws SamFSException {
        this.mountTime = this.mountTime;
    }

    public GregorianCalendar getModificationTime() throws SamFSException {
        return this.modificationTime;
    }

    public void setModificationTime(GregorianCalendar modificationTime) throws SamFSException {
        this.modificationTime = modificationTime;
    }

    public boolean isReserved() throws SamFSException {
        return this.reserved;
    }

    public GregorianCalendar getReservationTime() throws SamFSException {
        return this.reservationTime;
    }

    public String getReservedByPolicyName() throws SamFSException {
        return this.reservationPolicy;
    }

    public String getReservedByFileSystemName() throws SamFSException {
        return this.reservationFS;
    }

    public int getReservationByType() throws SamFSException {
        return this.reservationType;
    }

    public String getReservationNameForType() throws SamFSException {
        return this.reservationNameForType;
    }

    public String getReservedBy() throws SamFSException {
        return this.reservedBy;
    }

    public boolean isMediaDamaged() throws SamFSException {
        return this.mediaDamaged;
    }

    public void setMediaDamaged(boolean mediaDamaged) throws SamFSException {
        this.mediaDamaged = mediaDamaged;
    }

    public boolean isDuplicateVSN() throws SamFSException {
        return this.duplicateVSN;
    }

    public void setDuplicateVSN(boolean duplicateVSN) throws SamFSException {
        this.duplicateVSN = duplicateVSN;
    }

    public boolean isReadOnly() throws SamFSException {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) throws SamFSException {
        this.readOnly = readOnly;
    }

    public boolean isWriteProtected() throws SamFSException {
        return this.writeProtected;
    }

    public void setWriteProtected(boolean writeProtected) throws SamFSException {
        this.writeProtected = writeProtected;
    }

    public boolean isForeignMedia() throws SamFSException {
        return this.foreignMedia;
    }

    public void setForeignMedia(boolean foreignMedia) throws SamFSException {
        this.foreignMedia = foreignMedia;
    }

    public boolean isRecycled() throws SamFSException {
        return this.recycled;
    }

    public void setRecycled(boolean recycled) throws SamFSException {
        this.recycled = recycled;
    }

    public boolean isVolumeFull() throws SamFSException {
        return this.volumeFull;
    }

    public void setVolumeFull(boolean volumeFull) throws SamFSException {
        this.volumeFull = volumeFull;
    }

    public boolean isUnavailable() throws SamFSException {
        return this.unavailable;
    }

    public void setUnavailable(boolean unavailable) throws SamFSException {
        this.unavailable = unavailable;
    }

    public boolean isNeedAudit() throws SamFSException {
        return this.needAudit;
    }

    public void setNeedAudit(boolean needAudit) throws SamFSException {
        this.needAudit = needAudit;
    }

    public void changeAttributes() throws SamFSException {
    }

    public void audit() throws SamFSException {
    }

    public void load() throws SamFSException {
    }

    public void export() throws SamFSException {
    }

    public long label(int type, String labelName, long blockSize) throws SamFSException {
        LibraryImpl lib = (LibraryImpl)this.getLibrary();
        if (lib != null) {
            lib.changeVSN(this, labelName);
        }
        this.vsn = labelName;
        this.blockSize = blockSize;
        this.labelTime = new GregorianCalendar();
        long jobId = -1L;
        if (++immediateIndicator % 3 != 0) {
            BaseJobImpl job = new BaseJobImpl((int)(Math.random() * 100000.0), 0, 9, new String(), new GregorianCalendar(), new GregorianCalendar());
            LabelJobImpl jobL = new LabelJobImpl(job, this.vsn, lib.getDrives()[0].getDevicePath(), lib.getName(), -1);
            SamQFSSystemModel[] models = SamQFSFactory.getSamQFSAppModel().getAllSamQFSSystemModels();
            if (models != null) {
                for (int i = 0; i < models.length; ++i) {
                    ((SamQFSSystemJobManagerImpl)models[i].getSamQFSSystemJobManager()).addJob(jobL);
                }
            }
            jobId = job.getJobId();
        } else {
            immediateIndicator = 0;
        }
        return jobId;
    }

    public void clean() throws SamFSException {
    }

    public void reserve(String policyName, String filesystemName, int type, String name) throws SamFSException {
        this.reserved = false;
        this.reservationTime = null;
        this.reservationPolicy = new String();
        this.reservationFS = new String();
        this.reservationType = -1;
        this.reservationNameForType = new String();
        if (SamQFSUtil.isValidString(policyName)) {
            this.reservationPolicy = policyName;
            this.reserved = true;
        }
        if (SamQFSUtil.isValidString(filesystemName)) {
            this.reservationFS = filesystemName;
            this.reserved = true;
        }
        if (type == 2 || type == 3 || type == 4) {
            this.reservationType = type;
            this.reservationNameForType = name;
            this.reserved = true;
        }
        if (this.reserved) {
            this.reservationTime = new GregorianCalendar();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.library != null) {
            try {
                buf.append("Library: " + this.library.getName() + "\n\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.drive != null) {
            try {
                buf.append("Drive: " + this.drive.toString() + "\n\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        buf.append("VSN: " + this.vsn + "\n");
        buf.append("Barcode: " + this.barcode + "\n");
        buf.append("Capacity: " + this.capacity + "\n");
        buf.append("Available Space: " + this.availableSpace + "\n");
        buf.append("Block Size: " + this.blockSize + "\n");
        buf.append("Label Time: " + SamQFSUtil.dateTime(this.labelTime) + "\n");
        buf.append("Mount Time: " + SamQFSUtil.dateTime(this.mountTime) + "\n");
        buf.append("Modification Time: " + SamQFSUtil.dateTime(this.modificationTime) + "\n");
        buf.append("Reserved: " + this.reserved + "\n");
        buf.append("Reservation Time: " + SamQFSUtil.dateTime(this.reservationTime) + "\n");
        buf.append("ReservedBy: " + this.reservedBy + "\n");
        buf.append("Media Damaged: " + this.mediaDamaged + "\n");
        buf.append("Duplicate VSN: " + this.duplicateVSN + "\n");
        buf.append("Read Only: " + this.readOnly + "\n");
        buf.append("Write Protected: " + this.writeProtected + "\n");
        buf.append("Foreign Media: " + this.foreignMedia + "\n");
        buf.append("Recycled: " + this.recycled + "\n");
        buf.append("Volume Full: " + this.volumeFull + "\n");
        buf.append("Unavailable: " + this.unavailable + "\n");
        buf.append("Need Audit: " + this.needAudit + "\n");
        return buf.toString();
    }

    public void setVSN(String vsn) {
        this.vsn = vsn;
    }
}

