/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.media;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.media.StkNetLibParam;
import com.sun.netstorage.samqfs.mgmt.media.StkPhyConf;
import com.sun.netstorage.samqfs.mgmt.media.StkPool;
import com.sun.netstorage.samqfs.mgmt.media.StkVSN;
import com.sun.netstorage.samqfs.web.media.ImportVSNFilterHelper;
import com.sun.netstorage.samqfs.web.model.ImportVSNFilter;
import com.sun.netstorage.samqfs.web.model.alarm.Alarm;
import com.sun.netstorage.samqfs.web.model.archive43.BufferDirective;
import com.sun.netstorage.samqfs.web.model.archive43.DriveDirective;
import com.sun.netstorage.samqfs.web.model.archive43.RecycleParams;
import com.sun.netstorage.samqfs.web.model.impl.simulator.alarm.AlarmImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.BufferDirectiveImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.DriveDirectiveImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.RecycleParamsImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.BaseDeviceImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.DriveImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.VSNImpl;
import com.sun.netstorage.samqfs.web.model.job.MountJob;
import com.sun.netstorage.samqfs.web.model.media.BaseDevice;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class LibraryImpl
extends BaseDeviceImpl
implements Library {
    private String name = null;
    private ArrayList drives = null;
    private HashMap vsns = null;
    private String vendor = null;
    private String productID = null;
    private String serialNo = null;
    private int status = -1;
    private int noOfLicensedSlots = -1;
    private int noOfAvailableSlots = -1;
    private int noOfCatalogEntries = -1;
    private int driverType = -1;
    private String catalogLocation = null;
    private String paramFileLocation = null;
    private String firmware = null;
    private ArrayList associatedAlarms = null;
    private ArrayList jobs = null;
    private RecycleParamsImpl recycleParams = null;
    private DriveDirectiveImpl driveDirective = null;
    private BufferDirectiveImpl bufferDirective = null;
    private StkNetLibParam stkNetLibParam = null;
    private int driveStartEQ = -1;
    private int driveIncreEQ = -1;
    private static ImportVSNFilterHelper filterHelper = null;
    private static StkVSN[] stkVSNs = null;
    private static String importedVSN = "";

    public LibraryImpl() {
    }

    public LibraryImpl(String name, ArrayList drives, ArrayList vsn, BaseDevice baseDevice, String vendor, String productID, String serialNo, int status, int noOfLicensedSlots, int noOfAvailableSlots, int noOfCatalogEntries, String catalogLocation, ArrayList associatedAlarms, ArrayList associatedJobs, RecycleParamsImpl recycleParams, DriveDirectiveImpl driveDirective, BufferDirectiveImpl bufferDirective) throws SamFSException {
        super(baseDevice.getDevicePath(), baseDevice.getEquipOrdinal(), baseDevice.getEquipType(), baseDevice.getFamilySetName(), baseDevice.getFamilySetEquipOrdinal(), baseDevice.getState(), baseDevice.getAdditionalParamFilePath());
        int i;
        if (name == null || name == new String() || drives == null) {
            throw new SamFSException("INVALID_LIBRARY");
        }
        this.name = name;
        this.drives = drives;
        if (vsn != null) {
            this.vsns = new HashMap();
            for (i = 0; i < vsn.size(); ++i) {
                String vsnName = ((VSN)vsn.get(i)).getVSN();
                this.vsns.put(vsnName, vsn.get(i));
            }
        }
        if (filterHelper == null) {
            filterHelper = new ImportVSNFilterHelper(new int[]{0, 1, 2}, new int[]{0, 1, 2, 3, 4}, new int[]{0, 1, 2, 3, 4, 5}, 20, 0, 15, 0);
            this.createStkVSNs();
        }
        this.vendor = vendor;
        this.productID = productID;
        this.serialNo = serialNo;
        this.status = status;
        this.noOfLicensedSlots = noOfLicensedSlots;
        this.noOfAvailableSlots = noOfAvailableSlots;
        this.noOfCatalogEntries = noOfCatalogEntries;
        this.driverType = 1001;
        this.catalogLocation = catalogLocation;
        this.associatedAlarms = associatedAlarms;
        this.jobs = associatedJobs;
        this.recycleParams = recycleParams;
        this.driveDirective = driveDirective;
        this.bufferDirective = bufferDirective;
        this.firmware = Integer.toString((int)(Math.random() * 10.0)) + "." + Integer.toString((int)(Math.random() * 10.0));
        for (i = 0; i < drives.size(); ++i) {
            ((DriveImpl)drives.get(i)).setLibrary(this);
        }
        if (this.vsns != null) {
            VSNImpl[] vsnList = this.vsns.values().toArray(new VSNImpl[0]);
            for (int i2 = 0; i2 < vsnList.length; ++i2) {
                vsnList[i2].setLibrary(this);
            }
        }
        if (associatedAlarms != null) {
            for (int i3 = 0; i3 < associatedAlarms.size(); ++i3) {
                ((AlarmImpl)associatedAlarms.get(i3)).setLibrary(this);
            }
        }
        if (recycleParams == null) {
            recycleParams = new RecycleParamsImpl();
        }
        recycleParams.setLibrary(this);
        if (driveDirective == null) {
            driveDirective = new DriveDirectiveImpl();
        }
        driveDirective.setLibrary(this);
    }

    public String getName() throws SamFSException {
        return this.name;
    }

    public void setName(String name) throws SamFSException {
        if (name != null && name != new String()) {
            this.name = name;
        }
    }

    public Drive[] getDrives() throws SamFSException {
        return this.drives.toArray(new Drive[0]);
    }

    public void setDrives(Drive[] newDrives) throws SamFSException {
        this.drives.clear();
        if (newDrives != null && newDrives.length > 0) {
            for (int i = 0; i < newDrives.length; ++i) {
                this.drives.add(newDrives[i]);
            }
        }
    }

    public int getTotalVSNInLibrary() throws SamFSException {
        return this.vsns.size();
    }

    public VSN[] getVSNs() throws SamFSException {
        VSN[] vsnList = null;
        if (this.vsns != null) {
            vsnList = this.vsns.values().toArray(new VSN[0]);
        }
        return vsnList;
    }

    public VSN[] getVSNs(int start, int size, int sortby, boolean ascending) throws SamFSException {
        int pageNumber = 1;
        if (size != 0) {
            pageNumber = start / size + 1;
        }
        return this.getVSNs(sortby, ascending, pageNumber);
    }

    private VSN[] getVSNs(int sortBy, boolean ascending, int pageNumber) throws SamFSException {
        int i;
        ArrayList<VSN> sortedList = new ArrayList<VSN>();
        VSN[] vsnList = this.getVSNs();
        if (vsnList != null) {
            for (i = 0; i < vsnList.length; ++i) {
                int position = 0;
                for (int j = 0; j < sortedList.size(); ++j) {
                    VSN currentVSN = (VSN)sortedList.get(j);
                    if (ascending) {
                        if (sortBy == 7) {
                            if (currentVSN.getSlotNumber() > vsnList[i].getSlotNumber()) break;
                            ++position;
                            continue;
                        }
                        if (sortBy == 8) {
                            if (currentVSN.getVSN().compareTo(vsnList[i].getVSN()) > 0) break;
                            ++position;
                            continue;
                        }
                        if (sortBy != 9) continue;
                        if (currentVSN.getAvailableSpace() > vsnList[i].getAvailableSpace()) break;
                        ++position;
                        continue;
                    }
                    if (sortBy == 7) {
                        if (currentVSN.getSlotNumber() < vsnList[i].getSlotNumber()) break;
                        ++position;
                        continue;
                    }
                    if (sortBy == 8) {
                        if (currentVSN.getVSN().compareTo(vsnList[i].getVSN()) < 0) break;
                        ++position;
                        continue;
                    }
                    if (sortBy != 9) continue;
                    if (currentVSN.getAvailableSpace() < vsnList[i].getAvailableSpace()) break;
                    ++position;
                }
                sortedList.add(position, vsnList[i]);
            }
        }
        System.out.println(sortBy);
        System.out.println(ascending);
        for (i = 0; i < sortedList.size(); ++i) {
            System.out.println("i = " + (i + 1));
            System.out.println(((VSN)sortedList.get(i)).getVSN());
            System.out.println(((VSN)sortedList.get(i)).getSlotNumber());
            System.out.println(((VSN)sortedList.get(i)).getAvailableSpace());
        }
        System.out.println("-------\n");
        VSN[] tempVSNList = new VSN[]{};
        int startNo = (pageNumber - 1) * 25;
        if (startNo < sortedList.size()) {
            int count = 25;
            if (startNo + 25 > sortedList.size()) {
                count = sortedList.size() - startNo;
            }
            tempVSNList = new VSN[count];
            for (int i2 = 0; i2 < count; ++i2) {
                tempVSNList[i2] = (VSN)sortedList.get(startNo + i2);
            }
        }
        return tempVSNList;
    }

    public VSN getVSN(String name) throws SamFSException {
        VSN vsn = null;
        if (this.vsns != null) {
            vsn = (VSN)this.vsns.get(name);
        }
        return vsn;
    }

    public VSN getVSN(int slotNo) throws SamFSException {
        VSN[] vsnList = this.getVSNs();
        VSN vsn = null;
        if (vsnList != null) {
            for (int i = 0; i < vsnList.length; ++i) {
                if (vsnList[i].getSlotNumber() != slotNo) continue;
                vsn = vsnList[i];
                break;
            }
        }
        return vsn;
    }

    public void changeVSN(VSN vsn, String newVSN) throws SamFSException {
        if (this.vsns != null) {
            this.vsns.remove(vsn.getVSN());
            ((VSNImpl)vsn).setVSN(newVSN);
            this.vsns.put(vsn.getVSN(), vsn);
        }
    }

    public void addVSN(VSN vsn) throws SamFSException {
        if (this.vsns == null) {
            this.vsns = new HashMap();
        }
        this.vsns.put(vsn.getVSN(), vsn);
    }

    public void removeVSN(VSN vsn) throws SamFSException {
        VSN temp = null;
        if (this.vsns != null) {
            temp = (VSN)this.vsns.get(vsn.getVSN());
        }
        if (temp == null) {
            throw new SamFSException("NO_SUCH_VSN_FOUND");
        }
        this.vsns.remove(vsn.getVSN());
    }

    public String getVendor() throws SamFSException {
        return this.vendor;
    }

    public String getProductID() throws SamFSException {
        return this.productID;
    }

    public String getSerialNo() throws SamFSException {
        return this.serialNo;
    }

    public int getStatus() throws SamFSException {
        return this.status;
    }

    public void setStatus(int status) throws SamFSException {
        this.status = status;
    }

    public int[] getDetailedStatus() {
        return new int[0];
    }

    public int getNoOfLicensedSlots() throws SamFSException {
        return this.noOfLicensedSlots;
    }

    public int getNoOfAvailableSlots() throws SamFSException {
        return this.noOfAvailableSlots;
    }

    public int getDriverType() throws SamFSException {
        return this.driverType;
    }

    public void setDriverType(int driverType) throws SamFSException {
        this.driverType = driverType;
    }

    public String getFirmwareLevel() throws SamFSException {
        return this.firmware;
    }

    public long getTotalCapacity() throws SamFSException {
        VSN[] vsnList = this.vsns.values().toArray(new VSN[0]);
        long total = 0L;
        if (vsnList != null) {
            for (int i = 0; i < vsnList.length; ++i) {
                total += vsnList[i].getCapacity();
            }
        }
        return total;
    }

    public long getTotalFreeSpace() throws SamFSException {
        VSN[] vsnList = this.vsns.values().toArray(new VSN[0]);
        long total = 0L;
        if (vsnList != null) {
            for (int i = 0; i < vsnList.length; ++i) {
                total += vsnList[i].getAvailableSpace();
            }
        }
        return total;
    }

    public int getMediaType() throws SamFSException {
        return this.bufferDirective.getMediaType();
    }

    public String getCatalogLocation() throws SamFSException {
        return this.catalogLocation;
    }

    public void setCatalogLocation(String catalogLocation) throws SamFSException {
        this.catalogLocation = catalogLocation;
    }

    public String getParamFileLocation() throws SamFSException {
        return this.paramFileLocation;
    }

    public void setParamFileLocation(String location) throws SamFSException {
        this.paramFileLocation = location;
    }

    public Alarm[] getAssociatedAlarms() throws SamFSException {
        Alarm[] alarmList = null;
        if (this.associatedAlarms != null) {
            alarmList = this.associatedAlarms.toArray(new Alarm[0]);
        }
        return alarmList;
    }

    public void addAlarm(Alarm alarm) throws SamFSException {
        if (this.associatedAlarms == null) {
            this.associatedAlarms = new ArrayList();
        }
        this.associatedAlarms.add(alarm);
    }

    public void removeAlarm(Alarm alarm) throws SamFSException {
        int index = this.associatedAlarms.indexOf(alarm);
        if (index == -1) {
            throw new SamFSException("NO_SUCH_ALARM_FOUND");
        }
        this.associatedAlarms.remove(index);
    }

    public RecycleParams getRecycleParams() throws SamFSException {
        return this.recycleParams;
    }

    public void setRecycleParams(RecycleParamsImpl recycleParams) throws SamFSException {
        this.recycleParams = recycleParams;
    }

    public DriveDirective getDriveDirective() throws SamFSException {
        return this.driveDirective;
    }

    public void setDriveDirective(DriveDirectiveImpl driveDirective) throws SamFSException {
        this.driveDirective = driveDirective;
    }

    public BufferDirective getBufferDirective() throws SamFSException {
        return this.bufferDirective;
    }

    public void setBufferDirective(BufferDirectiveImpl bufferDirective) throws SamFSException {
        this.bufferDirective = bufferDirective;
    }

    public void importVSN() throws SamFSException {
    }

    public void importVSNInACSLS(long poolId, int count) throws SamFSException {
    }

    public void importVSNInNWALib(String startVSN, String endVSN) throws SamFSException {
    }

    public void unload() throws SamFSException {
    }

    public void fullAudit() throws SamFSException {
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("Name: " + this.name + "\n");
        buf.append("Base Device: " + super.toString() + "\n");
        buf.append("Vendor: " + this.vendor + "\n");
        buf.append("Product ID: " + this.productID + "\n");
        buf.append("Serial No: " + this.serialNo + "\n");
        buf.append("Status: " + this.status + "\n");
        buf.append("No OfLicensed Slots: " + this.noOfLicensedSlots + "\n");
        buf.append("No Of Available Slots: " + this.noOfAvailableSlots + "\n");
        buf.append("Catalog Location: " + this.catalogLocation + "\n");
        buf.append("\nDrives: \n");
        if (this.drives != null) {
            try {
                for (i = 0; i < this.drives.size(); ++i) {
                    buf.append(((Drive)this.drives.get(i)).toString() + "\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        buf.append("\nVSNs: \n");
        if (this.vsns != null) {
            VSN[] vsnList = this.vsns.values().toArray(new VSN[0]);
            try {
                for (int i2 = 0; i2 < vsnList.length; ++i2) {
                    buf.append(vsnList[i2].toString() + "\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        buf.append("\nAlarms: \n");
        if (this.associatedAlarms != null) {
            try {
                for (i = 0; i < this.associatedAlarms.size(); ++i) {
                    buf.append(((Alarm)this.associatedAlarms.get(i)).toString() + "\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.recycleParams != null) {
            buf.append("\nRecycle Parameters: \n" + this.recycleParams.toString());
        }
        if (this.driveDirective != null) {
            buf.append("\nDrive Directive: \n" + this.driveDirective.toString());
        }
        if (this.bufferDirective != null) {
            buf.append("\nBuffer Directive: \n" + this.bufferDirective.toString());
        }
        return buf.toString();
    }

    public MountJob[] getAssociatedMountRequestJobs() throws SamFSException {
        MountJob[] mountJobs = null;
        if (this.jobs != null) {
            mountJobs = this.jobs.toArray(new MountJob[0]);
        }
        return mountJobs;
    }

    public void addJob(MountJob job) throws SamFSException {
        if (this.jobs == null) {
            this.jobs = new ArrayList();
        }
        this.jobs.add(job);
    }

    public void removeJob(MountJob job) throws SamFSException {
        int index = this.jobs.indexOf(job);
        if (index == -1) {
            throw new SamFSException("NO_SUCH_JOB_FOUND");
        }
        this.jobs.remove(index);
    }

    public long getDefaultBlockSize() throws SamFSException {
        return -1L;
    }

    public String[] getMessages() {
        return new String[0];
    }

    public int getNoOfCatalogEntries() throws SamFSException {
        return this.noOfCatalogEntries;
    }

    public boolean doesLibraryContainMixedMedia() {
        if (this.drives == null || this.drives.size() == 0) {
            return false;
        }
        int mediaType = -1;
        int checkType = -1;
        for (int i = 0; i < this.drives.size(); ++i) {
            if (mediaType == -1) {
                mediaType = ((DriveImpl)this.drives.get(i)).getEquipType();
                continue;
            }
            checkType = ((DriveImpl)this.drives.get(i)).getEquipType();
            if (checkType == mediaType) continue;
            return true;
        }
        return false;
    }

    public StkNetLibParam getStkNetLibParam() throws SamFSException {
        return this.stkNetLibParam;
    }

    public void setStkNetLibParam(StkNetLibParam newParam) throws SamFSException {
        this.stkNetLibParam = newParam;
    }

    public int getDriveStartNumber() {
        return this.driveStartEQ;
    }

    public void setDriveStartNumber(int start) {
        this.driveStartEQ = start;
    }

    public int getDriveIncreNumber() {
        return this.driveIncreEQ;
    }

    public void setDriveIncreNumber(int incre) {
        this.driveIncreEQ = incre;
    }

    public void setDevicePath(String devicePath) {
        super.setDevicePath(devicePath);
    }

    public StkPhyConf getPhyConfForStkLib() throws SamFSException {
        int[] poolID = filterHelper.getPools();
        StkPool[] pools = new StkPool[poolID.length];
        for (int i = 0; i < poolID.length; ++i) {
            pools[i] = new StkPool(poolID[i], 80L, 60, "no status");
        }
        return new StkPhyConf(filterHelper.getMinRow(), filterHelper.getMaxRow(), filterHelper.getMinCol(), filterHelper.getMaxCol(), filterHelper.getPanels(), pools, filterHelper.getLsms());
    }

    public StkVSN[] getVSNsForStkLib(String filter) throws SamFSException {
        ImportVSNFilter myFilter = new ImportVSNFilter(filter);
        if (myFilter.getFilterType() == 4) {
            return stkVSNs;
        }
        LinkedList<StkVSN> myList = new LinkedList<StkVSN>();
        block6: for (int i = 0; i < stkVSNs.length; ++i) {
            switch (myFilter.getFilterType()) {
                case 0: {
                    if (myFilter.getPoolID() != stkVSNs[i].getPoolID()) continue block6;
                    myList.add(stkVSNs[i]);
                    continue block6;
                }
                case 1: {
                    String startVSN = myFilter.getStartVSN();
                    String endVSN = myFilter.getEndVSN();
                    String vsnLabel = stkVSNs[i].getName();
                    if (startVSN.compareTo(vsnLabel) > 0 || endVSN.compareTo(vsnLabel) < 0) continue block6;
                    myList.add(stkVSNs[i]);
                    continue block6;
                }
                case 2: {
                    String regEx = myFilter.getRegEx();
                    if (!stkVSNs[i].getName().matches(regEx)) continue block6;
                    myList.add(stkVSNs[i]);
                    continue block6;
                }
                case 3: {
                    int startRow = myFilter.getStartRow();
                    int endRow = myFilter.getEndRow();
                    int startCol = myFilter.getStartCol();
                    int endCol = myFilter.getEndCol();
                    int panel = myFilter.getPanel();
                    int lsm = myFilter.getLSM();
                    int vsnRowID = stkVSNs[i].getRowID();
                    int vsnColID = stkVSNs[i].getColID();
                    int vsnLsmNum = stkVSNs[i].getLsmNum();
                    int vsnPanelNum = stkVSNs[i].getPanelNum();
                    if (startRow > vsnRowID || endRow < vsnRowID || startCol > vsnColID || endCol < vsnColID || lsm != vsnLsmNum || panel != vsnPanelNum) continue block6;
                    myList.add(stkVSNs[i]);
                }
            }
        }
        StkVSN[] vsns = new StkVSN[myList.size()];
        Iterator it = myList.iterator();
        int index = 0;
        while (it.hasNext()) {
            vsns[index++] = (StkVSN)it.next();
        }
        return vsns;
    }

    public HashMap getVSNNamesForStkLib() throws SamFSException {
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        String[] vsnList = importedVSN.split(",");
        for (int i = 0; i < vsnList.length; ++i) {
            myMap.put(vsnList[i], null);
        }
        return myMap;
    }

    public String getLibraryNamesWithSameACSLSServer() throws SamFSException {
        return "stklib2@ns-east-101";
    }

    public void importVSNInACSLS(String[] vsnNames) throws SamFSException {
        if (vsnNames == null || vsnNames.length == 0) {
            throw new SamFSException("vsn names array is null!");
        }
        for (int i = 0; i < vsnNames.length; ++i) {
            if (importedVSN.length() > 0) {
                importedVSN = importedVSN + ",";
            }
            importedVSN = importedVSN + vsnNames[i];
        }
        String[] vsnList = importedVSN.split(",");
        if (vsnList.length <= 8) {
            return;
        }
        importedVSN = "";
        for (int i = vsnList.length - 8; i < vsnList.length; ++i) {
            if (importedVSN.length() > 0) {
                importedVSN = importedVSN + ",";
            }
            importedVSN = importedVSN + vsnList[i];
        }
    }

    private void createStkVSNs() {
        stkVSNs = new StkVSN[20];
        for (int i = 0; i < 20; ++i) {
            LibraryImpl.stkVSNs[i] = new StkVSN("AK1" + (100 + i), 0, (i * 37 + 12) / 3 % 2, (i * 79 + 13) / 7 % 3, (i * 179 + 13) / 19 % 20, (i * 181 + 19) / 23 % 15, (i * 43 + 7) / 5 % 5, i % 7 == 0 ? "in drive" : "home", "LTO-100G", "data");
        }
    }
}

