/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.media;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.samqfs.web.model.media.DiskVolume;
import java.util.Random;

public class DiskVolumeImpl
implements DiskVolume {
    private String name;
    private String host;
    private String path;
    private long capacity;
    private long availableSpace;
    private boolean unknown;
    private boolean badMedia;
    private boolean unavailable;
    private boolean readOnly;
    private boolean labeled;
    private boolean remote;

    protected DiskVolumeImpl() {
    }

    public DiskVolumeImpl(String name, String host, String path) {
        this.name = name;
        this.host = host;
        this.path = path;
        Random rand = this.getRandom();
        this.capacity = this.getCapacity(rand);
        this.availableSpace = (long)((double)this.capacity * rand.nextDouble());
        this.readOnly = rand.nextBoolean();
        this.badMedia = rand.nextBoolean();
        this.unavailable = rand.nextBoolean();
        this.labeled = rand.nextBoolean();
        this.unknown = rand.nextBoolean();
        this.remote = rand.nextBoolean();
    }

    public String getName() {
        return this.name;
    }

    public String getRemoteHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public long getCapacityKB() {
        return this.capacity;
    }

    public long getAvailableSpaceKB() {
        return this.availableSpace;
    }

    public boolean isUnknown() {
        return this.unknown;
    }

    public boolean isBadMedia() {
        return this.badMedia;
    }

    public void setBadMedia(boolean badMedia) {
        this.badMedia = badMedia;
    }

    public boolean isUnavailable() {
        return this.unavailable;
    }

    public void setUnavailable(boolean unavailable) {
        this.unavailable = unavailable;
    }

    public boolean isLabeled() {
        return this.labeled;
    }

    public void setLabeled(boolean labeled) {
        this.labeled = labeled;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    private long getCapacity(Random rand) {
        long capacity = rand.nextLong();
        while (capacity < 0L) {
            capacity = rand.nextLong();
        }
        return capacity;
    }

    private Random getRandom() {
        Random rand = (Random)RequestManager.getRequestContext().getServletContext().getAttribute("DISK_VSN_RANDOM");
        if (rand == null) {
            rand = new Random(100L);
            RequestManager.getRequestContext().getServletContext().setAttribute("DISK_VSN_RANDOM", (Object)rand);
        }
        return rand;
    }
}

