/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.job;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.BaseJobImpl;
import com.sun.netstorage.samqfs.web.model.job.BaseJob;
import com.sun.netstorage.samqfs.web.model.job.StageJob;
import com.sun.netstorage.samqfs.web.model.job.StageJobFileData;
import com.sun.netstorage.samqfs.web.model.media.VSN;

public class StageJobImpl
extends BaseJobImpl
implements StageJob {
    private FileSystem fs = null;
    private VSN vsn = null;
    private String fsName = new String();
    private String vsnName = new String();
    private int mediaType = -1;
    private String position = new String();
    private String offset = new String();
    private String name = new String();
    private String size = new String();
    private String complete = new String();
    private String username = new String();
    private StageJobFileData[] fileData = new StageJobFileData[0];

    public StageJobImpl() {
    }

    public StageJobImpl(BaseJob base, FileSystem fs2, VSN vsn, String position, String offset, String name, String size, String complete, String username, StageJobFileData[] fileData) throws SamFSException {
        super(base.getJobId(), base.getCondition(), base.getType(), base.getDescription(), base.getStartDateTime(), base.getEndDateTime());
        this.fs = fs2;
        this.vsn = vsn;
        this.position = position;
        this.offset = offset;
        this.name = name;
        this.size = size;
        this.complete = complete;
        this.username = username;
        this.fileData = fileData;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public void setFileSystem(FileSystem fs2) {
        this.fs = fs2;
    }

    public String getFileSystemName() {
        if (this.fs != null) {
            this.fsName = this.fs.getName();
        }
        return this.fsName;
    }

    public VSN getVSN() {
        return this.vsn;
    }

    public void setVSN(VSN vsn) {
        this.vsn = vsn;
    }

    public String getVSNName() {
        try {
            if (this.vsn != null) {
                this.vsnName = this.vsn.getVSN();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.vsnName;
    }

    public int getMediaType() {
        try {
            if (this.vsn != null) {
                this.mediaType = this.vsn.getLibrary().getMediaType();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mediaType;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        if (position != null) {
            this.position = position;
        }
    }

    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        if (offset != null) {
            this.offset = offset;
        }
    }

    public String getFileName() {
        return this.name;
    }

    public void setFileName(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    public String getFileSize() {
        return this.size;
    }

    public void setFileSize(String size) {
        if (size != null) {
            this.size = size;
        }
    }

    public String getStagedFileSize() {
        return this.complete;
    }

    public void setStagedFileSize(String complete) {
        if (complete != null) {
            this.complete = complete;
        }
    }

    public String getInitiatingUserName() {
        return this.username;
    }

    public void setInitiatingUserName(String username) {
        if (username != null) {
            this.username = username;
        }
    }

    public StageJobFileData[] getFileData() throws SamFSException {
        return this.fileData;
    }

    public long getNumberOfFiles() throws SamFSException {
        return this.fileData.length;
    }

    public StageJobFileData[] getFileData(int start, int size, int sortby, boolean ascending) throws SamFSException {
        return this.fileData;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        try {
            if (this.fs != null) {
                buf.append("Filesystem: " + this.fs.getName());
                buf.append("\n\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.vsn != null) {
            try {
                buf.append("VSN: " + this.vsn.getVSN() + "\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        buf.append("Position: " + this.position + "\n");
        buf.append("Offset: " + this.offset + "\n");
        buf.append("File Name: " + this.name + "\n");
        buf.append("File Size: " + this.size + "\n");
        buf.append("Staged: " + this.complete + "\n");
        buf.append("Username: " + this.username + "\n");
        return buf.toString();
    }
}

