/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.job;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.BaseJobImpl;
import com.sun.netstorage.samqfs.web.model.job.ArchiveJob;
import com.sun.netstorage.samqfs.web.model.job.BaseJob;
import com.sun.netstorage.samqfs.web.model.media.VSN;

public class ArchiveJobImpl
extends BaseJobImpl
implements ArchiveJob {
    private FileSystem fs = null;
    private String fsName = new String();
    private String fsMountPoint = new String();
    private ArchiveCopy copy = null;
    private String policyName = new String();
    private int copyNumber = -1;
    private VSN vsn = null;
    private String vsnName = new String();
    private int mediaType = -1;
    private boolean loaded = false;
    private VSN stageVSN = null;
    private String stageVSNName = new String();
    private int stageMediaType = -1;
    private boolean stageLoaded = false;
    private int filesCopied = -1;
    private String dataVolume = new String();
    private String curFileName = null;
    private int filesToBeCopied = -1;
    private String volumeToBeCopied = new String();
    private int archStatus = -1;

    public ArchiveJobImpl() {
    }

    public ArchiveJobImpl(BaseJob base, FileSystem fs2, ArchiveCopy copy, VSN vsn, boolean loaded, VSN stageVSN, boolean stageLoaded, int filesCopied, String dataVolume, String curFileName, int filesToBeCopied, String volumeToBeCopied, int archStatus) throws SamFSException {
        super(base.getJobId(), base.getCondition(), base.getType(), base.getDescription(), base.getStartDateTime(), base.getEndDateTime());
        this.fs = fs2;
        this.copy = copy;
        this.vsn = vsn;
        this.loaded = loaded;
        this.stageVSN = stageVSN;
        this.stageLoaded = stageLoaded;
        this.filesCopied = filesCopied;
        this.dataVolume = dataVolume;
        this.curFileName = curFileName;
        this.filesToBeCopied = filesToBeCopied;
        this.volumeToBeCopied = volumeToBeCopied;
        this.archStatus = archStatus;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public void setFileSystem(FileSystem fs2) {
        this.fs = fs2;
    }

    public String getFileSystemName() {
        if (this.fs != null) {
            this.fsName = this.fs.getName();
        }
        return this.fsName;
    }

    public String getFSMountPoint() throws SamFSException {
        if (this.fs != null) {
            this.fsMountPoint = this.fs.getMountPoint();
        }
        return this.fsMountPoint;
    }

    public ArchiveCopy getCopy() {
        return this.copy;
    }

    public void setCopy(ArchiveCopy copy) {
        this.copy = copy;
    }

    public String getPolicyName() {
        try {
            if (this.copy != null) {
                this.policyName = this.copy.getArchivePolicy().getPolicyName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.policyName;
    }

    public int getCopyNumber() {
        try {
            if (this.copy != null) {
                this.copyNumber = this.copy.getCopyNumber();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.copyNumber;
    }

    public VSN getVSN() {
        return this.vsn;
    }

    public void setVSN(VSN vsn) {
        this.vsn = vsn;
    }

    public String getVSNName() {
        try {
            if (this.vsn != null) {
                this.vsnName = this.vsn.getVSN();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.vsnName;
    }

    public int getMediaType() {
        try {
            if (this.vsn != null) {
                this.mediaType = this.vsn.getLibrary().getMediaType();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mediaType;
    }

    public boolean isVSNLoaded() throws SamFSException {
        return this.loaded;
    }

    public void setVSNLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public VSN getStageVSN() {
        return this.stageVSN;
    }

    public void setStageVSN(VSN stageVSN) throws SamFSException {
        this.stageVSN = stageVSN;
    }

    public String getStageVSNName() {
        try {
            if (this.stageVSN != null) {
                this.stageVSNName = this.stageVSN.getVSN();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.vsnName;
    }

    public int getStageMediaType() {
        try {
            if (this.stageVSN != null) {
                this.stageMediaType = this.vsn.getLibrary().getMediaType();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.stageMediaType;
    }

    public boolean isStageVSNLoaded() throws SamFSException {
        return this.stageLoaded;
    }

    public void setStageVSNLoaded(boolean stageLoaded) {
        this.stageLoaded = stageLoaded;
    }

    public int getTotalNoOfFilesAlreadyCopied() {
        return this.filesCopied;
    }

    public void setTotalNoOfFilesAlreadyCopied(int filesCopied) throws SamFSException {
        this.filesCopied = filesCopied;
    }

    public String getDataVolumeAlreadyCopied() {
        return this.dataVolume;
    }

    public void setDataVolumeAlreadyCopied(String dataVolume) {
        this.dataVolume = dataVolume;
    }

    public String getCurrentFileName() {
        return this.curFileName;
    }

    public void setCurrentFileName(String curFileName) {
        this.curFileName = curFileName;
    }

    public int getTotalNoOfFilesToBeCopied() {
        return this.filesToBeCopied;
    }

    public void setTotalNoOfFilesToBeCopied(int filesToBeCopied) {
        this.filesToBeCopied = filesToBeCopied;
    }

    public String getDataVolumeToBeCopied() {
        return this.volumeToBeCopied;
    }

    public void setDataVolumeToBeCopied(String volumeToBeCopied) {
        this.volumeToBeCopied = volumeToBeCopied;
    }

    public int getArchivingStatus() {
        return this.archStatus;
    }

    public void setArchivingStatus(int archStatus) {
        this.archStatus = archStatus;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        try {
            if (this.fs != null) {
                buf.append("Filesystem: " + this.fs.getName());
                buf.append("\n\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.copy != null) {
            buf.append("Archive Copy: " + this.copy.toString() + "\n");
        }
        if (this.vsn != null) {
            try {
                buf.append("VSN: " + this.vsn.getVSN() + "\n");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        buf.append("VSN Loaded: " + this.loaded + "\n");
        if (this.stageVSN != null) {
            try {
                buf.append("StageVSN: " + this.stageVSN.getVSN() + "\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        buf.append("StageVSN Loaded: " + this.stageLoaded + "\n");
        buf.append("Total No Of Files Already Copied: " + this.filesCopied + "\n");
        buf.append("DataVolume Already Copied: " + this.dataVolume + "\n");
        buf.append("Current FileName: " + this.curFileName + "\n");
        buf.append("Total No Of Files To Be Copied: " + this.filesToBeCopied + "\n");
        buf.append("Total DataVolume To Be Copied: " + this.volumeToBeCopied + "\n");
        return buf.toString();
    }
}

