/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.fs;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiHostException;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.fs.GenericFileSystem;
import com.sun.netstorage.samqfs.web.model.fs.NFSOptions;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSAppModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.DiskCacheImpl;
import java.util.ArrayList;
import java.util.HashMap;

public class GenericFileSystemImpl
implements GenericFileSystem {
    protected String hostName;
    protected String name;
    protected String typeName;
    protected int state = -1;
    protected String mountPoint;
    protected long capacity;
    protected long avail;
    protected int consumed;
    protected boolean nfsShared = false;
    protected boolean ha = false;
    protected ArrayList haInstances = new ArrayList();

    protected GenericFileSystemImpl() {
    }

    public GenericFileSystemImpl(String hostName, String name, String typeName, int state, String mountPoint, long capacity, long avail) {
        this.hostName = hostName;
        this.name = name;
        this.typeName = typeName;
        this.state = state;
        this.mountPoint = mountPoint;
        this.capacity = capacity;
        this.avail = avail;
        this.consumed = (int)((capacity - avail) * 100L / capacity);
        this.setHA(DiskCacheImpl.isHADevice(name));
        this.haInstances = new ArrayList();
        if (this.isHA()) {
            this.haInstances.add(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getFSTypeByProduct() {
        return 13;
    }

    public String getFSTypeName() {
        return this.typeName;
    }

    public boolean isHA() {
        return this.ha;
    }

    public void setHA(boolean ha) {
        this.ha = ha;
    }

    public GenericFileSystem[] getHAFSInstances() throws SamFSMultiHostException {
        return this.haInstances.toArray(new GenericFileSystem[0]);
    }

    public void addHAFSInstance(GenericFileSystem fs2) {
        if (this.haInstances == null) {
            this.haInstances = new ArrayList();
        }
        this.haInstances.add(fs2);
    }

    public void removeHAFSInstance(String host) {
        for (int i = 0; i < this.haInstances.size(); ++i) {
            if (!((GenericFileSystem)this.haInstances.get(i)).getHostName().equalsIgnoreCase(host)) continue;
            this.haInstances.remove(i);
            break;
        }
    }

    public boolean hasNFSShares() {
        return this.nfsShared;
    }

    public void setNFSShares(boolean shared) {
        this.nfsShared = shared;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getAvailableSpace() {
        return this.avail;
    }

    public int getConsumedSpacePercentage() {
        return this.consumed;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void mount() throws SamFSException {
        this.state = 0;
    }

    public void unmount() throws SamFSException {
        this.state = 1;
    }

    public NFSOptions[] getNFSOptions() throws SamFSException {
        NFSOptions[] opts = new NFSOptions[]{};
        HashMap nfsMap = ((SamQFSAppModelImpl)SamQFSFactory.getSamQFSAppModel()).getNFSSharedMap();
        if (nfsMap != null && nfsMap.containsKey(this.getName())) {
            ArrayList nfsOpts = (ArrayList)nfsMap.get(this.getName());
            opts = nfsOpts.toArray(new NFSOptions[0]);
        }
        return opts;
    }

    public void setNFSOptions(NFSOptions opts) throws SamFSException {
        String shareState = opts.getShareState();
        HashMap<String, ArrayList> nfsMap = ((SamQFSAppModelImpl)SamQFSFactory.getSamQFSAppModel()).getNFSSharedMap();
        if (nfsMap == null) {
            nfsMap = new HashMap<String, ArrayList>();
        }
        if (!nfsMap.containsKey(this.getName())) {
            ArrayList<NFSOptions> nfsFilesArray = new ArrayList<NFSOptions>();
            nfsFilesArray.add(opts);
            nfsMap.put(this.getName(), nfsFilesArray);
        } else {
            ArrayList nfsOpts = (ArrayList)nfsMap.get(this.getName());
            boolean exist = false;
            for (int i = 0; i < nfsOpts.size(); ++i) {
                NFSOptions opt = (NFSOptions)nfsOpts.get(i);
                if (opt == null || opt.getDirName().compareTo(opts.getDirName()) != 0) continue;
                exist = true;
                if ("no".equals(shareState)) {
                    nfsOpts.remove(i);
                    nfsMap.put(this.getName(), nfsOpts);
                    break;
                }
                opt.setShareState(opts.getShareState());
                opt.setReadOnlyAccessList(opts.getReadOnlyAccessList());
                opt.setReadWriteAccessList(opts.getReadWriteAccessList());
                opt.setRootAccessList(opts.getRootAccessList());
                break;
            }
            if (!exist && ("yes".equals(shareState) || "config".equals(shareState))) {
                nfsOpts.add(opts);
                nfsMap.put(this.getName(), nfsOpts);
            }
        }
        this.nfsShared = "yes".equals(shareState);
    }
}

