/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.archive43;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopyGUIWrapper;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaProp;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchiveCopyImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchivePolCriteriaCopyImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchivePolCriteriaImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchivePolCriteriaPropImpl;
import java.util.ArrayList;

public class ArchivePolicyImpl
implements ArchivePolicy {
    public static int MAX_COPY_REGULAR = 4;
    public static int MAX_COPY_ALLSETS = 5;
    private SamQFSSystemModel model = null;
    private String policyName = new String();
    private int policyType = -1;
    private ArrayList polCriteriaList = new ArrayList();
    private ArrayList archiveCopyList = new ArrayList();

    public ArchivePolicyImpl() {
    }

    public ArchivePolicyImpl(SamQFSSystemModel model, String policyName, int policyType, ArrayList polCriteriaList, ArrayList archiveCopyList) {
        this.model = model;
        this.policyName = policyName;
        this.policyType = policyType;
        this.polCriteriaList = polCriteriaList;
        this.archiveCopyList = archiveCopyList;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public SamQFSSystemModel getModel() {
        return this.model;
    }

    public void setModel(SamQFSSystemModel model) {
        this.model = model;
    }

    public int getPolicyType() {
        return this.policyType;
    }

    public void setPolicyType(int policyType) {
        this.policyType = policyType;
    }

    public ArchivePolCriteria[] getArchivePolCriteria() {
        return this.polCriteriaList.toArray(new ArchivePolCriteria[0]);
    }

    public ArchivePolCriteria getArchivePolCriteria(int index) {
        ArchivePolCriteria[] crits = this.getArchivePolCriteria();
        ArchivePolCriteria crit = null;
        if (crits != null && crits.length > 0) {
            for (int i = 0; i < crits.length; ++i) {
                if (crits[i].getIndex() != index) continue;
                crit = crits[i];
                break;
            }
        }
        return crit;
    }

    public void setArchivePolCriteria(ArchivePolCriteria[] polCrits) {
        this.polCriteriaList.clear();
        for (int i = 0; i < polCrits.length; ++i) {
            this.polCriteriaList.add(polCrits[i]);
        }
    }

    public ArchivePolCriteria getDefaultArchivePolCriteriaForPolicy() {
        ArchivePolCriteriaPropImpl prop = new ArchivePolCriteriaPropImpl();
        ArchiveCopy[] copies = this.getArchiveCopies();
        ArchivePolCriteriaCopy[] critCopies = new ArchivePolCriteriaCopyImpl[copies.length];
        for (int i = 0; i < copies.length; ++i) {
            critCopies[i] = new ArchivePolCriteriaCopyImpl();
            critCopies[i].setArchivePolCriteriaCopyNumber(copies[i].getCopyNumber());
        }
        ArchivePolCriteriaImpl polCrit = new ArchivePolCriteriaImpl();
        polCrit.setArchivePolCriteriaProperties(prop);
        polCrit.setArchivePolCriteriaCopies(critCopies);
        return polCrit;
    }

    public void addArchivePolCriteria(ArchivePolCriteria polCriteria, String[] fsNames) throws SamFSException {
        if (polCriteria != null && fsNames != null && fsNames.length > 0) {
            ArchivePolCriteriaImpl polCrit = new ArchivePolCriteriaImpl();
            polCrit.setArchivePolicy(this);
            for (int i = 0; i < fsNames.length; ++i) {
                polCrit.addFileSystemForCriteria(fsNames[i]);
            }
            ArchivePolCriteriaProp prop = polCriteria.getArchivePolCriteriaProperties();
            prop.setArchivePolCriteria(polCrit);
            polCrit.setArchivePolCriteriaProperties(prop);
            ArchivePolCriteriaCopy[] copies = polCriteria.getArchivePolCriteriaCopies();
            for (int i = 0; i < copies.length; ++i) {
                copies[i].setArchivePolCriteria(polCrit);
            }
            polCrit.setArchivePolCriteriaCopies(copies);
            polCrit.setIndex(this.polCriteriaList.size());
            this.polCriteriaList.add(polCrit);
        }
    }

    public void deleteArchivePolCriteria(int criteriaIndex) throws SamFSException {
        for (int i = 0; i < this.polCriteriaList.size(); ++i) {
            ArchivePolCriteria polCrit = (ArchivePolCriteria)this.polCriteriaList.get(i);
            if (polCrit.getIndex() != criteriaIndex) continue;
            this.polCriteriaList.remove(i);
        }
    }

    public ArchiveCopy[] getArchiveCopies() {
        return this.archiveCopyList.toArray(new ArchiveCopy[0]);
    }

    public ArchiveCopy getArchiveCopy(int copyNo) {
        ArchiveCopy target = null;
        for (int i = 0; i < this.archiveCopyList.size(); ++i) {
            ArchiveCopy copy = (ArchiveCopy)this.archiveCopyList.get(i);
            if (copy.getCopyNumber() != copyNo) continue;
            target = copy;
            break;
        }
        return target;
    }

    public void addArchiveCopy(ArchiveCopyGUIWrapper copyWrapper) throws SamFSException {
        ArchiveCopy copy = copyWrapper.getArchiveCopy();
        this.addArchiveCopy(copy);
    }

    public void addArchiveCopy(ArchiveCopy copy) throws SamFSException {
        int i;
        int[] possible = new int[MAX_COPY_REGULAR];
        for (i = 0; i < MAX_COPY_REGULAR; ++i) {
            possible[i] = i + 1;
        }
        for (i = 0; i < this.archiveCopyList.size(); ++i) {
            ArchiveCopy currentCopy = (ArchiveCopy)this.archiveCopyList.get(i);
            possible[currentCopy.getCopyNumber() - 1] = -1;
        }
        int available = -1;
        for (int i2 = MAX_COPY_REGULAR; i2 > 0; --i2) {
            if (possible[i2 - 1] == -1) continue;
            available = possible[i2 - 1];
        }
        if (available == -1) {
            throw new SamFSException("logic.noCopyAvailable");
        }
        copy.setArchivePolicy(this);
        ((ArchiveCopyImpl)copy).setCopyNumber(available);
        this.archiveCopyList.add(copy);
    }

    public void deleteArchiveCopy(int copyNo) throws SamFSException {
        if (this.archiveCopyList.size() == 1 && ((ArchiveCopy)this.archiveCopyList.get(0)).getCopyNumber() == copyNo) {
            throw new SamFSException("logic.lastCopy");
        }
        for (int i = 0; i < this.archiveCopyList.size(); ++i) {
            ArchiveCopy copy = (ArchiveCopy)this.archiveCopyList.get(i);
            if (copy.getCopyNumber() != copyNo) continue;
            this.archiveCopyList.remove(i);
            break;
        }
    }

    public void updatePolicy() throws SamFSException {
    }

    public ArchivePolCriteria[] getArchivePolCriteriaForFS(String fsName) {
        ArrayList<ArchivePolCriteriaImpl> list = new ArrayList<ArchivePolCriteriaImpl>();
        if (SamQFSUtil.isValidString(fsName)) {
            for (int i = 0; i < this.polCriteriaList.size(); ++i) {
                ArchivePolCriteriaImpl polCrit = (ArchivePolCriteriaImpl)this.polCriteriaList.get(i);
                if (!polCrit.isFSPresent(fsName)) continue;
                list.add(polCrit);
            }
        }
        return list.toArray(new ArchivePolCriteria[0]);
    }

    public String toString() {
        ArchiveCopy[] copies;
        StringBuffer buf = new StringBuffer();
        buf.append("Policy Name: " + this.getPolicyName() + "\n");
        buf.append("Policy Type: " + this.getPolicyType() + "\n");
        ArchivePolCriteria[] crits = this.getArchivePolCriteria();
        if (crits != null && crits.length > 0) {
            for (int i = 0; i < crits.length; ++i) {
                buf.append("Criteria: \n" + crits[i].toString() + "\n");
            }
        }
        if ((copies = this.getArchiveCopies()) != null && copies.length > 0) {
            for (int i = 0; i < copies.length; ++i) {
                buf.append("Copy: \n" + copies[i].toString() + "\n");
            }
        }
        return buf.toString();
    }
}

