/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.archive43;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaProp;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchivePolicyImpl;
import java.util.ArrayList;

public class ArchivePolCriteriaImpl
implements ArchivePolCriteria {
    private ArchivePolicyImpl policy = null;
    private int index = -1;
    private ArchivePolCriteriaProp criteriaProp = null;
    private ArrayList criteriaCopy = new ArrayList();
    private ArrayList fsNameList = new ArrayList();

    public ArchivePolCriteriaImpl() {
    }

    public ArchivePolCriteriaImpl(ArchivePolicy policy, int index, ArchivePolCriteriaProp criteriaProp, ArrayList criteriaCopy, ArrayList fsNameList) {
        this.policy = (ArchivePolicyImpl)policy;
        this.index = index;
        this.criteriaProp = criteriaProp;
        this.criteriaCopy = criteriaCopy;
        this.fsNameList = fsNameList;
    }

    public ArchivePolicy getArchivePolicy() {
        return this.policy;
    }

    public void setArchivePolicy(ArchivePolicy policy) {
        this.policy = (ArchivePolicyImpl)policy;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public ArchivePolCriteriaProp getArchivePolCriteriaProperties() {
        return this.criteriaProp;
    }

    public void setArchivePolCriteriaProperties(ArchivePolCriteriaProp prop) {
        this.criteriaProp = prop;
    }

    public ArchivePolCriteriaCopy[] getArchivePolCriteriaCopies() {
        return this.criteriaCopy.toArray(new ArchivePolCriteriaCopy[0]);
    }

    public void setArchivePolCriteriaCopies(ArchivePolCriteriaCopy[] copies) {
        this.criteriaCopy.clear();
        if (copies != null && copies.length > 0) {
            for (int i = 0; i < copies.length; ++i) {
                this.criteriaCopy.add(copies[i]);
            }
        }
    }

    public FileSystem[] getFileSystemsForCriteria() throws SamFSException {
        FileSystem[] totalFSList;
        ArrayList<FileSystem> fsList = new ArrayList<FileSystem>();
        if (this.policy != null && this.policy.getModel() != null && (totalFSList = this.policy.getModel().getSamQFSSystemFSManager().getAllFileSystems()) != null) {
            block0: for (int i = 0; i < this.fsNameList.size(); ++i) {
                String name = (String)this.fsNameList.get(i);
                for (int j = 0; j < totalFSList.length; ++j) {
                    if (!name.equals(totalFSList[j].getName())) continue;
                    fsList.add(totalFSList[j]);
                    continue block0;
                }
            }
        }
        return fsList.toArray(new FileSystem[0]);
    }

    public void addFileSystemForCriteria(String fileSystem) throws SamFSException {
        FileSystem fs2;
        if (this.policy != null && SamQFSUtil.isValidString(fileSystem)) {
            this.fsNameList.add(fileSystem);
            this.policy.updatePolicy();
        }
        if (this.policy != null && this.policy.getModel() != null && (fs2 = this.policy.getModel().getSamQFSSystemFSManager().getFileSystem(fileSystem)) != null) {
            ArchivePolCriteria[] tempCritArray = new ArchivePolCriteria[]{this};
            fs2.addPolCriteria(tempCritArray);
        }
    }

    public void deleteFileSystemForCriteria(String fileSystem) throws SamFSException {
        FileSystem fs2;
        if (this.policy != null && SamQFSUtil.isValidString(fileSystem)) {
            int index = this.fsNameList.indexOf(fileSystem);
            if (index != -1) {
                this.fsNameList.remove(index);
            }
            this.policy.updatePolicy();
        }
        if (this.policy != null && this.policy.getModel() != null && (fs2 = this.policy.getModel().getSamQFSSystemFSManager().getFileSystem(fileSystem)) != null) {
            ArchivePolCriteria[] tempCritArray = new ArchivePolCriteria[]{this};
            fs2.removePolCriteria(tempCritArray);
        }
    }

    public boolean isFSPresent(String fsName) {
        boolean present = false;
        int index = this.fsNameList.indexOf(fsName);
        if (index != -1) {
            present = true;
        }
        return present;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Policy Name: \n");
        if (this.getArchivePolicy() != null) {
            buf.append(this.policy.getPolicyName() + "\n");
        }
        buf.append("Policy criteria index number: " + this.getIndex() + "\n");
        buf.append("Criteria Property: \n");
        if (this.criteriaProp != null) {
            buf.append(this.criteriaProp.toString() + "\n");
        }
        buf.append("Criteria Copies: \n");
        ArchivePolCriteriaCopy[] copies = this.getArchivePolCriteriaCopies();
        if (copies != null && copies.length > 0) {
            for (int i = 0; i < copies.length; ++i) {
                buf.append(copies[i].toString() + "\n");
            }
        }
        buf.append("Criteria File Systems: \n");
        String[] names = this.fsNameList.toArray(new String[0]);
        if (names != null && names.length > 0) {
            for (int i = 0; i < names.length; ++i) {
                buf.append(names[i] + "\n");
            }
        }
        return buf.toString();
    }
}

