/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.archive;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.archive.VSNPool;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import java.util.ArrayList;

public class VSNPoolImpl
implements VSNPool,
Cloneable {
    private String poolName = null;
    private int mediaType = -1;
    private long spaceAvailable = -1L;
    private String vsnExp = null;
    private ArrayList memberVSNs = null;

    public VSNPoolImpl() {
    }

    public VSNPoolImpl(String poolName, int mediaType, String vsnExp, ArrayList memberVSNs) {
        this.poolName = poolName;
        this.mediaType = mediaType;
        this.vsnExp = vsnExp;
        this.memberVSNs = memberVSNs;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public int getMediaType() {
        return this.mediaType;
    }

    public long getSpaceAvailable() throws SamFSException {
        long available = 0L;
        if (this.memberVSNs != null) {
            for (int i = 0; i < this.memberVSNs.size(); ++i) {
                available += ((VSN)this.memberVSNs.get(i)).getAvailableSpace();
            }
        }
        return available;
    }

    public String getVSNExpression() {
        return this.vsnExp;
    }

    public VSN[] getMemberVSNs() throws SamFSException {
        return this.memberVSNs.toArray(new VSN[0]);
    }

    public VSN[] getMemberVSNs(int start, int size, int sortby, boolean ascending) throws SamFSException {
        return this.memberVSNs.toArray(new VSN[0]);
    }

    public void setMemberVSNs(int mediaType, String expression, VSN[] memberVSNs) throws SamFSException {
        this.mediaType = mediaType;
        this.vsnExp = expression;
        if (this.memberVSNs == null) {
            this.memberVSNs = new ArrayList();
        } else {
            this.memberVSNs.clear();
        }
        if (memberVSNs != null) {
            for (int i = 0; i < memberVSNs.length; ++i) {
                this.memberVSNs.add(memberVSNs[i]);
            }
        }
    }

    public void setMemberVSNs(int mediaType, String expression) throws SamFSException {
        this.mediaType = mediaType;
        this.vsnExp = expression;
    }

    public int getNoOfVSNsInPool() throws SamFSException {
        int size = 0;
        if (this.memberVSNs != null) {
            size = this.memberVSNs.size();
        }
        return size;
    }

    public String[] getMemberVSNNames() throws SamFSException {
        String[] strs = new String[]{};
        if (this.memberVSNs != null && this.memberVSNs.size() > 0) {
            strs = new String[this.memberVSNs.size()];
            for (int i = 0; i < this.memberVSNs.size(); ++i) {
                strs[i] = ((VSN)this.memberVSNs.get(i)).getVSN();
            }
        }
        return strs;
    }

    public Object clone() {
        VSNPoolImpl newPool = null;
        try {
            ArrayList list = null;
            if (this.memberVSNs != null) {
                list = new ArrayList();
                for (int i = 0; i < this.memberVSNs.size(); ++i) {
                    list.add(this.memberVSNs.get(i));
                }
            }
            newPool = new VSNPoolImpl(this.getPoolName(), this.getMediaType(), this.getVSNExpression(), list);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newPool;
    }

    public String toString() {
        long spaceAvailable = 0L;
        try {
            spaceAvailable = this.getSpaceAvailable();
        }
        catch (Exception e) {
            // empty catch block
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Pool Name: " + this.poolName + "\n");
        buf.append("Media Type: " + this.mediaType + "\n");
        buf.append("Space Available: " + spaceAvailable + "\n");
        buf.append("VSN Expression: " + this.vsnExp + "\n");
        try {
            if (this.memberVSNs != null) {
                for (int i = 0; i < this.memberVSNs.size(); ++i) {
                    buf.append("VSN Members: " + (VSN)this.memberVSNs.get(i) + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }
}

