/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.archive;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.archive.GlobalArchiveDirective;
import com.sun.netstorage.samqfs.web.model.archive43.BufferDirective;
import com.sun.netstorage.samqfs.web.model.archive43.DriveDirective;
import java.util.ArrayList;

public class GlobalArchiveDirectiveImpl
implements GlobalArchiveDirective {
    private ArrayList bufDir = new ArrayList();
    private ArrayList minFileSize = new ArrayList();
    private ArrayList bufSize = new ArrayList();
    private ArrayList driveDir = new ArrayList();
    private String archLogfile = null;
    private long interval = -1L;
    private int unit = -1;
    private int archMethod = -1;

    public GlobalArchiveDirectiveImpl() {
    }

    public GlobalArchiveDirectiveImpl(ArrayList bufDir, ArrayList minFileSize, ArrayList bufSize, ArrayList driveDir, String archLogfile, long interval, int unit, int archMethod) {
        this.bufDir = bufDir;
        this.minFileSize = minFileSize;
        this.bufSize = bufSize;
        this.driveDir = driveDir;
        this.archLogfile = archLogfile;
        this.interval = interval;
        this.unit = unit;
        this.archMethod = archMethod;
    }

    public BufferDirective[] getMaxFileSize() {
        return this.bufDir.toArray(new BufferDirective[0]);
    }

    public void addMaxFileSizeDirective(BufferDirective dir) {
        if (this.bufDir == null) {
            this.bufDir = new ArrayList();
        }
        this.bufDir.add(dir);
    }

    public void deleteMaxFileSizeDirective(BufferDirective dir) {
        int index = this.bufDir.indexOf(dir);
        if (index != -1) {
            this.bufDir.remove(index);
        }
    }

    public BufferDirective[] getMinFileSizeForOverflow() {
        return this.minFileSize.toArray(new BufferDirective[0]);
    }

    public void addMinFileSizeForOverflow(BufferDirective dir) {
        if (this.minFileSize == null) {
            this.minFileSize = new ArrayList();
        }
        this.minFileSize.add(dir);
    }

    public void deleteMinFileSizeForOverflow(BufferDirective dir) {
        int index = this.minFileSize.indexOf(dir);
        if (index != -1) {
            this.minFileSize.remove(index);
        }
    }

    public BufferDirective[] getBufferSize() {
        return this.bufSize.toArray(new BufferDirective[0]);
    }

    public void addBufferSize(BufferDirective dir) {
        if (this.bufSize == null) {
            this.bufSize = new ArrayList();
        }
        this.bufSize.add(dir);
    }

    public void deleteBufferSize(BufferDirective dir) {
        int index = this.bufSize.indexOf(dir);
        if (index != -1) {
            this.bufSize.remove(index);
        }
    }

    public DriveDirective[] getDriveDirectives() {
        return this.driveDir.toArray(new DriveDirective[0]);
    }

    public void addDriveDirective(DriveDirective dir) {
        if (this.driveDir == null) {
            this.driveDir = new ArrayList();
        }
        this.driveDir.add(dir);
    }

    public void deleteDriveDirective(DriveDirective dir) {
        int index = this.driveDir.indexOf(dir);
        if (index != -1) {
            this.driveDir.remove(index);
        }
    }

    public String getArchiveLogfile() {
        return this.archLogfile;
    }

    public void setArchiveLogfile(String logfile) {
        this.archLogfile = logfile;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public int getIntervalUnit() {
        return this.unit;
    }

    public void setIntervalUnit(int unit) {
        this.unit = unit;
    }

    public int getArchiveScanMethod() {
        return this.archMethod;
    }

    public void setArchiveScanMethod(int method) {
        this.archMethod = method;
    }

    public void changeGlobalDirective() throws SamFSException {
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        try {
            if (this.bufDir != null) {
                for (i = 0; i < this.bufDir.size(); ++i) {
                    buf.append("Max File Size Directive: " + ((BufferDirective)this.bufDir.get(i)).toString() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.minFileSize != null) {
                for (i = 0; i < this.minFileSize.size(); ++i) {
                    buf.append("Min FileSize For Overflow: " + ((BufferDirective)this.minFileSize.get(i)).toString() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.driveDir != null) {
                for (int i2 = 0; i2 < this.driveDir.size(); ++i2) {
                    buf.append("Drive Directive: " + ((DriveDirective)this.driveDir.get(i2)).toString() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        buf.append("Archive Logfile: " + this.archLogfile + "\n");
        buf.append("Interval: " + this.interval + "\n");
        buf.append("Archive Scan Method: " + this.archMethod + "\n");
        return buf.toString();
    }
}

