/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.archive;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveFileParams;
import com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.archive.LegacySetInfo;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive.ArchiveCopyImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive.ArchiveFileParamsImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.fs.FileSystemImpl;
import java.util.ArrayList;

public class ArchivePolicyImpl
implements ArchivePolicy,
Cloneable {
    private SamQFSSystemModelImpl model = null;
    private String policyName = null;
    private String startingDir = null;
    private ArchiveFileParams fileParams = null;
    private ArrayList archCopies = new ArrayList();
    private ArrayList fsList = new ArrayList();
    private boolean legacy = false;
    private ArrayList legacyInfoList = new ArrayList();

    public ArchivePolicyImpl() {
    }

    public ArchivePolicyImpl(SamQFSSystemModelImpl model, String policyName, String startingDir, ArchiveFileParams fileParams, ArrayList archCopies, ArrayList fsList) throws SamFSException {
        if (policyName == null || policyName == new String()) {
            throw new SamFSException("INVALID_POLICY");
        }
        if (startingDir == null) {
            startingDir = new String();
        }
        this.model = model;
        this.policyName = policyName;
        this.startingDir = startingDir;
        this.fileParams = fileParams;
        if (fileParams != null) {
            fileParams.setStartingDir(startingDir);
        }
        if (archCopies != null) {
            this.archCopies = archCopies;
        }
        if (fsList != null) {
            this.fsList = fsList;
        }
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public void setLegacy(boolean legacy) {
        this.legacy = legacy;
    }

    public LegacySetInfo[] getLegacySetInfo() {
        return this.legacyInfoList.toArray(new LegacySetInfo[0]);
    }

    public void setLegacySetInfo(ArrayList list) {
        this.legacyInfoList = list;
    }

    public String getPolicyName() throws SamFSException {
        return this.policyName;
    }

    public String getStartingDir() throws SamFSException {
        return this.startingDir;
    }

    public ArchiveFileParams getFileCharacteristics() throws SamFSException {
        return this.fileParams;
    }

    public void setFileCharacteristics(ArchiveFileParams fileParams) throws SamFSException {
        this.fileParams = fileParams;
        if (fileParams != null) {
            this.startingDir = fileParams.getStartingDir();
        }
    }

    public ArchiveCopy[] getArchiveCopies() throws SamFSException {
        return this.archCopies.toArray(new ArchiveCopy[0]);
    }

    public ArchiveCopy getArchiveCopy(int copyNo) throws SamFSException {
        ArchiveCopy[] copies = this.archCopies.toArray(new ArchiveCopy[0]);
        ArchiveCopy copy = null;
        for (int i = 0; i < copies.length; ++i) {
            if (copies[i].getCopyNumber() != copyNo) continue;
            copy = copies[i];
            break;
        }
        return copy;
    }

    public FileSystem[] getFileSystemsForPolicy() throws SamFSException {
        return this.fsList.toArray(new FileSystem[0]);
    }

    public void changeFileCharacteristics() throws SamFSException {
    }

    public void addArchiveCopy(ArchiveCopy copy) throws SamFSException {
        if (this.archCopies == null) {
            this.archCopies = new ArrayList();
        }
        this.archCopies.add(copy);
    }

    public void deleteArchiveCopy(ArchiveCopy copy) throws SamFSException {
        int index = this.archCopies.indexOf(copy);
        if (index == -1) {
            throw new SamFSException("COPY_NOT_FOUND");
        }
        this.archCopies.remove(index);
    }

    public void changeArchiveCopies() throws SamFSException {
    }

    public void addFileSystemForPolicy(FileSystem filesystem) throws SamFSException {
        this.addFS(filesystem);
        ArchivePolicy[] policies = filesystem.getArchivePoliciesForFS();
        boolean absent = true;
        if (policies != null) {
            for (int i = 0; i < policies.length; ++i) {
                if (!policies[i].getPolicyName().equals(this.getPolicyName())) continue;
                absent = false;
                break;
            }
        }
        if (absent) {
            ((FileSystemImpl)filesystem).addPol(this);
        }
    }

    public void addFileSystemForPolicy(String filesystem) throws SamFSException {
        FileSystem fs2;
        if (this.model != null && (fs2 = this.model.getSamQFSSystemFSManager().getFileSystem(filesystem)) != null) {
            this.addFileSystemForPolicy(fs2);
        }
    }

    public void deleteFileSystemForPolicy(FileSystem filesystem) throws SamFSException {
        this.removeFS(filesystem);
        try {
            ((FileSystemImpl)filesystem).removePol(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteFileSystemForPolicy(String filesystem) throws SamFSException {
        FileSystem fs2;
        if (this.model != null && (fs2 = this.model.getSamQFSSystemFSManager().getFileSystem(filesystem)) != null) {
            this.deleteFileSystemForPolicy(fs2);
        }
    }

    public Object clone() {
        ArchivePolicyImpl policy = null;
        try {
            ArrayList<Object> copies = new ArrayList<Object>();
            if (this.archCopies != null) {
                for (int i = 0; i < this.archCopies.size(); ++i) {
                    ArchiveCopyImpl copy = (ArchiveCopyImpl)this.archCopies.get(i);
                    copies.add(copy.clone());
                }
            }
            ArrayList fileSystems = new ArrayList();
            if (this.fsList != null) {
                for (int i = 0; i < this.fsList.size(); ++i) {
                    fileSystems.add(this.fsList.get(i));
                }
            }
            ArchiveFileParamsImpl params = null;
            if (this.fileParams != null) {
                params = (ArchiveFileParamsImpl)((ArchiveFileParamsImpl)this.fileParams).clone();
            }
            policy = new ArchivePolicyImpl(this.model, this.policyName, this.startingDir, params, copies, fileSystems);
            params.setArchivePolicy(policy);
            if (copies != null && copies.size() > 0) {
                for (int i = 0; i < copies.size(); ++i) {
                    ((ArchiveCopyImpl)copies.get(i)).setArchivePolicy(policy);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return policy;
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("Policy Name: " + this.policyName + "\n");
        buf.append("Starting Dir: " + this.startingDir + "\n");
        buf.append("File Characteristics: " + this.fileParams.toString() + "\n");
        try {
            if (this.archCopies != null) {
                for (i = 0; i < this.archCopies.size(); ++i) {
                    buf.append("Archive Copies: " + ((ArchiveCopy)this.archCopies.get(i)).toString() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.fsList != null) {
                for (i = 0; i < this.fsList.size(); ++i) {
                    buf.append("FileSystems For Policy: " + ((FileSystem)this.fsList.get(i)).getName() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    public void addFS(FileSystem filesystem) throws SamFSException {
        if (this.fsList == null) {
            this.fsList = new ArrayList();
        }
        this.fsList.add(filesystem);
    }

    public void removeFS(FileSystem filesystem) throws SamFSException {
        int index = this.fsList.indexOf(filesystem);
        if (index == -1) {
            throw new SamFSException("FILE_SYSTEM_NOT_A_MEMBER");
        }
        this.fsList.remove(index);
    }

    public void setPolicyName(String policyName) throws SamFSException {
        this.policyName = policyName;
    }

    public void setStartingDir(String startingDir) throws SamFSException {
        this.startingDir = startingDir;
    }

    public void setCandidateFileSystems(FileSystem[] fsNew) {
        FileSystem[] fs2 = null;
        try {
            fs2 = this.getFileSystemsForPolicy();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (fs2 != null) {
            for (int i = 0; i < fs2.length; ++i) {
                try {
                    this.deleteFileSystemForPolicy(fs2[i]);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (fsNew != null) {
            for (int i = 0; i < fsNew.length; ++i) {
                try {
                    this.addFileSystemForPolicy(fsNew[i]);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public FileSystem[] getCandidateFileSystems() {
        FileSystem[] fs2 = null;
        try {
            fs2 = this.getFileSystemsForPolicy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fs2;
    }
}

