/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.archive;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveFileParams;
import com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSUtil;

public class ArchiveFileParamsImpl
implements ArchiveFileParams,
Cloneable {
    private ArchivePolicy archPolicy = null;
    private String startingDir = new String();
    private long minSize = -1L;
    private int minSizeUnit = -1;
    private long maxSize = -1L;
    private int maxSizeUnit = -1;
    private String namePattern = null;
    private String owner = null;
    private String group = null;
    private int stageAttribs = -1;
    private int releaseAttribs = -1;

    public ArchiveFileParamsImpl() {
    }

    public ArchiveFileParamsImpl(ArchivePolicy archPolicy, long minSize, long maxSize, String namePattern, String owner, String group, int stageAttribs, int releaseAttribs) {
        this.archPolicy = archPolicy;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.namePattern = namePattern;
        this.owner = owner;
        this.group = group;
        this.stageAttribs = stageAttribs;
        this.releaseAttribs = releaseAttribs;
        if (minSize >= 0L) {
            this.minSizeUnit = 0;
        }
        if (maxSize >= 0L) {
            this.maxSizeUnit = 0;
        }
    }

    public ArchivePolicy getArchivePolicy() throws SamFSException {
        return this.archPolicy;
    }

    public void setArchivePolicy(ArchivePolicy policy) throws SamFSException {
        this.archPolicy = policy;
    }

    public String getStartingDir() throws SamFSException {
        return this.startingDir;
    }

    public void setStartingDir(String startingDir) throws SamFSException {
        if (startingDir != null) {
            this.startingDir = startingDir;
        }
    }

    public long getMinSize() throws SamFSException {
        return this.minSize;
    }

    public void setMinSize(long size) throws SamFSException {
        this.minSize = size;
    }

    public long getMinSizeInBytes() throws SamFSException {
        long size = -1L;
        if (this.minSizeUnit != -1 && this.minSize >= 0L) {
            size = SamQFSUtil.getSizeInBytes(this.minSize, this.minSizeUnit);
        }
        return size;
    }

    public int getMinSizeUnit() throws SamFSException {
        return this.minSizeUnit;
    }

    public void setMinSizeUnit(int sizeUnit) throws SamFSException {
        this.minSizeUnit = sizeUnit;
    }

    public long getMaxSize() throws SamFSException {
        return this.maxSize;
    }

    public void setMaxSize(long size) throws SamFSException {
        this.maxSize = size;
    }

    public long getMaxSizeInBytes() throws SamFSException {
        long size = -1L;
        if (this.maxSizeUnit != -1 && this.maxSize >= 0L) {
            size = SamQFSUtil.getSizeInBytes(this.maxSize, this.maxSizeUnit);
        }
        return size;
    }

    public int getMaxSizeUnit() throws SamFSException {
        return this.maxSizeUnit;
    }

    public void setMaxSizeUnit(int sizeUnit) throws SamFSException {
        this.maxSizeUnit = sizeUnit;
    }

    public String getNamePattern() throws SamFSException {
        return this.namePattern;
    }

    public void setNamePattern(String pattern) throws SamFSException {
        this.namePattern = pattern;
    }

    public String getOwner() throws SamFSException {
        return this.owner;
    }

    public void setOwner(String owner) throws SamFSException {
        this.owner = owner;
    }

    public String getGroup() throws SamFSException {
        return this.group;
    }

    public void setGroup(String group) throws SamFSException {
        this.group = group;
    }

    public int getStageAttributes() throws SamFSException {
        return this.stageAttribs;
    }

    public void setStageAttributes(int attribs) throws SamFSException {
        this.stageAttribs = attribs;
    }

    public int getReleaseAttributes() throws SamFSException {
        return this.releaseAttribs;
    }

    public void setReleaseAttributes(int attribs) throws SamFSException {
        this.releaseAttribs = attribs;
    }

    public Object clone() {
        ArchiveFileParamsImpl newParams = null;
        try {
            newParams = new ArchiveFileParamsImpl(this.getArchivePolicy(), this.getMinSize(), this.getMaxSize(), this.getNamePattern(), this.getOwner(), this.getGroup(), this.getStageAttributes(), this.getReleaseAttributes());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newParams;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.archPolicy != null) {
            try {
                buf.append("Archive Policy: " + this.archPolicy.getPolicyName() + "\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        buf.append("Min Size: " + this.minSize + "\n");
        buf.append("Max Size: " + this.maxSize + "\n");
        buf.append("Name Pattern: " + this.namePattern + "\n");
        buf.append("Owner: " + this.owner + "\n");
        buf.append("Group: " + this.group + "\n");
        buf.append("Stage Attributes: " + this.stageAttribs + "\n");
        buf.append("Release Attributes: " + this.releaseAttribs + "\n");
        return buf.toString();
    }
}

