/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.alarm;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.alarm.Alarm;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.media.Library;
import java.util.GregorianCalendar;

public class AlarmImpl
implements Alarm {
    private long index = -1L;
    private int severity = -1;
    private String description = null;
    private GregorianCalendar dateTimeGenerated = null;
    private int status = -1;
    private int associatedEquipOrdinal = -1;
    private Library associatedLibrary = null;
    private FileSystem associatedFileSystem = null;

    public AlarmImpl() {
    }

    public AlarmImpl(long index, int severity, String description, GregorianCalendar dateTimeGenerated, int status, Library associatedLibrary, FileSystem associatedFileSystem) {
        this.index = index;
        this.severity = severity;
        this.description = description;
        this.dateTimeGenerated = dateTimeGenerated;
        this.status = status;
        this.associatedLibrary = associatedLibrary;
        this.associatedFileSystem = associatedFileSystem;
        try {
            if (associatedLibrary != null) {
                this.associatedEquipOrdinal = associatedLibrary.getEquipOrdinal();
            } else if (associatedFileSystem != null) {
                this.associatedEquipOrdinal = associatedFileSystem.getEquipOrdinal();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getAlarmID() throws SamFSException {
        return this.index;
    }

    public int getSeverity() throws SamFSException {
        return this.severity;
    }

    public String getDescription() throws SamFSException {
        return this.description;
    }

    public GregorianCalendar getDateTimeGenerated() throws SamFSException {
        return this.dateTimeGenerated;
    }

    public int getStatus() throws SamFSException {
        return this.status;
    }

    public void setStatus(int status) throws SamFSException {
        this.status = status;
    }

    public int getAssociatedEquipOrdinal() throws SamFSException {
        return this.associatedEquipOrdinal;
    }

    public Library getAssociatedLibrary() throws SamFSException {
        return this.associatedLibrary;
    }

    public void setLibrary(Library library) throws SamFSException {
        this.associatedLibrary = library;
        this.associatedEquipOrdinal = this.associatedLibrary.getEquipOrdinal();
    }

    public FileSystem getAssociatedFileSystem() throws SamFSException {
        return this.associatedFileSystem;
    }

    public void setFileSystem(FileSystem fileSystem) throws SamFSException {
        this.associatedFileSystem = fileSystem;
        this.associatedEquipOrdinal = this.associatedFileSystem.getEquipOrdinal();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        try {
            if (this.associatedLibrary != null) {
                buf.append("Library: " + this.associatedLibrary.getName() + "\n\n");
            } else if (this.associatedFileSystem != null) {
                buf.append("Filesystem: " + this.associatedFileSystem.getName());
                buf.append("\n\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        buf.append("Severity: " + this.severity + "\n");
        buf.append("Description: " + this.description + "\n");
        buf.append("Generated on : " + SamQFSUtil.dateTime(this.dateTimeGenerated) + "\n");
        buf.append("Status: " + this.status + "\n");
        buf.append("Associated Equip Ordinal: " + this.associatedEquipOrdinal + "\n");
        return buf.toString();
    }
}

