/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive.ArchiveCopyImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive.ArchiveFileParamsImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive.ArchivePolicyImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive.ArchiveVSNMapImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.fs.FileSystemMountPropertiesImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.DiskCacheImpl;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;

public class SamQFSUtil {
    public static String dateTime(GregorianCalendar dateTime) {
        String dateTimeString = new String();
        if (dateTime != null) {
            int month = dateTime.get(2) + 1;
            int day = dateTime.get(5);
            int year = dateTime.get(1);
            int hour = dateTime.get(10);
            int minute = dateTime.get(12);
            int second = dateTime.get(13);
            String am_pm = new String();
            if (dateTime.get(9) == 1) {
                am_pm = "PM";
            } else if (dateTime.get(9) == 0) {
                am_pm = "AM";
            }
            String fillerMin = new String();
            if (minute < 10) {
                fillerMin = "0";
            }
            String fillerSec = new String();
            if (second < 10) {
                fillerSec = "0";
            }
            dateTimeString = month + "/" + day + "/" + year + ", " + hour + ":" + fillerMin + minute + ":" + fillerSec + second + " " + am_pm;
        }
        return dateTimeString;
    }

    public static GregorianCalendar getDateTime() {
        return new GregorianCalendar();
    }

    public static ArrayList createAUs(int type, int number) throws SamFSException {
        String path = null;
        long capacity = 100L + (long)(Math.random() * 10000.0);
        ArrayList<DiskCacheImpl> list = new ArrayList<DiskCacheImpl>();
        for (int i = 0; i < number; ++i) {
            if (type == 101) {
                path = "/dev/dsk/c1t10d" + i + "s" + (int)(Math.random() * 10.0);
            } else if (type == 102) {
                path = "/dev/md/dsk/d" + (int)((double)i + Math.random() * 100.0);
                type = 104;
            } else {
                path = "/dev/vx/dsk/d" + (int)((double)i + Math.random() * 100.0);
                type = 107;
            }
            DiskCacheImpl disk = new DiskCacheImpl(path, type, capacity);
            if (type == 101) {
                disk.setVendor("Sun Microsystems, Inc.");
                disk.setProductId("T3-b");
            }
            list.add(disk);
        }
        return list;
    }

    public static FileSystemMountProperties getDefaultMountProperties(int fsType, int archType, int shareType) throws SamFSException {
        return new FileSystemMountPropertiesImpl(fsType, archType, shareType);
    }

    public static void printDisks(DiskCache[] disks) throws SamFSException {
        System.out.println("Printing Disks...");
        if (disks != null) {
            for (int i = 0; i < disks.length; ++i) {
                System.out.println("Printing disk " + (i + 1));
                System.out.println(disks[i]);
            }
        }
    }

    public static void printFS(FileSystem[] fs2) throws SamFSException {
        System.out.println("Printing File Systems...");
        if (fs2 != null) {
            for (int i = 0; i < fs2.length; ++i) {
                System.out.println("Printing File System " + (i + 1));
                System.out.println(fs2[i]);
            }
        }
    }

    private static int getRandom() {
        int i = 11;
        return i += (int)(Math.random() * 100000.0);
    }

    public static ArchivePolicy createDefaultPolicy() throws SamFSException {
        ArchivePolicyImpl policy = new ArchivePolicyImpl();
        policy.setStartingDir(".");
        ArchiveFileParamsImpl params = new ArchiveFileParamsImpl(null, -1L, -1L, "", "", "", 10004, 10009);
        ArchiveCopyImpl[] copies = new ArchiveCopyImpl[4];
        ArchiveVSNMapImpl[] maps = new ArchiveVSNMapImpl[4];
        policy.setFileCharacteristics(params);
        params.setArchivePolicy(policy);
        for (int i = 0; i < 4; ++i) {
            copies[i] = new ArchiveCopyImpl(null, i + 1, null, 10L, 14, 8, 3, false, false, "", -1, -1L, 1L, 0, 10L, 11, false, 1000L, 1000L, 2000, false, 10L, -1, 20L, 4000L, 90, false, "", 10, 1000);
            copies[i].setArchiveAgeUnit(6);
            copies[i].setStartAgeUnit(6);
            copies[i].setStartSizeUnit(2);
            copies[i].setRecycleDataSizeUnit(2);
            maps[i] = new ArchiveVSNMapImpl();
            copies[i].setArchiveVSNMap(maps[i]);
            maps[i].setArchiveCopy(copies[i]);
            copies[i].setArchivePolicy(policy);
            policy.addArchiveCopy(copies[i]);
        }
        return policy;
    }

    public static long getSizeInBytes(long srcSize, int srcUnit) {
        long size = -1L;
        switch (srcUnit) {
            case 0: {
                size = srcSize;
                break;
            }
            case 1: {
                size = srcSize * 1024L;
                break;
            }
            case 2: {
                size = srcSize * 1024L * 1024L;
                break;
            }
            case 3: {
                size = srcSize * 1024L * 1024L * 1024L;
                break;
            }
            case 4: {
                size = srcSize * 1024L * 1024L * 1024L * 1024L;
            }
        }
        return size;
    }

    public static GregorianCalendar convertTime(long time) {
        GregorianCalendar calendar = null;
        if (time > 0L) {
            Date date = new Date(time * 1000L);
            calendar = new GregorianCalendar();
            calendar.setTime(date);
        }
        return calendar;
    }

    public static boolean isValidString(String str) {
        boolean valid = true;
        if (str == null || str.equals("") || str.equals(new String())) {
            valid = false;
        }
        return valid;
    }

    public static GregorianCalendar getRandomCalendar() {
        GregorianCalendar cal = new GregorianCalendar();
        Date date = new Date();
        date.setTime((long)((double)date.getTime() * Math.random()));
        cal.setTime(date);
        return cal;
    }
}

