/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.ClusterNodeInfo;
import com.sun.netstorage.samqfs.web.model.ConfigStatus;
import com.sun.netstorage.samqfs.web.model.DaemonInfo;
import com.sun.netstorage.samqfs.web.model.LogAndTraceInfo;
import com.sun.netstorage.samqfs.web.model.PkgInfo;
import com.sun.netstorage.samqfs.web.model.SamExplorerOutputs;
import com.sun.netstorage.samqfs.web.model.SamQFSDataStore;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemAdminManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemAlarmManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemArchiveManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemArchiveManager43;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemJobManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemMediaManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.SystemCapacity;
import com.sun.netstorage.samqfs.web.model.SystemInfo;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSAppModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSDataStoreImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemAdminManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemAlarmManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemArchiveManager43Impl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemArchiveManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemFSManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemJobManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemMediaManagerImpl;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.util.ConversionUtil;
import java.util.ArrayList;
import java.util.HashMap;

public class SamQFSSystemModelImpl
implements SamQFSSystemModel {
    private String serverAPIVersion = "1.3.3";
    private String serverProductVersion = "4.5";
    private String hostname = null;
    private boolean down = false;
    private SamQFSDataStoreImpl dataStore = null;
    private HashMap policyMap = new HashMap();
    protected ArrayList availableAUs = new ArrayList();
    private HashMap eqMap = new HashMap();
    private HashMap driveMap = new HashMap();
    private HashMap bufferDir = new HashMap();
    private HashMap libStageDriveDir = new HashMap();
    private ArrayList alarms = new ArrayList();
    int eqCounter = 1000;
    private HashMap libRecParams = new HashMap();
    private String dumpPath = "Tell LC: this method call needs to be changed.";
    private String defaultDumpPath = "/etc/opt/SUNWsamfs";
    private ArrayList ipAddresses = new ArrayList();
    private SamQFSSystemFSManager fsManager = null;
    private SamQFSSystemArchiveManager archiveManager = null;
    private SamQFSSystemArchiveManager43 archiveManager43 = null;
    private SamQFSSystemMediaManager mediaManager = null;
    private SamQFSSystemJobManager jobManager = null;
    private SamQFSSystemAlarmManager alarmManager = null;
    private SamQFSSystemAdminManager adminManager = null;

    public SamQFSSystemModelImpl(String hostname) throws SamFSException {
        if (hostname == null || hostname == new String()) {
            throw new IllegalArgumentException();
        }
        this.hostname = hostname;
        this.dataStore = new SamQFSDataStoreImpl(this);
    }

    public int getVersionStatus() {
        return 1001;
    }

    public String getServerAPIVersion() {
        return this.serverAPIVersion;
    }

    public void setServerAPIVersion(String serverAPIVersion) {
        this.serverAPIVersion = serverAPIVersion;
    }

    public String getServerProductVersion() {
        return this.serverProductVersion;
    }

    public void setServerProductVersion(String serverProductVersion) {
        this.serverProductVersion = serverProductVersion;
    }

    public short getLicenseType() throws SamFSException {
        return 3;
    }

    public void reconnect() throws SamFSException {
    }

    public void reinitialize() throws SamFSException {
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getServerHostname() {
        return this.hostname;
    }

    public boolean isClusterNode() {
        return this.hostname.startsWith("scnode");
    }

    public String getClusterVersion() {
        if (this.isClusterNode()) {
            return new String("Sun Cluster 3.1u4 u4_26 for Solaris 10 sparc");
        }
        return null;
    }

    public String getClusterName() {
        if (this.isClusterNode()) {
            return new String("mycluster");
        }
        return null;
    }

    public int getPlexMgrState() throws SamFSException {
        return 0;
    }

    public String getArchitecture() {
        return "sparc";
    }

    public boolean isDown() {
        return this.down;
    }

    public void setDown() {
        this.down = true;
    }

    public void setDown(boolean down) {
        this.down = down;
    }

    public SamQFSDataStore getDataStore() throws SamFSException {
        return this.dataStore;
    }

    public String getDumpPath() throws SamFSException {
        return this.dumpPath;
    }

    public void setDumpPath(String dumpPath) throws SamFSException {
        this.dumpPath = dumpPath;
    }

    public String getDefaultDumpPath() {
        return this.defaultDumpPath;
    }

    public void setDefaultDumpPath(String dumpPath) {
        this.defaultDumpPath = dumpPath;
    }

    public void clearContext() {
    }

    public String[] getIPAddresses() {
        return this.ipAddresses.toArray(new String[0]);
    }

    public void setIPAddresses(String[] ips) {
        this.ipAddresses.clear();
        if (ips != null) {
            for (int i = 0; i < ips.length; ++i) {
                this.ipAddresses.add(ips[i]);
            }
        }
    }

    public SystemCapacity getCapacity() {
        SystemCapacity mySystemCapacity = new SystemCapacity(80, 100500000L, 79856000L, 2, 220000000L, 85689000L, 10);
        return mySystemCapacity;
    }

    public SystemInfo getSystemInfo() throws SamFSException {
        SystemInfo si = new SystemInfo("Hostid=80c475b0, Hostname=" + this.hostname + "," + " OSname=SunOS, Release=5.10, Version=Generic_112233-11," + " Machine=sun4u, Cpus=4, Memory=223344, Architecture=sparc," + " IPaddress=10.8.11.73 fe80::a00:20ff:fec4:75b0");
        return si;
    }

    public PkgInfo[] getPkgInfo() throws SamFSException {
        return new PkgInfo[]{new PkgInfo("PKGINST=SUNWsamfsr,NAME=Sun SAM-FS and Sun SAM-QFS software Solaris 10 (root),CATEGORY=system,ARCH=sparc,VERSION=4.4 REV debug REV 5.10.2005.02.24,VENDOR=Sun Microsystems  Inc.,DESC=Storage and Archive Manager File System,PSTAMP=superball-mn20050224105009,INSTDATE=Feb 25 2005 09:39,HOTLINE=Please contact your local service provider,STATUS=0"), new PkgInfo("PKGINST=SUNWsamfsu,NAME=Sun SAM-FS and Sun SAM-QFS software Solaris 10 (usr),CATEGORY=system,ARCH=sparc,VERSION=4.4 REV debug REV 5.10.2005.02.24,VENDOR=Sun Microsystems  Inc.,DESC=Storage and Archive Manager File System,PSTAMP=superball-mn20050224105017,INSTDATE=Feb 25 2005 09:43,HOTLINE=Please contact your local service provider,STATUS=0"), new PkgInfo("PKGINST=SUNWfsmgrr,NAME=File System Manager Solaris 10 (root),CATEGORY=unbundled,ARCH=sparc,VERSION=2.0 REV 5.10.2005.05.19,VENDOR=Sun Microsystems Inc.,DESC=File System Manager (WEB-based),PSTAMP=superball-mn20050224105036,INSTDATE=May 19 2005 09:44,HOTLINE=Please contact your local service provider.,STATUS=0"), new PkgInfo("PKGINST=SUNWfsmgru,NAME=File System Manager Solaris 10 (usr),CATEGORY=unbundled,ARCH=sparc,VERSION=2.0 REV 5.10.2005.05.19,VENDOR=Sun Microsystems Inc.,DESC=File System Manager (WEB-based),PSTAMP=superball-mn20050224105058,INSTDATE=May 19 2005 09:52,HOTLINE=Please contact your local service provider.,STATUS=0")};
    }

    public LogAndTraceInfo[] getLogAndTraceInfo() throws SamFSException {
        return new LogAndTraceInfo[]{new LogAndTraceInfo("name=Master automated library daemon, path=, type=Trace, flags=, state=off, size=, modtime="), new LogAndTraceInfo("name=Archiver daemon, path=/var/opt/SUNWsamfs/trace/sam-archiverd, type=Trace, flags=, state=on, size=281, modtime=1116337638"), new LogAndTraceInfo("name=Media catalog daemon, path=, type=Trace, flags=, state=off, size=, modtime="), new LogAndTraceInfo("name=File system daemon, path=, type=Trace, flags=, state=off, size=, modtime="), new LogAndTraceInfo("name=File transfer daemon, path=, type=Trace, flags=, state=off, size=, modtime="), new LogAndTraceInfo("name=Recycler, path=, type=Trace, flags=, state=off, size=, modtime="), new LogAndTraceInfo("name=Shared file system daemon, path=, type=Trace, flags=, state=off, size=, modtime="), new LogAndTraceInfo("name=Stager daemon, path=, type=Trace, flags=, state=off, size=, modtime="), new LogAndTraceInfo("name=SAM-Remote server, path=, type=Trace, flags=, state=off, size=, modtime="), new LogAndTraceInfo("name=SAM-Remote client, path=, type=Trace, flags=, state=off, size=, modtime="), new LogAndTraceInfo("name=Management daemon, path=/var/opt/SUNWsamfs/trace/fsmgmt, type=Trace, flags=, state=on, size=14370000, modtime=1116616564"), new LogAndTraceInfo("name=SAM system log, path=, type=Log, flags=, state=off, size=, modtime="), new LogAndTraceInfo("name=Recycle log, path=/var/tmp/recycler.log, type=Log, flags=, state=on, size=1200, modtime=1075406088"), new LogAndTraceInfo("name=Archive log (global), path=, type=Log, flags=, state=off, size=, modtime="), new LogAndTraceInfo("name=Archive log samfs1, path=/var/tmp/archiver.log, type=Log, flags=, state=on, size=1411, modtime=1116337641"), new LogAndTraceInfo("name=Releaser log (global), path=/var/tmp/releaser.log, type=Log, flags=, state=on, size=5421, modtime=1116340602"), new LogAndTraceInfo("name=Stage log, path=/var/tmp/stager.log, type=Log, flags=, state=on, size=19211, modtime=1116337638"), new LogAndTraceInfo("name=Restore log, path=, type=Log, flags=, state=off, size=, modtime=")};
    }

    public DaemonInfo[] getDaemonInfo() throws SamFSException {
        return new DaemonInfo[]{new DaemonInfo("details=sam-stagealld,description=Stage-all daemon"), new DaemonInfo("details=sam-arfind samfs1,description=File system archive monitor"), new DaemonInfo("details=sam-fsd,description=File system daemon"), new DaemonInfo("details=fsmgmtd,description=Management daemon"), new DaemonInfo("details=sam-archiverd,description=Archiver daemon"), new DaemonInfo("details=arfind samfs2,description=File system archive monitor"), new DaemonInfo("details=sam-stagerd,description=Stager daemon")};
    }

    public ConfigStatus[] getConfigStatus() throws SamFSException {
        return new ConfigStatus[]{new ConfigStatus("config=/etc/opt/SUNWsamfs/mcf, status=OK"), new ConfigStatus("config=/etc/opt/SUNWsamfs/defaults.conf, status=OK"), new ConfigStatus("config=/etc/opt/SUNWsamfs/diskvols.conf, status=OK"), new ConfigStatus("config=/etc/opt/SUNWsamfs/samfs.cmd, status=OK"), new ConfigStatus("config=/etc/opt/SUNWsamfs/archiver.cmd, status=WARNING, message=There are archive policy copies that has no available media. No archiving will be performed for these copies. Go to the copy vsns page for each copy to assign vsns., vsns=samfs1.1"), new ConfigStatus("config=/etc/opt/SUNWsamfs/releaser.cmd, status=OK"), new ConfigStatus("config=/etc/opt/SUNWsamfs/recycler, status=OK"), new ConfigStatus("config=/etc/opt/SUNWsamfs/stager, status=OK")};
    }

    public String[] getConfigStatusDetails(String keyConfig) throws SamFSException {
        return null;
    }

    public ClusterNodeInfo[] getClusterNodes() throws SamFSException {
        ClusterNodeInfo[] nodes = new ClusterNodeInfo[SamQFSAppModelImpl.SC_NODES + 2];
        for (int i = 0; i < SamQFSAppModelImpl.SC_NODES + 2; ++i) {
            nodes[i] = new ClusterNodeInfo(ConversionUtil.strToProps("sc_nodename=scnode" + (i + 1) + ",sc_nodeid=" + (i + 1) + ",sc_nodestatus=UP" + ",sc_nodeprivaddr=clusterpriv" + i));
        }
        return nodes;
    }

    public SamExplorerOutputs[] getSamExplorerOutputs() throws SamFSException {
        SamExplorerOutputs[] outputs = new SamExplorerOutputs[4];
        for (int i = 0; i < 4; ++i) {
            outputs[i] = new SamExplorerOutputs(ConversionUtil.strToProps("path=/tmp/SAMreport.082" + i + "_172" + i + ",name=mySAMExplorerReport" + (i + 1) + ",size=28" + i + ",created=111633763" + i + ",modified=121733763" + i));
        }
        return outputs;
    }

    public void runSamExplorer(String location, int logLines) throws SamFSException {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("=====================================\n");
        buf.append("Hostname: " + this.hostname + "\n");
        try {
            int i;
            FileSystem[] fsList = this.fsManager.getAllFileSystems();
            ArchivePolicy[] policyList = this.archiveManager43.getAllArchivePolicies();
            Library[] libList = this.mediaManager.getAllLibraries();
            buf.append("File Systems:\n");
            for (i = 0; i < fsList.length; ++i) {
                buf.append(fsList[i]);
            }
            buf.append("Archive Policies:\n");
            for (i = 0; i < policyList.length; ++i) {
                buf.append(policyList[i]);
            }
            buf.append("Libraries:\n");
            for (i = 0; i < libList.length; ++i) {
                buf.append(libList[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        buf.append("=====================================\n");
        return buf.toString();
    }

    public SamQFSSystemFSManager getSamQFSSystemFSManager() {
        if (this.fsManager == null) {
            this.fsManager = new SamQFSSystemFSManagerImpl(this);
        }
        return this.fsManager;
    }

    public SamQFSSystemArchiveManager getSamQFSSystemArchiveManager() {
        if (this.archiveManager == null) {
            this.archiveManager = new SamQFSSystemArchiveManagerImpl(this);
        }
        return this.archiveManager;
    }

    public SamQFSSystemArchiveManager43 getSamQFSSystemArchiveManager43() {
        if (this.archiveManager43 == null) {
            this.archiveManager43 = new SamQFSSystemArchiveManager43Impl(this);
        }
        return this.archiveManager43;
    }

    public SamQFSSystemMediaManager getSamQFSSystemMediaManager() {
        if (this.mediaManager == null) {
            this.mediaManager = new SamQFSSystemMediaManagerImpl(this);
        }
        return this.mediaManager;
    }

    public SamQFSSystemJobManager getSamQFSSystemJobManager() {
        if (this.jobManager == null) {
            this.jobManager = new SamQFSSystemJobManagerImpl(this);
        }
        return this.jobManager;
    }

    public SamQFSSystemAlarmManager getSamQFSSystemAlarmManager() {
        if (this.alarmManager == null) {
            this.alarmManager = new SamQFSSystemAlarmManagerImpl(this);
        }
        return this.alarmManager;
    }

    public SamQFSSystemAdminManager getSamQFSSystemAdminManager() {
        if (this.adminManager == null) {
            this.adminManager = new SamQFSSystemAdminManagerImpl(this);
        }
        return this.adminManager;
    }

    public ArrayList getAvailableAUs() {
        return this.availableAUs;
    }

    public HashMap getEqMap() {
        return this.eqMap;
    }

    public void addDrive(Drive drive) throws SamFSException {
        int driveEQ = -1;
        try {
            driveEQ = drive.getEquipOrdinal();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (driveEQ == -1) {
            ++this.eqCounter;
            drive.setEquipOrdinal(this.eqCounter);
            driveEQ = this.eqCounter;
        } else {
            Object o = this.eqMap.get(new Integer(driveEQ));
            if (o != null) {
                throw new SamFSException("EQ_IN_USE");
            }
        }
        Integer key = new Integer(driveEQ);
        this.eqMap.put(key, drive);
        this.driveMap.put(drive.getDevicePath(), drive);
    }

    public void removeDrive(Drive drive) throws SamFSException {
        int driveEQ = -1;
        try {
            driveEQ = drive.getEquipOrdinal();
        }
        catch (Exception e) {
            // empty catch block
        }
        Integer key = new Integer(driveEQ);
        this.eqMap.remove(key);
        this.driveMap.remove(drive.getDevicePath());
    }

    public HashMap getPolicyMap() {
        return this.policyMap;
    }

    public HashMap getBufferDir() {
        return this.bufferDir;
    }

    public HashMap getLibStageDriveDir() {
        return this.libStageDriveDir;
    }

    public HashMap getLibRecParams() {
        return this.libRecParams;
    }

    public ArrayList getAlarms() {
        return this.alarms;
    }

    public void setAvailableAUs(ArrayList aus) {
        this.availableAUs = aus;
    }

    public boolean doesFileExist(String filePath) throws SamFSException {
        return filePath != null && !filePath.startsWith("/tmp");
    }

    public boolean isAccessDenied() {
        return false;
    }

    public boolean isServerSupported() {
        return this.getServerAPIVersion().compareTo("1.3") >= 0;
    }
}

