/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.media.StkClntConn;
import com.sun.netstorage.samqfs.mgmt.media.StkDevice;
import com.sun.netstorage.samqfs.mgmt.media.StkNetLibParam;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemMediaManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.alarm.Alarm;
import com.sun.netstorage.samqfs.web.model.archive43.BufferDirective;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSAppModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.BufferDirectiveImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.DriveDirectiveImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.RecycleParamsImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.BaseDeviceImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.DiskVolumeImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.DriveImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.LibraryImpl;
import com.sun.netstorage.samqfs.web.model.media.DiskVolume;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SamQFSSystemMediaManagerImpl
implements SamQFSSystemMediaManager {
    SamQFSSystemModelImpl theModel;
    private ArrayList availableStdaloneDrives = new ArrayList();
    private ArrayList availableLibraries = new ArrayList();
    private ArrayList availableStkLibraries = new ArrayList();
    private int netAttachedLibStartEQ = 111;
    private HashMap libMap = new HashMap();
    private HashMap standaloneDriveMap = new HashMap();

    public SamQFSSystemMediaManagerImpl(SamQFSSystemModel model) {
        this.theModel = (SamQFSSystemModelImpl)model;
    }

    public int[] getAvailableMediaTypes() throws SamFSException {
        int[] mediaTypes = null;
        BufferDirective[] bufs = this.theModel.getSamQFSSystemArchiveManager43().getStagerBufDirectives();
        mediaTypes = bufs == null ? new int[]{} : new int[bufs.length];
        if (bufs != null) {
            for (int i = 0; i < bufs.length; ++i) {
                mediaTypes[i] = bufs[i].getMediaType();
            }
        }
        return mediaTypes;
    }

    public int[] getAvailableArchiveMediaTypes() throws SamFSException {
        int[] mediaTypes = this.getAvailableMediaTypes();
        int[] result = new int[mediaTypes.length + 1];
        result[0] = 133;
        int i = 0;
        int j = 1;
        while (i < mediaTypes.length) {
            result[j] = mediaTypes[i];
            ++i;
            ++j;
        }
        return result;
    }

    public Drive[] discoverStandAloneDrives() throws SamFSException {
        return this.availableStdaloneDrives.toArray(new Drive[0]);
    }

    public Library[] discoverLibraries() throws SamFSException {
        return this.availableLibraries.toArray(new Library[0]);
    }

    public Library[] discoverSTKLibraries(StkClntConn[] conns) throws SamFSException {
        if (conns == null || conns.length == 0) {
            return new Library[0];
        }
        int acsPort = -1;
        String acsHostName = conns[0].getAcsServerName();
        try {
            acsPort = Integer.parseInt(conns[0].getAcsPort());
        }
        catch (NumberFormatException numEx) {
            System.out.println("ACS PORT NEEDS to be an integer!");
            return new Library[0];
        }
        String vendor = "StorageTek";
        String serialNo = "12345678";
        Library[] myLibraries = new Library[2];
        for (int i = 0; i < myLibraries.length; ++i) {
            int mediaType = i == 0 ? 124 : 109;
            String driveProductId = i == 0 ? "STK 3480" : "STK 9490";
            Library lib = SamQFSAppModelImpl.createLibrary("myLibrary", mediaType, 2, vendor, driveProductId, "4.0", 10, 2, "STK Timberwolf", "aa623656ccbbdd00");
            StkDevice[] devices = new StkDevice[2];
            for (int j = 0; j < devices.length; ++j) {
                String drvPath = "/dev/rmt/" + i * 1000 + "cbn";
                devices[i] = new StkDevice(drvPath, false);
            }
            StkNetLibParam stkParam = new StkNetLibParam("", acsHostName, acsPort, devices);
            lib.setStkNetLibParam(stkParam);
            Drive[] drvs = lib.getDrives();
            for (int j = 0; j < 2; ++j) {
                ((BaseDeviceImpl)((Object)drvs[j])).setDevicePath("/dev/rmt/" + (j + this.netAttachedLibStartEQ) + "cbn");
            }
            ((LibraryImpl)lib).setName("");
            ((LibraryImpl)lib).setParamFileLocation("");
            ((LibraryImpl)lib).setCatalogLocation("");
            ((LibraryImpl)lib).setDriverType(1002);
            myLibraries[i] = lib;
        }
        return myLibraries;
    }

    public Library discoverNetworkLibrary(String libName, int mediaType, String catalog, String paramFile, int ordinal) throws SamFSException {
        String vendor = new String();
        String driveProductId = new String();
        String librayProductId = new String();
        switch (mediaType) {
            case 117: {
                vendor = "Storage Tek";
                driveProductId = "STK li40";
                librayProductId = "STK 949";
                break;
            }
            case 118: {
                vendor = "ADIC";
                driveProductId = "ADIC li40";
                librayProductId = "ADIC 949";
                break;
            }
            case 119: {
                vendor = "SONY";
                driveProductId = "SONY li40";
                librayProductId = "SONY 949";
                break;
            }
            case 120: {
                vendor = "Fujitsu";
                driveProductId = "Fujitsu li40";
                librayProductId = "Fujitsu 949";
                break;
            }
            case 121: {
                vendor = "IBM";
                driveProductId = "IBM li40";
                librayProductId = "IBM 949";
            }
        }
        Library lib = SamQFSAppModelImpl.createLibrary(libName, mediaType, 10, vendor, driveProductId, "8.7", 10, 2, librayProductId, "aa623656ccbbdd00");
        Drive[] drvs = lib.getDrives();
        for (int i = 0; i < 10; ++i) {
            ((BaseDeviceImpl)((Object)drvs[i])).setDevicePath("/dev/rmt/" + (i + this.netAttachedLibStartEQ) + "cbn");
        }
        ((LibraryImpl)lib).setParamFileLocation(paramFile);
        ((LibraryImpl)lib).setCatalogLocation(catalog);
        lib.setEquipOrdinal(ordinal);
        return lib;
    }

    public Library[] getAllLibraries() throws SamFSException {
        return this.libMap.values().toArray(new Library[0]);
    }

    public Library getLibraryByName(String libraryName) throws SamFSException {
        return (Library)this.libMap.get(libraryName);
    }

    public Library getLibraryByEQ(int libraryEQ) throws SamFSException {
        return (Library)this.theModel.getEqMap().get(new Integer(libraryEQ));
    }

    public void addLibrary(Library library) throws SamFSException {
        if (library == null) {
            throw new SamFSException("INVALID_LIBRARY");
        }
        Drive[] drives = library.getDrives();
        for (int i = 0; i < drives.length; ++i) {
            this.theModel.addDrive(drives[i]);
            ((DriveImpl)drives[i]).setLibrary(library);
        }
        int libEQ = -1;
        try {
            libEQ = library.getEquipOrdinal();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (libEQ == -1) {
            ++this.theModel.eqCounter;
            library.setEquipOrdinal(this.theModel.eqCounter);
            ((LibraryImpl)library).setFamilySetEquipOrdinal(this.theModel.eqCounter);
            libEQ = this.theModel.eqCounter;
            for (int i = 0; i < drives.length; ++i) {
                ((DriveImpl)drives[i]).setFamilySetEquipOrdinal(libEQ);
            }
        } else {
            Object o = this.theModel.getEqMap().get(new Integer(libEQ));
            if (o != null) {
                throw new SamFSException("EQ_IN_USE");
            }
        }
        Integer key = new Integer(libEQ);
        this.theModel.getEqMap().put(key, library);
        this.libMap.put(library.getName(), library);
        BufferDirective buf = library.getBufferDirective();
        if (buf == null) {
            throw new SamFSException("BUFFER_DIRECTIVE_MISSING");
        }
        Object o = this.theModel.getBufferDir().get(new Integer(buf.getMediaType()));
        if (o == null) {
            this.theModel.getBufferDir().put(new Integer(buf.getMediaType()), buf);
        } else {
            ((LibraryImpl)library).setBufferDirective((BufferDirectiveImpl)o);
            ((BufferDirectiveImpl)o).addLibrary(library);
        }
        DriveDirectiveImpl drvDir = (DriveDirectiveImpl)library.getDriveDirective();
        if (drvDir == null) {
            drvDir = new DriveDirectiveImpl(library, -1);
            ((LibraryImpl)library).setDriveDirective(drvDir);
        }
        this.theModel.getLibStageDriveDir().put(key, drvDir);
        RecycleParamsImpl recParams = (RecycleParamsImpl)library.getRecycleParams();
        if (recParams == null) {
            recParams = new RecycleParamsImpl();
            recParams.setLibrary(library);
            ((LibraryImpl)library).setRecycleParams(recParams);
        }
        this.theModel.getLibRecParams().put(key, recParams);
        int index = this.availableLibraries.indexOf(library);
        if (index != -1) {
            this.availableLibraries.remove(index);
        }
    }

    public void addLibraries(Library[] libraries) throws SamFSException {
        if (libraries == null || libraries.length == 0) {
            throw new SamFSException("INVALID_LIBRARY");
        }
        for (int i = 0; i < libraries.length; ++i) {
            if (libraries[i] == null) {
                throw new SamFSException("INVALID_LIBRARY");
            }
            this.addLibrary(libraries[i]);
        }
    }

    public void addLibrary(Library library, Drive[] drives) throws SamFSException {
        if (library == null) {
            throw new SamFSException("INVALID_LIBRARY");
        }
        int libEQ = -1;
        try {
            libEQ = library.getEquipOrdinal();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (libEQ == -1) {
            ++this.theModel.eqCounter;
            library.setEquipOrdinal(this.theModel.eqCounter);
            ((LibraryImpl)library).setFamilySetEquipOrdinal(this.theModel.eqCounter);
            libEQ = this.theModel.eqCounter;
            for (int i = 0; i < drives.length; ++i) {
                ((DriveImpl)drives[i]).setFamilySetEquipOrdinal(libEQ);
            }
        } else {
            Object o = this.theModel.getEqMap().get(new Integer(libEQ));
            if (o != null) {
                throw new SamFSException("EQ_IN_USE");
            }
        }
        Integer key = new Integer(libEQ);
        this.theModel.getEqMap().put(key, library);
        this.libMap.put(library.getName(), library);
        BufferDirective buf = library.getBufferDirective();
        if (buf == null) {
            throw new SamFSException("BUFFER_DIRECTIVE_MISSING");
        }
        Object o = this.theModel.getBufferDir().get(new Integer(buf.getMediaType()));
        if (o == null) {
            this.theModel.getBufferDir().put(new Integer(buf.getMediaType()), buf);
        } else {
            ((LibraryImpl)library).setBufferDirective((BufferDirectiveImpl)o);
            ((BufferDirectiveImpl)o).addLibrary(library);
        }
        DriveDirectiveImpl drvDir = (DriveDirectiveImpl)library.getDriveDirective();
        if (drvDir == null) {
            drvDir = new DriveDirectiveImpl(library, -1);
            ((LibraryImpl)library).setDriveDirective(drvDir);
        }
        this.theModel.getLibStageDriveDir().put(key, drvDir);
        RecycleParamsImpl recParams = (RecycleParamsImpl)library.getRecycleParams();
        if (recParams == null) {
            recParams = new RecycleParamsImpl();
            recParams.setLibrary(library);
            ((LibraryImpl)library).setRecycleParams(recParams);
        }
        this.theModel.getLibRecParams().put(key, recParams);
        int index = this.availableLibraries.indexOf(library);
        if (index != -1) {
            this.availableLibraries.remove(index);
        }
    }

    public void addNetworkLibrary(Library library, Drive[] includedDrives) throws SamFSException {
        ((LibraryImpl)library).setDrives(includedDrives);
        this.addLibrary(library);
        this.netAttachedLibStartEQ += 10;
    }

    public void removeLibrary(Library library) throws SamFSException {
        int i;
        if (library == null) {
            throw new SamFSException("INVALID_LIBRARY");
        }
        int libEQ = -1;
        try {
            libEQ = library.getEquipOrdinal();
        }
        catch (Exception e) {
            // empty catch block
        }
        Integer key = new Integer(libEQ);
        this.theModel.getLibRecParams().remove(key);
        this.theModel.getLibStageDriveDir().remove(key);
        Integer bufKey = new Integer(library.getBufferDirective().getMediaType());
        BufferDirectiveImpl buf = (BufferDirectiveImpl)this.theModel.getBufferDir().get(bufKey);
        buf.removeLibrary(library);
        if (buf.getNoOfLibraries() == 0) {
            this.theModel.getBufferDir().remove(bufKey);
        }
        Drive[] drives = library.getDrives();
        for (int i2 = 0; i2 < drives.length; ++i2) {
            this.theModel.removeDrive(drives[i2]);
        }
        Alarm[] alarm = library.getAssociatedAlarms();
        if (alarm != null) {
            for (i = 0; i < alarm.length; ++i) {
                int index = this.theModel.getAlarms().indexOf(alarm[i]);
                if (index == -1) continue;
                this.theModel.getAlarms().remove(index);
            }
        }
        this.libMap.remove(library.getName());
        this.theModel.getEqMap().remove(key);
        drives = library.getDrives();
        for (i = 0; i < drives.length; ++i) {
            drives[i].setEquipOrdinal(-1);
        }
        library.setEquipOrdinal(-1);
        this.availableLibraries.add(library);
    }

    public Drive[] getAllStandAloneDrives() throws SamFSException {
        return this.standaloneDriveMap.values().toArray(new Drive[0]);
    }

    public Drive getStdAloneDrvByPath(String drivePath) throws SamFSException {
        return (Drive)this.standaloneDriveMap.get(drivePath);
    }

    public Drive getStdAloneByEQ(int driveEQ) throws SamFSException {
        return (Drive)this.theModel.getEqMap().get(new Integer(driveEQ));
    }

    public void addStandAloneDrive(Drive drive) throws SamFSException {
        this.theModel.addDrive(drive);
        int driveEQ = -1;
        try {
            driveEQ = drive.getEquipOrdinal();
        }
        catch (Exception e) {
            // empty catch block
        }
        Integer key = new Integer(driveEQ);
        this.standaloneDriveMap.put(drive.getDevicePath(), drive);
        int index = this.availableStdaloneDrives.indexOf(drive);
        if (index != -1) {
            this.availableStdaloneDrives.remove(index);
        }
    }

    public void removeStandAloneDrive(Drive drive) throws SamFSException {
        int driveEQ = -1;
        try {
            driveEQ = drive.getEquipOrdinal();
        }
        catch (Exception e) {
            // empty catch block
        }
        Integer key = new Integer(driveEQ);
        Object o = this.standaloneDriveMap.get(drive.getDevicePath());
        if (o == null) {
            throw new SamFSException("NO_SUCH_STANDALONE_DRIVE_FOUND");
        }
        this.theModel.removeDrive(drive);
        this.standaloneDriveMap.remove(drive.getDevicePath());
        this.availableStdaloneDrives.add(drive);
    }

    public void addAvailableStandAloneDrive(Drive drive) throws SamFSException {
        this.availableStdaloneDrives.add(drive);
    }

    public VSN[] searchVSNInLibraries(String vsnName) throws SamFSException {
        ArrayList<VSN> vsnList = new ArrayList<VSN>();
        Library[] lib = this.getAllLibraries();
        if (lib != null && lib.length > 0) {
            for (int i = 0; i < lib.length; ++i) {
                VSN vsn = lib[i].getVSN(vsnName);
                if (vsn == null) continue;
                vsnList.add(vsn);
            }
        }
        return vsnList.toArray(new VSN[0]);
    }

    protected void setAvailableDrives(ArrayList availableStdaloneDrives) {
        this.availableStdaloneDrives = availableStdaloneDrives;
    }

    protected void setAvailableLibraries(ArrayList availableLibraries) {
        this.availableLibraries = availableLibraries;
    }

    protected void setAvailableStkLibraries(ArrayList availableStkLibraries) {
        this.availableStkLibraries = availableStkLibraries;
    }

    public VSN searchVSNInStandAloneDrive(String vsnString, int eq) throws SamFSException {
        VSN[] allvsns = this.searchVSNInLibraries(vsnString);
        VSN currentVSN = null;
        if (allvsns != null) {
            for (int i = 0; i < allvsns.length; ++i) {
                if (allvsns[i].getDrive().getEquipOrdinal() != eq) continue;
                currentVSN = allvsns[i];
                break;
            }
        }
        return currentVSN;
    }

    public DiskVolume[] getDiskVSNs() throws SamFSException {
        List vsnList = this.getDiskVSNList();
        DiskVolume[] vsns = new DiskVolume[vsnList.size()];
        vsns = vsnList.toArray(vsns);
        return vsns;
    }

    public DiskVolume getDiskVSN(String name) throws SamFSException {
        DiskVolume[] volumes = this.getDiskVSNs();
        DiskVolume volume = null;
        boolean found = false;
        for (int i = 0; i < volumes.length && !found; ++i) {
            if (!volumes[i].getName().equals(name)) continue;
            volume = volumes[i];
            found = true;
        }
        return volume;
    }

    public void createDiskVSN(String name, String remoteHost, String path) throws SamFSException {
        List vsnList = this.getDiskVSNList();
        vsnList.add(new DiskVolumeImpl(name, remoteHost, path));
        RequestManager.getRequestContext().getServletContext().setAttribute("DISK_VSNS", (Object)vsnList);
    }

    public void updateDiskVSNFlags(DiskVolume volume) throws SamFSException {
    }

    private List getDiskVSNList() {
        List vsns = (List)RequestManager.getRequestContext().getServletContext().getAttribute("DISK_VSNS");
        if (vsns == null) {
            vsns = this.initDiskVSNs();
        }
        return vsns;
    }

    private List initDiskVSNs() {
        ArrayList<DiskVolumeImpl> vsnList = new ArrayList<DiskVolumeImpl>();
        for (int i = 0; i < 3; ++i) {
            vsnList.add(new DiskVolumeImpl("dv200" + i, "ns-east-" + i * i, "/opt/diskvsns"));
        }
        RequestManager.getRequestContext().getServletContext().setAttribute("DISK_VSNS", vsnList);
        return vsnList;
    }
}

