/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemArchiveManager43;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopyGUIWrapper;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaProp;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.archive43.BufferDirective;
import com.sun.netstorage.samqfs.web.model.archive43.DriveDirective;
import com.sun.netstorage.samqfs.web.model.archive43.FSArchiveDirective;
import com.sun.netstorage.samqfs.web.model.archive43.GlobalArchiveDirective;
import com.sun.netstorage.samqfs.web.model.archive43.RecycleParams;
import com.sun.netstorage.samqfs.web.model.archive43.VSNPool;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchiveCopyGUIWrapperImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchiveCopyImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchivePolCriteriaCopyImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchivePolCriteriaImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchivePolCriteriaPropImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchivePolicyImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.DriveDirectiveImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.GlobalArchiveDirectiveImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.RecycleParamsImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.VSNPoolImpl;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import java.util.ArrayList;
import java.util.HashMap;

public class SamQFSSystemArchiveManager43Impl
implements SamQFSSystemArchiveManager43 {
    private SamQFSSystemModelImpl theModel = null;
    private HashMap vsnPoolMap = new HashMap();
    private HashMap policyMap = new HashMap();
    private HashMap fsDirMap = new HashMap();
    private GlobalArchiveDirectiveImpl globalArch = new GlobalArchiveDirectiveImpl();
    private String stagerLog = "/var/opt/SUNWsamfs/stageLog";
    private String releaseLog = "/var/opt/SUNWsamfs/releaseLog";
    private String releaseAge = "36H";
    private String recycleLog = "/var/opt/SUNWsamfs/recycleLog";
    private int postRecycleOpt = 1;

    public SamQFSSystemArchiveManager43Impl(SamQFSSystemModel model) {
        this.theModel = (SamQFSSystemModelImpl)model;
    }

    public GlobalArchiveDirective getGlobalDirective() throws SamFSException {
        return this.globalArch;
    }

    public void setGlobalDirective(GlobalArchiveDirective global) throws SamFSException {
        this.globalArch = (GlobalArchiveDirectiveImpl)global;
    }

    public FSArchiveDirective[] getFSGeneralArchiveDirective() throws SamFSException {
        return this.fsDirMap.values().toArray(new FSArchiveDirective[0]);
    }

    public void addFSGeneralArchiveDirective(FSArchiveDirective dir) {
        this.fsDirMap.put(dir.getFileSystemName(), dir);
    }

    public void removeFSGeneralArchiveDirective(String fsName) {
        this.fsDirMap.remove(fsName);
    }

    public boolean isValidGroup(String groupName) throws SamFSException {
        return true;
    }

    public boolean isValidUser(String userName) throws SamFSException {
        return true;
    }

    public String[] getAllArchivePolicyNames() throws SamFSException {
        String[] names = new String[]{};
        ArchivePolicy[] pols = this.getAllArchivePolicies();
        if (pols != null) {
            names = new String[pols.length];
            for (int i = 0; i < pols.length; ++i) {
                names[i] = pols[i].getPolicyName();
            }
        }
        return names;
    }

    public ArchivePolicy[] getAllArchivePolicies() throws SamFSException {
        return this.policyMap.values().toArray(new ArchivePolicy[0]);
    }

    public ArchivePolicy getArchivePolicy(String policyName) throws SamFSException {
        return (ArchivePolicy)this.policyMap.get(policyName);
    }

    public ArchivePolCriteriaProp getDefaultArchivePolCriteriaProperties() {
        return new ArchivePolCriteriaPropImpl();
    }

    public ArchiveCopyGUIWrapper getArchiveCopyGUIWrapper() {
        return new ArchiveCopyGUIWrapperImpl();
    }

    public ArchivePolicy createArchivePolicy(String policyName, ArchivePolCriteriaProp prop, ArchiveCopyGUIWrapper[] copies, String[] fsNames) throws SamFSException {
        int policyType = 1002;
        if (policyName.equals("no_archive")) {
            policyType = 1003;
        }
        return this.createArchivePolicy(policyName, policyType, prop, copies, fsNames);
    }

    public ArchivePolicy createArchivePolicy(String policyName, int policyType, ArchivePolCriteriaProp prop, ArchiveCopyGUIWrapper[] copies, String[] fsNames) throws SamFSException {
        int i;
        int i2;
        if (!SamQFSUtil.isValidString(policyName)) {
            throw new SamFSException("logic.invalidPolName");
        }
        ArchivePolicy existingPol = this.getArchivePolicy(policyName);
        if (existingPol != null) {
            throw new SamFSException("logic.existingPol");
        }
        if (!(policyType != 1003 && policyType != 1002 || fsNames != null && fsNames.length != 0)) {
            throw new SamFSException("logic.oneFSNeededForPol");
        }
        ArchivePolicyImpl policy = new ArchivePolicyImpl();
        policy.setPolicyName(policyName);
        policy.setModel(this.theModel);
        policy.setPolicyType(policyType);
        ArchivePolCriteriaImpl polCrit = new ArchivePolCriteriaImpl();
        polCrit.setArchivePolicy(policy);
        polCrit.setIndex(0);
        if (prop != null) {
            prop.setArchivePolCriteria(polCrit);
        }
        polCrit.setArchivePolCriteriaProperties(prop);
        ArchivePolCriteriaCopy[] polCritCopies = new ArchivePolCriteriaCopyImpl[copies.length];
        ArchiveCopyImpl[] polCopies = new ArchiveCopyImpl[copies.length];
        for (i2 = 0; i2 < copies.length; ++i2) {
            polCritCopies[i2] = (ArchivePolCriteriaCopyImpl)copies[i2].getArchivePolCriteriaCopy();
            ((ArchivePolCriteriaCopyImpl)polCritCopies[i2]).setArchivePolCriteriaCopyNumber(i2 + 1);
            ((ArchivePolCriteriaCopyImpl)polCritCopies[i2]).setArchivePolCriteria(polCrit);
            polCopies[i2] = (ArchiveCopyImpl)copies[i2].getArchiveCopy();
            polCopies[i2].setCopyNumber(i2 + 1);
        }
        polCrit.setArchivePolCriteriaCopies(polCritCopies);
        for (i2 = 0; i2 < fsNames.length; ++i2) {
            polCrit.addFileSystemForCriteria(fsNames[i2]);
        }
        ArchivePolCriteria[] tempCritArray = new ArchivePolCriteria[]{polCrit};
        policy.setArchivePolCriteria(tempCritArray);
        for (i = 0; i < copies.length; ++i) {
            policy.addArchiveCopy(polCopies[i]);
        }
        if (policyType == 1003 || policyType == 1002) {
            for (i = 0; i < fsNames.length; ++i) {
                FileSystem fs2 = this.theModel.getSamQFSSystemFSManager().getFileSystem(fsNames[i]);
                if (fs2 == null) continue;
                fs2.addPolCriteria(tempCritArray);
            }
        }
        this.policyMap.put(policyName, policy);
        return policy;
    }

    public void deleteArchivePolicy(ArchivePolicy pol) throws SamFSException {
        if (pol == null) {
            throw new SamFSException("INVALID_POLICY");
        }
        ArchivePolCriteria[] crits = pol.getArchivePolCriteria();
        if (crits != null) {
            for (int i = 0; i < crits.length; ++i) {
                FileSystem[] fs2 = crits[i].getFileSystemsForCriteria();
                ArchivePolCriteria[] oneCrit = new ArchivePolCriteria[]{crits[i]};
                if (fs2 == null) continue;
                for (int j = 0; j < fs2.length; ++j) {
                    fs2[j].removePolCriteria(oneCrit);
                }
            }
        }
        this.policyMap.remove(pol.getPolicyName());
    }

    public void deleteArchivePolicy(String policyName) throws SamFSException {
        if (!SamQFSUtil.isValidString(policyName)) {
            throw new SamFSException("INVALID_POLICY");
        }
        ArchivePolicy pol = this.getArchivePolicy(policyName);
        this.deleteArchivePolicy(pol);
    }

    public String[] getAllPoolNames() throws SamFSException {
        VSNPool[] pools = this.getAllVSNPools();
        String[] names = new String[]{};
        if (pools != null) {
            names = new String[pools.length];
            for (int i = 0; i < pools.length; ++i) {
                names[i] = pools[i].getPoolName();
            }
        }
        return names;
    }

    public VSNPool[] getAllVSNPools() throws SamFSException {
        return this.vsnPoolMap.values().toArray(new VSNPool[0]);
    }

    public VSNPool getVSNPool(String poolName) throws SamFSException {
        return (VSNPool)this.vsnPoolMap.get(poolName);
    }

    public VSNPool createVSNPool(String poolName, int mediaType, String vsnExpr) throws SamFSException {
        return this.createVSNPool(poolName, mediaType, vsnExpr, null);
    }

    public VSNPool createVSNPool(String poolName, int mediaType, String vsnExpr, VSN[] memberVSNs) throws SamFSException {
        ArrayList<VSN> vsn = new ArrayList<VSN>(0);
        if (memberVSNs != null) {
            vsn = new ArrayList();
            for (int i = 0; i < memberVSNs.length; ++i) {
                vsn.add(memberVSNs[i]);
            }
        }
        VSNPoolImpl pool = new VSNPoolImpl(poolName, mediaType, vsnExpr, vsn, null);
        this.vsnPoolMap.put(poolName, pool);
        return pool;
    }

    public void updateVSNPool(String poolName) throws SamFSException {
    }

    public boolean isPoolInUse(String poolName) throws SamFSException {
        return false;
    }

    public void deleteVSNPool(VSNPool pool) throws SamFSException {
        if (pool == null) {
            throw new SamFSException("INVALID_POOL");
        }
        this.vsnPoolMap.remove(pool.getPoolName());
    }

    public void deleteVSNPool(String poolName) throws SamFSException {
        this.deleteVSNPool(this.getVSNPool(poolName));
    }

    public ArrayList isDuplicateCriteria(ArchivePolCriteria criteria, String[] fsName, boolean update) throws SamFSException {
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(0, "false");
        return resultList;
    }

    public String getStagerLogFile() throws SamFSException {
        return this.stagerLog;
    }

    public void setStagerLogFile(String logfile) throws SamFSException {
        this.stagerLog = logfile;
    }

    public BufferDirective[] getStagerBufDirectives() throws SamFSException {
        BufferDirective[] bufs = this.theModel.getBufferDir().values().toArray(new BufferDirective[0]);
        ArrayList<BufferDirective> bufList = new ArrayList<BufferDirective>();
        for (int i = 0; i < bufs.length; ++i) {
            if (bufs[i].getMediaType() == 116) continue;
            bufList.add(bufs[i]);
        }
        return bufList.toArray(new BufferDirective[0]);
    }

    public void changeStagerDirective(BufferDirective[] dirs) throws SamFSException {
    }

    public DriveDirective[] getStagerDriveDirectives() throws SamFSException {
        DriveDirectiveImpl[] drvs = this.theModel.getLibStageDriveDir().values().toArray(new DriveDirectiveImpl[0]);
        ArrayList<DriveDirectiveImpl> drvList = new ArrayList<DriveDirectiveImpl>();
        for (int i = 0; i < drvs.length; ++i) {
            if (drvs[i].getLibrary().getBufferDirective().getMediaType() == 116) continue;
            drvList.add(drvs[i]);
        }
        return drvList.toArray(new DriveDirective[0]);
    }

    public void changeStagerDriveDirective(DriveDirective[] dirs) throws SamFSException {
    }

    public String getReleaserLogFile() throws SamFSException {
        return this.releaseLog;
    }

    public void setReleaserLogFile(String logFile) throws SamFSException {
        this.releaseLog = logFile;
    }

    public String getMinReleaseAge() throws SamFSException {
        return this.releaseAge;
    }

    public void setMinReleaseAge(String age) throws SamFSException {
        this.releaseAge = age;
    }

    public String getRecyclerLogFile() throws SamFSException {
        return this.recycleLog;
    }

    public void setRecyclerLogFile(String logFile) throws SamFSException {
        this.recycleLog = logFile;
    }

    public int getPostRecycle() throws SamFSException {
        return this.postRecycleOpt;
    }

    public void setPostRecycle(int postRecycleOpt) throws SamFSException {
        this.postRecycleOpt = postRecycleOpt;
    }

    public RecycleParams[] getRecycleParams() throws SamFSException {
        RecycleParamsImpl[] params = this.theModel.getLibRecParams().values().toArray(new RecycleParamsImpl[0]);
        ArrayList<RecycleParamsImpl> paramList = new ArrayList<RecycleParamsImpl>();
        for (int i = 0; i < params.length; ++i) {
            if (params[i].getLibrary().getBufferDirective().getMediaType() == 116) continue;
            paramList.add(params[i]);
        }
        return paramList.toArray(new RecycleParams[0]);
    }

    public void changeRecycleParams(RecycleParams param) throws SamFSException {
    }

    public void restartArchivingAll() throws SamFSException {
    }

    public void idleArchivingAll() throws SamFSException {
    }

    public void runNowArchivingAll() throws SamFSException {
    }

    public void stopArchivingAll() throws SamFSException {
    }

    public void rerunArchivingAll() throws SamFSException {
    }

    public void runStagingAll() throws SamFSException {
    }

    public void idleStagingAll() throws SamFSException {
    }

    public void restartStagingAll() throws SamFSException {
    }
}

