/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemAlarmManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.alarm.Alarm;
import com.sun.netstorage.samqfs.web.model.alarm.AlarmSummary;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.alarm.AlarmImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.alarm.AlarmSummaryImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.LibraryImpl;
import com.sun.netstorage.samqfs.web.model.media.Library;
import java.util.ArrayList;

public class SamQFSSystemAlarmManagerImpl
implements SamQFSSystemAlarmManager {
    SamQFSSystemModelImpl theModel;
    private ArrayList alarms = new ArrayList();

    public SamQFSSystemAlarmManagerImpl(SamQFSSystemModel model) {
        this.theModel = (SamQFSSystemModelImpl)model;
    }

    public AlarmSummary getAlarmSummary() throws SamFSException {
        int critical = 0;
        int major = 0;
        int minor = 0;
        Alarm[] alarms = this.getAllAlarms();
        for (int i = 0; i < alarms.length; ++i) {
            if (alarms[i].getSeverity() == 0) {
                ++critical;
                continue;
            }
            if (alarms[i].getSeverity() == 1) {
                ++major;
                continue;
            }
            ++minor;
        }
        return new AlarmSummaryImpl(critical, major, minor);
    }

    public Alarm[] getAllAlarms() throws SamFSException {
        return this.alarms.toArray(new Alarm[0]);
    }

    public Alarm getAlarm(long alarmID) throws SamFSException {
        Alarm[] alarms = this.getAllAlarms();
        Alarm alarm = null;
        if (alarms != null) {
            for (int i = 0; i < alarms.length; ++i) {
                if (alarms[i].getAlarmID() != alarmID) continue;
                alarm = alarms[i];
            }
        }
        return alarm;
    }

    public void deleteAlarm(long alarmID) throws SamFSException {
        Alarm alarm = this.getAlarm(alarmID);
        if (alarm != null) {
            Library lib = alarm.getAssociatedLibrary();
            FileSystem fs2 = alarm.getAssociatedFileSystem();
            if (lib != null) {
                ((LibraryImpl)lib).removeAlarm(alarm);
            }
            this.removeAlarm(alarm);
        }
    }

    public void deleteAlarm(long[] alarmIDs) throws SamFSException {
        if (alarmIDs != null) {
            for (int i = 0; i < alarmIDs.length; ++i) {
                this.deleteAlarm(alarmIDs[i]);
            }
        }
    }

    public void acknowledgeAlarm(long[] alarmIDs) throws SamFSException {
        if (alarmIDs != null) {
            for (int i = 0; i < alarmIDs.length; ++i) {
                AlarmImpl alarm = (AlarmImpl)this.getAlarm(alarmIDs[i]);
                if (alarm == null) continue;
                alarm.setStatus(4);
            }
        }
    }

    public void addAlarm(Alarm alarm) throws SamFSException {
        this.removeAlarm(alarm);
        this.alarms.add(alarm);
    }

    public void removeAlarm(Alarm alarm) throws SamFSException {
        int index = this.alarms.indexOf(alarm);
        if (index != -1) {
            this.alarms.remove(index);
        }
    }

    public ArrayList getAlarms() {
        return this.alarms;
    }
}

