/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemAdminManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.admin.Notification;
import com.sun.netstorage.samqfs.web.model.admin.SystemLicense;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.admin.NotificationImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.admin.SystemLicenseImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class SamQFSSystemAdminManagerImpl
implements SamQFSSystemAdminManager {
    SamQFSSystemModelImpl theModel;
    private HashMap notifications = new HashMap();

    public SamQFSSystemAdminManagerImpl(SamQFSSystemModel model) {
        this.theModel = (SamQFSSystemModelImpl)model;
    }

    public Notification[] getAllNotifications() throws SamFSException {
        return this.notifications.values().toArray(new Notification[0]);
    }

    public Notification getNotification(String emailAddress) throws SamFSException {
        return (Notification)this.notifications.get(emailAddress);
    }

    public String getNotificationEmailsForSubject(int subject) throws SamFSException {
        if (subject != 1 && subject != 0 && subject != 4 && subject != 5 && subject != 2 && subject != 3) {
            throw new SamFSException("Invalid notification subject: " + String.valueOf(subject));
        }
        Collection notifCol = this.notifications.values();
        Iterator iter = notifCol.iterator();
        NonSyncStringBuffer emails = new NonSyncStringBuffer();
        while (iter.hasNext()) {
            Notification notif = (Notification)iter.next();
            boolean hasSubject = false;
            switch (subject) {
                case 1: {
                    if (!notif.isArchiverInterruptNotify()) break;
                    hasSubject = true;
                    break;
                }
                case 0: {
                    if (!notif.isDeviceDownNotify()) break;
                    hasSubject = true;
                    break;
                }
                case 4: {
                    if (!notif.isDumpInterruptNotify()) break;
                    hasSubject = true;
                    break;
                }
                case 5: {
                    if (!notif.isFsNospaceNotify()) break;
                    hasSubject = true;
                    break;
                }
                case 2: {
                    if (!notif.isReqMediaNotify()) break;
                    hasSubject = true;
                    break;
                }
                case 3: {
                    if (!notif.isRecycleNotify()) break;
                    hasSubject = true;
                }
            }
            if (!hasSubject) continue;
            emails.appendDelimited(",", (Object)notif.getEmailAddress());
        }
        return emails.toString();
    }

    public Notification createNotification(String name, String emailAddress, boolean devDown, boolean archIntr, boolean reqMedia, boolean recycle) throws SamFSException {
        NotificationImpl n = new NotificationImpl(name, emailAddress, devDown, archIntr, reqMedia, recycle);
        this.notifications.remove(emailAddress);
        this.notifications.put(emailAddress, n);
        return n;
    }

    public Notification createNotification(String name, String emailAddress, boolean devDown, boolean archIntr, boolean reqMedia, boolean recycle, boolean dumpIntr, boolean fsNospace) throws SamFSException {
        NotificationImpl n = new NotificationImpl(name, emailAddress, devDown, archIntr, reqMedia, recycle, dumpIntr, fsNospace);
        this.notifications.remove(emailAddress);
        this.notifications.put(emailAddress, n);
        return n;
    }

    public void editNotification(Notification notification) throws SamFSException {
        this.notifications.remove(notification.getEmailAddress());
        this.notifications.put(notification.getEmailAddress(), notification);
    }

    public void deleteNotification(Notification notification) throws SamFSException {
        this.notifications.remove(notification.getEmailAddress());
    }

    public SystemLicense getLicense() throws SamFSException {
        SystemLicenseImpl license = new SystemLicenseImpl(3);
        return license;
    }

    public String[] tailFile(String path, int maxLines) throws SamFSException {
        return new String[]{"This machine is now running in simulator mode.", "You will see the real content of the log/trace file in a real setup.", "If you are launching this window from the view log/trace section,", "this popup window is capable of auto-refresh.", "Simply select a value in the auto refresh time interval drop down menu."};
    }

    public String[] getTxtFile(String path, int start, int end) throws SamFSException {
        String[] reportStrs = new String[200];
        String lineZero = "This machine is now running in simulator mode.";
        String lineOne = "You will see the real content of the SAM Explorer report in a real setup.";
        for (int i = 0; i < 200; ++i) {
            reportStrs[i] = start == 0 && i == 0 ? lineZero : (start == 0 && i == 1 ? lineOne : "This is Line " + (i + 1 + start));
        }
        return reportStrs;
    }
}

