/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator;

import com.iplanet.jato.model.DefaultModel;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.media.StkDevice;
import com.sun.netstorage.samqfs.mgmt.media.StkNetLibParam;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemSharedFSManager;
import com.sun.netstorage.samqfs.web.model.alarm.Alarm;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopyGUIWrapper;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.archive43.VSNPool;
import com.sun.netstorage.samqfs.web.model.fs.DumpSched;
import com.sun.netstorage.samqfs.web.model.fs.DumpSchedDateTimeModel;
import com.sun.netstorage.samqfs.web.model.fs.DumpSchedRetention;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;
import com.sun.netstorage.samqfs.web.model.fs.NFSOptions;
import com.sun.netstorage.samqfs.web.model.fs.SharedMember;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemAlarmManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemArchiveManager43Impl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemFSManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemJobManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemMediaManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemSharedFSManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.simulator.alarm.AlarmImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchiveCopyGUIWrapperImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchiveCopyImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchivePolCriteriaCopyImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchivePolCriteriaImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchivePolCriteriaPropImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchivePolicyImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.ArchiveVSNMapImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.BufferDirectiveImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.DriveDirectiveImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.GlobalArchiveDirectiveImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.archive43.RecycleParamsImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.fs.FileSystemImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.fs.GenericFileSystemImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.ArchiveJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.ArchiveScanJobDataImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.ArchiveScanJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.BaseJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.FSDumpJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.LabelJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.MountJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.ReleaseJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.SamfsckJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.StageJobFileDataImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.job.StageJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.BaseDeviceImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.DiskCacheImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.DriveImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.LibraryImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.VSNImpl;
import com.sun.netstorage.samqfs.web.model.job.StageJobFileData;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.model.media.SharedDiskCache;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;

public class SamQFSAppModelImpl
extends DefaultModel
implements SamQFSAppModel {
    public static int SC_NODES = 2;
    private static final int INIT_AU_NO_PER_TYPE = 25;
    private static int alarmCounter = 100;
    private HashMap map = new HashMap();
    private HashMap nfsFilesMap = new HashMap();
    private boolean dumpOn = false;
    private SamQFSSystemSharedFSManager sharedFSManager = null;

    public SamQFSAppModelImpl() throws SamFSException {
    }

    public SamQFSAppModelImpl(int noOfHosts) throws SamFSException {
        for (int i = 0; i < noOfHosts; ++i) {
            int j = 91 + i * 3 + i * i * 7;
            int no = 1;
            if (i == 0 || i == 1) {
                no = 2;
            }
            String[] ipAddresses = new String[no];
            for (int k = 0; k < no; ++k) {
                ipAddresses[k] = "10.8.11." + (j + k);
            }
            if (i >= noOfHosts - SC_NODES) {
                int node = SC_NODES - (noOfHosts - i) + 1;
                this.populateHost("scnode" + node, ipAddresses);
                continue;
            }
            this.populateHost("ns-east-" + j, ipAddresses);
        }
        noOfHosts -= SC_NODES;
        SamQFSSystemModel[] models = this.getAllSamQFSSystemModels();
        for (int i = 0; i < models.length; ++i) {
            if (models[i].getHostname().indexOf("scnode") != -1) {
                ((SamQFSSystemModelImpl)models[i]).setServerAPIVersion("1.4");
                ((SamQFSSystemModelImpl)models[i]).setServerProductVersion("4.5");
                ((GenericFileSystemImpl)((Object)models[i].getSamQFSSystemFSManager().getFileSystem("samfs05"))).setHA(true);
                ((GenericFileSystemImpl)((Object)models[i].getSamQFSSystemFSManager().getFileSystem("samfs10"))).setHA(true);
                continue;
            }
            if (models[i].getHostname().indexOf("ns-east-9") != -1) {
                ((SamQFSSystemModelImpl)models[i]).setDown(true);
                continue;
            }
            if (models[i].getHostname().indexOf("ns-east-16") != -1) {
                ((SamQFSSystemModelImpl)models[i]).setServerAPIVersion("1.3");
                ((SamQFSSystemModelImpl)models[i]).setServerProductVersion("4.4");
                continue;
            }
            ((SamQFSSystemModelImpl)models[i]).setServerAPIVersion("1.4");
            ((SamQFSSystemModelImpl)models[i]).setServerProductVersion("4.5");
        }
        this.createSharedFileSystems();
    }

    public SamQFSSystemModel[] getAllSamQFSSystemModels() {
        return this.map.values().toArray(new SamQFSSystemModelImpl[0]);
    }

    public SamQFSSystemModel getSamQFSSystemModel(String hostname) throws SamFSException {
        SamQFSSystemModel sysModel = (SamQFSSystemModel)this.map.get(hostname);
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        return sysModel;
    }

    public String getInetHostName(String hostName) throws UnknownHostException {
        if (this.map.get(hostName) != null) {
            return hostName;
        }
        return null;
    }

    public void addHost(String hostname) throws SamFSException {
        if (this.map.get(hostname) != null) {
            throw new SamFSException("logic.existingHost");
        }
        String[] ipAddresses = new String[]{(int)(Math.random() * 100.0) + "." + (int)(Math.random() * 100.0) + "." + (int)(Math.random() * 100.0) + "." + (int)(Math.random() * 100.0)};
        this.populateHost(hostname, ipAddresses);
    }

    public void removeHost(String hostname) throws SamFSException {
        if (this.map.get(hostname) == null) {
            throw new SamFSException("SAMFS_NO_SUCH_HOST");
        }
        this.map.remove(hostname);
    }

    public boolean isDumpOn() throws SamFSException {
        return this.dumpOn;
    }

    public void setDumpOn(boolean dump) throws SamFSException {
        this.dumpOn = dump;
    }

    public void updateDownServers() {
    }

    public HashMap getNFSSharedMap() {
        return this.nfsFilesMap;
    }

    public SamQFSSystemSharedFSManager getSamQFSSystemSharedFSManager() {
        if (this.sharedFSManager == null) {
            this.sharedFSManager = new SamQFSSystemSharedFSManagerImpl(this);
        }
        return this.sharedFSManager;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("No. of hosts = " + this.map.size() + ".\n");
        if (this.map.size() > 0) {
            SamQFSSystemModelImpl[] systems = this.map.values().toArray(new SamQFSSystemModelImpl[0]);
            for (int i = 0; i < this.map.size(); ++i) {
                buf.append(systems[i].toString());
            }
        }
        return buf.toString();
    }

    private void populateHost(String hostname, String[] ipAddresses) throws SamFSException {
        int i;
        long capacity;
        long available;
        int i2;
        if (this.map.get(hostname) != null) {
            throw new SamFSException("logic.existingHost");
        }
        SamQFSSystemModelImpl hostModel = new SamQFSSystemModelImpl(hostname);
        hostModel.setIPAddresses(ipAddresses);
        if (hostname.indexOf("scnode") != -1) {
            hostModel.setServerAPIVersion("1.4");
            hostModel.setServerProductVersion("4.5");
        }
        this.map.put(hostname, hostModel);
        ArrayList availableAUs = new ArrayList();
        ArrayList list1 = SamQFSUtil.createAUs(101, 25);
        ArrayList list2 = SamQFSUtil.createAUs(102, 25);
        ArrayList list3 = SamQFSUtil.createAUs(103, 25);
        int i3 = 0;
        while (true) {
            if (i3 >= 25) break;
            availableAUs.add(list1.get(i3));
            availableAUs.add(list2.get(i3));
            availableAUs.add(list3.get(i3));
            ++i3;
        }
        hostModel.setAvailableAUs(availableAUs);
        DiskCache[] avail = hostModel.getSamQFSSystemFSManager().discoverAvailableAllocatableUnits(null);
        DiskCache[] disks1 = new DiskCache[3];
        DiskCache[] disks2 = new DiskCache[3];
        DiskCache[] disks3 = new DiskCache[3];
        DiskCache[] disks4 = new DiskCache[3];
        DiskCache[] disks5 = new DiskCache[3];
        DiskCache[] disks6 = new DiskCache[3];
        DiskCache[] disks7 = new DiskCache[3];
        DiskCache[] disks8 = new DiskCache[3];
        DiskCache[] disks9 = new DiskCache[3];
        DiskCache[] disks10 = new DiskCache[3];
        DiskCache[] mdisks1 = new DiskCache[2];
        DiskCache[] mdisks2 = new DiskCache[2];
        DiskCache[] mdisks3 = new DiskCache[2];
        DiskCache[] mdisks4 = new DiskCache[2];
        DiskCache[] mdisks5 = new DiskCache[2];
        DiskCache[] mdisks6 = new DiskCache[2];
        DiskCache[] mdisks7 = new DiskCache[2];
        disks1[0] = avail[0];
        disks1[1] = avail[25];
        disks1[2] = avail[50];
        for (i2 = 0; i2 < 3; ++i2) {
            available = 10L;
            capacity = disks1[i2].getCapacity();
            if (available > capacity) {
                available = capacity;
            }
            ((DiskCacheImpl)disks1[i2]).setAvailableSpace(available);
        }
        disks2[0] = avail[1];
        disks2[1] = avail[26];
        disks2[2] = avail[51];
        disks3[0] = avail[2];
        disks3[1] = avail[27];
        disks3[2] = avail[52];
        disks4[0] = avail[3];
        disks4[1] = avail[28];
        disks4[2] = avail[53];
        disks5[0] = avail[4];
        disks5[1] = avail[29];
        disks5[2] = avail[54];
        disks6[0] = avail[5];
        disks6[1] = avail[30];
        disks6[2] = avail[55];
        for (i2 = 0; i2 < 3; ++i2) {
            available = 10L;
            capacity = disks6[i2].getCapacity();
            if (available > capacity) {
                available = capacity;
            }
            ((DiskCacheImpl)disks6[i2]).setAvailableSpace(available);
        }
        disks7[0] = avail[6];
        disks7[1] = avail[31];
        disks7[2] = avail[56];
        disks8[0] = avail[7];
        disks8[1] = avail[32];
        disks8[2] = avail[57];
        for (i2 = 0; i2 < 3; ++i2) {
            available = 10L;
            capacity = disks8[i2].getCapacity();
            if (available > capacity) {
                available = capacity;
            }
            ((DiskCacheImpl)disks8[i2]).setAvailableSpace(available);
        }
        disks9[0] = avail[8];
        disks9[1] = avail[33];
        disks9[2] = avail[58];
        disks10[0] = avail[9];
        disks10[1] = avail[34];
        disks10[2] = avail[59];
        mdisks1[0] = avail[11];
        mdisks1[1] = avail[12];
        mdisks2[0] = avail[13];
        mdisks2[1] = avail[14];
        mdisks3[0] = avail[15];
        mdisks3[1] = avail[16];
        mdisks4[0] = avail[17];
        mdisks4[1] = avail[18];
        mdisks5[0] = avail[19];
        mdisks5[1] = avail[20];
        mdisks6[0] = avail[21];
        mdisks6[1] = avail[22];
        mdisks7[0] = avail[23];
        mdisks7[1] = avail[24];
        FileSystemMountProperties prop1 = SamQFSUtil.getDefaultMountProperties(1, 2, 0);
        FileSystemMountProperties prop2 = SamQFSUtil.getDefaultMountProperties(1, 2, 0);
        FileSystemMountProperties prop3 = SamQFSUtil.getDefaultMountProperties(1, 2, 0);
        FileSystemMountProperties prop4 = SamQFSUtil.getDefaultMountProperties(0, 3, 0);
        FileSystemMountProperties prop5 = SamQFSUtil.getDefaultMountProperties(0, 3, 0);
        FileSystemMountProperties prop6 = SamQFSUtil.getDefaultMountProperties(0, 2, 0);
        FileSystemMountProperties prop7 = SamQFSUtil.getDefaultMountProperties(0, 2, 0);
        FileSystemMountProperties prop8 = SamQFSUtil.getDefaultMountProperties(0, 2, 0);
        FileSystemMountProperties prop9 = SamQFSUtil.getDefaultMountProperties(0, 2, 0);
        FileSystemMountProperties prop10 = SamQFSUtil.getDefaultMountProperties(0, 3, 0);
        SamQFSSystemFSManagerImpl manager = (SamQFSSystemFSManagerImpl)hostModel.getSamQFSSystemFSManager();
        FileSystemImpl fs1 = (FileSystemImpl)manager.createFileSystem("samfs01", 1, 2, -1, "/samfs01", 0, 64, prop1, null, disks1, null);
        ArrayList<NFSOptions> nfsFilesArray = new ArrayList<NFSOptions>();
        NFSOptions opt1 = new NFSOptions("/usr/bin", "config");
        NFSOptions opt2 = new NFSOptions("/usr/dist/exe", "yes");
        nfsFilesArray.add(opt1);
        nfsFilesArray.add(opt2);
        this.nfsFilesMap.put(fs1.getName(), nfsFilesArray);
        fs1.setNFSShares(true);
        FileSystem fs2 = manager.createFileSystem("samfs02", 1, 2, -1, "/samfs02", 0, 64, prop2, null, disks2, null);
        FileSystem fs3 = manager.createFileSystem("samfs03", 1, 2, -1, "/samfs03", 0, 64, prop3, null, disks3, null);
        FileSystem fs4 = manager.createFileSystem("samfs04", 0, 3, -1, "/samfs04", 0, 64, prop4, mdisks1, disks4, null);
        FileSystem fs5 = manager.createFileSystem("samfs05", 0, 3, -1, "/samfs05", 0, 64, prop5, mdisks2, disks5, null);
        FileSystem fs6 = manager.createFileSystem("samfs06", 0, 2, -1, "/samfs06", 0, 64, prop6, mdisks3, disks6, null);
        FileSystem fs7 = manager.createFileSystem("samfs07", 0, 2, -1, "/samfs07", 0, 64, prop7, mdisks4, disks7, null);
        FileSystem fs8 = manager.createFileSystem("samfs08", 0, 2, -1, "/samfs08", 0, 64, prop8, mdisks5, disks8, null);
        FileSystem fs9 = manager.createFileSystem("samfs09", 0, 2, -1, "/samfs09", 0, 64, prop9, mdisks6, disks9, null);
        FileSystem fs10 = manager.createFileSystem("samfs10", 0, 3, -1, "/samfs10", 0, 64, prop10, mdisks6, disks9, null);
        manager.setMetadataDumpSchedParams("samfs01", new DumpSched(1024295446L, DumpSchedDateTimeModel.getIntervalUnitFromName("Interval4Hours"), "", Boolean.FALSE, "", "", "/", null, "samfs01", "samfs01-%Y-%m-%d", "none", Boolean.TRUE, Boolean.TRUE, new DumpSchedRetention(3, "D")));
        manager.setMetadataDumpSchedParams("samfs02", new DumpSched(1024324845L, 3600L, "myPreScript", Boolean.TRUE, "", "", "/", null, "samfs02", "samfs02-%Y-%m-%d", "compress", Boolean.FALSE, Boolean.TRUE, null));
        manager.setMetadataDumpSchedParams("samfs06", new DumpSched(1024684845L, 86400L, "", Boolean.FALSE, "", "", "/", null, "samfs06", "samfs06-%Y-%m-%d", "gzipFast", Boolean.TRUE, Boolean.FALSE, new DumpSchedRetention(1, "M")));
        BaseDeviceImpl baseLib = new BaseDeviceImpl("/dev/samst/c10t0u0", -1, 110, "stklib1", 10, 0, null);
        BaseDeviceImpl baseDrv1 = new BaseDeviceImpl("/dev/rmt/2cbn", -1, 110, "stklib1", 10, 0, null);
        BaseDeviceImpl baseDrv2 = new BaseDeviceImpl("/dev/rmt/3cbn", -1, 110, "stklib1", 10, 0, null);
        DriveImpl libDrive1 = new DriveImpl(null, null, baseDrv1, "Storage Tek", "STK40i", "AZ0456", "2.4", 0);
        DriveImpl libDrive2 = new DriveImpl(null, null, baseDrv2, "Storage Tek", "STK40i", "AZ0457", "2.4", 0);
        ArrayList<DriveImpl> driveList = new ArrayList<DriveImpl>();
        driveList.add(libDrive1);
        driveList.add(libDrive2);
        VSNImpl vsn1 = new VSNImpl(null, null, "AZ0001", 1, "AZ0001", 1000L, 230L, 256, 3, new GregorianCalendar(2001, 11, 16, 23, 57, 48), SamQFSUtil.getDateTime(), SamQFSUtil.getDateTime(), false, null, null, false, true, true, true, false, false, true, true, false);
        VSNImpl vsn2 = new VSNImpl(null, null, "AZ0002", 2, "AZ0002", 1000L, 230L, 256, 2, new GregorianCalendar(2001, 11, 16, 23, 57, 48), SamQFSUtil.getDateTime(), SamQFSUtil.getDateTime(), false, null, null, false, true, true, true, false, false, true, true, false);
        VSNImpl vsn3 = new VSNImpl(null, null, "AZ0004", 4, "AZ0004", 1000L, 230L, 256, 1, new GregorianCalendar(2001, 11, 16, 23, 57, 48), SamQFSUtil.getDateTime(), SamQFSUtil.getDateTime(), false, null, null, false, true, true, true, false, false, true, true, false);
        VSNImpl vsn4 = new VSNImpl(null, null, "AZ0006", 6, "AZ0006", 1000L, 230L, 256, 4, new GregorianCalendar(2001, 11, 16, 23, 57, 48), SamQFSUtil.getDateTime(), SamQFSUtil.getDateTime(), false, null, null, false, true, true, true, false, false, true, true, false);
        ArrayList<VSNImpl> vsnList = new ArrayList<VSNImpl>();
        vsnList.add(vsn1);
        vsnList.add(vsn2);
        vsnList.add(vsn3);
        vsnList.add(vsn4);
        vsn4.setDrive(libDrive2);
        libDrive2.setVSN(vsn4);
        ArrayList<AlarmImpl> alarmList = new ArrayList<AlarmImpl>();
        AlarmImpl alarm = new AlarmImpl(alarmCounter++, 2, "No cleaning catridge found", new GregorianCalendar(), 3, null, null);
        alarmList.add(alarm);
        alarm = new AlarmImpl(alarmCounter++, 1, "A library operation has been attempted that is invalid at this\ntime.Illegal operation detected.\nRepeated " + (alarmCounter + 1) + " time(s) from May 23, 2005 04:26:32 PM EDT", new GregorianCalendar(), 3, null, null);
        alarmList.add(alarm);
        RecycleParamsImpl recycleParams = new RecycleParamsImpl(null, 80, 10, 100, 64L, 2, true);
        DriveDirectiveImpl driveDirective = new DriveDirectiveImpl();
        driveDirective.setCount(2);
        BufferDirectiveImpl bufferDirective = new BufferDirectiveImpl(110, 8L, false);
        Library lib = new LibraryImpl("stklib1", driveList, vsnList, baseLib, "Storage Tek", "STK 9840", "124325699898", 0, 6, 2, 3, "/var/opt/SUNWsamfs/catalog/stklib1", alarmList, null, recycleParams, driveDirective, bufferDirective);
        bufferDirective.addLibrary(lib);
        hostModel.getSamQFSSystemMediaManager().addLibrary(lib);
        ((SamQFSSystemAlarmManagerImpl)hostModel.getSamQFSSystemAlarmManager()).addAlarm(alarm);
        lib = SamQFSAppModelImpl.createLibrary("stklib1", 110, 10, "Storage Tek", "STK 9840x", "6.9", 15, 2, "STK 9840 XX", "d4568732bx6463");
        Library myLibrary = SamQFSAppModelImpl.createLibrary("MyStorEdge", 107, 6, "Sun", "StorEdge L20", "3.7", 35, 3, "StorEdge L20", "1234567890");
        Library[] libs = new Library[9];
        libs[0] = SamQFSAppModelImpl.createLibrary("ibmlib1", 107, 6, "IBM", "IBM 50x", "3.7", 35, 3, "IBM 3580 LTO", "0229A00507");
        libs[1] = SamQFSAppModelImpl.createLibrary("ibmlib2", 106, 5, "IBM", "IBM 60y", "7.7", 32, 4, "IBM 3570", "77434A2112");
        libs[2] = SamQFSAppModelImpl.createLibrary("stklib2", 109, 4, "Storage Tek", "STK li40", "1.7", 33, 1, "STK 9490", "2342B11237");
        libs[3] = SamQFSAppModelImpl.createLibrary("sonylib2", 101, 3, "Sony", "Sony X80", "2.3", 31, 2, "SONY AIT", "8342321111");
        libs[4] = SamQFSAppModelImpl.createLibrary("Historian", 116, 0, "SUN", "", "", 35, 0, "SAMFS Historian", "");
        ((LibraryImpl)libs[2]).setDriverType(1002);
        ((LibraryImpl)libs[3]).setDriverType(1007);
        String vsnName = "SAME00";
        ((LibraryImpl)libs[1]).changeVSN(libs[1].getVSNs()[0], vsnName);
        ((LibraryImpl)libs[2]).changeVSN(libs[2].getVSNs()[0], vsnName);
        ((LibraryImpl)libs[3]).changeVSN(libs[3].getVSNs()[0], vsnName);
        int hostNumber = 0;
        try {
            if (hostname.startsWith("ns-east-")) {
                hostNumber = Integer.parseInt(hostname.substring(8));
            }
        }
        catch (NumberFormatException numEx) {
            // empty catch block
        }
        for (int i4 = 0; i4 < 5; ++i4) {
            Alarm[] alarms = libs[i4].getAssociatedAlarms();
            hostModel.getSamQFSSystemMediaManager().addLibrary(libs[i4]);
            if (alarms == null || alarms.length <= 0) continue;
            for (int j = 0; j < alarms.length; ++j) {
                ((SamQFSSystemAlarmManagerImpl)hostModel.getSamQFSSystemAlarmManager()).addAlarm(alarms[j]);
            }
        }
        if (hostNumber > 200) {
            hostModel.getSamQFSSystemMediaManager().addLibrary(myLibrary);
        }
        libs[5] = SamQFSAppModelImpl.createLibrary("ibmlib3", 106, 5, "IBM", "IBM 60y", "7.7", 10, 4, "IBM 3570", "AA32113509");
        libs[6] = SamQFSAppModelImpl.createLibrary("stklib3", 109, 4, "Storage Tek", "STK li40", "1.7", 10, 1, "STK 9490", "0938562189");
        libs[7] = SamQFSAppModelImpl.createLibrary("sonylib3", 101, 3, "Sony", "Sony X80", "2.3", 12, 2, "SONY AIT", "3424213111");
        libs[8] = SamQFSAppModelImpl.createLibrary("mixedmedia", 123, 4, "STK", "STK 9940", "4.0", 12, 2, "STK ACSLS Mixed Media", "9878854236");
        ArrayList<Library> tempLibList = new ArrayList<Library>();
        tempLibList.add(libs[5]);
        tempLibList.add(libs[6]);
        tempLibList.add(libs[7]);
        tempLibList.add(libs[8]);
        ((SamQFSSystemMediaManagerImpl)hostModel.getSamQFSSystemMediaManager()).setAvailableLibraries(tempLibList);
        ArrayList<BufferDirectiveImpl> archMax = new ArrayList<BufferDirectiveImpl>();
        ArrayList<BufferDirectiveImpl> overflowMin = new ArrayList<BufferDirectiveImpl>();
        ArrayList<BufferDirectiveImpl> bufSize = new ArrayList<BufferDirectiveImpl>();
        ArrayList<DriveDirectiveImpl> drvMax = new ArrayList<DriveDirectiveImpl>();
        int[] mType = new int[5];
        for (int i5 = 0; i5 < 5; ++i5) {
            int mediaType = -1;
            Library library = null;
            switch (i5) {
                case 0: {
                    mediaType = 110;
                    library = lib;
                    mType[i5] = mediaType;
                    break;
                }
                case 1: {
                    mediaType = 107;
                    library = libs[0];
                    mType[i5] = mediaType;
                    break;
                }
                case 2: {
                    mediaType = 106;
                    library = libs[1];
                    mType[i5] = mediaType;
                    break;
                }
                case 3: {
                    mediaType = 109;
                    library = libs[2];
                    mType[i5] = mediaType;
                    break;
                }
                case 4: {
                    mediaType = 101;
                    library = libs[3];
                    mType[i5] = mediaType;
                }
            }
            archMax.add(new BufferDirectiveImpl(mediaType, 4L, false));
            overflowMin.add(new BufferDirectiveImpl(mediaType, 8L, false));
            bufSize.add(new BufferDirectiveImpl(mediaType, 16L, false));
            drvMax.add(new DriveDirectiveImpl(library, 2));
        }
        GlobalArchiveDirectiveImpl globalDir = new GlobalArchiveDirectiveImpl(archMax, overflowMin, bufSize, drvMax, "/var/opt/SUNWsamfs/achiver/archiver.log", 30L, 6, 3);
        hostModel.getSamQFSSystemArchiveManager43().setGlobalDirective(globalDir);
        VSNPool[] pools = new VSNPool[5];
        for (int i6 = 0; i6 < 5; ++i6) {
            pools[i6] = i6 == 0 ? this.createPool(hostModel, "pool" + (i6 + 1), lib, 2) : this.createPool(hostModel, "pool" + (i6 + 1), libs[i6 - 1], 3);
        }
        ArchivePolicy[] policies = new ArchivePolicy[5];
        for (i = 0; i < 5; ++i) {
            int j;
            ArchiveCopyGUIWrapper[] wrapper = new ArchiveCopyGUIWrapperImpl[3];
            ArchiveCopyImpl[] copies = new ArchiveCopyImpl[3];
            ArchivePolCriteriaCopyImpl[] polCritCopies = new ArchivePolCriteriaCopyImpl[3];
            ArchiveVSNMapImpl[] maps = new ArchiveVSNMapImpl[3];
            for (j = 0; j < 3; ++j) {
                copies[j] = new ArchiveCopyImpl(null, null, j + 1, false, null, null, null, 16, 10, 4, 2, 64L, 2, 32L, 2, 2, 11, false, 128L, 2, 256L, 2, 16, true, 10L, 6, 256, 128L, 2, 512L, 2, 90, false, "admin@sun.com", 90, 1024);
                polCritCopies[j] = new ArchivePolCriteriaCopyImpl(null, j + 1, 10 + j * 3, 6, 5 + j * 2, 6, true, false);
                wrapper[j] = new ArchiveCopyGUIWrapperImpl();
                ((ArchiveCopyGUIWrapperImpl)wrapper[j]).setArchiveCopy(copies[j]);
                ((ArchiveCopyGUIWrapperImpl)wrapper[j]).setArchivePolCriteriaCopy(polCritCopies[j]);
            }
            for (j = 0; j < 3; ++j) {
                int k;
                ArrayList<Object> vsnListForMap = new ArrayList<Object>();
                ArrayList<VSNPool> vsnPoolListForMap = new ArrayList<VSNPool>();
                VSN[] vsns = lib.getVSNs();
                if (i != 0) {
                    vsns = libs[i - 1].getVSNs();
                }
                if (j == 0) {
                    for (k = 0; k < 4; ++k) {
                        vsnListForMap.add(vsns[k + 3]);
                    }
                    vsnPoolListForMap.add(pools[i]);
                } else {
                    for (k = 7; k < vsns.length - 2; ++k) {
                        vsnListForMap.add(vsns[k]);
                    }
                }
                if (j == 2) {
                    vsnListForMap = new ArrayList(1);
                    vsnListForMap.add("dv2001");
                    maps[j] = new ArchiveVSNMapImpl(copies[j], 133, vsnListForMap, new ArrayList());
                } else {
                    maps[j] = new ArchiveVSNMapImpl(copies[j], mType[i], vsnListForMap, vsnPoolListForMap);
                }
                copies[j].setArchiveVSNMap(maps[j]);
            }
            String[] fsNameList = new String[3];
            String pattern = null;
            switch (i) {
                case 0: {
                    pattern = "*.zip";
                    fsNameList[0] = "samfs08";
                    fsNameList[1] = "samfs02";
                    fsNameList[2] = "samfs01";
                    break;
                }
                case 1: {
                    pattern = "*.tar";
                    fsNameList[0] = "samfs03";
                    fsNameList[1] = "samfs02";
                    fsNameList[2] = "samfs07";
                    break;
                }
                case 2: {
                    pattern = "*.mpeg";
                    fsNameList[0] = "samfs08";
                    fsNameList[1] = "samfs06";
                    fsNameList[2] = "samfs01";
                    break;
                }
                case 3: {
                    pattern = "*.au";
                    fsNameList[0] = "samfs06";
                    fsNameList[1] = "samfs02";
                    fsNameList[2] = "samfs03";
                    break;
                }
                case 4: {
                    pattern = "*.doc";
                    fsNameList[0] = "samfs07";
                    fsNameList[1] = "samfs03";
                    fsNameList[2] = "samfs08";
                }
            }
            ArchivePolCriteriaPropImpl prop = new ArchivePolCriteriaPropImpl(null, "dir" + (i + 1), 1024L, 0, 0x20000000L, 0, pattern, "", "", 10001, 10005, 10L, 6);
            if (i == 0) {
                hostModel.getSamQFSSystemArchiveManager43().createArchivePolicy("no_archive", prop, new ArchiveCopyGUIWrapper[0], fsNameList);
                continue;
            }
            ArchivePolicyImpl thePolicy = (ArchivePolicyImpl)hostModel.getSamQFSSystemArchiveManager43().createArchivePolicy("policy" + i, prop, wrapper, fsNameList);
            if (i != 1) continue;
            thePolicy.setPolicyType(1004);
        }
        for (i = 0; i < 6; ++i) {
            String fsName = null;
            switch (i) {
                case 0: {
                    fsName = "samfs02";
                    break;
                }
                case 1: {
                    fsName = "samfs06";
                    break;
                }
                case 2: {
                    fsName = "samfs08";
                    break;
                }
                case 3: {
                    fsName = "samfs01";
                    break;
                }
                case 4: {
                    fsName = "samfs07";
                    break;
                }
                case 5: {
                    fsName = "samfs03";
                }
            }
            ArchiveCopyImpl copy = new ArchiveCopyImpl(null, null, 1, false, "", "", "", 16, 10, 4, 2, 64L, 2, 32L, 2, 2, 11, false, 128L, 2, 256L, 2, 16, true, 10L, 6, 256, 128L, 2, 512L, 2, 90, false, "admin@sun.com", 90, 1024);
            ArrayList<VSN> vsnListForMap = new ArrayList<VSN>();
            ArrayList<VSNPool> vsnPoolListForMap = new ArrayList<VSNPool>();
            VSN[] vsns = lib.getVSNs();
            for (int k = 0; k < 4; ++k) {
                vsnListForMap.add(vsns[k + 3]);
            }
            vsnPoolListForMap.add(pools[0]);
            ArchiveVSNMapImpl map = new ArchiveVSNMapImpl(copy, mType[0], vsnListForMap, vsnPoolListForMap);
            copy.setArchiveVSNMap(map);
            ArchiveCopyGUIWrapper[] wrapper = new ArchiveCopyGUIWrapperImpl[]{new ArchiveCopyGUIWrapperImpl()};
            wrapper[0].setArchiveCopy(copy);
            ArchivePolicyImpl pol = (ArchivePolicyImpl)((SamQFSSystemArchiveManager43Impl)hostModel.getSamQFSSystemArchiveManager43()).createArchivePolicy(fsName, 1001, null, wrapper, new String[0]);
            ArchivePolCriteriaImpl crit = new ArchivePolCriteriaImpl();
            crit.setIndex(0);
            ArchivePolCriteriaCopyImpl critCp = new ArchivePolCriteriaCopyImpl(crit, 1, 15L, 6, 1L, 6, true, false);
            ArchivePolCriteriaCopy[] tempPolCritCopy = new ArchivePolCriteriaCopy[]{critCp};
            crit.setArchivePolCriteriaCopies(tempPolCritCopy);
            crit.setArchivePolicy(pol);
            ArchivePolCriteria[] tempPolCrit = new ArchivePolCriteria[]{crit};
            pol.setArchivePolCriteria(tempPolCrit);
        }
        for (i = 0; i < 6; ++i) {
            String drvPath = "/dev/rmt/" + (int)(Math.random() * 1000.0) + i + "cbn";
            BaseDeviceImpl stdBase = new BaseDeviceImpl(drvPath, -1, 112, "drive" + (i + 1), -1, 0, null);
            DriveImpl drv = new DriveImpl(null, null, stdBase, "METRUM", "MET VHSi", SamQFSAppModelImpl.createSerialNo(), "2.4", 0);
            if (i < 3) {
                hostModel.getSamQFSSystemMediaManager().addStandAloneDrive(drv);
            } else {
                ((SamQFSSystemMediaManagerImpl)hostModel.getSamQFSSystemMediaManager()).addAvailableStandAloneDrive(drv);
            }
            if (i == 1) continue;
            VSNImpl vsn = new VSNImpl(null, null, "6abb0cdf", 6, "6abb0cdf", 1000L, 230L, 256, 4, new GregorianCalendar(2001, 11, 16, 23, 57, 48), SamQFSUtil.getDateTime(), SamQFSUtil.getDateTime(), false, null, null, false, true, true, true, false, false, true, true, false);
            drv.setVSN(vsn);
            vsn.setDrive(drv);
        }
        hostModel.getSamQFSSystemAdminManager().createNotification("sysadmin1", "admin1@company.com", true, true, true, true, true, true);
        hostModel.getSamQFSSystemAdminManager().createNotification("sysadmin2", "admin2@company.com", true, true, true, true, true, true);
        hostModel.getSamQFSSystemAdminManager().createNotification("sysadmin3", "admin3@company.com", true, true, true, true, true, true);
        AlarmImpl alarmFS = new AlarmImpl(alarmCounter++, 2, "Could not take snapshot. File system samfs01 is not mounted. Please mount the\nfile system before the next scheduled snapshot\nRepeated 47 time(s) from May 16, 2005 12:57:00 PM EDT", new GregorianCalendar(), 3, null, null);
        ((SamQFSSystemAlarmManagerImpl)hostModel.getSamQFSSystemAlarmManager()).addAlarm(alarmFS);
        alarmFS.setFileSystem(fs4);
        this.createArchiveJob(hostModel, 0, 1, "policy1", "stklib1", fs1, 1);
        this.createArchiveJob(hostModel, 0, 1, "policy1", "stklib1", fs6, 3);
        this.createArchiveJob(hostModel, 0, 1, "policy3", "stklib1", fs7, 1);
        this.createArchiveJob(hostModel, 0, 1, "policy4", "stklib1", fs3, 1);
        this.createArchiveJob(hostModel, 0, 1, "policy2", "stklib1", fs8, 1);
        this.createArchiveJob(hostModel, 0, 1, "policy4", "stklib1", fs2, 1);
        this.createArchiveJob(hostModel, 0, 1, "policy1", "stklib1", fs9, 1);
        this.createStageJob(hostModel, 0, fs3, "stklib1");
        this.createStageJob(hostModel, 1, fs8, "stklib1");
        this.createStageJob(hostModel, 1, fs2, "stklib1");
        this.createStageJob(hostModel, 1, fs7, "stklib1");
        this.createReleaseJob(hostModel, 0, fs6);
        this.createReleaseJob(hostModel, 0, fs1);
        this.createReleaseJob(hostModel, 0, fs8);
        this.createMountJob(hostModel, 1, "stklib1");
        SamQFSSystemJobManagerImpl jobmanager = (SamQFSSystemJobManagerImpl)hostModel.getSamQFSSystemJobManager();
        this.createArchiveScanJob(hostModel, 0, fs6);
        this.createArchiveScanJob(hostModel, 1, fs1);
        this.createArchiveScanJob(hostModel, 1, fs8);
        this.createArchiveScanJob(hostModel, 0, fs9);
        this.createFsckJob(hostModel, 0, fs6);
        this.createFsckJob(hostModel, 0, fs1);
        this.createFsckJob(hostModel, 0, fs8);
        this.createFsckJob(hostModel, 0, fs9);
        this.createLabelJob(hostModel, 0, "stklib1");
        this.createLabelJob(hostModel, 0, "ibmlib1");
        this.createLabelJob(hostModel, 0, "sonylib2");
        this.createLabelJob(hostModel, 0, "stklib2");
        FSDumpJobImpl jobD = new FSDumpJobImpl(fs4.getName(), "200411/samfsdump_" + fs4.getName() + "_10");
        jobmanager.addJob(jobD);
        ((FileSystemImpl)fs4).addJob(jobD);
        jobD = new FSDumpJobImpl(fs5.getName(), "200411/samfsdump_" + fs5.getName() + "_10");
        jobmanager.addJob(jobD);
        ((FileSystemImpl)fs5).addJob(jobD);
        jobD = new FSDumpJobImpl(fs8.getName(), "200411/samfsdump_" + fs8.getName() + "_10");
        jobmanager.addJob(jobD);
        ((FileSystemImpl)fs8).addJob(jobD);
    }

    public static Library createLibrary(String libName, int mediaType, int drvCount, String vendor, String drvProductId, String drvFirmware, int vsnCount, int vsnInDrv, String libProductId, String libSerial) throws SamFSException {
        int i;
        String libPath = "/dev/samst/c" + (int)(Math.random() * 100.0) + "t0u0";
        BaseDeviceImpl baseLib = new BaseDeviceImpl(libPath, -1, mediaType, libName, -1, 0, null);
        ArrayList<DriveImpl> driveList = new ArrayList<DriveImpl>();
        BaseDeviceImpl[] baseDrv = new BaseDeviceImpl[drvCount];
        DriveImpl[] libDrive = new DriveImpl[drvCount];
        StkDevice[] devices = new StkDevice[drvCount];
        for (int i2 = 0; i2 < drvCount; ++i2) {
            String drvPath = "/dev/rmt/" + i2 * 1000 + "cbn";
            devices[i2] = new StkDevice(drvPath, false);
            if (libName.equals("mixedmedia")) {
                if (i2 % 2 == 0) {
                    baseDrv[i2] = new BaseDeviceImpl(drvPath, -1, 124, libName, -1, 0, null);
                    libDrive[i2] = new DriveImpl(null, null, baseDrv[i2], vendor, "STK3480", SamQFSAppModelImpl.createSerialNo(), drvFirmware, 0);
                } else {
                    baseDrv[i2] = new BaseDeviceImpl(drvPath, -1, mediaType, libName, -1, 0, null);
                    libDrive[i2] = new DriveImpl(null, null, baseDrv[i2], vendor, drvProductId, SamQFSAppModelImpl.createSerialNo(), drvFirmware, 0);
                }
            } else {
                baseDrv[i2] = new BaseDeviceImpl(drvPath, -1, mediaType, libName, -1, 0, null);
                libDrive[i2] = new DriveImpl(null, null, baseDrv[i2], vendor, drvProductId, SamQFSAppModelImpl.createSerialNo(), drvFirmware, 0);
            }
            driveList.add(libDrive[i2]);
        }
        StkNetLibParam stkParam = new StkNetLibParam("", "ns-east-63", 500004, devices);
        ArrayList<VSNImpl> vsnList = new ArrayList<VSNImpl>();
        VSNImpl[] vsn = new VSNImpl[vsnCount];
        for (i = 0; i < vsnCount; ++i) {
            String barcode = SamQFSAppModelImpl.createSerialNo();
            vsn[i] = new VSNImpl(null, null, barcode, i + 2, barcode, 1000L, (long)(Math.random() * 100.0), 256, (int)(Math.random() * 10.0), new GregorianCalendar(2001, 11, 16, 23, 57, 48), SamQFSUtil.getDateTime(), SamQFSUtil.getDateTime(), false, null, null, false, true, true, true, false, false, true, true, false);
            vsnList.add(vsn[i]);
        }
        for (i = 0; i < vsnInDrv; ++i) {
            vsn[i].setDrive(libDrive[i]);
            libDrive[i].setVSN(vsn[i]);
        }
        ArrayList<AlarmImpl> alarmList = null;
        if (mediaType != 116) {
            alarmList = new ArrayList<AlarmImpl>();
            AlarmImpl alarm = new AlarmImpl(alarmCounter++, 1, "There is a potential problem with the drive ejecting cartridges\nor with the library mechanism picking a cartridge from a slot.\n1. No action needs to be taken at this time.\n2. If the problem persists, call the library supplier help line.\nOperation to pick a cartridge from a slot had to perform an\nexcessive number of retries before succeeding.", SamQFSUtil.getRandomCalendar(), 3, null, null);
            alarmList.add(alarm);
            alarm = new AlarmImpl(alarmCounter++, 2, "The library security mode has been changed. The library has\neither been put into secure mode, or the library has exited the\nsecure mode. This is for information purposes only. No action\nis required.\nLibrary security mode changed.", SamQFSUtil.getRandomCalendar(), 3, null, null);
            alarmList.add(alarm);
        }
        RecycleParamsImpl recycleParams = new RecycleParamsImpl(null, 80, 10, 100, 64L, 2, true);
        DriveDirectiveImpl driveDirective = new DriveDirectiveImpl();
        int count = drvCount - 2;
        if (count < 1) {
            count = drvCount;
        }
        driveDirective.setCount(count);
        BufferDirectiveImpl bufferDirective = new BufferDirectiveImpl(mediaType, 16L, false);
        LibraryImpl lib = new LibraryImpl(libName, driveList, vsnList, baseLib, vendor, libProductId, libSerial, 0, vsnCount + 2, 2, 2, "/var/opt/SUNWsamfs/catalog/" + libName, alarmList, null, recycleParams, driveDirective, bufferDirective);
        bufferDirective.addLibrary(lib);
        lib.setStkNetLibParam(stkParam);
        return lib;
    }

    protected static String createSerialNo() throws SamFSException {
        String[] prefix = new String[]{"BY", "CP", "DX", "EW", "FV", "GU", "HT", "IS", "JR", "KQ"};
        String serialNo = prefix[(int)(Math.random() * 10.0)] + (int)(Math.random() * 10.0) + (int)(Math.random() * 10.0) + (int)(Math.random() * 10.0) + (int)(Math.random() * 10.0);
        return serialNo;
    }

    private VSNPool createPool(SamQFSSystemModel model, String poolName, Library lib, int count) throws SamFSException {
        ArrayList<VSN> poolMembers = new ArrayList<VSN>();
        VSN[] vsn = lib.getVSNs();
        String expr = new String();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                expr = expr + ",";
            }
            expr = expr + vsn[i].getVSN();
            poolMembers.add(vsn[i]);
        }
        VSNPool pool = ((SamQFSSystemArchiveManager43Impl)model.getSamQFSSystemArchiveManager43()).createVSNPool(poolName, lib.getMediaType(), expr, poolMembers.toArray(new VSN[0]));
        return pool;
    }

    private BaseJobImpl createBaseJob(int condition, int type) throws SamFSException {
        return new BaseJobImpl((int)(Math.random() * 100000.0), condition, type, new String(), SamQFSUtil.getRandomCalendar(), SamQFSUtil.getRandomCalendar());
    }

    private ArchiveJobImpl createArchiveJob(SamQFSSystemModelImpl model, int condition, int type, String policyName, String libName, FileSystem fs2, int archiveStatus) throws SamFSException {
        BaseJobImpl job = this.createBaseJob(condition, type);
        ArchiveCopy copy = model.getSamQFSSystemArchiveManager43().getArchivePolicy(policyName).getArchiveCopy(1);
        VSN[] vsns = model.getSamQFSSystemMediaManager().getLibraryByName(libName).getVSNs();
        ArchiveJobImpl arJob = new ArchiveJobImpl(job, fs2, copy, vsns[0], true, vsns[1], false, 1000, "200", "myfile", 938, "3000", archiveStatus);
        ((SamQFSSystemJobManagerImpl)model.getSamQFSSystemJobManager()).addJob(arJob);
        ((FileSystemImpl)fs2).addJob(arJob);
        return arJob;
    }

    private StageJobImpl createStageJob(SamQFSSystemModelImpl model, int condition, FileSystem fs2, String libName) throws SamFSException {
        BaseJobImpl job = this.createBaseJob(condition, 4);
        VSN[] vsns = model.getSamQFSSystemMediaManager().getLibraryByName(libName).getVSNs();
        StageJobFileData[] files = new StageJobFileDataImpl[3];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new StageJobFileDataImpl("file" + (i + 1), "1024", "100", "12", vsns[0].getVSN(), "sysadmin");
        }
        StageJobImpl stageJob = new StageJobImpl(job, fs2, vsns[0], "123210", "111000", "myfile", "980000", "654230", "sysadmin", files);
        ((SamQFSSystemJobManagerImpl)model.getSamQFSSystemJobManager()).addJob(stageJob);
        ((FileSystemImpl)fs2).addJob(stageJob);
        return stageJob;
    }

    private ReleaseJobImpl createReleaseJob(SamQFSSystemModelImpl model, int condition, FileSystem fs2) throws SamFSException {
        BaseJobImpl job = this.createBaseJob(condition, 5);
        ReleaseJobImpl releaseJob = new ReleaseJobImpl(job, fs2);
        ((SamQFSSystemJobManagerImpl)model.getSamQFSSystemJobManager()).addJob(releaseJob);
        ((FileSystemImpl)fs2).addJob(releaseJob);
        return releaseJob;
    }

    private MountJobImpl createMountJob(SamQFSSystemModelImpl model, int condition, String libName) throws SamFSException {
        BaseJobImpl job = this.createBaseJob(condition, 7);
        VSN[] vsns = model.getSamQFSSystemMediaManager().getLibraryByName(libName).getVSNs();
        MountJobImpl mountJob = new MountJobImpl(job, vsns[0], true, 12343L, "johndoe", new GregorianCalendar());
        ((SamQFSSystemJobManagerImpl)model.getSamQFSSystemJobManager()).addJob(mountJob);
        ((LibraryImpl)model.getSamQFSSystemMediaManager().getLibraryByName(libName)).addJob(mountJob);
        return mountJob;
    }

    private LabelJobImpl createLabelJob(SamQFSSystemModelImpl model, int condition, String libName) throws SamFSException {
        BaseJobImpl job = this.createBaseJob(condition, 9);
        VSN[] vsns = model.getSamQFSSystemMediaManager().getLibraryByName(libName).getVSNs();
        Drive[] drives = model.getSamQFSSystemMediaManager().getLibraryByName(libName).getDrives();
        LabelJobImpl jobL = new LabelJobImpl(job, vsns[0].getVSN(), drives[0].getDevicePath(), libName, -1);
        ((SamQFSSystemJobManagerImpl)model.getSamQFSSystemJobManager()).addJob(jobL);
        return jobL;
    }

    private SamfsckJobImpl createFsckJob(SamQFSSystemModelImpl model, int condition, FileSystem fs2) throws SamFSException {
        BaseJobImpl job = this.createBaseJob(condition, 8);
        SamfsckJobImpl jobS = new SamfsckJobImpl(job, fs2.getName(), "sysadmin");
        ((SamQFSSystemJobManagerImpl)model.getSamQFSSystemJobManager()).addJob(jobS);
        return jobS;
    }

    private ArchiveScanJobImpl createArchiveScanJob(SamQFSSystemModelImpl model, int condition, FileSystem fs2) throws SamFSException {
        BaseJobImpl job = this.createBaseJob(condition, 2);
        ArchiveScanJobDataImpl[] data = new ArchiveScanJobDataImpl[9];
        for (int i = 0; i < 9; ++i) {
            data[i] = new ArchiveScanJobDataImpl(i * 100 + 1, "1234567890", i * 10 + 1, "987654321");
        }
        ArchiveScanJobImpl jobA = new ArchiveScanJobImpl(job, fs2.getName(), data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7], data[8]);
        ((SamQFSSystemJobManagerImpl)model.getSamQFSSystemJobManager()).addJob(jobA);
        return jobA;
    }

    private void createSharedFileSystems() {
        String host1 = "ns-east-101";
        String host2 = "ns-east-125";
        String host3 = "ns-east-163";
        String host4 = "ns-east-215";
        String[] servers1 = new String[]{host1, host3};
        String[] clients1 = new String[]{host2, host4};
        SamQFSSystemSharedFSManager mgr = this.getSamQFSSystemSharedFSManager();
        SharedDiskCache[] disks = null;
        try {
            disks = mgr.discoverAllocatableUnitsForShared(servers1, clients1);
        }
        catch (Exception e) {
            // empty catch block
        }
        DiskCache[] mdisk1 = new SharedDiskCache[3];
        DiskCache[] mdisk2 = new SharedDiskCache[3];
        DiskCache[] disk1 = new SharedDiskCache[3];
        DiskCache[] disk2 = new SharedDiskCache[3];
        for (int i = 0; i < 3; ++i) {
            mdisk1[i] = disks[i];
            mdisk2[i] = disks[i + 4];
            disk1[i] = disks[i + 11];
            disk2[i] = disks[i + 15];
        }
        FileSystemMountProperties prop1 = null;
        FileSystemMountProperties prop2 = null;
        try {
            prop1 = SamQFSUtil.getDefaultMountProperties(0, 2, 1);
            prop2 = SamQFSUtil.getDefaultMountProperties(0, 3, 1);
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] ip1 = new String[]{"10.8.11.101", "10.8.11.102"};
        String[] ip2 = new String[]{"10.8.11.125", "10.8.11.126"};
        String[] ip3 = new String[]{"10.8.11.163", "10.8.11.164"};
        String[] ip4 = new String[]{"10.8.11.215", "10.8.11.216"};
        SharedMember md1 = mgr.createSharedMember(host1, ip1, 0);
        SharedMember pmd1 = mgr.createSharedMember(host3, ip3, 1);
        SharedMember md2 = mgr.createSharedMember(host3, ip3, 0);
        SharedMember pmd2 = mgr.createSharedMember(host1, ip1, 1);
        SharedMember c1 = mgr.createSharedMember(host2, ip2, 2);
        SharedMember c2 = mgr.createSharedMember(host4, ip4, 2);
        SharedMember[] members1 = new SharedMember[4];
        SharedMember[] members2 = new SharedMember[4];
        members1[0] = md1;
        members1[1] = pmd1;
        members1[2] = c1;
        members1[3] = c2;
        members2[0] = md2;
        members2[1] = pmd2;
        members2[2] = c1;
        members2[3] = c2;
        try {
            mgr.createSharedFileSystem("mySFS01", "/mySFS01", 32, members1, prop1, mdisk1, disk1, null, false, true, true, true);
            mgr.createSharedFileSystem("mySFS02", "/mySFS02", 32, members2, prop2, mdisk2, disk2, null, false, true, true, true);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void cleanup() {
    }
}

