/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.mt;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class MethodDB {
    protected static Hashtable methods;

    public static void init(String[] interfaces) throws ClassNotFoundException {
        methods = new Hashtable();
        for (int i = 0; i < interfaces.length; ++i) {
            Method[] methodSet = Class.forName(interfaces[i]).getDeclaredMethods();
            for (int j = 0; j < methodSet.length; ++j) {
                MethodDB.addMethod(methodSet[j]);
            }
        }
    }

    public static Method getMethod(String methodName, Object[] args) throws NoSuchMethodException {
        if (args == null) {
            args = new Object[]{};
        }
        Method met = null;
        if (methods.containsKey(methodName)) {
            Object val = methods.get(methodName);
            if (val instanceof Method) {
                met = (Method)val;
            } else {
                met = MethodDB.matchMethod(args, (Vector)val);
                if (met == null) {
                    throw new NoSuchMethodException(methodName);
                }
            }
        } else {
            throw new NoSuchMethodException(methodName);
        }
        return met;
    }

    protected static void addMethod(Method newMet) {
        String name = newMet.getName();
        if (methods.containsKey(name)) {
            Object val = methods.get(name);
            if (val instanceof Vector) {
                ((Vector)val).add(newMet);
            } else {
                Vector<Object> vec = new Vector<Object>();
                vec.add(val);
                vec.add(newMet);
                methods.remove(name);
                methods.put(name, vec);
            }
        } else {
            methods.put(name, newMet);
        }
    }

    protected static Method matchMethod(Object[] args, Vector mets) {
        Method method = null;
        boolean found = false;
        Iterator methods = mets.iterator();
        while (!found && methods.hasNext()) {
            int i;
            method = (Method)methods.next();
            Class<?>[] paramTypes = method.getParameterTypes();
            if (args.length != paramTypes.length) continue;
            found = true;
            for (i = 0; i < paramTypes.length && found; ++i) {
                if (paramTypes[i].isPrimitive()) {
                    try {
                        Class c = (Class)args[i].getClass().getField("TYPE").get(null);
                        found = c.isAssignableFrom(paramTypes[i]);
                    }
                    catch (Exception e) {
                        found = false;
                    }
                    continue;
                }
                if (paramTypes[i].isInstance(args[i])) continue;
                found = false;
            }
            if (i != 0 || args.length == 0) continue;
            found = false;
        }
        if (found) {
            return method;
        }
        return null;
    }

    public static void dumpAll() {
        Enumeration keys = methods.keys();
        System.out.println("\n*** known methods:\nmethod name                full signature\n---------------------------------------------");
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object val = methods.get(key);
            if (val instanceof Method) {
                System.out.println(key + "\t - " + (Method)val);
                continue;
            }
            Vector vec = (Vector)val;
            for (int i = 0; i < vec.size(); ++i) {
                System.out.println(key + "\t > " + (Method)vec.elementAt(i));
            }
        }
    }

    public static void main(String[] args) {
        try {
            MethodDB.init(new String[]{"java.util.Collection", "com.sun.netstorage.sve.util.ThreadListener"});
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("MetDB: " + cnfe);
        }
        MethodDB.dumpAll();
        try {
            System.out.println("\n*** Looking for toArray() ...");
            Method m1 = MethodDB.getMethod("toArray", null);
            System.out.println("Method found: " + m1);
            System.out.println("\n*** Looking for toArray(Object[]) ...");
            Method m2 = MethodDB.getMethod("toArray", new Object[]{new String[]{"o1", "o2"}});
            System.out.println("Method found: " + m2);
        }
        catch (NoSuchMethodException nsme) {
            System.out.println(nsme);
        }
    }
}

