/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.media;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.media.CatEntry;
import com.sun.netstorage.samqfs.mgmt.media.DriveDev;
import com.sun.netstorage.samqfs.mgmt.media.LabelJob;
import com.sun.netstorage.samqfs.mgmt.media.Media;
import com.sun.netstorage.samqfs.mgmt.media.ReservInfo;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.DriveImpl;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import java.util.GregorianCalendar;

public class VSNImpl
implements VSN {
    private SamQFSSystemModelImpl model = null;
    private CatEntry jniVSN = null;
    private int status = 0;
    private Library library = null;
    private int libEq = -1;
    private Drive drive = null;
    private String vsn = new String();
    private int slotNo = -1;
    private String barcode = new String();
    private long capacity = -1L;
    private long availableSpace = -1L;
    private long blockSize = -1L;
    private long accessCount = -1L;
    private GregorianCalendar labelTime = null;
    private GregorianCalendar mountTime = null;
    private GregorianCalendar modificationTime = null;
    private boolean reserved = false;
    private GregorianCalendar reservationTime = null;
    private String reservedBy = new String();
    private String reservationPolicy = new String();
    private String reservationFS = new String();
    private int reservationType = -1;
    private String reservationNameForType = new String();
    private boolean mediaDamaged = false;
    private boolean duplicateVSN = false;
    private boolean readOnly = false;
    private boolean writeProtected = false;
    private boolean foreignMedia = false;
    private boolean recycled = false;
    private boolean volumeFull = false;
    private boolean unavailable = false;
    private boolean needAudit = false;

    public VSNImpl() {
    }

    public VSNImpl(Library library, Drive drive, String vsn, int slotNo, String barcode, long capacity, long availableSpace, long blockSize, long accessCount) {
        this.library = library;
        this.drive = drive;
        this.vsn = vsn;
        this.slotNo = slotNo;
        this.barcode = barcode;
        this.capacity = capacity;
        this.availableSpace = availableSpace;
        this.blockSize = blockSize;
        this.accessCount = accessCount;
    }

    public VSNImpl(Library library, Drive drive, String vsn, int slotNo, String barcode, long capacity, long availableSpace, int blockSize, int accessCount, GregorianCalendar labelTime, GregorianCalendar mountTime, GregorianCalendar modificationTime, boolean reserved, GregorianCalendar reservationTime, String reservedBy, boolean mediaDamaged, boolean duplicateVSN, boolean readOnly, boolean writeProtected, boolean foreignMedia, boolean recycled, boolean volumeFull, boolean unavailable, boolean needAudit) {
        this.library = library;
        this.drive = drive;
        this.vsn = vsn;
        this.slotNo = slotNo;
        this.barcode = barcode;
        this.capacity = capacity;
        this.availableSpace = availableSpace;
        this.blockSize = blockSize;
        this.accessCount = accessCount;
        this.labelTime = labelTime;
        this.mountTime = mountTime;
        this.modificationTime = modificationTime;
        this.reserved = reserved;
        this.reservationTime = reservationTime;
        if (reservedBy != null && !reservedBy.equals(new String())) {
            this.reservationType = 2;
            this.reservationNameForType = reservedBy;
        }
        this.mediaDamaged = mediaDamaged;
        this.duplicateVSN = duplicateVSN;
        this.readOnly = readOnly;
        this.writeProtected = writeProtected;
        this.foreignMedia = foreignMedia;
        this.recycled = recycled;
        this.volumeFull = volumeFull;
        this.unavailable = unavailable;
        this.needAudit = needAudit;
    }

    public VSNImpl(SamQFSSystemModelImpl model, CatEntry jniVSN) {
        this.model = model;
        this.jniVSN = jniVSN;
        this.setup();
    }

    public Library getLibrary() throws SamFSException {
        Library lib = this.library;
        try {
            if (this.model != null && this.libEq != -1) {
                lib = this.model.getSamQFSSystemMediaManager().getLibraryByEQ(this.libEq);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lib;
    }

    public void setLibrary(Library library) throws SamFSException {
        this.library = library;
    }

    public Drive getDrive() throws SamFSException {
        DriveDev dev;
        Drive drv = this.drive;
        if (this.model != null && this.jniVSN != null && (dev = Media.isVSNLoaded((Ctx)this.model.getJniContext(), (String)this.jniVSN.getVSN())) != null) {
            this.drive = drv = new DriveImpl(this.model, dev);
        }
        return drv;
    }

    public void setDrive(Drive drive) throws SamFSException {
        this.drive = drive;
    }

    public String getVSN() throws SamFSException {
        return this.vsn;
    }

    public int getSlotNumber() throws SamFSException {
        return this.slotNo;
    }

    public void setSlotNumber(int slotNo) throws SamFSException {
        this.slotNo = slotNo;
    }

    public String getBarcode() throws SamFSException {
        return this.barcode;
    }

    public long getCapacity() throws SamFSException {
        return this.capacity;
    }

    public long getAvailableSpace() throws SamFSException {
        return this.availableSpace;
    }

    public void setAvailableSpace(long availableSpace) throws SamFSException {
        availableSpace = this.availableSpace;
    }

    public long getBlockSize() throws SamFSException {
        return this.blockSize;
    }

    public long getAccessCount() throws SamFSException {
        return this.accessCount;
    }

    public void setAccessCount(int accessCount) throws SamFSException {
        this.accessCount = accessCount;
    }

    public GregorianCalendar getLabelTime() throws SamFSException {
        return this.labelTime;
    }

    public void setLabelTime(GregorianCalendar labelTime) throws SamFSException {
        this.labelTime = labelTime;
    }

    public GregorianCalendar getMountTime() throws SamFSException {
        return this.mountTime;
    }

    public void setMountTime(GregorianCalendar MountTime) throws SamFSException {
        this.mountTime = this.mountTime;
    }

    public GregorianCalendar getModificationTime() throws SamFSException {
        return this.modificationTime;
    }

    public void setModificationTime(GregorianCalendar modificationTime) throws SamFSException {
        this.modificationTime = modificationTime;
    }

    public boolean isReserved() throws SamFSException {
        return this.reserved;
    }

    public GregorianCalendar getReservationTime() throws SamFSException {
        return this.reservationTime;
    }

    public String getReservedByPolicyName() throws SamFSException {
        return this.reservationPolicy;
    }

    public String getReservedByFileSystemName() throws SamFSException {
        return this.reservationFS;
    }

    public int getReservationByType() throws SamFSException {
        return this.reservationType;
    }

    public String getReservationNameForType() throws SamFSException {
        return this.reservationNameForType;
    }

    public String getReservedBy() throws SamFSException {
        return this.reservedBy;
    }

    public boolean isMediaDamaged() throws SamFSException {
        return this.mediaDamaged;
    }

    public void setMediaDamaged(boolean mediaDamaged) throws SamFSException {
        this.status = mediaDamaged ? (this.status |= 0x10000000) : (this.status &= 0xEFFFFFFF);
    }

    public boolean isDuplicateVSN() throws SamFSException {
        return this.duplicateVSN;
    }

    public void setDuplicateVSN(boolean duplicateVSN) throws SamFSException {
        this.status = duplicateVSN ? (this.status |= 0x4000) : (this.status &= 0xFFFFBFFF);
    }

    public boolean isReadOnly() throws SamFSException {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) throws SamFSException {
        this.status = readOnly ? (this.status |= 0x800000) : (this.status &= 0xFF7FFFFF);
    }

    public boolean isWriteProtected() throws SamFSException {
        return this.writeProtected;
    }

    public void setWriteProtected(boolean writeProtected) throws SamFSException {
        this.status = writeProtected ? (this.status |= 0x1000000) : (this.status &= 0xFEFFFFFF);
    }

    public boolean isForeignMedia() throws SamFSException {
        return this.foreignMedia;
    }

    public void setForeignMedia(boolean foreignMedia) throws SamFSException {
        this.status = foreignMedia ? (this.status |= 0x80000) : (this.status &= 0xFFF7FFFF);
    }

    public boolean isRecycled() throws SamFSException {
        return this.recycled;
    }

    public void setRecycled(boolean recycled) throws SamFSException {
        this.status = recycled ? (this.status |= 0x400000) : (this.status &= 0xFFBFFFFF);
    }

    public boolean isVolumeFull() throws SamFSException {
        return this.volumeFull;
    }

    public void setVolumeFull(boolean volumeFull) throws SamFSException {
        this.status = volumeFull ? (this.status |= 0x800) : (this.status &= 0xFFFFF7FF);
    }

    public boolean isUnavailable() throws SamFSException {
        return this.unavailable;
    }

    public void setUnavailable(boolean unavailable) throws SamFSException {
        this.status = unavailable ? (this.status |= 0x200000) : (this.status &= 0xFFDFFFFF);
    }

    public boolean isNeedAudit() throws SamFSException {
        return this.needAudit;
    }

    public void setNeedAudit(boolean needAudit) throws SamFSException {
        this.status = needAudit ? (this.status |= Integer.MIN_VALUE) : (this.status &= Integer.MAX_VALUE);
    }

    public void changeAttributes() throws SamFSException {
        if (this.model != null) {
            Media.chgMediaStatus((Ctx)this.model.getJniContext(), (int)this.libEq, (int)this.slotNo, (boolean)true, (int)this.status);
            Media.chgMediaStatus((Ctx)this.model.getJniContext(), (int)this.libEq, (int)this.slotNo, (boolean)false, (int)(~this.status));
            this.updateStatus();
        }
    }

    public void audit() throws SamFSException {
        if (this.model != null) {
            Media.auditSlot((Ctx)this.model.getJniContext(), (int)this.libEq, (int)this.slotNo, (int)-1, (boolean)false);
        }
    }

    public void load() throws SamFSException {
        if (this.model != null) {
            Media.load((Ctx)this.model.getJniContext(), (int)this.libEq, (int)this.slotNo, (int)-1, (boolean)false);
        }
    }

    public void export() throws SamFSException {
        if (this.model != null) {
            Media.exportCartridge((Ctx)this.model.getJniContext(), (int)this.libEq, (int)this.slotNo, (boolean)false);
        }
    }

    public long label(int type, String labelName, long blockSize) throws SamFSException {
        long jobId = -1L;
        if (SamQFSUtil.isValidString(labelName) && this.model != null) {
            String oldVSN = new String();
            if (type == 1) {
                oldVSN = this.vsn;
            }
            Media.tapeLabel((Ctx)this.model.getJniContext(), (int)this.libEq, (int)this.slotNo, (int)-1, (String)labelName, (String)oldVSN, (long)blockSize, (boolean)false, (boolean)false);
            this.vsn = labelName;
            this.blockSize = blockSize;
            this.labelTime = new GregorianCalendar();
            LabelJob[] jniJobs = null;
            try {
                jniJobs = LabelJob.getAll((Ctx)this.model.getJniContext());
            }
            catch (Exception e) {
                this.model.processException(e);
            }
            if (jniJobs != null && jniJobs.length > 0) {
                for (int i = 0; i < jniJobs.length; ++i) {
                    String loadedVSN = jniJobs[i].getDrive().getLoadedVSN();
                    if (!oldVSN.equals(loadedVSN) && !this.vsn.equals(loadedVSN)) continue;
                    jobId = jniJobs[i].getID();
                    break;
                }
            }
        }
        return jobId;
    }

    public void clean() throws SamFSException {
        Drive drv = this.getDrive();
        if (this.model != null && drv != null) {
            Media.cleanDrive((Ctx)this.model.getJniContext(), (int)drv.getEquipOrdinal());
        }
    }

    public void reserve(String policyName, String filesystemName, int type, String name) throws SamFSException {
        this.reservationPolicy = SamQFSUtil.isValidString(policyName) ? policyName : null;
        this.reservationFS = SamQFSUtil.isValidString(filesystemName) ? filesystemName : null;
        if (type == 2 || type == 3 || type == 4) {
            this.reservationType = type;
            this.reservationNameForType = name;
        } else {
            this.reservationNameForType = null;
        }
        long time = SamQFSUtil.convertTime(new GregorianCalendar());
        ReservInfo info = new ReservInfo(time, this.reservationPolicy, this.reservationNameForType, this.reservationFS);
        if (this.model != null) {
            if (this.reservationPolicy != null || this.reservationFS != null || this.reservationNameForType != null) {
                Media.reserve((Ctx)this.model.getJniContext(), (int)this.libEq, (int)this.slotNo, (int)-1, (ReservInfo)info);
            } else if (this.model != null) {
                Media.unreserve((Ctx)this.model.getJniContext(), (int)this.libEq, (int)this.slotNo, (int)-1);
            }
            CatEntry[] cat = Media.getCatEntriesForVSN((Ctx)this.model.getJniContext(), (String)this.jniVSN.getVSN());
            if (cat.length == 1) {
                this.jniVSN = cat[0];
            } else {
                int targetEq = this.jniVSN.getLibraryEqu();
                int match = -1;
                for (int i = 0; i < cat.length; ++i) {
                    if (targetEq != cat[i].getLibraryEqu()) continue;
                    match = i;
                    break;
                }
                if (match != -1) {
                    this.jniVSN = cat[match];
                }
            }
            this.setup();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.library != null) {
            try {
                buf.append("Library: " + this.library.getName() + "\n\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.drive != null) {
            try {
                buf.append("Drive: " + this.drive.toString() + "\n\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        buf.append("VSN: " + this.vsn + "\n");
        buf.append("Slot: " + this.slotNo + "\n");
        buf.append("Barcode: " + this.barcode + "\n");
        buf.append("Capacity: " + this.capacity + "\n");
        buf.append("Available Space: " + this.availableSpace + "\n");
        buf.append("Block Size: " + this.blockSize + "\n");
        buf.append("Label Time: " + SamQFSUtil.dateTime(this.labelTime) + "\n");
        buf.append("Mount Time: " + SamQFSUtil.dateTime(this.mountTime) + "\n");
        buf.append("Modification Time: " + SamQFSUtil.dateTime(this.modificationTime) + "\n");
        buf.append("Reserved: " + this.reserved + "\n");
        buf.append("Reservation Time: " + SamQFSUtil.dateTime(this.reservationTime) + "\n");
        buf.append("ReservedBy: " + this.reservedBy + "\n");
        buf.append("Media Damaged: " + this.mediaDamaged + "\n");
        buf.append("Duplicate VSN: " + this.duplicateVSN + "\n");
        buf.append("Read Only: " + this.readOnly + "\n");
        buf.append("Write Protected: " + this.writeProtected + "\n");
        buf.append("Foreign Media: " + this.foreignMedia + "\n");
        buf.append("Recycled: " + this.recycled + "\n");
        buf.append("Volume Full: " + this.volumeFull + "\n");
        buf.append("Unavailable: " + this.unavailable + "\n");
        buf.append("Need audit: " + this.needAudit + "\n");
        return buf.toString();
    }

    public void setVSN(String vsn) {
        this.vsn = vsn;
    }

    private void setup() {
        if (this.jniVSN != null) {
            this.status = this.jniVSN.getStatus();
            this.libEq = this.jniVSN.getLibraryEqu();
            this.vsn = this.jniVSN.getVSN();
            this.slotNo = this.jniVSN.getSlot();
            this.barcode = this.jniVSN.getBarcode();
            this.capacity = this.jniVSN.getCapacity();
            this.availableSpace = this.jniVSN.getFreeSpace();
            this.blockSize = SamQFSUtil.convertSize(this.jniVSN.getBlockSz(), 0, 1);
            this.accessCount = this.jniVSN.getAccessCount();
            this.labelTime = SamQFSUtil.convertTime(this.jniVSN.getLabelTime());
            this.mountTime = SamQFSUtil.convertTime(this.jniVSN.getMountTime());
            this.modificationTime = SamQFSUtil.convertTime(this.jniVSN.getModTime());
            ReservInfo jniRes = this.jniVSN.getReservationInfo();
            if (jniRes != null) {
                this.reservationNameForType = jniRes.getResOwner();
                if (SamQFSUtil.isValidString(this.reservationNameForType)) {
                    this.reservationType = 2;
                }
                this.reservationPolicy = jniRes.getResCopyName();
                if (SamQFSUtil.isValidString(this.reservationPolicy)) {
                    this.reservationPolicy = SamQFSUtil.getCriteriaName(this.reservationPolicy);
                }
                this.reservationFS = jniRes.getResFS();
                if (SamQFSUtil.isValidString(this.reservationNameForType) || SamQFSUtil.isValidString(this.reservationPolicy) || SamQFSUtil.isValidString(this.reservationFS)) {
                    this.reserved = true;
                }
                if (this.reserved) {
                    this.reservationTime = SamQFSUtil.convertTime(jniRes.getResTime());
                }
                StringBuffer buf = new StringBuffer();
                if (SamQFSUtil.isValidString(this.reservationNameForType)) {
                    buf.append(this.reservationNameForType + " ");
                }
                if (SamQFSUtil.isValidString(this.reservationFS)) {
                    buf.append(this.reservationFS + " ");
                }
                if (SamQFSUtil.isValidString(this.reservationPolicy)) {
                    buf.append(this.reservationPolicy);
                }
                this.reservedBy = buf.toString();
            }
            this.updateStatus();
        }
    }

    private void updateStatus() {
        if ((this.status & 0x10000000) == 0x10000000) {
            this.mediaDamaged = true;
        }
        if ((this.status & 0x4000) == 16384) {
            this.duplicateVSN = true;
        }
        if ((this.status & 0x800000) == 0x800000) {
            this.readOnly = true;
        }
        if ((this.status & 0x1000000) == 0x1000000) {
            this.writeProtected = true;
        }
        if ((this.status & 0x80000) == 524288) {
            this.foreignMedia = true;
        }
        if ((this.status & 0x400000) == 0x400000) {
            this.recycled = true;
        }
        if ((this.status & 0x800) == 2048) {
            this.volumeFull = true;
        }
        if ((this.status & 0x200000) == 0x200000) {
            this.unavailable = true;
        }
        if ((this.status & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            this.needAudit = true;
        }
    }
}

