/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.media;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.adm.Fault;
import com.sun.netstorage.samqfs.mgmt.adm.FaultAttr;
import com.sun.netstorage.samqfs.mgmt.media.CatEntry;
import com.sun.netstorage.samqfs.mgmt.media.DriveDev;
import com.sun.netstorage.samqfs.mgmt.media.ImportOpts;
import com.sun.netstorage.samqfs.mgmt.media.LibDev;
import com.sun.netstorage.samqfs.mgmt.media.Media;
import com.sun.netstorage.samqfs.mgmt.media.StkClntConn;
import com.sun.netstorage.samqfs.mgmt.media.StkNetLibParam;
import com.sun.netstorage.samqfs.mgmt.media.StkPhyConf;
import com.sun.netstorage.samqfs.mgmt.media.StkVSN;
import com.sun.netstorage.samqfs.web.model.Common;
import com.sun.netstorage.samqfs.web.model.ImportVSNFilter;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.alarm.Alarm;
import com.sun.netstorage.samqfs.web.model.archive43.BufferDirective;
import com.sun.netstorage.samqfs.web.model.archive43.DriveDirective;
import com.sun.netstorage.samqfs.web.model.archive43.RecycleParams;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.alarm.AlarmImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.BaseDeviceImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.DriveImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.VSNImpl;
import com.sun.netstorage.samqfs.web.model.job.MountJob;
import com.sun.netstorage.samqfs.web.model.media.BaseDevice;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.util.ArrayList;
import java.util.HashMap;

public class LibraryImpl
extends BaseDeviceImpl
implements Library {
    private SamQFSSystemModelImpl model = null;
    private LibDev jniLib = null;
    private String name = new String();
    private ArrayList drives = new ArrayList();
    private HashMap vsns = new HashMap();
    private String vendor = new String();
    private String productID = new String();
    private String serialNo = new String();
    private int status = -1;
    private int noOfLicensedSlots = -1;
    private int noOfAvailableSlots = -1;
    private int noOfCatalogEntries = -1;
    private int driverType = -1;
    private String catalogPath = new String();
    private String paramFileLocation = new String();
    private String firmware = new String();
    private ArrayList associatedAlarms = new ArrayList();
    private ArrayList jobs = null;
    private RecycleParams recycleParams = null;
    private DriveDirective driveDirective = null;
    private BufferDirective bufferDirective = null;
    private int[] detailedStatus = new int[0];
    private int driveStartEQ = -1;
    private int driveIncreEQ = -1;

    public LibraryImpl() {
    }

    public LibraryImpl(String name, ArrayList s, ArrayList vsn, BaseDevice baseDevice, String vendor, String productID, String serialNo, int status, int noOfLicensedSlots, int noOfAvailableSlots, String catalogLocation, ArrayList associatedAlarms, ArrayList associatedJobs, RecycleParams recycleParams, DriveDirective driveDirective, BufferDirective bufferDirective) throws SamFSException {
        int i;
        if (name == null || name == new String() || this.drives == null) {
            throw new SamFSException("logic.invalidLibrary");
        }
        this.name = name;
        this.drives = this.drives;
        if (vsn != null) {
            this.vsns = new HashMap();
            for (i = 0; i < vsn.size(); ++i) {
                String vsnName = ((VSN)vsn.get(i)).getVSN();
                this.vsns.put(vsnName, vsn.get(i));
            }
        }
        this.vendor = vendor;
        this.productID = productID;
        this.serialNo = serialNo;
        this.status = status;
        this.noOfLicensedSlots = noOfLicensedSlots;
        this.noOfAvailableSlots = noOfAvailableSlots;
        this.driverType = 1001;
        this.catalogPath = catalogLocation;
        this.associatedAlarms = associatedAlarms;
        this.jobs = associatedJobs;
        this.recycleParams = recycleParams;
        this.driveDirective = driveDirective;
        this.bufferDirective = bufferDirective;
        this.firmware = Integer.toString((int)(Math.random() * 10.0)) + "." + Integer.toString((int)(Math.random() * 10.0));
        for (i = 0; i < this.drives.size(); ++i) {
            ((DriveImpl)this.drives.get(i)).setLibrary(this);
        }
        if (this.vsns != null) {
            VSNImpl[] vsnList = this.vsns.values().toArray(new VSNImpl[0]);
            for (int i2 = 0; i2 < vsnList.length; ++i2) {
                vsnList[i2].setLibrary(this);
            }
        }
    }

    public LibraryImpl(SamQFSSystemModelImpl model, LibDev jniLib) throws SamFSException {
        this.model = model;
        this.jniLib = jniLib;
        this.setup(false);
    }

    public LibraryImpl(SamQFSSystemModelImpl model, LibDev jniLib, boolean discoveryCase) throws SamFSException {
        this.model = model;
        this.jniLib = jniLib;
        this.setup(discoveryCase);
    }

    public LibDev getJniLibrary() {
        return this.jniLib;
    }

    public String getName() throws SamFSException {
        return this.name;
    }

    public void setName(String name) throws SamFSException {
        if (name != null && name != new String()) {
            Drive[] drvs;
            this.name = name;
            super.setFamilySetName(name);
            if (this.jniLib != null) {
                this.jniLib.setFamilySetName(name);
            }
            if ((drvs = this.getDrives()) != null) {
                for (int i = 0; i < drvs.length; ++i) {
                    ((DriveImpl)drvs[i]).setName(name);
                }
            }
        }
    }

    public Drive[] getDrives() throws SamFSException {
        return this.drives.toArray(new Drive[0]);
    }

    public void setDrives(Drive[] newDrives) throws SamFSException {
        this.drives.clear();
        if (newDrives != null && newDrives.length > 0) {
            for (int i = 0; i < newDrives.length; ++i) {
                this.drives.add(newDrives[i]);
            }
        }
    }

    public VSN[] getVSNs() throws SamFSException {
        CatEntry[] cats;
        this.vsns.clear();
        if (this.model != null && this.jniLib != null && (cats = Media.getAllCatEntriesForLib((Ctx)this.model.getJniContext(), (int)this.jniLib.getEquipOrdinal(), (int)-1, (int)-1, (short)4, (boolean)false)) != null && cats.length > 0) {
            for (int i = 0; i < cats.length; ++i) {
                this.vsns.put(cats[i].getVSN(), new VSNImpl(this.model, cats[i]));
            }
        }
        return this.vsns.values().toArray(new VSN[0]);
    }

    public int getTotalVSNInLibrary() throws SamFSException {
        return Media.getNumberOfCatEntries((Ctx)this.model.getJniContext(), (int)this.jniLib.getEquipOrdinal());
    }

    /*
     * WARNING - void declaration
     */
    public VSN[] getVSNs(int start, int size, int sortby, boolean ascending) throws SamFSException {
        void var6_6;
        CatEntry[] cats;
        int s;
        VSN[] vsnList = new VSN[]{};
        if (sortby == 7) {
            s = 2;
        } else if (sortby == 8) {
            s = 0;
        } else if (sortby == 9) {
            s = 1;
        } else {
            throw new SamFSException("logic.unsupportedSortLib");
        }
        if (this.model != null && this.jniLib != null && (cats = Media.getAllCatEntriesForLib((Ctx)this.model.getJniContext(), (int)this.jniLib.getEquipOrdinal(), (int)start, (int)size, (short)var6_6, (boolean)ascending)) != null && cats.length > 0) {
            vsnList = new VSN[cats.length];
            for (int i = 0; i < cats.length; ++i) {
                vsnList[i] = new VSNImpl(this.model, cats[i]);
            }
        }
        return vsnList;
    }

    public VSN getVSN(String vsn) throws SamFSException {
        CatEntry[] list;
        VSNImpl vsnObj = null;
        if (SamQFSUtil.isValidString(vsn) && this.model != null && (list = Media.getCatEntriesForVSN((Ctx)this.model.getJniContext(), (String)vsn)) != null && list.length > 0) {
            if (list.length == 1) {
                vsnObj = new VSNImpl(this.model, list[0]);
            } else {
                int targetEq = this.getFamilySetEquipOrdinal();
                int match = -1;
                for (int i = 0; i < list.length; ++i) {
                    if (targetEq != list[i].getLibraryEqu()) continue;
                    match = i;
                    break;
                }
                if (match != -1) {
                    vsnObj = new VSNImpl(this.model, list[match]);
                }
            }
        }
        return vsnObj;
    }

    public VSN getVSN(int slotNo) throws SamFSException {
        CatEntry cat;
        VSNImpl vsnObj = null;
        if (this.model != null && (cat = Media.getCatEntryForSlot((Ctx)this.model.getJniContext(), (int)this.getEquipOrdinal(), (int)slotNo, (int)0)) != null) {
            vsnObj = new VSNImpl(this.model, cat);
        }
        return vsnObj;
    }

    public void changeVSN(VSN vsn, String newVSN) throws SamFSException {
    }

    public void addVSN(VSN vsn) throws SamFSException {
    }

    public void removeVSN(VSN vsn) throws SamFSException {
    }

    public String getVendor() throws SamFSException {
        return this.vendor;
    }

    public String getProductID() throws SamFSException {
        return this.productID;
    }

    public String getSerialNo() throws SamFSException {
        return this.serialNo;
    }

    public int getStatus() throws SamFSException {
        return this.status;
    }

    public void setStatus(int status) throws SamFSException {
        if (this.model != null && this.jniLib != null) {
            Media.changeDriveState((Ctx)this.model.getJniContext(), (int)this.jniLib.getEquipOrdinal(), (int)SamQFSUtil.convertStateToJni(status));
            this.jniLib.setState(SamQFSUtil.convertStateToJni(status));
            this.status = status;
        }
    }

    public int[] getDetailedStatus() {
        return this.detailedStatus;
    }

    public int getNoOfLicensedSlots() throws SamFSException {
        return this.noOfLicensedSlots;
    }

    public int getNoOfAvailableSlots() throws SamFSException {
        return this.noOfAvailableSlots;
    }

    public int getDriverType() throws SamFSException {
        return this.driverType;
    }

    public void setDriverType(int driverType) throws SamFSException {
        this.driverType = driverType;
    }

    public String getFirmwareLevel() throws SamFSException {
        return this.firmware;
    }

    public long getTotalCapacity() throws SamFSException {
        long total = -1L;
        if (this.model != null && this.jniLib != null) {
            total = Media.getLibCapacity((Ctx)this.model.getJniContext(), (int)this.jniLib.getEquipOrdinal());
        }
        return total;
    }

    public long getTotalFreeSpace() throws SamFSException {
        long total = 0L;
        if (this.model != null && this.jniLib != null) {
            total = Media.getLibFreeSpace((Ctx)this.model.getJniContext(), (int)this.jniLib.getEquipOrdinal());
        }
        return total;
    }

    public int getMediaType() throws SamFSException {
        int mediaType = -1;
        if (this.jniLib != null) {
            mediaType = SamQFSUtil.getEquipTypeInteger(this.jniLib.getEquipType());
        }
        return mediaType;
    }

    public String getCatalogLocation() throws SamFSException {
        return this.catalogPath;
    }

    public void setCatalogLocation(String catalogLocation) throws SamFSException {
        if (catalogLocation != null && catalogLocation != new String()) {
            this.catalogPath = catalogLocation;
            if (this.jniLib != null) {
                this.jniLib.setCatalogPath(catalogLocation);
            }
        }
    }

    public String getParamFileLocation() throws SamFSException {
        return this.paramFileLocation;
    }

    public void setParamFileLocation(String location) throws SamFSException {
        this.paramFileLocation = location;
    }

    public Alarm[] getAssociatedAlarms() throws SamFSException {
        FaultAttr[] faults = Fault.getByLibName((Ctx)this.model.getJniContext(), (String)this.getName());
        this.associatedAlarms.clear();
        if (faults != null && faults.length > 0) {
            for (int i = 0; i < faults.length; ++i) {
                AlarmImpl a = new AlarmImpl(this.model, faults[i]);
                this.associatedAlarms.add(a);
            }
        }
        return this.associatedAlarms.toArray(new Alarm[0]);
    }

    public void addAlarm(Alarm alarm) throws SamFSException {
        if (this.associatedAlarms == null) {
            this.associatedAlarms = new ArrayList();
        }
        this.associatedAlarms.add(alarm);
    }

    public void removeAlarm(Alarm alarm) throws SamFSException {
        int index = this.associatedAlarms.indexOf(alarm);
        if (index == -1) {
            throw new SamFSException("logic.noSuchAlarmFound");
        }
        this.associatedAlarms.remove(index);
    }

    public RecycleParams getRecycleParams() throws SamFSException {
        return this.recycleParams;
    }

    public DriveDirective getDriveDirective() throws SamFSException {
        return this.driveDirective;
    }

    public BufferDirective getBufferDirective() throws SamFSException {
        return this.bufferDirective;
    }

    public void importVSN() throws SamFSException {
        if (this.model != null && this.jniLib != null) {
            Media.importCartridge((Ctx)this.model.getJniContext(), (int)this.jniLib.getEquipOrdinal(), null);
        }
    }

    public void importVSNInACSLS(long poolId, int count) throws SamFSException {
        if (this.model != null && this.jniLib != null && poolId >= 0L && count > 0) {
            ImportOpts opt = new ImportOpts(null, null, null, false, false, count, poolId);
            Media.importCartridge((Ctx)this.model.getJniContext(), (int)this.jniLib.getEquipOrdinal(), (ImportOpts)opt);
        }
    }

    public void importVSNInNWALib(String startVSN, String endVSN) throws SamFSException {
        if (this.model != null && this.jniLib != null) {
            if (SamQFSUtil.isValidString(startVSN) && !SamQFSUtil.isValidString(endVSN)) {
                ImportOpts opt = new ImportOpts(startVSN, null, null, false, false, -1, -1L);
                Media.importCartridge((Ctx)this.model.getJniContext(), (int)this.jniLib.getEquipOrdinal(), (ImportOpts)opt);
            } else if (SamQFSUtil.isValidString(startVSN) && SamQFSUtil.isValidString(endVSN)) {
                ImportOpts opt = new ImportOpts(startVSN, null, null, false, false, -1, -1L);
                if (startVSN.equals(endVSN)) {
                    Media.importCartridge((Ctx)this.model.getJniContext(), (int)this.jniLib.getEquipOrdinal(), (ImportOpts)opt);
                } else {
                    Media.importCartridges((Ctx)this.model.getJniContext(), (int)this.jniLib.getEquipOrdinal(), (String)startVSN, (String)endVSN, (ImportOpts)opt);
                }
            }
        }
    }

    public void unload() throws SamFSException {
        if (this.model != null && this.jniLib != null) {
            Media.unload((Ctx)this.model.getJniContext(), (int)this.jniLib.getEquipOrdinal(), (boolean)false);
        }
    }

    public void fullAudit() throws SamFSException {
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("Name: " + this.name + "\n");
        buf.append("Base Device: " + super.toString() + "\n");
        buf.append("Vendor: " + this.vendor + "\n");
        buf.append("Product ID: " + this.productID + "\n");
        buf.append("Serial No: " + this.serialNo + "\n");
        buf.append("Status: " + this.status + "\n");
        buf.append("No OfLicensed Slots: " + this.noOfLicensedSlots + "\n");
        buf.append("No Of Available Slots: " + this.noOfAvailableSlots + "\n");
        buf.append("Catalog Location: " + this.catalogPath + "\n");
        buf.append("\nDrives: \n");
        if (this.drives != null) {
            try {
                for (i = 0; i < this.drives.size(); ++i) {
                    buf.append(((Drive)this.drives.get(i)).toString() + "\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        buf.append("\nVSNs: \n");
        if (this.vsns != null) {
            VSN[] vsnList = this.vsns.values().toArray(new VSN[0]);
            try {
                for (int i2 = 0; i2 < vsnList.length; ++i2) {
                    buf.append(vsnList[i2].toString() + "\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        buf.append("\nAlarms: \n");
        if (this.associatedAlarms != null) {
            try {
                for (i = 0; i < this.associatedAlarms.size(); ++i) {
                    buf.append(((Alarm)this.associatedAlarms.get(i)).toString() + "\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.recycleParams != null) {
            buf.append("\nRecycle Parameters: \n" + this.recycleParams.toString());
        }
        if (this.driveDirective != null) {
            buf.append("\nDrive Directive: \n" + this.driveDirective.toString());
        }
        if (this.bufferDirective != null) {
            buf.append("\nBuffer Directive: \n" + this.bufferDirective.toString());
        }
        return buf.toString();
    }

    public MountJob[] getAssociatedMountRequestJobs() throws SamFSException {
        MountJob[] mountJobs = null;
        return mountJobs;
    }

    public long getDefaultBlockSize() throws SamFSException {
        return -1L;
    }

    private void setup(boolean discoveryCase) throws SamFSException {
        if (this.model != null && this.jniLib != null) {
            String[] altPaths;
            String devPath = this.jniLib.getDevicePath();
            if (!SamQFSUtil.isValidString(devPath) && (altPaths = this.jniLib.getAlternatePaths()) != null && altPaths.length > 0) {
                devPath = altPaths[0];
            }
            super.setDevicePath(devPath);
            this.jniLib.setPath(devPath);
            super.setEquipOrdinal(this.jniLib.getEquipOrdinal());
            super.setEquipType(SamQFSUtil.getEquipTypeInteger(this.jniLib.getEquipType()));
            super.setFamilySetName(this.jniLib.getFamilySetName());
            super.setFamilySetEquipOrdinal(this.jniLib.getFamilySetEquipOrdinal());
            super.setState(SamQFSUtil.convertStateToUI(this.jniLib.getState()));
            super.setAdditionalParamFilePath(this.jniLib.getAdditionalParamFilePath());
            this.name = this.jniLib.getFamilySetName();
            if ("historian".equals(devPath)) {
                this.name = "historian";
            }
            this.drives.clear();
            DriveDev[] drvs = this.jniLib.getDrives();
            if (this.model != null && drvs != null && drvs.length > 0) {
                for (int i = 0; i < drvs.length; ++i) {
                    DriveImpl tempDrive = new DriveImpl(this.model, drvs[i]);
                    String path = tempDrive.getDevicePath();
                    if (discoveryCase) {
                        if (!SamQFSUtil.isValidString(path)) continue;
                        this.drives.add(tempDrive);
                        continue;
                    }
                    this.drives.add(tempDrive);
                }
            }
            if (discoveryCase) {
                LibDev lib = this.getJniLibrary();
                Drive[] drives = this.getDrives();
                DriveDev[] drvsJni = new DriveDev[drives.length];
                for (int i = 0; i < drives.length; ++i) {
                    drvsJni[i] = ((DriveImpl)drives[i]).getJniDrive();
                }
                lib.setDrives(drvsJni);
            }
            this.vendor = this.jniLib.getVendor();
            this.productID = this.jniLib.getProductID();
            this.serialNo = this.jniLib.getSerialNum();
            this.status = SamQFSUtil.convertStateToUI(this.jniLib.getState());
            this.detailedStatus = SamQFSUtil.getRemovableMediaStatusIntegers(this.jniLib.getStatus());
            this.noOfLicensedSlots = 0;
            this.noOfAvailableSlots = 0;
            this.driverType = SamQFSUtil.getDriverTypeFromEQType(this.jniLib.getEquipType());
            this.catalogPath = this.jniLib.getCatalogPath();
            this.paramFileLocation = this.jniLib.getAdditionalParamFilePath();
            this.firmware = this.jniLib.getFirmwareLevel();
        }
    }

    public void setEquipOrdinal(int equipOrdinal) {
        super.setEquipOrdinal(equipOrdinal);
        if (this.jniLib != null) {
            this.jniLib.setEquipOrdinal(equipOrdinal);
        }
    }

    public void setEquipType(int equipType) {
        super.setEquipType(equipType);
        if (this.jniLib != null) {
            this.jniLib.setEquipType(SamQFSUtil.getMediaTypeString(equipType));
        }
    }

    public void setFamilySetName(String familySetName) {
        if (familySetName != null) {
            super.setFamilySetName(familySetName);
            if (this.jniLib != null) {
                this.jniLib.setFamilySetName(familySetName);
            }
        }
    }

    public void setFamilySetEquipOrdinal(int familySetEquipOrdinal) {
        super.setFamilySetEquipOrdinal(familySetEquipOrdinal);
        if (this.jniLib != null) {
            this.jniLib.setFamilySetEquipOrdinal(familySetEquipOrdinal);
        }
    }

    public void setState(int state) {
        super.setState(state);
        if (this.jniLib != null) {
            this.jniLib.setState(SamQFSUtil.convertStateToJni(state));
        }
    }

    public void setAdditionalParamFilePath(String path) {
        if (path != null) {
            super.setAdditionalParamFilePath(path);
            if (this.jniLib != null) {
                this.jniLib.setAdditionalParamFilePath(path);
            }
        }
    }

    public String[] getMessages() {
        String[] msg = null;
        if (this.jniLib != null) {
            msg = this.jniLib.getMessages();
        }
        if (msg == null) {
            msg = new String[]{};
        }
        return msg;
    }

    public int getNoOfCatalogEntries() throws SamFSException {
        this.noOfCatalogEntries = Media.getNumberOfCatEntries((Ctx)this.model.getJniContext(), (int)this.jniLib.getEquipOrdinal());
        return this.noOfCatalogEntries;
    }

    public boolean doesLibraryContainMixedMedia() {
        if (this.drives == null || this.drives.size() == 0) {
            return false;
        }
        int mediaType = -1;
        int checkType = -1;
        for (int i = 0; i < this.drives.size(); ++i) {
            if (mediaType == -1) {
                mediaType = ((DriveImpl)this.drives.get(i)).getEquipType();
                continue;
            }
            checkType = ((DriveImpl)this.drives.get(i)).getEquipType();
            if (checkType == mediaType) continue;
            return true;
        }
        return false;
    }

    public StkNetLibParam getStkNetLibParam() throws SamFSException {
        return this.jniLib.getStkParam();
    }

    public void setStkNetLibParam(StkNetLibParam newParam) throws SamFSException {
        this.jniLib.setStkParam(newParam);
    }

    public int getDriveStartNumber() {
        return this.driveStartEQ;
    }

    public void setDriveStartNumber(int start) {
        this.driveStartEQ = start;
    }

    public int getDriveIncreNumber() {
        return this.driveIncreEQ;
    }

    public void setDriveIncreNumber(int incre) {
        this.driveIncreEQ = incre;
    }

    public void setDevicePath(String devicePath) {
        super.setDevicePath(devicePath);
        this.jniLib.setPath(devicePath);
    }

    public StkPhyConf getPhyConfForStkLib() throws SamFSException {
        return Media.getPhyConfForStkLib((Ctx)this.model.getJniContext(), (String)this.getDriveMediaType(), (StkClntConn)this.getStkClntConn());
    }

    public StkVSN[] getVSNsForStkLib(String filter) throws SamFSException {
        ImportVSNFilter myFilter = new ImportVSNFilter(filter);
        myFilter.setEQType(this.getDriveMediaType());
        return Media.getVSNsForStkLib((Ctx)this.model.getJniContext(), (StkClntConn)this.getStkClntConn(), (String)myFilter.toString());
    }

    public HashMap getVSNNamesForStkLib() throws SamFSException {
        String[] vsnNames = Media.getVSNNamesForStkLib((Ctx)this.model.getJniContext(), (String)this.getDriveMediaType());
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        for (int i = 0; i < vsnNames.length; ++i) {
            myMap.put(vsnNames[i], null);
        }
        return myMap;
    }

    private StkClntConn getStkClntConn() {
        StkNetLibParam stkParam = this.jniLib.getStkParam();
        StkClntConn clnConn = new StkClntConn(stkParam.getAcsServerName(), Integer.toString(stkParam.getAcsPort()));
        clnConn.setAccess(stkParam.getAccess());
        clnConn.setSamServerName(stkParam.getSamServerName());
        clnConn.setSamRecvPort(Integer.toString(stkParam.getSamRecvPort()));
        clnConn.setSamSendPort(Integer.toString(stkParam.getSamSendPort()));
        return clnConn;
    }

    private String getDriveMediaType() throws SamFSException {
        Drive[] drvs = this.getDrives();
        if (drvs != null && drvs.length != 0) {
            return SamQFSUtil.getMediaTypeString(((DriveImpl)drvs[0]).getEquipType());
        }
        return null;
    }

    public String getLibraryNamesWithSameACSLSServer() throws SamFSException {
        if (1002 != this.driverType) {
            throw new SamFSException("logic.wronglibcomparison");
        }
        String acsServerName = this.jniLib.getStkParam().getAcsServerName();
        NonSyncStringBuffer buf = new NonSyncStringBuffer();
        SamQFSAppModel app = SamQFSFactory.getSamQFSAppModel();
        SamQFSSystemModel[] models = app.getAllSamQFSSystemModels();
        if (models == null) {
            return "";
        }
        for (int i = 0; i < models.length; ++i) {
            if (models[i].isDown()) {
                TraceUtil.trace1("Skip " + models[i].getHostname() + ", down!");
                continue;
            }
            if (models[i].getServerAPIVersion().compareTo("1.4") < 0) continue;
            try {
                Library[] crtLibs = models[i].getSamQFSSystemMediaManager().getAllLibraries();
                for (int c = 0; c < crtLibs.length; ++c) {
                    if (116 == crtLibs[c].getEquipType() || 1002 != crtLibs[c].getDriverType() || !Common.shareACSLSServer(acsServerName, crtLibs[c])) continue;
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append(crtLibs[c].getName()).append("@").append(models[i].getHostname());
                }
                continue;
            }
            catch (SamFSException e) {
                TraceUtil.trace1("Skipped model for which cannot get libraries");
            }
        }
        return buf.toString();
    }

    public void importVSNInACSLS(String[] vsnNames) throws SamFSException {
        if (vsnNames == null || vsnNames.length == 0) {
            throw new SamFSException("vsn names array is null!");
        }
        ImportOpts opts = new ImportOpts(vsnNames[0], null, null, false, false, -1, -1L);
        Media.importStkCartridges((Ctx)this.model.getJniContext(), (int)this.getEquipOrdinal(), (ImportOpts)opts, (String[])vsnNames);
    }
}

