/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.media;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.media.CatEntry;
import com.sun.netstorage.samqfs.mgmt.media.DriveDev;
import com.sun.netstorage.samqfs.mgmt.media.Media;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.BaseDeviceImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.VSNImpl;
import com.sun.netstorage.samqfs.web.model.media.BaseDevice;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.model.media.VSN;

public class DriveImpl
extends BaseDeviceImpl
implements Drive {
    private SamQFSSystemModelImpl model = null;
    private DriveDev jniDrive = null;
    private String libName = new String();
    private String vsn = new String();
    private String vendor = new String();
    private String productID = new String();
    private String serialNo = new String();
    private String firmwareLevel = new String();
    private int status = -1;
    private int[] detailedStatus = new int[0];
    private boolean shared = false;

    public DriveImpl() {
    }

    public DriveImpl(Library library, VSN vsn, BaseDevice baseDevice, String vendor, String productID, String serialNo, String firmwareLevel, int status) throws SamFSException {
        if (library != null) {
            this.libName = library.getName();
        }
        if (vsn != null) {
            this.vsn = vsn.getVSN();
        }
        this.vendor = vendor;
        this.productID = productID;
        this.serialNo = serialNo;
        this.firmwareLevel = firmwareLevel;
        this.status = status;
    }

    public DriveImpl(SamQFSSystemModelImpl model, DriveDev jniDrive) {
        this.model = model;
        this.jniDrive = jniDrive;
        this.setup();
    }

    public DriveDev getJniDrive() {
        return this.jniDrive;
    }

    public void setName(String name) throws SamFSException {
        if (name != null && name != new String()) {
            super.setFamilySetName(name);
            if (this.jniDrive != null) {
                this.jniDrive.setFamilySetName(name);
            }
        }
    }

    public Library getLibrary() throws SamFSException {
        Library lib = null;
        if (SamQFSUtil.isValidString(this.getFamilySetName()) && this.model != null) {
            lib = this.model.getSamQFSSystemMediaManager().getLibraryByName(this.getFamilySetName());
        }
        return lib;
    }

    public String getLibraryName() {
        return this.getFamilySetName();
    }

    public void setLibrary(Library library) throws SamFSException {
        if (library != null) {
            super.setFamilySetName(library.getName());
        }
    }

    public VSN getVSN() throws SamFSException {
        VSNImpl vsnObj = null;
        if (SamQFSUtil.isValidString(this.vsn) && this.model != null) {
            CatEntry[] list = null;
            try {
                list = Media.getCatEntriesForVSN((Ctx)this.model.getJniContext(), (String)this.vsn);
            }
            catch (SamFSException e) {
                this.model.processException((Exception)((Object)e));
            }
            if (list != null && list.length > 0) {
                if (list.length == 1) {
                    vsnObj = new VSNImpl(this.model, list[0]);
                } else {
                    int targetEq = this.getFamilySetEquipOrdinal();
                    int match = -1;
                    for (int i = 0; i < list.length; ++i) {
                        if (targetEq != list[i].getLibraryEqu()) continue;
                        match = i;
                        break;
                    }
                    if (match != -1) {
                        vsnObj = new VSNImpl(this.model, list[match]);
                    }
                }
            }
        }
        return vsnObj;
    }

    public String getVSNName() {
        return this.vsn;
    }

    public void setVSN(VSN vsn) throws SamFSException {
        this.vsn = vsn.getVSN();
    }

    public String getVendor() throws SamFSException {
        return this.vendor;
    }

    public String getProductID() throws SamFSException {
        return this.productID;
    }

    public String getSerialNo() throws SamFSException {
        return this.serialNo;
    }

    public String getFirmwareLevel() throws SamFSException {
        return this.firmwareLevel;
    }

    public void setFirmwareLevel(String firmwareLevel) throws SamFSException {
    }

    public int getStatus() throws SamFSException {
        return this.status;
    }

    public void setStatus(int status) throws SamFSException {
        if (this.model != null && this.jniDrive != null) {
            Media.changeDriveState((Ctx)this.model.getJniContext(), (int)this.jniDrive.getEquipOrdinal(), (int)SamQFSUtil.convertStateToJni(status));
            this.jniDrive.setState(SamQFSUtil.convertStateToJni(status));
            this.status = status;
        }
    }

    public void idle() throws SamFSException {
        this.setStatus(4);
    }

    public int[] getDetailedStatus() {
        return this.detailedStatus;
    }

    public void unload() throws SamFSException {
        if (this.model != null && this.jniDrive != null) {
            Media.unload((Ctx)this.model.getJniContext(), (int)this.jniDrive.getEquipOrdinal(), (boolean)false);
        }
    }

    public void clean() throws SamFSException {
        if (this.model != null && this.jniDrive != null) {
            Media.cleanDrive((Ctx)this.model.getJniContext(), (int)this.jniDrive.getEquipOrdinal());
        }
    }

    public String[] getMessages() {
        String[] msg = null;
        if (this.jniDrive != null) {
            msg = this.jniDrive.getMessages();
        }
        if (msg == null) {
            msg = new String[]{};
        }
        return msg;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Drive: " + super.getFamilySetName() + "\n\n");
        buf.append("VSN: " + this.vsn + "\n\n");
        buf.append(super.toString() + "\n");
        buf.append("Vendor: " + this.vendor + "\n");
        buf.append("Product ID: " + this.productID + "\n");
        buf.append("Serial No: " + this.serialNo + "\n");
        buf.append("Firmware Level: " + this.firmwareLevel + "\n");
        buf.append("Status: " + this.status + "\n");
        return buf.toString();
    }

    public long getDefaultBlockSize() throws SamFSException {
        return -1L;
    }

    private void setup() {
        if (this.jniDrive != null) {
            String[] altPaths;
            String devPath = this.jniDrive.getDevicePath();
            if (!SamQFSUtil.isValidString(devPath) && (altPaths = this.jniDrive.getAlternatePaths()) != null && altPaths.length > 0) {
                devPath = altPaths[0];
            }
            super.setDevicePath(devPath);
            this.jniDrive.setPath(devPath);
            super.setEquipOrdinal(this.jniDrive.getEquipOrdinal());
            super.setEquipType(SamQFSUtil.getEquipTypeInteger(this.jniDrive.getEquipType()));
            super.setFamilySetName(this.jniDrive.getFamilySetName());
            super.setFamilySetEquipOrdinal(this.jniDrive.getFamilySetEquipOrdinal());
            super.setState(SamQFSUtil.convertStateToUI(this.jniDrive.getState()));
            super.setAdditionalParamFilePath(this.jniDrive.getAdditionalParamFilePath());
            this.vsn = this.jniDrive.getLoadedVSN();
            this.vendor = this.jniDrive.getVendor();
            this.productID = this.jniDrive.getProductID();
            this.serialNo = this.jniDrive.getSerialNum();
            this.firmwareLevel = this.jniDrive.getFirmware();
            this.status = SamQFSUtil.convertStateToUI(this.jniDrive.getState());
            this.detailedStatus = SamQFSUtil.getRemovableMediaStatusIntegers(this.jniDrive.getStatus());
        }
    }

    public void setEquipOrdinal(int equipOrdinal) {
        super.setEquipOrdinal(equipOrdinal);
        if (this.jniDrive != null) {
            this.jniDrive.setEquipOrdinal(equipOrdinal);
        }
    }

    public void setEquipType(int equipType) {
        super.setEquipType(equipType);
        if (this.jniDrive != null) {
            this.jniDrive.setEquipType(SamQFSUtil.getMediaTypeString(equipType));
        }
    }

    public void setFamilySetName(String familySetName) {
        if (familySetName != null) {
            super.setFamilySetName(familySetName);
            if (this.jniDrive != null) {
                this.jniDrive.setFamilySetName(familySetName);
            }
        }
    }

    public void setFamilySetEquipOrdinal(int familySetEquipOrdinal) {
        super.setFamilySetEquipOrdinal(familySetEquipOrdinal);
        if (this.jniDrive != null) {
            this.jniDrive.setFamilySetEquipOrdinal(familySetEquipOrdinal);
        }
    }

    public void setState(int state) {
        super.setState(state);
        if (this.jniDrive != null) {
            this.jniDrive.setState(SamQFSUtil.convertStateToJni(state));
        }
    }

    public void setAdditionalParamFilePath(String path) {
        if (path != null) {
            super.setAdditionalParamFilePath(path);
            if (this.jniDrive != null) {
                this.jniDrive.setAdditionalParamFilePath(path);
            }
        }
    }

    public boolean unLabeled() {
        boolean unlabel = false;
        String[] message = this.getMessages();
        String realMsgs = message[0];
        if (realMsgs.startsWith("Unlabeled")) {
            unlabel = true;
        }
        return unlabel;
    }

    public boolean isShared() {
        if (this.jniDrive != null) {
            return this.jniDrive.isShared();
        }
        return false;
    }

    public void setShared(boolean shared) throws SamFSException {
        if (this.jniDrive != null) {
            System.out.println("Setting drive to " + (shared ? "shared" : "unshared"));
            this.jniDrive.modifyShared(shared);
            Media.changeStkDriveShareStatus((Ctx)this.model.getJniContext(), (int)this.getLibrary().getEquipOrdinal(), (int)this.getEquipOrdinal(), (boolean)shared);
        }
    }
}

