/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.media;

import com.sun.netstorage.samqfs.mgmt.fs.DiskDev;
import com.sun.netstorage.samqfs.mgmt.fs.SCSIDevInfo;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.BaseDeviceImpl;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;

public class DiskCacheImpl
extends BaseDeviceImpl
implements DiskCache {
    private DiskDev diskDev = null;
    private int diskType = -1;
    private int diskCacheType = 0;
    private long capacity = -1L;
    private long availableSpace = -1L;
    private int consumedSpace = -1;
    private int noOfInodesRemaining = -1;
    private String vendor = new String();
    private String productId = new String();

    public DiskCacheImpl() {
    }

    public DiskCacheImpl(DiskDev disk) {
        if (disk != null) {
            SCSIDevInfo dev;
            super.setDevicePath(disk.getDevicePath());
            super.setEquipOrdinal(disk.getEquipOrdinal());
            super.setEquipType(SamQFSUtil.getEquipTypeInteger(disk.getEquipType()));
            super.setFamilySetName(disk.getFamilySetName());
            super.setFamilySetEquipOrdinal(disk.getFamilySetEquipOrdinal());
            super.setState(SamQFSUtil.convertStateToUI(disk.getState()));
            super.setAdditionalParamFilePath(disk.getAdditionalParamFilePath());
            this.diskDev = disk;
            this.diskType = this.getDiskType(disk.getAU().getType(), disk.getAU().getRAID());
            this.diskCacheType = SamQFSUtil.getEquipTypeInteger(disk.getEquipType());
            if (this.diskCacheType == -1) {
                this.diskCacheType = 0;
            }
            if ((dev = disk.getAU().getSCSIDevInfo()) != null) {
                if (dev.vendor != null) {
                    this.vendor = dev.vendor;
                }
                if (dev.prodID != null) {
                    this.productId = dev.prodID;
                }
            }
            this.capacity = disk.getAU().getSize();
            this.availableSpace = disk.getFreeSpace();
            this.consumedSpace = this.capacity != 0L ? (int)((this.capacity - this.availableSpace) * 100L / this.capacity) : 0;
        }
    }

    public DiskDev getJniDisk() {
        return this.diskDev;
    }

    public int getDiskType() {
        return this.diskType;
    }

    public int getDiskCacheType() {
        return this.diskCacheType;
    }

    public void setDiskCacheType(int diskCacheType) {
        this.diskCacheType = diskCacheType;
    }

    public static boolean isHADevice(String devPath) {
        return devPath.startsWith("/dev/global/") || devPath.startsWith("/dev/did/") || devPath.matches("/dev/((md)|(vx))/[^/]+/r?dsk/[^\\s]+");
    }

    public boolean isHA() {
        return DiskCacheImpl.isHADevice(this.getDevicePath());
    }

    public long getCapacity() {
        return SamQFSUtil.convertSize(this.capacity, 1, 2);
    }

    public long getAvailableSpace() {
        return SamQFSUtil.convertSize(this.availableSpace, 1, 2);
    }

    public int getConsumedSpacePercentage() {
        return this.consumedSpace;
    }

    public int getNoOfInodesRemaining() {
        this.noOfInodesRemaining = -1;
        if (this.getDiskCacheType() == 1 && this.getJniDisk() != null) {
            this.noOfInodesRemaining = (int)this.getJniDisk().getFreeInodes();
        }
        return this.noOfInodesRemaining;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append("Disk Type: " + this.diskType + "\n");
        buf.append("Disk Cache Type: " + this.diskCacheType + "\n");
        buf.append("Capacity: " + this.capacity + "\n");
        buf.append("Vendor: " + this.vendor + "\n");
        buf.append("Product ID: " + this.productId + "\n");
        buf.append("Available Space: " + this.availableSpace + "\n");
        buf.append("Consumed Space: " + this.consumedSpace + "% \n");
        buf.append("No Of Inodes Remaining: " + this.noOfInodesRemaining + "\n");
        return buf.toString();
    }

    private int getDiskType(int jniType, String raid) {
        int type = 101;
        int raidVal = 0;
        if (SamQFSUtil.isValidString(raid)) {
            if (raid.charAt(0) == '1') {
                raidVal = 1;
            } else if (raid.charAt(0) == '5') {
                raidVal = 5;
            }
        }
        switch (jniType) {
            case 1: {
                if (raidVal == 0) {
                    type = 102;
                    break;
                }
                if (raidVal == 1) {
                    type = 104;
                    break;
                }
                if (raidVal != 5) break;
                type = 106;
                break;
            }
            case 2: {
                if (raidVal == 0) {
                    type = 103;
                    break;
                }
                if (raidVal == 1) {
                    type = 105;
                    break;
                }
                if (raidVal != 5) break;
                type = 107;
            }
        }
        return type;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getProductId() {
        return this.productId;
    }
}

