/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.job;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.Job;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.job.BaseJobImpl;
import com.sun.netstorage.samqfs.web.model.job.EnableDumpJob;
import com.sun.netstorage.samqfs.web.model.job.FSDumpJob;
import com.sun.netstorage.samqfs.web.model.job.RestoreJob;
import com.sun.netstorage.samqfs.web.model.job.RestoreSearchJob;
import com.sun.netstorage.samqfs.web.util.ConversionUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import java.util.GregorianCalendar;
import java.util.Properties;

public class RestoreJobImpl
extends BaseJobImpl
implements RestoreJob,
RestoreSearchJob,
EnableDumpJob,
FSDumpJob {
    static final String KEY_ACTIVITY_ID = "activityid";
    static final String KEY_STARTTIME = "starttime";
    static final String KEY_TYPE = "type";
    static final String KEY_DETAILS = "details";
    static final String KEY_FSNAME = "fsname";
    static final String KEY_DUMPNAME = "dumpname";
    static final String KEY_PID = "pid";
    static final String KEY_RESTRICT = "restrictions";
    static final String KEY_STATUS = "status";
    static final String KEY_FILENAME = "filename";
    static final String KEY_REPLACE_TYPE = "replaceType";
    static final String KEY_RESTORE_TO = "destname";
    static final String KEY_ONLINESTATUS = "copy";
    static final String KEY_FILES_TODO = "filestodo";
    static final String KEY_FILES_DONE = "filesdone";
    protected String fsName;
    protected String dumpName;
    protected String fileName;
    protected String restrictions;
    protected int replaceType = 0;
    protected int onlineStatusAfterRestore = 3000;
    protected String restoreToPath;
    protected String filesToDo = "0";
    protected String filesDone = "0";
    protected long activityId = -1L;
    protected String activityTypeStr;

    private static long calcJobID(Properties props) throws SamFSException {
        if (props == null) {
            throw new SamFSException("internal error: null properties");
        }
        long id = 100L * ConversionUtil.strToLongVal(props.getProperty(KEY_ACTIVITY_ID));
        String typeStr = props.getProperty(KEY_TYPE);
        if (typeStr.equals("SAMRDUMP")) {
            id += 10L;
        }
        if (typeStr.equals("SAMRSEARCH")) {
            id += 13L;
        }
        if (typeStr.equals("SAMRDECOMPRESS")) {
            id += 11L;
        }
        if (typeStr.equals("SAMRRESTORE")) {
            id += 12L;
        }
        return id;
    }

    private static int calcTypeID(String typeStr) {
        int type = -1;
        if (typeStr.equals("SAMRDUMP")) {
            type = 20;
        }
        if (typeStr.equals("SAMRSEARCH")) {
            type = 22;
        }
        if (typeStr.equals("SAMRDECOMPRESS")) {
            type = 21;
        }
        if (typeStr.equals("SAMRRESTORE")) {
            type = 23;
        }
        return type;
    }

    private static GregorianCalendar calcCalendar(String secs) throws SamFSException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(ConversionUtil.strToLongVal(secs) * 1000L);
        return cal;
    }

    public RestoreJobImpl(Properties props) throws SamFSException {
        super(RestoreJobImpl.calcJobID(props), 0, RestoreJobImpl.calcTypeID(props.getProperty(KEY_TYPE)), props.getProperty(KEY_DETAILS), RestoreJobImpl.calcCalendar(props.getProperty(KEY_STARTTIME)), null);
        this.activityId = ConversionUtil.strToLongVal(props.getProperty(KEY_ACTIVITY_ID));
        this.activityTypeStr = props.getProperty(KEY_TYPE);
        this.fsName = props.getProperty(KEY_FSNAME);
        switch (this.getType()) {
            case 21: {
                this.dumpName = props.getProperty(KEY_DETAILS);
                break;
            }
            case 23: {
                this.filesToDo = props.getProperty(KEY_FILES_TODO);
                this.filesDone = props.getProperty(KEY_FILES_DONE);
                this.dumpName = props.getProperty(KEY_DUMPNAME);
                this.fileName = props.getProperty(KEY_FILENAME);
                this.restoreToPath = props.getProperty(KEY_RESTORE_TO);
                String replaceTypeStr = props.getProperty(KEY_REPLACE_TYPE);
                String onlineStatusStr = props.getProperty(KEY_ONLINESTATUS);
                try {
                    if (replaceTypeStr != null) {
                        this.replaceType = Integer.parseInt(replaceTypeStr);
                    }
                    if (onlineStatusStr == null) break;
                    this.onlineStatusAfterRestore = Integer.parseInt(onlineStatusStr);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SamFSException("Invalid property value -  should be int." + props);
                }
            }
            case 20: {
                this.dumpName = props.getProperty(KEY_DUMPNAME);
                break;
            }
            case 22: {
                this.dumpName = props.getProperty(KEY_DUMPNAME);
                this.restrictions = props.getProperty(KEY_RESTRICT);
            }
        }
    }

    public RestoreJobImpl(String propsStr) throws SamFSException {
        this(ConversionUtil.strToProps(propsStr));
    }

    public void cancel(Ctx c) throws SamFSException {
        Job.cancelActivity((Ctx)c, (String)Long.toString(this.activityId), (String)this.activityTypeStr);
    }

    public String getFileSystemName() {
        return this.fsName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getReplaceType() {
        return this.replaceType;
    }

    public String getDumpFileName() {
        return this.dumpName;
    }

    public String getSearchCriteria() {
        return this.restrictions;
    }

    public String getRestoreStatus(String hostname) throws SamFSException {
        Ctx c;
        String[] jobsStrs;
        if (hostname != null && (jobsStrs = Job.getAllActivities((Ctx)(c = ((SamQFSSystemModelImpl)SamQFSFactory.getSamQFSAppModel().getSamQFSSystemModel(hostname)).getJniContext()), (int)2, (String)("activityid=" + this.activityId))) != null && jobsStrs.length > 0) {
            Properties props = ConversionUtil.strToProps(jobsStrs[0]);
            String toDo = props.getProperty(KEY_FILES_TODO);
            String done = props.getProperty(KEY_FILES_DONE);
            if (toDo != null && done != null) {
                this.filesToDo = toDo;
                this.filesDone = done;
            }
        }
        return SamUtil.getResourceString("JobsDetails.restore.status", new String[]{this.filesDone, this.filesToDo});
    }

    public String getRestoreToPath() {
        return this.restoreToPath;
    }

    public int getOnlineStatusAfterRestore() {
        return this.onlineStatusAfterRestore;
    }
}

