/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.job;

import com.sun.netstorage.samqfs.mgmt.Job;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.media.MountJob;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.job.BaseJobImpl;
import com.sun.netstorage.samqfs.web.model.job.BaseJob;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import java.util.GregorianCalendar;

public class MountJobImpl
extends BaseJobImpl
implements com.sun.netstorage.samqfs.web.model.job.MountJob {
    private VSN vsn = null;
    private String vsnName = new String();
    private int mediaType = -1;
    private String libName = new String();
    private boolean archiveMount = true;
    private long processId = -1L;
    private String username = new String();
    private GregorianCalendar time = null;

    public MountJobImpl() {
    }

    public MountJobImpl(BaseJob base, VSN vsn, boolean archiveMount, long processId, String username, GregorianCalendar time) throws SamFSException {
        super(base.getJobId(), base.getCondition(), base.getType(), base.getDescription(), base.getStartDateTime(), base.getEndDateTime());
        this.vsn = vsn;
        this.archiveMount = archiveMount;
        this.processId = processId;
        this.username = username;
        this.time = time;
    }

    public MountJobImpl(SamQFSSystemModelImpl model, MountJob jniJob) {
        super((Job)jniJob);
        if (jniJob != null) {
            this.vsnName = jniJob.vsn;
            this.mediaType = SamQFSUtil.getMediaTypeInteger(jniJob.mediaType);
            if (jniJob.robotEq > -1 && model != null) {
                try {
                    this.libName = model.getSamQFSSystemMediaManager().getLibraryByEQ(jniJob.robotEq).getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((jniJob.flags & 0x40) == 64) {
                this.archiveMount = false;
            }
            this.processId = jniJob.pid;
            this.username = jniJob.userName;
        }
    }

    public VSN getVSN() {
        return this.vsn;
    }

    public String getVSNName() throws SamFSException {
        try {
            if (this.vsn != null) {
                this.vsnName = this.vsn.getVSN();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.vsnName;
    }

    public int getMediaType() throws SamFSException {
        try {
            if (this.vsn != null) {
                this.mediaType = this.vsn.getLibrary().getMediaType();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mediaType;
    }

    public String getLibraryName() throws SamFSException {
        Library lib = null;
        if (this.vsn != null) {
            lib = this.vsn.getLibrary();
        }
        if (lib != null) {
            this.libName = lib.getName();
        }
        return this.libName;
    }

    public boolean isArchiveMount() throws SamFSException {
        return this.archiveMount;
    }

    public void setIsArchiveMount(boolean mount) throws SamFSException {
        this.archiveMount = mount;
    }

    public long getProcessId() throws SamFSException {
        return this.processId;
    }

    public String getInitiatingUsername() throws SamFSException {
        return this.username;
    }

    public GregorianCalendar getTimeInQueue() throws SamFSException {
        return this.time;
    }

    public void setTimeInQueue(GregorianCalendar time) throws SamFSException {
        this.time = time;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        if (this.vsn != null) {
            try {
                buf.append("VSN: " + this.vsn.getVSN() + "\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        buf.append("Archive Mount: " + this.archiveMount + "\n");
        buf.append("Process Id: " + this.processId + "\n");
        buf.append("Initiating Username: " + this.username + "\n");
        buf.append("Time In Queue: " + SamQFSUtil.dateTime(this.time) + "\n");
        return buf.toString();
    }
}

