/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.job;

import com.sun.netstorage.samqfs.mgmt.Job;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.job.BaseJob;
import java.util.GregorianCalendar;

public class BaseJobImpl
implements BaseJob {
    private Job jniJob = null;
    private long jobID = -1L;
    private int condition = -1;
    private int type = -1;
    private String desc = new String();
    private GregorianCalendar startDateTime = null;
    private GregorianCalendar endDateTime = null;

    public BaseJobImpl() {
    }

    public BaseJobImpl(long jobID, int condition, int type, String desc, GregorianCalendar startDateTime, GregorianCalendar endDateTime) {
        this.jobID = jobID;
        this.condition = condition;
        this.type = type;
        this.desc = desc;
        this.startDateTime = startDateTime;
        this.endDateTime = endDateTime;
    }

    public BaseJobImpl(Job job) {
        this.jniJob = job;
        this.update();
    }

    public Job getJniJob() {
        return this.jniJob;
    }

    public long getJobId() {
        return this.jobID;
    }

    public int getCondition() {
        return this.condition;
    }

    public void setCondition(int condition) {
        this.condition = condition;
    }

    public int getType() {
        return this.type;
    }

    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String desc) {
        if (SamQFSUtil.isValidString(desc)) {
            this.desc = desc;
        }
    }

    public GregorianCalendar getStartDateTime() {
        return this.startDateTime;
    }

    public void setstartDateTime(GregorianCalendar startDateTime) {
        this.startDateTime = startDateTime;
    }

    public GregorianCalendar getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(GregorianCalendar endDateTime) {
        this.endDateTime = endDateTime;
    }

    public GregorianCalendar getLastDateTime() {
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Job ID: " + this.jobID + "\n");
        buf.append("Condition: " + this.condition + "\n");
        buf.append("Type: " + this.type + "\n");
        buf.append("Description: " + this.desc + "\n");
        buf.append("Start Time: " + SamQFSUtil.dateTime(this.startDateTime) + "\n");
        buf.append("End Time: " + SamQFSUtil.dateTime(this.endDateTime));
        return buf.toString();
    }

    private void update() {
        if (this.jniJob != null) {
            this.jobID = this.jniJob.getID();
            switch (this.jniJob.getState()) {
                case 0: {
                    this.condition = 0;
                    break;
                }
                case 1: {
                    this.condition = 1;
                    break;
                }
                case 2: {
                    this.condition = 2;
                }
            }
            switch (this.jniJob.getType()) {
                case 0: {
                    this.type = 1;
                    break;
                }
                case 1: {
                    this.type = 2;
                    break;
                }
                case 2: {
                    this.type = 4;
                    break;
                }
                case 3: {
                    this.type = 5;
                    break;
                }
                case 5: {
                    this.type = 7;
                    break;
                }
                case 8: {
                    this.type = 8;
                    break;
                }
                case 9: {
                    this.type = 9;
                }
            }
        }
    }
}

