/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.fs;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.fs.RestoreFile;
import com.sun.netstorage.samqfs.web.util.ConversionUtil;
import java.io.File;
import java.util.GregorianCalendar;
import java.util.Properties;

public class RestoreFileImpl
implements RestoreFile {
    protected boolean isDirectory;
    protected String absolutePath;
    protected String parentPath;
    protected String fileName;
    protected String restorePath;
    protected String fileDetails;
    protected String prot;
    protected String size;
    protected String user;
    protected String group;
    protected GregorianCalendar crTime;
    protected GregorianCalendar modTime;
    protected String crTimeStr;
    protected String modTimeStr;
    protected Boolean isDamaged;
    protected Boolean isOnline;
    protected String[] archCopies;
    protected int stageCopy = 1000;
    protected final String KEY_PROT = "protection";
    protected final String KEY_SIZE = "size";
    protected final String KEY_USER = "user";
    protected final String KEY_GROUP = "group";
    protected final String KEY_CRTIME = "created";
    protected final String KEY_MODTIME = "modified";
    protected final String KEY_DAMAGED = "damaged";
    protected final String KEY_ONLINE = "online";

    public RestoreFileImpl(String absolutePath, String[] details) throws SamFSException {
        this.fileDetails = details[0];
        Properties props = ConversionUtil.strToProps(this.fileDetails);
        this.prot = props.getProperty("protection");
        if (this.prot != null && this.prot.charAt(0) == 'd') {
            this.isDirectory = true;
        }
        this.size = props.getProperty("size");
        this.user = props.getProperty("user");
        this.group = props.getProperty("group");
        this.crTimeStr = props.getProperty("created");
        if (this.crTimeStr != null) {
            this.crTime = new GregorianCalendar();
            this.crTime.setTimeInMillis(1000L * ConversionUtil.strToLongVal(this.crTimeStr));
        }
        this.modTimeStr = props.getProperty("modified");
        if (this.modTimeStr != null) {
            this.modTime = new GregorianCalendar();
            this.modTime.setTimeInMillis(1000L * ConversionUtil.strToLongVal(this.modTimeStr));
        }
        this.isDamaged = this.propertyValueToBoolean(props.getProperty("damaged"));
        this.isOnline = this.propertyValueToBoolean(props.getProperty("online"));
        this.archCopies = new String[details.length - 1];
        int copynum = 0;
        while (copynum + 1 < details.length) {
            this.archCopies[copynum] = details[copynum + 1];
            ++copynum;
        }
        this.absolutePath = absolutePath;
        this.restorePath = absolutePath;
        File file = new File(absolutePath);
        this.fileName = file.getName();
        this.parentPath = file.getParent();
    }

    private Boolean propertyValueToBoolean(String propertyVal) {
        if (propertyVal == null) {
            return null;
        }
        if (propertyVal.equals("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getRestorePath() {
        return this.restorePath;
    }

    public void setRestorePath(String restorePath) {
        this.restorePath = restorePath;
    }

    public String getProtection() {
        return this.prot;
    }

    public String getSize() {
        return this.size;
    }

    public String getUser() {
        return this.user;
    }

    public String getGroup() {
        return this.group;
    }

    public GregorianCalendar getCreationTime() {
        return this.crTime;
    }

    public GregorianCalendar getModTime() {
        return this.modTime;
    }

    public Boolean getIsDamaged() {
        return this.isDamaged;
    }

    public Boolean getIsOnline() {
        return this.isOnline;
    }

    public String[] getArchCopies() {
        return this.archCopies;
    }

    public void setStageCopy(int copy) {
        this.stageCopy = copy;
    }

    public int getStageCopy() {
        return this.stageCopy;
    }

    public String toString() {
        String s = this.absolutePath + "\t" + this.fileDetails;
        for (int i = 0; i < this.archCopies.length; ++i) {
            if (this.archCopies[i] == null || this.archCopies[i].length() <= 0) continue;
            s = s + "\n\t\t" + this.archCopies[i];
        }
        return s;
    }
}

