/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.fs;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiHostException;
import com.sun.netstorage.samqfs.mgmt.fs.FS;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.GenericFileSystem;
import com.sun.netstorage.samqfs.web.model.fs.NFSOptions;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemFSManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.DiskCacheImpl;
import com.sun.netstorage.samqfs.web.util.ConversionUtil;
import java.util.Properties;

public class GenericFileSystemImpl
implements GenericFileSystem {
    protected String hostName = new String();
    protected String name;
    protected String typeName;
    protected int state = -1;
    protected String mountPoint;
    protected long capacity;
    protected long avail;
    protected int consumed = 0;
    protected String nfs = "no";
    protected boolean nfsShared = false;
    protected boolean ha = false;
    protected static final GenericFileSystem[] emptyGenFSArray = new GenericFileSystem[0];
    final String KEY_NAME = "name";
    final String KEY_MNTPT = "mountpt";
    final String KEY_TYPE = "type";
    final String KEY_STATE = "state";
    final String KEY_CAPACITY = "capacity";
    final String KEY_AVAILSPACE = "availspace";
    final String KEY_NFS = "nfs";

    protected GenericFileSystemImpl() {
    }

    public GenericFileSystemImpl(String hostName, String name, String typeName, int state, String mountPoint, long capacity, long avail) {
        this.hostName = hostName;
        this.name = name;
        this.typeName = typeName;
        this.state = state;
        this.mountPoint = mountPoint;
        this.capacity = capacity;
        this.avail = avail;
        if (capacity != 0L) {
            this.consumed = (int)((capacity - avail) * 100L / capacity);
        }
    }

    public GenericFileSystemImpl(String hostName, Properties props) throws SamFSException {
        this.hostName = hostName;
        this.name = props.getProperty("name");
        this.mountPoint = props.getProperty("mountpt");
        this.typeName = props.getProperty("type");
        this.state = 1;
        String stateStr = props.getProperty("state");
        if (null != stateStr && stateStr.equals("mounted")) {
            this.state = 0;
        }
        this.capacity = ConversionUtil.strToLongVal(props.getProperty("capacity"));
        this.avail = ConversionUtil.strToLongVal(props.getProperty("availspace"));
        if (this.capacity != 0L) {
            this.consumed = (int)((this.capacity - this.avail) * 100L / this.capacity);
        }
        this.nfs = props.getProperty("nfs");
        if ("yes".equals(this.nfs)) {
            this.nfsShared = true;
        }
        this.setHA(DiskCacheImpl.isHADevice(this.name));
    }

    public GenericFileSystemImpl(String hostName, String propsStr) throws SamFSException {
        this(hostName, ConversionUtil.strToProps(propsStr));
    }

    public String getName() {
        return this.name;
    }

    public int getFSTypeByProduct() {
        return 13;
    }

    public String getFSTypeName() {
        return this.typeName;
    }

    public boolean hasNFSShares() {
        return this.nfsShared;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public boolean isHA() {
        return this.ha;
    }

    protected void setHA(boolean ha) {
        this.ha = ha;
    }

    public GenericFileSystem[] getHAFSInstances() throws SamFSMultiHostException {
        return emptyGenFSArray;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getAvailableSpace() {
        return this.avail;
    }

    public int getConsumedSpacePercentage() {
        return this.consumed;
    }

    public String getHostName() {
        return this.hostName;
    }

    protected SamQFSSystemModel getSysModel() throws SamFSException {
        SamQFSAppModel app = SamQFSFactory.getSamQFSAppModel();
        return app.getSamQFSSystemModel(this.hostName);
    }

    protected Ctx getCtx() throws SamFSException {
        return ((SamQFSSystemModelImpl)this.getSysModel()).getJniContext();
    }

    public void mount() throws SamFSException {
        FS.mountByType((Ctx)this.getCtx(), (String)this.name, (String)this.typeName);
        this.state = 0;
        ((SamQFSSystemFSManagerImpl)this.getSysModel().getSamQFSSystemFSManager()).invalidateCachedFS(this.name);
    }

    public void unmount() throws SamFSException {
        FS.umount((Ctx)this.getCtx(), (String)this.name);
        this.state = 1;
        this.mountPoint = "";
        this.avail = -1L;
        this.consumed = -1;
    }

    public NFSOptions[] getNFSOptions() throws SamFSException {
        NFSOptions[] opts = null;
        if (this.mountPoint == null) {
            return new NFSOptions[0];
        }
        String[] optsStrs = FS.getNFSOptions((Ctx)this.getCtx(), (String)this.mountPoint);
        if (optsStrs == null) {
            return new NFSOptions[0];
        }
        opts = new NFSOptions[optsStrs.length];
        for (int i = 0; i < optsStrs.length; ++i) {
            opts[i] = new NFSOptions(optsStrs[i]);
        }
        return opts;
    }

    public void setNFSOptions(NFSOptions opts) throws SamFSException {
        if (this.mountPoint != null) {
            FS.setNFSOptions((Ctx)this.getCtx(), (String)this.mountPoint, (String)opts.toString());
        }
        ((SamQFSSystemFSManagerImpl)this.getSysModel().getSamQFSSystemFSManager()).invalidateCachedFS(this.name);
    }

    public String toString() {
        String E = "=";
        String C = ",";
        String s = "name" + E + this.name + C + "type" + E + this.typeName + C + "mountpt" + E + this.mountPoint + C + "state" + E + (this.state == 0 ? "mounted" : "unmounted") + C + "capacity" + E + this.capacity + C + "availspace" + E + this.avail + C + "nfs" + E + this.nfs;
        return s;
    }
}

